/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.debug;

import android.content.SharedPreferences;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.debug.FileTracer;
import com.mi.milink.sdk.base.debug.FileTracerConfig;
import com.mi.milink.sdk.base.debug.LogcatTracer;
import com.mi.milink.sdk.base.debug.TraceLevel;
import com.mi.milink.sdk.base.os.info.StorageDash;
import com.mi.milink.sdk.base.os.info.StorageInfo;
import com.mi.milink.sdk.data.Option;
import com.mi.milink.sdk.util.CommonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class MiLinkTracer
implements SharedPreferences.OnSharedPreferenceChangeListener,
TraceLevel {
    private static MiLinkTracer sInstance = null;
    protected static final FileTracerConfig CLIENT_CONFIG;
    protected static final FileTracerConfig SERVICE_CONFIG;
    protected static final FileTracerConfig CHANNEL_CONFIG;
    protected FileTracer fileTracer;
    protected LogcatTracer logcatTracer;
    private volatile boolean enabled = true;
    private volatile boolean fileTracerEnabled = true;
    private volatile boolean logcatTracerEnabled = true;

    protected MiLinkTracer() {
        try {
            Option.startListen(this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void setInstance(MiLinkTracer miLinkTracer) {
        sInstance = miLinkTracer;
    }

    public static void autoTrace(int n2, String string2, String string3, Throwable throwable) {
        if (sInstance != null) {
            sInstance.trace(n2, string2, string3, throwable);
        }
    }

    public static File getLogFilePath() {
        if (Global.getClientAppInfo() == null || TextUtils.isEmpty((CharSequence)Global.getClientAppInfo().getLogPath())) {
            return MiLinkTracer.getLogFileInternalPath();
        }
        return MiLinkTracer.pathExistsAndCreate(Global.getClientAppInfo().getLogPath());
    }

    public static File getLogFileFolderPath() {
        boolean bl2 = false;
        String string2 = "Xiaomi" + File.separator + Global.getClientAppInfo().getAppName() + File.separator + "logs";
        StorageInfo storageInfo = StorageDash.getExternalInfo();
        if (storageInfo != null && storageInfo.getAvailableSize() > 0x5000000L) {
            bl2 = true;
        }
        if (bl2) {
            if (!TextUtils.isEmpty((CharSequence)Global.getClientAppInfo().getLogPath())) {
                return new File(Global.getClientAppInfo().getLogPath());
            }
            return new File(Environment.getExternalStorageDirectory(), string2);
        }
        return MiLinkTracer.getLogFileInternalPath();
    }

    public static File getLogFileInternalPath() {
        String string2 = "logs" + File.separator;
        if (!TextUtils.isEmpty((CharSequence)Global.getClientAppInfo().getLogPath())) {
            return new File(Global.getClientAppInfo().getLogPath());
        }
        return new File(Global.getFilesDir(), string2);
    }

    public void stop() {
        if (this.fileTracer != null) {
            this.fileTracer.flush();
            this.fileTracer.quit();
        }
    }

    public void flush() {
        if (this.fileTracer != null) {
            this.fileTracer.flush();
        }
    }

    public void trace(int n2, String string2, String string3, Throwable throwable) {
        if (!Global.isInit()) {
            return;
        }
        if (this.isEnabled()) {
            try {
                if (this.isFileTracerEnabled() && this.fileTracer != null) {
                    this.fileTracer.trace(n2, Thread.currentThread(), System.currentTimeMillis(), string2, string3, throwable);
                }
                if (this.isLogcatTracerEnabled()) {
                    string2 = Global.getClientAppInfo().getCustomTag().equals("") ? string2 + "(MiLinkSDK)(" + Global.getClientAppInfo().getAppName() + ")" : string2 + "(" + Global.getClientAppInfo().getCustomTag() + ")(MiLinkSDK)(" + Global.getClientAppInfo().getAppName() + ")";
                    if (this.logcatTracer != null) {
                        this.logcatTracer.trace(n2, Thread.currentThread(), System.currentTimeMillis(), string2, string3, throwable);
                    }
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    public final void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setFileTracerLevel(int n2) {
        this.fileTracer.setTraceLevel(n2);
    }

    public final void setFileTracerEnabled(boolean bl2) {
        this.fileTracer.flush();
        this.fileTracerEnabled = bl2;
    }

    public final boolean isFileTracerEnabled() {
        return this.fileTracerEnabled;
    }

    public final void setLogcatTracerEnabled(boolean bl2) {
        this.logcatTracerEnabled = bl2;
    }

    public final boolean isLogcatTracerEnabled() {
        return this.logcatTracerEnabled;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        if ("debug.file.tracelevel".equals(string2)) {
            int n2 = Option.getInt("debug.file.tracelevel", 63);
            this.trace(16, "MnsTracer", "File Trace Level Changed = ".concat(String.valueOf(n2)), null);
            if (this.fileTracer != null) {
                this.fileTracer.setTraceLevel(n2);
            }
            return;
        }
        if ("client.debug.file.tracelevel".equals(string2)) {
            int n3 = Option.getInt("client.debug.file.tracelevel", 63);
            this.trace(16, "MnsTracer", "Client File Trace Level Changed = ".concat(String.valueOf(n3)), null);
            if (this.fileTracer != null) {
                this.fileTracer.setTraceLevel(n3);
            }
            return;
        }
        if ("debug.logcat.tracelevel".equals(string2)) {
            int n4 = Option.getInt("debug.logcat.tracelevel", 63);
            this.trace(16, "MnsTracer", "Logcat Trace Level Changed = ".concat(String.valueOf(n4)), null);
            if (this.logcatTracer != null) {
                this.logcatTracer.setTraceLevel(n4);
            }
            return;
        }
        if ("client.debug.logcat.tracelevel".equals(string2)) {
            int n5 = Option.getInt("client.debug.logcat.tracelevel", 63);
            this.trace(16, "MnsTracer", "Client Logcat Trace Level Changed = ".concat(String.valueOf(n5)), null);
            if (this.logcatTracer != null) {
                this.logcatTracer.setTraceLevel(n5);
            }
        }
    }

    public static BufferedReader getChannelLogReader(int n2) {
        File[] fileArray = CHANNEL_CONFIG.getWorkFolder(System.currentTimeMillis());
        if (fileArray == null || !fileArray.isDirectory()) {
            return null;
        }
        fileArray = CHANNEL_CONFIG.getAllBlocksInFolder((File)fileArray);
        fileArray = CHANNEL_CONFIG.sortBlocksByIndex(fileArray);
        BufferedReader bufferedReader = null;
        if (n2 >= 0 && n2 < fileArray.length) {
            n2 = fileArray.length - n2 - 1;
            Object object = fileArray[n2];
            try {
                object = new FileReader((File)object);
                bufferedReader = new BufferedReader((Reader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return bufferedReader;
    }

    public static BufferedReader getClientLogReader(int n2) {
        File[] fileArray = CLIENT_CONFIG.getWorkFolder(System.currentTimeMillis());
        if (fileArray == null || !fileArray.isDirectory()) {
            return null;
        }
        fileArray = CLIENT_CONFIG.getAllBlocksInFolder((File)fileArray);
        fileArray = CLIENT_CONFIG.sortBlocksByIndex(fileArray);
        BufferedReader bufferedReader = null;
        if (n2 >= 0 && n2 < fileArray.length) {
            n2 = fileArray.length - n2 - 1;
            Object object = fileArray[n2];
            try {
                object = new FileReader((File)object);
                bufferedReader = new BufferedReader((Reader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return bufferedReader;
    }

    public static BufferedReader getMnsLogReader(int n2) {
        File[] fileArray = SERVICE_CONFIG.getWorkFolder(System.currentTimeMillis());
        if ((fileArray = SERVICE_CONFIG.getAllBlocksInFolder((File)fileArray)) == null) {
            return null;
        }
        fileArray = SERVICE_CONFIG.sortBlocksByIndex(fileArray);
        BufferedReader bufferedReader = null;
        if (n2 >= 0 && n2 < fileArray.length) {
            n2 = fileArray.length - n2 - 1;
            Object object = fileArray[n2];
            try {
                object = new FileReader((File)object);
                bufferedReader = new BufferedReader((Reader)object);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return bufferedReader;
    }

    public static void cleanChannelLog() {
        File[] fileArray = CHANNEL_CONFIG.getWorkFolder(System.currentTimeMillis());
        if ((fileArray = CHANNEL_CONFIG.getAllBlocksInFolder((File)fileArray)) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                MiLinkTracer.deleteFile(fileArray[i2]);
            }
        }
    }

    public static void cleanMnsLog() {
        File[] fileArray = SERVICE_CONFIG.getWorkFolder(System.currentTimeMillis());
        if ((fileArray = SERVICE_CONFIG.getAllBlocksInFolder((File)fileArray)) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                MiLinkTracer.deleteFile(fileArray[i2]);
            }
        }
    }

    public static void cleanClientLog() {
        File[] fileArray = CLIENT_CONFIG.getWorkFolder(System.currentTimeMillis());
        if ((fileArray = CLIENT_CONFIG.getAllBlocksInFolder((File)fileArray)) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                MiLinkTracer.deleteFile(fileArray[i2]);
            }
        }
    }

    public static File prepareReportLogFile(long l2) {
        File file;
        float f2;
        if (l2 < 1L) {
            l2 = System.currentTimeMillis();
        }
        FileTracerConfig fileTracerConfig = CLIENT_CONFIG;
        File[] fileArray = SERVICE_CONFIG;
        FileTracerConfig fileTracerConfig2 = CHANNEL_CONFIG;
        File file2 = MiLinkTracer.getLogFilePath();
        String string2 = "report.log";
        if ((file2 = new File(file2, string2)).exists()) {
            file2.delete();
        } else {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        File[] fileArray2 = fileTracerConfig.getWorkFolder(l2);
        File[] fileArray3 = fileTracerConfig.getAllBlocksInFolder((File)fileArray2);
        if (fileArray3 != null) {
            fileArray3 = fileTracerConfig.sortBlocksByIndex(fileArray3);
        }
        if ((fileArray = fileArray.getAllBlocksInFolder((File)fileArray2)) != null) {
            fileArray = fileTracerConfig.sortBlocksByIndex(fileArray);
        }
        if ((fileArray2 = fileTracerConfig2.getAllBlocksInFolder((File)fileArray2)) != null) {
            fileArray2 = fileTracerConfig.sortBlocksByIndex(fileArray2);
        }
        float f3 = fileArray3 != null ? (float)fileArray3.length : 0.0f;
        float f4 = fileArray != null ? (float)fileArray.length : 0.0f;
        float f5 = f2 = fileArray2 != null ? (float)fileArray2.length : 0.0f;
        if (f3 + f4 + f2 <= 0.0f) {
            return file2;
        }
        float f6 = f3 + f4 + f2;
        int n2 = Math.round(f3 / f6 * 24.0f);
        int n3 = Math.round(f4 / f6 * 24.0f);
        int n4 = Math.round(f2 / f6 * 24.0f);
        if (n2 == 0 && fileArray3 != null && fileArray3.length > 0) {
            n2 = 1;
            --n3;
            if (n4 == 0) {
                if (n3 > 1) {
                    --n3;
                }
                n4 = 1;
            }
        } else if (n3 == 0 && fileArray != null && fileArray.length > 0) {
            n3 = 1;
            --n2;
            if (n4 == 0) {
                if (n2 > 1) {
                    --n2;
                }
                n4 = 1;
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        if (fileArray3 != null) {
            while (n2 > 0) {
                --n2;
                if (arrayList.size() >= fileArray3.length) continue;
                file = fileArray3[fileArray3.length - arrayList.size() - 1];
                arrayList.add(0, file);
            }
        }
        if (fileArray != null) {
            while (n3 > 0) {
                --n3;
                if (arrayList2.size() >= fileArray.length) continue;
                file = fileArray[fileArray.length - arrayList2.size() - 1];
                arrayList2.add(0, file);
            }
        }
        if (fileArray2 != null) {
            while (n4 > 0) {
                --n4;
                if (arrayList3.size() >= fileArray2.length) continue;
                file = fileArray2[fileArray2.length - arrayList3.size() - 1];
                arrayList3.add(0, file);
            }
        }
        MiLinkTracer.mergeFiles(arrayList, file2, "------client log block count:" + arrayList.size() + "------\n");
        MiLinkTracer.mergeFiles(arrayList2, file2, "\n------mns log block count:" + arrayList2.size() + "------\n");
        MiLinkTracer.mergeFiles(arrayList3, file2, "------client log block count:" + arrayList3.size() + "------\n");
        return file2;
    }

    public static File prepareReportLogFile(long l2, int n2) {
        if (n2 < 0) {
            return MiLinkTracer.prepareReportLogFile(l2);
        }
        if (l2 < 1L) {
            l2 = System.currentTimeMillis();
        }
        FileTracerConfig fileTracerConfig = CLIENT_CONFIG;
        FileTracerConfig fileTracerConfig2 = SERVICE_CONFIG;
        FileTracerConfig fileTracerConfig3 = CHANNEL_CONFIG;
        File file = MiLinkTracer.getLogFilePath();
        String string2 = "report.log";
        if ((file = new File(file, string2)).exists()) {
            file.delete();
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        int n3 = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        ArrayList<File> arrayList4 = new ArrayList<File>();
        ArrayList<File> arrayList5 = new ArrayList<File>();
        ArrayList<File> arrayList6 = new ArrayList<File>();
        int n4 = 0;
        while (n3 < n2 && n4++ < 7 && (fileTracerConfig.isWorkFolderExists(l2) || fileTracerConfig2.isWorkFolderExists(l2))) {
            float f2;
            float f3;
            float f4;
            File[] fileArray;
            arrayList4.clear();
            arrayList5.clear();
            arrayList6.clear();
            File[] fileArray2 = fileTracerConfig.getWorkFolder(l2);
            File[] fileArray3 = fileTracerConfig.getAllBlocksInFolder((File)fileArray2);
            if (fileArray3 != null) {
                fileArray3 = fileTracerConfig.sortBlocksByIndex(fileArray3);
            }
            if ((fileArray = fileTracerConfig2.getAllBlocksInFolder((File)fileArray2)) != null) {
                fileArray = fileTracerConfig2.sortBlocksByIndex(fileArray);
            }
            if ((fileArray2 = fileTracerConfig3.getAllBlocksInFolder((File)fileArray2)) != null) {
                fileArray2 = fileTracerConfig3.sortBlocksByIndex(fileArray);
            }
            if ((f4 = fileArray3 != null ? (float)fileArray3.length : 0.0f) + (f3 = fileArray != null ? (float)fileArray.length : 0.0f) + (f2 = fileArray2 != null ? (float)fileArray2.length : 0.0f) <= 0.0f) continue;
            float f5 = f4 + f3 + f2;
            int n5 = Math.round(f4 / f5 * 24.0f);
            int n6 = Math.round(f3 / f5 * 24.0f);
            int n7 = Math.round(f2 / f5 * 24.0f);
            if (n5 == 0 && fileArray3 != null && fileArray3.length > 0) {
                n5 = 1;
                --n6;
                if (n7 == 0) {
                    if (n6 > 1) {
                        --n6;
                    }
                    n7 = 1;
                }
            } else if (n6 == 0 && fileArray != null && fileArray.length > 0) {
                n6 = 1;
                --n5;
                if (n7 == 0) {
                    if (n5 > 1) {
                        --n5;
                    }
                    n7 = 1;
                }
            }
            if (fileArray3 != null) {
                while (n5 > 0) {
                    --n5;
                    if (arrayList4.size() >= fileArray3.length) continue;
                    File file2 = fileArray3[fileArray3.length - arrayList4.size() - 1];
                    arrayList4.add(0, file2);
                    n3 = (int)((long)n3 + file2.length());
                }
            }
            if (fileArray != null) {
                while (n6 > 0) {
                    --n6;
                    if (arrayList5.size() >= fileArray.length) continue;
                    File file3 = fileArray[fileArray.length - arrayList5.size() - 1];
                    arrayList5.add(0, file3);
                    n3 = (int)((long)n3 + file3.length());
                }
            }
            if (fileArray2 != null) {
                while (n7 > 0) {
                    --n7;
                    if (arrayList6.size() >= fileArray2.length) continue;
                    File file4 = fileArray2[fileArray2.length - arrayList6.size() - 1];
                    arrayList6.add(0, file4);
                    n3 = (int)((long)n3 + file4.length());
                }
            }
            l2 -= 86400000L;
            arrayList.addAll(arrayList4);
            arrayList2.addAll(arrayList5);
            arrayList3.addAll(arrayList6);
        }
        if (arrayList.size() == 0 && arrayList2.size() == 0 && arrayList3.size() == 0) {
            return null;
        }
        MiLinkTracer.mergeFiles(arrayList, file, "------client log block count:" + arrayList.size() + "------\n");
        MiLinkTracer.mergeFiles(arrayList2, file, "\n------mns log block count:" + arrayList2.size() + "------\n");
        MiLinkTracer.mergeFiles(arrayList3, file, "\n------mns log block count:" + arrayList3.size() + "------\n");
        return file;
    }

    private static boolean mergeFiles(List<File> list, File object, String string2) {
        boolean bl2;
        if (list == null || list.size() <= 0 || object == null) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)object, true);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                fileOutputStream.write(string2.getBytes("UTF-8"));
            }
            object = new byte[4096];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int n2;
                FileInputStream fileInputStream = new FileInputStream(list.get(i2));
                while ((n2 = fileInputStream.read((byte[])object, 0, 4096)) > 0) {
                    fileOutputStream.write((byte[])object, 0, n2);
                }
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl2 = CommonUtils.closeDataObject(fileOutputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl2 = CommonUtils.closeDataObject(fileOutputStream);
        }
        catch (IOException iOException) {
            bl2 = CommonUtils.closeDataObject(fileOutputStream);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(fileOutputStream);
            throw throwable;
        }
        bl2 = CommonUtils.closeDataObject(fileOutputStream);
        return bl2;
    }

    public static void deleteFile(File fileArray) {
        if (fileArray == null || !fileArray.exists()) {
            return;
        }
        if (fileArray.isFile()) {
            fileArray.delete();
            return;
        }
        fileArray = fileArray.listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MiLinkTracer.deleteFile(fileArray[i2]);
        }
    }

    private static File pathExistsAndCreate(String object) {
        if (!((File)(object = new File((String)object))).exists()) {
            try {
                ((File)object).mkdir();
                ((File)object).mkdirs();
            }
            catch (Exception exception) {
                Log.e((String)"MiLinkTracer", (String)String.format("create path: %s\uff0cerror\uff1a%s", ((File)object).toString(), exception.toString()));
            }
        }
        ((File)object).setReadable(true, false);
        ((File)object).setWritable(true, false);
        ((File)object).setExecutable(true, false);
        return object;
    }

    static {
        File file = MiLinkTracer.getLogFilePath();
        Global.getClientAppInfo().setLogPath(file.getAbsolutePath());
        int n2 = Global.isDebug() ? Integer.MAX_VALUE : Option.getInt("client.debug.file.blockcount", 48);
        long l2 = Option.getLong("client.debug.file.keepperiod", 172800000L);
        CLIENT_CONFIG = new FileTracerConfig(file, n2, 524288, 32768, "Mns.Client.File.Tracer", 45000L, 10, ".app.log", l2);
        n2 = Global.isDebug() ? Integer.MAX_VALUE : Option.getInt("debug.file.blockcount", 48);
        long l3 = Option.getLong("debug.file.keepperiod", 172800000L);
        SERVICE_CONFIG = new FileTracerConfig(file, n2, 524288, 32768, "Mns.File.Tracer", 45000L, 10, ".m.log", l3);
        CHANNEL_CONFIG = new FileTracerConfig(file, n2, 524288, 32768, "Mns.File.Tracer", 45000L, 10, ".c.log", l3);
    }
}

