/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.debug;

import android.text.TextUtils;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.util.CommonUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TrafficMonitor {
    private static final String TAG = "TrafficMonitor";
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static TrafficMonitor sInstance = new TrafficMonitor();
    private final ConcurrentHashMap<String, TrafficMonitorItem> mMonitorItemMap = new ConcurrentHashMap(32);
    private volatile long mStartTime;
    private volatile boolean mIsStarted = false;

    private TrafficMonitor() {
    }

    public static TrafficMonitor getInstance() {
        return sInstance;
    }

    public void resume() {
        this.mIsStarted = true;
    }

    public void pause() {
        this.mIsStarted = false;
    }

    public void start() {
        this.mStartTime = System.currentTimeMillis();
        this.mMonitorItemMap.clear();
        this.mIsStarted = true;
    }

    public void traffic(String string2, int n2) {
        if (this.mIsStarted && !TextUtils.isEmpty((CharSequence)string2)) {
            TrafficMonitorItem trafficMonitorItem = this.mMonitorItemMap.get(string2);
            if (trafficMonitorItem != null) {
                ++trafficMonitorItem.count;
                trafficMonitorItem.totalSize += n2;
                return;
            }
            trafficMonitorItem = new TrafficMonitorItem();
            this.mMonitorItemMap.put(string2, trafficMonitorItem);
            ++trafficMonitorItem.count;
            trafficMonitorItem.totalSize += n2;
        }
    }

    public void print() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("startTime:").append(CommonUtils.createDataFormat(TIME_FORMAT).format(new Date(this.mStartTime)));
        ConcurrentHashMap<String, TrafficMonitorItem> concurrentHashMap = new ConcurrentHashMap<String, TrafficMonitorItem>(32);
        concurrentHashMap.putAll(this.mMonitorItemMap);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            if (Const.isMnsCmd((String)entry.getKey())) {
                n2 += ((TrafficMonitorItem)entry.getValue()).count;
                n3 += ((TrafficMonitorItem)entry.getValue()).totalSize;
                continue;
            }
            if (((String)entry.getKey()).contains(".do")) {
                n6 += ((TrafficMonitorItem)entry.getValue()).count;
                n7 += ((TrafficMonitorItem)entry.getValue()).totalSize;
                continue;
            }
            n4 += ((TrafficMonitorItem)entry.getValue()).count;
            n5 += ((TrafficMonitorItem)entry.getValue()).totalSize;
        }
        stringBuilder.append(" ");
        stringBuilder.append("{mlinkCount:").append(n2).append(",");
        stringBuilder.append("mlinkTotalSize:").append(n3).append("} ");
        stringBuilder.append("{otherCount:").append(n4).append(",");
        stringBuilder.append("otherTotalSize:").append(n5).append("} ");
        stringBuilder.append("{httpCount:").append(n6).append(",");
        stringBuilder.append("httpTotalSize:").append(n7).append("}");
        stringBuilder.append("]");
        MiLinkLog.w(TAG, "traffic statistic: " + stringBuilder.toString());
    }

    public void printDetail() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append("startTime:").append(CommonUtils.createDataFormat(TIME_FORMAT).format(new Date(this.mStartTime)));
        ConcurrentHashMap<String, TrafficMonitorItem> concurrentHashMap = new ConcurrentHashMap<String, TrafficMonitorItem>(32);
        concurrentHashMap.putAll(this.mMonitorItemMap);
        for (Map.Entry entry : concurrentHashMap.entrySet()) {
            stringBuilder.append(" {cmd:").append((String)entry.getKey()).append(", count:").append(((TrafficMonitorItem)entry.getValue()).count).append(", totalSize:").append(((TrafficMonitorItem)entry.getValue()).totalSize).append("}");
        }
        stringBuilder.append("]");
        MiLinkLog.i(TAG, "traffic statistic detail: " + stringBuilder.toString());
    }

    static class TrafficMonitorItem
    implements Serializable {
        private static final long serialVersionUID = -1887022887439235063L;
        public int count;
        public int totalSize;

        TrafficMonitorItem() {
        }
    }
}

