/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.receiver;

import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.service.MiLinkJobService;
import java.util.Calendar;
import org.greenrobot.eventbus.EventBus;

public class AlarmReceiver
extends BroadcastReceiver {
    private int jobId = 0;

    public final void onReceive(Context context, Intent intent) {
        if (intent != null) {
            String string2 = intent.getAction();
            String string3 = intent.getPackage();
            if (!Global.isInit()) {
                Log.d((String)"AlarmReceiver", (String)"milink cannot be inited");
                return;
            }
            if (string2 != null && string2.equals("com.milink.sdk.heartbeat") && string3 != null && string3.equals(Global.getPackageName())) {
                MiLinkLog.w("HeartBeat", "\u6536\u5230\u5fc3\u8df3 AlarmReceiver " + (intent != null));
                if (!MiAccountManager.getInstance().appHasLogined()) {
                    MiLinkLog.w("MiLinkAlarm", "app not login cancel");
                    AlarmClockService.stop();
                    return;
                }
                boolean bl2 = false;
                if (System.currentTimeMillis() - Global.LAST_PACKET_SEND_TIME > 3600000L) {
                    if (Global.isSuicideEnable()) {
                        bl2 = true;
                    } else {
                        long l2 = Calendar.getInstance().get(11);
                        if (l2 >= 1L && l2 <= 8L) {
                            MiLinkLog.e("HeartBeat", "1~8\u70b9 \uff1a \u4e0d\u81ea\u6740");
                        }
                    }
                }
                MiLinkLog.e("HeartBeat", "\u662f\u5426\u9700\u8981\u81ea\u6740 \uff1a ".concat(String.valueOf(bl2)));
                if (bl2) {
                    MiLinkLog.w("MiLinkAlarm", "milinkservice will be suicide , after 10s Launch");
                    if (!Global.isSuicideEnable()) {
                        AlarmClockService.start(10000L);
                    }
                    int n2 = Process.myPid();
                    MiLinkLog.d("MiLinkAlarm", "suicide now!!! pid=".concat(String.valueOf(n2)));
                    if (!TextUtils.isEmpty((CharSequence)Global.getClientAppInfo().getServiceProcessName()) && Build.VERSION.SDK_INT >= 26) {
                        Log.e((String)"MiLinkAlarm", (String)"suicide need to stop jobscheduler");
                        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                        new ComponentName(context, MiLinkJobService.class);
                        jobScheduler.cancelAll();
                    }
                    Process.killProcess((int)n2);
                    return;
                }
                MiLinkLog.e("HeartBeat", "\u7f51\u7edc\u662f\u5426\u6b63\u5e38 \uff1a " + NetworkDash.isAvailable());
                if (NetworkDash.isAvailable()) {
                    AlarmClockService.start();
                } else {
                    AlarmClockService.stop();
                }
                string2 = Global.getClientAppInfo().getServiceProcessName();
                MiLinkLog.e("HeartBeat", "\u662f\u5426\u662f\u5355\u8fdb\u7a0b \uff1a " + !TextUtils.isEmpty((CharSequence)string2));
                EventBus.getDefault().post(new MiLinkEvent.SystemNotificationEvent(MiLinkEvent.SystemNotificationEvent.EventType.AlarmArrived));
            }
        }
    }
}

