/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.receiver;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.service.MiLinkJobService;
import java.util.Calendar;

public class NetworkReceiver
extends BroadcastReceiver {
    private static final String TAG = "NetworkReceiver";
    private int jobId = 0;

    public void onReceive(Context context, Intent intent) {
        if (!MiAccountManager.getInstance().appHasLogined()) {
            return;
        }
        MiLinkLog.v(TAG, "network changed, NetworkReceiver start milink service");
        if (!Global.isSuicideEnable() && (long)Calendar.getInstance().get(11) >= 8L) {
            if (Build.VERSION.SDK_INT >= 26) {
                intent = (JobScheduler)context.getSystemService("jobscheduler");
                context = new ComponentName(context, MiLinkJobService.class);
                context = new JobInfo.Builder(++this.jobId, (ComponentName)context);
                context.setMinimumLatency(1L);
                context.setRequiredNetworkType(1);
                intent.schedule(context.build());
                return;
            }
            intent = new Intent();
            intent.putExtra("onStartCommandReturn", 1);
            intent.setComponent(new ComponentName(context, "com.mi.milink.sdk.service.MiLinkService"));
            context.startService(intent);
        }
    }
}

