/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.service;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.text.format.Formatter;
import android.text.format.Time;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MiLinkExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static String TAG = MiLinkExceptionHandler.class.getName();
    private static final Thread.UncaughtExceptionHandler sDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    private String mPhoneModel = Build.MODEL;
    private String mPhoneSdk = Build.VERSION.SDK;

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        Appendable appendable = new PrintWriter(stringWriter);
        throwable.printStackTrace((PrintWriter)appendable);
        appendable = new StringBuilder();
        Object object = new Time();
        object.setToNow();
        object = object.format("%Y-%m-%d %H:%M:%S");
        ((StringBuilder)appendable).append("\t\n==================LOG=================\t\n");
        ((StringBuilder)appendable).append("PHONE_MODEL:" + this.mPhoneModel + "\t\n");
        ((StringBuilder)appendable).append("ANDROID_SDK:" + this.mPhoneSdk + "\t\n");
        ((StringBuilder)appendable).append((String)object + "\t\n");
        ((StringBuilder)appendable).append(((Object)stringWriter).toString());
        ((StringBuilder)appendable).append("\t\n==================MemoryInfo=================\t\n");
        ((StringBuilder)appendable).append(this.getMemoryInfo(Global.getContext()));
        ((StringBuilder)appendable).append("\t\n--------------------------------------\t\n");
        MiLinkLog.i(TAG, ((StringBuilder)appendable).toString());
        MiLinkLog.getInstance().flush();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {}
        MiLinkLog.i(TAG, "sDefaultHandler=" + sDefaultHandler);
        this.arouseMiLink();
        if (sDefaultHandler != null) {
            sDefaultHandler.uncaughtException(thread, throwable);
        }
        MiLinkLog.getInstance().stop();
    }

    private String getMemoryInfo(Context context) {
        String string2 = "";
        try {
            string2 = string2 + "\ntotalMemory()=" + this.toMib(context, Runtime.getRuntime().totalMemory());
            string2 = string2 + "\nmaxMemory()=" + this.toMib(context, Runtime.getRuntime().maxMemory());
            string2 = string2 + "\nfreeMemory()=" + this.toMib(context, Runtime.getRuntime().freeMemory());
            context = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)context);
            string2 = string2 + "\ndbg.mi.dalvikPrivateDirty=" + this.toMib(context.dalvikPrivateDirty);
            string2 = string2 + "\ndbg.mi.dalvikPss=" + this.toMib(context.dalvikPss);
            string2 = string2 + "\ndbg.mi.dalvikSharedDirty=" + this.toMib(context.dalvikSharedDirty);
            string2 = string2 + "\ndbg.mi.nativePrivateDirty=" + this.toMib(context.nativePrivateDirty);
            string2 = string2 + "\ndbg.mi.nativePss=" + this.toMib(context.nativePss);
            string2 = string2 + "\ndbg.mi.nativeSharedDirty=" + this.toMib(context.nativeSharedDirty);
            string2 = string2 + "\ndbg.mi.otherPrivateDirty=" + this.toMib(context.otherPrivateDirty);
            string2 = string2 + "\ndbg.mi.otherPss" + this.toMib(context.otherPss);
            string2 = string2 + "\ndbg.mi.otherSharedDirty=" + this.toMib(context.otherSharedDirty);
            string2 = string2 + "\nTotalPrivateDirty=" + this.toMib(context.getTotalPrivateDirty());
            string2 = string2 + "\nTotalPss=" + this.toMib(context.getTotalPss());
            string2 = string2 + "\nTotalSharedDirty=" + this.toMib(context.getTotalSharedDirty());
        }
        catch (Exception exception) {}
        return string2;
    }

    private String toMib(Context context, long l2) {
        return Formatter.formatFileSize((Context)context, (long)l2);
    }

    private String toMib(int n2) {
        return String.format("%.2fMB", (double)n2 / 1024.0);
    }

    private void arouseMiLink() {
        Intent intent = new Intent();
        intent.putExtra("onStartCommandReturn", 1);
        intent.setComponent(new ComponentName(Global.getContext(), "com.mi.milink.sdk.service.MiLinkService"));
        intent = PendingIntent.getService((Context)Global.getContext(), (int)0, (Intent)intent, (int)0x8000000);
        ((AlarmManager)Global.getContext().getSystemService("alarm")).set(1, System.currentTimeMillis() + 500L, (PendingIntent)intent);
        MiLinkLog.i(TAG, "arouseMiLink");
    }
}

