/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.service;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemClock;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.LevelPromote;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.service.MiLinkExceptionHandler;
import com.mi.milink.sdk.service.MnsServiceBinder;
import com.mi.milink.sdk.util.PreloadClearUtil;
import com.mi.milink.sdk.util.SystemUtils;

@TargetApi(value=21)
public class MiLinkJobService
extends JobService {
    private static final String TAG = "MiLinkJobService";

    public IBinder onBindService(Intent intent) {
        super.onBind(intent);
        MiLinkLog.w(TAG, "MiLink Service Binded");
        return MnsServiceBinder.getInstance();
    }

    public void onCreate() {
        super.onCreate();
        PreloadClearUtil.clearResources();
        LevelPromote.promoteApplicationLevelInMIUI();
        long l2 = System.currentTimeMillis();
        Thread.setDefaultUncaughtExceptionHandler(new MiLinkExceptionHandler());
        Global.STARTUP_TIME = SystemClock.elapsedRealtime();
        AlarmClockService.start();
        long l3 = System.currentTimeMillis();
        MiLinkLog.w(TAG, "MiLink Service Created, pid=" + Process.myPid() + ", cost=" + (l3 - l2));
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    public boolean onUnbind(Intent intent) {
        MiLinkLog.w(TAG, "MiLink JobService UnBinded");
        this.onJobStoped();
        return true;
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        MiLinkLog.w(TAG, "MiLink Service Started ,and onStartCommand=1");
        this.startWork();
        return 1;
    }

    private void startWork() {
        MiLinkLog.w(TAG, "MiLink Service Started ,and onStartCommandReturn=1");
        if (SystemUtils.getPidByProcessName(Global.getPackageName()) == -1) {
            Intent intent = new Intent("com.mi.milink.ACTION_MSG");
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    public boolean onStartJob(JobParameters jobParameters) {
        MiLinkLog.w(TAG, "MiLink Service Started ,and onStartJob=1");
        this.startWork();
        return false;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        MiLinkLog.w(TAG, "MiLink Service onStopJob");
        this.onJobStoped();
        return false;
    }

    private void onJobStoped() {
        MiLinkLog.v(TAG, "onJobStoped");
        if (Build.VERSION.SDK_INT > 14) {
            Intent intent = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
            intent.setPackage(this.getPackageName());
            intent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)intent, (int)0x40000000);
            ((AlarmManager)this.getApplicationContext().getSystemService("alarm")).set(3, SystemClock.elapsedRealtime() + 1000L, (PendingIntent)intent);
        }
    }

    public void onTaskRemoved(Intent intent) {
        MiLinkLog.v(TAG, "onTaskRemoved");
        if (Build.VERSION.SDK_INT > 14) {
            Intent intent2 = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
            intent2.setPackage(this.getPackageName());
            intent2 = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)intent2, (int)0x40000000);
            ((AlarmManager)this.getApplicationContext().getSystemService("alarm")).set(3, SystemClock.elapsedRealtime() + 1000L, (PendingIntent)intent2);
            super.onTaskRemoved(intent);
        }
    }
}

