/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.service;

import android.content.Intent;
import android.os.Bundle;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.aidl.IEventCallback;
import com.mi.milink.sdk.aidl.IPacketCallback;
import com.mi.milink.sdk.aidl.ISendCallback;
import com.mi.milink.sdk.aidl.IService;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.service.MnsNotify;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.SessionManager;
import java.util.ArrayList;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MnsServiceBinder
extends IService.Stub
implements IPacketListener {
    private static final String TAG = "MnsServiceBinder";
    private static final MnsServiceBinder sInstance = new MnsServiceBinder();
    private final RemoteCallbackList<IPacketCallback> mPacketCallBackList = new RemoteCallbackList();
    private final RemoteCallbackList<IEventCallback> mEventCallBackList = new RemoteCallbackList();

    private MnsServiceBinder() {
        EventBus.getDefault().register(this);
        MnsPacketDispatcher.getInstance().setCallback(this);
        SessionManager.getInstance();
        EventBus.getDefault().post(new MiLinkEvent.SystemNotificationEvent(MiLinkEvent.SystemNotificationEvent.EventType.ServiceCreated));
        System.currentTimeMillis();
    }

    public static MnsServiceBinder getInstance() {
        return sInstance;
    }

    @Override
    public void init(String string2, String string3, String string4, byte[] byArray, boolean bl2) throws RemoteException {
        MiLinkLog.w(TAG, "init,passportInit=".concat(String.valueOf(bl2)));
        SessionManager.getInstance().initApp();
        MiAccountManager.getInstance().login(string2, string3, string4, byArray, bl2);
    }

    @Override
    public void setEventCallBack(IEventCallback iEventCallback) {
        this.mEventCallBackList.register((IInterface)iEventCallback);
    }

    @Override
    public void setPacketCallBack(IPacketCallback iPacketCallback) throws RemoteException {
        this.mPacketCallBackList.register((IInterface)iPacketCallback);
    }

    @Override
    public void sendAsyncWithResponse(PacketData packetData, int n2, final ISendCallback iSendCallback) throws RemoteException {
        if (iSendCallback == null) {
            SessionManager.getInstance().sendData(packetData, n2, null);
            return;
        }
        SessionManager.getInstance().sendData(packetData, n2, new ResponseListener(){

            @Override
            public void onDataSendSuccess(int n2, PacketData packetData) {
                if (iSendCallback != null) {
                    try {
                        iSendCallback.onRsponse(packetData);
                        return;
                    }
                    catch (RemoteException remoteException) {}
                }
            }

            @Override
            public void onDataSendFailed(int n2, String string2) {
                if (iSendCallback != null) {
                    try {
                        iSendCallback.onFailed(n2, string2);
                        return;
                    }
                    catch (RemoteException remoteException) {}
                }
            }
        });
    }

    @Override
    public void logoff() throws RemoteException {
        MiLinkLog.i(TAG, "logoff");
        MiAccountManager.getInstance().userLogoff();
    }

    @Override
    public int setClientInfo(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return Integer.MIN_VALUE;
        }
        try {
            bundle = (Messenger)bundle.getParcelable("ipc.client.notifier");
            if (bundle == null) {
                return Integer.MIN_VALUE;
            }
            this.start((Messenger)bundle);
            return Process.myPid();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    private MnsServiceBinder start(Messenger messenger) {
        MnsNotify.setMessenger(messenger);
        MnsNotify.sendEvent(10, 0, System.currentTimeMillis());
        return this;
    }

    @Override
    public int getServerState() {
        try {
            return SessionManager.getInstance().getSessionState();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Override
    public boolean isMiLinkLogined() {
        MiLinkLog.i(TAG, "isMiLinkLogined");
        try {
            return SessionManager.getInstance().isMiLinkLogined();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public boolean onError(int n2, String string2, Object object) {
        MnsNotify.sendEvent(9, n2, string2);
        return true;
    }

    @Override
    public void setIpAndPortInManualMode(String string2, int n2) throws RemoteException {
        SessionManager.getInstance().setIpAndPortInManualMode(string2, n2);
    }

    @Override
    public String getSuid() throws RemoteException {
        MiLinkLog.i(TAG, "getSuid");
        return ConfigManager.getInstance().getSuid();
    }

    @Override
    public void forceReconnet() throws RemoteException {
        MiLinkLog.i(TAG, "forceReconnet");
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientForceOpen));
    }

    @Override
    public void fastLogin(String string2, String string3, String string4, byte[] byArray) throws RemoteException {
        MiLinkLog.i(TAG, "fastLogin");
        MiAccountManager.getInstance().login(string2, string3, string4, byArray, false);
    }

    @Override
    public boolean enableConnectionManualMode(boolean bl2) throws RemoteException {
        return SessionManager.getInstance().enableConnectionManualMode(bl2);
    }

    @Override
    public void setTimeoutMultiply(float f2) throws RemoteException {
        ConfigManager.getInstance().setTimeoutMultiply(f2);
    }

    @Override
    public void onReceive(ArrayList<PacketData> arrayList) {
        MiLinkLog.e("MiLinkReceive", "\u63a5\u6536\u5230push\u5305\u4fe1\u606f MnsServiceBinder list:  " + arrayList.size());
        Intent intent = new ArrayList();
        MiLinkLog.v(TAG, "delivery data, data size=" + arrayList.size());
        boolean bl2 = false;
        int n2 = this.mPacketCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n2; ++i2) {
            IPacketCallback iPacketCallback = (IPacketCallback)this.mPacketCallBackList.getBroadcastItem(i2);
            try {
                if (iPacketCallback.onReceive(arrayList)) {
                    bl2 = true;
                    MiLinkLog.v(TAG, "delivery data success");
                    continue;
                }
                bl2 = false;
                MiLinkLog.v(TAG, "onReceive return false,try delivery data by broadcast");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.w(TAG, "dead callback.");
                intent.add(iPacketCallback);
            }
        }
        this.mPacketCallBackList.finishBroadcast();
        for (IPacketCallback iPacketCallback : intent) {
            MiLinkLog.v(TAG, "unregister callback.");
            this.mPacketCallBackList.unregister((IInterface)iPacketCallback);
        }
        if (!bl2) {
            long l2 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app not run, delivery data by broadcast, data size=" + arrayList.size() + ", time=" + l2);
            intent = new Intent("com.mi.milink.ACTION_MSG");
            intent.putParcelableArrayListExtra("extra_msg_ary", arrayList);
            intent.putExtra("extra_act_time", l2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    private boolean onSessionStateChanged(int n2, int n3) {
        MiLinkLog.i(TAG, "Session State Changed From " + n2 + " \u2192 " + n3);
        if (n2 != n3) {
            MnsNotify.sendEvent(6, n2, n3);
        }
        return true;
    }

    private boolean onMiLinkLoginStateChanged(int n2) {
        MiLinkLog.i(TAG, "onMiLinkLoginStateChanged state=".concat(String.valueOf(n2)));
        MnsNotify.sendEvent(14, 0, n2);
        return true;
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionManagerStateChangeEvent sessionManagerStateChangeEvent) {
        switch (sessionManagerStateChangeEvent.mEventType) {
            case LoginStateChange: {
                this.onMiLinkLoginStateChanged(sessionManagerStateChangeEvent.mNewState);
                return;
            }
            case SessionStateChange: {
                this.onSessionStateChanged(sessionManagerStateChangeEvent.mOldState, sessionManagerStateChangeEvent.mNewState);
            }
        }
    }

    private void onEventGetServiceToken() {
        MiLinkLog.v(TAG, "no service token, call app onEventGetServiceToken");
        Intent intent = new ArrayList();
        boolean bl2 = false;
        int n2 = this.mEventCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n2; ++i2) {
            IEventCallback iEventCallback = (IEventCallback)this.mEventCallBackList.getBroadcastItem(i2);
            try {
                iEventCallback.onEventGetServiceToken();
                bl2 = true;
                MiLinkLog.v(TAG, " notify app get service token success");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.v(TAG, "dead callback.");
                intent.add(iEventCallback);
            }
        }
        this.mEventCallBackList.finishBroadcast();
        for (IEventCallback iEventCallback : intent) {
            MiLinkLog.v(TAG, "unregister event callback.");
            this.mEventCallBackList.unregister((IInterface)iEventCallback);
        }
        if (!bl2) {
            long l2 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app does not run, broadcast get service token, time=".concat(String.valueOf(l2)));
            intent = new Intent("com.mi.milink.ACTION_GET_ST");
            intent.putExtra("extra_act_time", l2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    private void onEventServiceTokenExpired() {
        MiLinkLog.v(TAG, "service token expired, call app onEventServiceTokenExpired");
        Intent intent = new ArrayList();
        boolean bl2 = false;
        int n2 = this.mEventCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n2; ++i2) {
            IEventCallback iEventCallback = (IEventCallback)this.mEventCallBackList.getBroadcastItem(i2);
            try {
                iEventCallback.onEventServiceTokenExpired();
                bl2 = true;
                MiLinkLog.v(TAG, " notify app service token expired success");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.v(TAG, "dead callback.");
                intent.add(iEventCallback);
            }
        }
        this.mEventCallBackList.finishBroadcast();
        for (IEventCallback iEventCallback : intent) {
            MiLinkLog.v(TAG, "unregister event callback.");
            this.mEventCallBackList.unregister((IInterface)iEventCallback);
        }
        if (!bl2) {
            long l2 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app does not run, broadcast service token expired, time=".concat(String.valueOf(l2)));
            intent = new Intent("com.mi.milink.ACTION_ST_EXPIRED");
            intent.putExtra("extra_act_time", l2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    private void onEventKickByServer(int n2, long l2, String string2) {
        MiLinkLog.v(TAG, String.format("kicked by server, type is %d,time is %d s,device is %s call app onKickedByServer", n2, l2, string2));
        ArrayList<IEventCallback> arrayList = new ArrayList<IEventCallback>();
        boolean bl2 = false;
        int n3 = this.mEventCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n3; ++i2) {
            IEventCallback iEventCallback = (IEventCallback)this.mEventCallBackList.getBroadcastItem(i2);
            try {
                iEventCallback.onEventKickedByServer(n2, l2 * 1000L, string2);
                bl2 = true;
                MiLinkLog.v(TAG, " notify app service kicked by server success");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.v(TAG, "dead callback.");
                arrayList.add(iEventCallback);
            }
        }
        this.mEventCallBackList.finishBroadcast();
        for (IEventCallback iEventCallback : arrayList) {
            MiLinkLog.v(TAG, "unregister event callback.");
            this.mEventCallBackList.unregister((IInterface)iEventCallback);
        }
        if (!bl2) {
            long l3 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app does not run, broadcast kicked by server, time=".concat(String.valueOf(l3)));
            Intent intent = new Intent("com.mi.milink.ACTION_KICKED_BY_SERVER");
            intent.putExtra("extra_act_time", l3);
            intent.putExtra("extra_kicked_type", string2);
            intent.putExtra("extra_kicked_time", l2);
            intent.putExtra("extra_kicked_device", string2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    private void onEventShouldUpdate() {
        MiLinkLog.v(TAG, "app should check update.");
        Intent intent = new ArrayList();
        boolean bl2 = false;
        int n2 = this.mEventCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n2; ++i2) {
            IEventCallback iEventCallback = (IEventCallback)this.mEventCallBackList.getBroadcastItem(i2);
            try {
                iEventCallback.onEventShouldCheckUpdate();
                bl2 = true;
                MiLinkLog.v(TAG, " notify app check update success");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.v(TAG, "dead callback.");
                intent.add(iEventCallback);
            }
        }
        this.mEventCallBackList.finishBroadcast();
        for (IEventCallback iEventCallback : intent) {
            MiLinkLog.v(TAG, "unregister event callback.");
            this.mEventCallBackList.unregister((IInterface)iEventCallback);
        }
        if (!bl2) {
            long l2 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app does not run, broadcast check update, time=".concat(String.valueOf(l2)));
            intent = new Intent("com.mi.milink.ACTION_CHECK_UPDATE");
            intent.putExtra("extra_act_time", l2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    private void onEventRecvInvalidPacket() {
        MiLinkLog.v(TAG, "invalid packet, call app onEventInvalidPacket ");
        Intent intent = new ArrayList();
        boolean bl2 = false;
        int n2 = this.mEventCallBackList.beginBroadcast();
        for (int i2 = 0; i2 < n2; ++i2) {
            IEventCallback iEventCallback = (IEventCallback)this.mEventCallBackList.getBroadcastItem(i2);
            try {
                iEventCallback.onEventInvalidPacket();
                bl2 = true;
                MiLinkLog.v(TAG, " notify app invalid packet success");
                continue;
            }
            catch (Exception exception) {
                MiLinkLog.v(TAG, "dead callback.");
                intent.add(iEventCallback);
            }
        }
        this.mEventCallBackList.finishBroadcast();
        for (IEventCallback iEventCallback : intent) {
            MiLinkLog.v(TAG, "unregister event callback.");
            this.mEventCallBackList.unregister((IInterface)iEventCallback);
        }
        if (!bl2) {
            long l2 = System.currentTimeMillis();
            MiLinkLog.v(TAG, "app does not run, broadcast invalid packet, time=".concat(String.valueOf(l2)));
            intent = new Intent("com.mi.milink.ACTION_INVALID_PACKET");
            intent.putExtra("extra_act_time", l2);
            intent.setPackage(Global.getClientAppInfo().getPackageName());
            Global.sendBroadcast(intent);
        }
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionManagerNotificationEvent object) {
        switch (((MiLinkEvent.SessionManagerNotificationEvent)object).mEventType) {
            case GetServiceToken: {
                this.onEventGetServiceToken();
                return;
            }
            case KickByServer: {
                int n2 = 0;
                long l2 = 0L;
                String string2 = "";
                if (((MiLinkEvent.SessionManagerNotificationEvent)object).mObject != null) {
                    object = (PushPacketProto.KickMessage)((MiLinkEvent.SessionManagerNotificationEvent)object).mObject;
                    n2 = ((PushPacketProto.KickMessage)object).getType();
                    l2 = ((PushPacketProto.KickMessage)object).getTime();
                    string2 = ((PushPacketProto.KickMessage)object).getDevice();
                }
                this.onEventKickByServer(n2, l2, string2);
                return;
            }
            case ServiceTokenExpired: {
                this.onEventServiceTokenExpired();
                return;
            }
            case ShouldUpdate: {
                this.onEventShouldUpdate();
                return;
            }
            case RecvInvalidPacket: {
                this.onEventRecvInvalidPacket();
            }
        }
    }

    @Override
    public void setAllowAnonymousLoginSwitch(boolean bl2) throws RemoteException {
        MiAccountManager.getInstance().setAnonymousModeSwitch(bl2);
    }

    @Override
    public void initUseAnonymousMode() throws RemoteException {
        SessionManager.getInstance().initApp();
        MiAccountManager.getInstance().initUseAnonymousMode();
    }

    @Override
    public void setMipushRegId(String string2) throws RemoteException {
        MiAccountManager.getInstance().setMipushRegId(string2);
    }

    @Override
    public void suspectBadConnection() throws RemoteException {
        SessionManager.getInstance().suspectBadConnection();
    }

    @Override
    public void setMilinkLogLevel(int n2) throws RemoteException {
        MiLinkLog.setLogcatTraceLevel(n2);
        MiLinkLog.setFileTraceLevel(n2);
    }

    @Override
    public void setLanguage(String string2) throws RemoteException {
        Global.getClientAppInfo().setLanguageCode(string2);
    }

    @Override
    public long getAnonymousAccountId() throws RemoteException {
        try {
            return Long.parseLong(AnonymousAccount.getInstance().getUserId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public void setGlobalPushFlag(boolean bl2) throws RemoteException {
        SessionManager.getInstance().setGlobalPushFlag(bl2);
    }
}

