/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.StreamUtil;

public class BufferUtil {
    private static String TAG = "BufferUtil";

    public static boolean isHttpHead(byte[] byArray) {
        String string2 = new String(byArray).substring(0, 4).toUpperCase();
        return byArray != null && string2.charAt(0) == 'H' && string2.charAt(1) == 'T' && string2.charAt(2) == 'T' && string2.charAt(3) == 'P';
    }

    public static boolean isMNSHead(byte[] byArray) {
        if (byArray != null && byArray.length >= StreamUtil.MNS.length) {
            return byArray[0] == StreamUtil.MNS[0] && byArray[1] == StreamUtil.MNS[1] && byArray[2] == StreamUtil.MNS[2] && byArray[3] == StreamUtil.MNS[3];
        }
        return false;
    }

    public static boolean isEqualByte(byte by2, byte by3) {
        return by2 == by3 || Character.isLetter((char)by2) && Character.isLetter((char)by2) && Math.abs(by2 - by3) == 32;
    }

    public static void copy(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n2++] = byArray2[n3 + i2];
        }
    }

    public static int findFormByte(byte[] byArray, byte[] byArray2) {
        MiLinkLog.d(TAG, "findFormByte recvData");
        for (int i2 = byArray2.length - 1; i2 < byArray.length; ++i2) {
            boolean bl2 = true;
            int n2 = byArray2.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (BufferUtil.isEqualByte(byArray[i2 - n2 + i3 + 1], byArray2[i3])) continue;
                bl2 = false;
            }
            if (!bl2) continue;
            return i2 + 1;
        }
        return -1;
    }

    public static int findFromByteKMP(byte[] byArray, byte[] byArray2) {
        int n2 = BufferUtil.getIndexKMP(byArray, byArray2);
        if (n2 != -1) {
            n2 += byArray2.length;
        }
        return n2;
    }

    public static int getIndexKMP(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (n2 < n3) {
            return -1;
        }
        int[] nArray = BufferUtil.getKMPNext(byArray2);
        if (nArray == null) {
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < n3) {
            if (BufferUtil.isEqualByte(byArray[n4], byArray2[n5])) {
                ++n4;
                ++n5;
                continue;
            }
            if (n5 == 0) {
                ++n4;
                continue;
            }
            n5 = nArray[n5 - 1] + 1;
        }
        if (n5 == n3) {
            return n4 - n5;
        }
        return -1;
    }

    private static int[] getKMPNext(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2];
        int[] nArray2 = nArray;
        nArray[0] = -1;
        for (int i2 = 1; i2 < n2; ++i2) {
            int n3 = nArray2[i2 - 1];
            while (n3 >= 0 && !BufferUtil.isEqualByte(byArray[i2], byArray[n3 + 1])) {
                n3 = nArray2[n3];
            }
            nArray2[i2] = BufferUtil.isEqualByte(byArray[i2], byArray[n3 + 1]) ? n3 + 1 : -1;
        }
        return nArray2;
    }

    public static int findContentLengthFromByte(byte[] byArray) {
        byte[] byArray2 = new byte[15];
        BufferUtil.copy(byArray2, 0, "Content-Length:".getBytes(), 0, 15);
        return BufferUtil.findFormByte(byArray, byArray2);
    }

    public static int findMNSHeaderFromByte(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = byArray2;
        byArray2[0] = StreamUtil.MNS[0];
        byArray3[1] = StreamUtil.MNS[1];
        byArray3[2] = StreamUtil.MNS[2];
        byArray3[3] = StreamUtil.MNS[3];
        return BufferUtil.findFormByte(byArray, byArray3);
    }

    public static int findHttpHeaderEndFromByte(byte[] byArray) {
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = byArray2;
        byArray2[0] = 13;
        byArray3[1] = 10;
        byArray3[2] = 13;
        byArray3[3] = 10;
        return BufferUtil.findFormByte(byArray, byArray3);
    }
}

