/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.connection.DomainManager;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class IServerManager {
    protected IIpInfoManager mIpInfoManager;
    protected static final int DEFAULT_SESSION_COUNT = 4;
    protected List<ServerProfile> mTcpServerList = Collections.synchronizedList(new ArrayList());
    protected int mTcpServerListIndex = 0;

    protected IServerManager(IIpInfoManager iIpInfoManager) {
        this.mIpInfoManager = iIpInfoManager;
    }

    protected static void addServerProfileInSpecifiedList(List<ServerProfile> list, List<ServerProfile> list2) {
        if (Const.ServerPort.PORT_ARRAY.length != 4) {
            MiLinkLog.e("IServerManager", "PORT_ARRAY.length != 4");
            return;
        }
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0}, {0, 0, 1, 1}, {0, 0, 1, 2}, {0, 1, 2, 3}};
        int n2 = list.size();
        if (n2 > 4) {
            n2 = 4;
        }
        if (n2 <= 4 && n2 > 0) {
            for (int i2 = 0; i2 < Const.ServerPort.PORT_ARRAY.length; ++i2) {
                try {
                    list2.add(new ServerProfile(list.get(nArrayArray[n2 - 1][i2]).getServerIP(), Const.ServerPort.PORT_ARRAY[i2], 1, 1));
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public abstract ServerProfile[] reset(boolean var1);

    public abstract ServerProfile[] getNext(ServerProfile var1, int var2);

    public boolean save(ServerProfile serverProfile) {
        if (serverProfile == null) {
            return false;
        }
        serverProfile.setServerIP(DomainManager.getInstance().queryDomainIP(serverProfile.getServerIP()));
        if (serverProfile.getProtocol() != 1) {
            return false;
        }
        this.mIpInfoManager.setRecentlyServer(new ServerProfile(serverProfile.getServerIP(), serverProfile.getServerPort(), serverProfile.getProtocol(), 3));
        return true;
    }

    public abstract void destroy();

    protected ServerProfile getNextTcpProfile() {
        if (this.mTcpServerListIndex == this.mTcpServerList.size()) {
            return null;
        }
        return this.mTcpServerList.get(this.mTcpServerListIndex++);
    }

    public abstract void loadCurrentApn();
}

