/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import com.mi.milink.sdk.base.data.Convert;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.session.common.BufferUtil;
import com.mi.milink.sdk.session.common.InvalidPacketExecption;
import java.io.UnsupportedEncodingException;
import org.greenrobot.eventbus.EventBus;

public class ReceiveBuffer {
    private static String CLASSTAG = "ReceiveBuffer";
    private String TAG;
    public static final int SOCKET_RECV_BUFFER = 256;
    private static final int INTEGER_LENGTH = 4;
    private static final int MIN_TCP_PACKAGE_HEADER_LENGTH = 8;
    private static final int MAX_HTTP_PACKAGE_HEADER_LENGTH = 2048;
    private byte[] mBuffer = null;
    private byte[] mBufferBuffer = null;
    private boolean mBtWorkingStatus = false;
    private final Object mBufLock;
    private int mPosition = 0;
    private ReceiveBufferSink mSink;
    private int mCreatorSessionNO;
    private boolean mBackupThreadDead = false;
    private Thread mBackupThread;
    private boolean mIsAssistSession = false;
    private int mChannelBusy = 0;
    private static int sThreadIndex = 0;

    public ReceiveBuffer(ReceiveBufferSink receiveBufferSink, int n2, boolean bl2) {
        this.mSink = receiveBufferSink;
        try {
            this.mBuffer = new byte[256];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MiLinkLog.e(this.TAG, "ReceiveBuffer init failed", outOfMemoryError);
        }
        this.mCreatorSessionNO = n2;
        this.TAG = String.format("[No:%d]%s", n2, CLASSTAG);
        this.mIsAssistSession = bl2;
        this.mBufLock = new Object();
    }

    public void startBufferThread() {
        this.clear();
        try {
            this.mBackupThread = new Thread("Milink-ReceiverBuffer-" + ++sThreadIndex){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    super.run();
                    while (true) {
                        byte[] byArray = null;
                        Object object = ReceiveBuffer.this.mBufLock;
                        synchronized (object) {
                            try {
                                if (ReceiveBuffer.this.mBufferBuffer == null || ReceiveBuffer.this.mBufferBuffer.length == 0) {
                                    ReceiveBuffer.this.mBufLock.wait();
                                }
                                if (ReceiveBuffer.this.mBackupThreadDead) {
                                    MiLinkLog.e(ReceiveBuffer.this.TAG, String.format("%s back up thread dead", Thread.currentThread().getName()));
                                    return;
                                }
                                byArray = new byte[ReceiveBuffer.this.mBufferBuffer.length];
                                System.arraycopy(ReceiveBuffer.this.mBufferBuffer, 0, byArray, 0, ReceiveBuffer.this.mBufferBuffer.length);
                                ReceiveBuffer.access$102(ReceiveBuffer.this, null);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        if (byArray == null) continue;
                        try {
                            ReceiveBuffer.this.mBtWorkingStatus = true;
                            ReceiveBuffer.this.bufferHandler(byArray);
                            ReceiveBuffer.this.mBtWorkingStatus = false;
                            continue;
                        }
                        catch (InvalidPacketExecption invalidPacketExecption) {
                            invalidPacketExecption.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            this.mBackupThread.start();
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e(this.getClass().getName(), "\u521b\u5efa receiver back thread \u5931\u8d25");
            this.clear();
            return;
        }
    }

    public void bufferHandler(byte[] byArray) throws InvalidPacketExecption {
        if (byArray == null) {
            MiLinkLog.e(this.getClass().getName(), "==> buffer handler the buffer is null");
            return;
        }
        int n2 = byArray.length;
        if (!this.mIsAssistSession) {
            if (n2 >= 5000) {
                if (++this.mChannelBusy > 10) {
                    EventBus.getDefault().post(new MiLinkEvent.ChannelStatusChangeEvent(MiLinkEvent.ChannelStatusChangeEvent.EventType.channelBusy, null));
                    this.mChannelBusy = 0;
                }
            } else if (n2 < 1000 && --this.mChannelBusy < -5) {
                EventBus.getDefault().post(new MiLinkEvent.ChannelStatusChangeEvent(MiLinkEvent.ChannelStatusChangeEvent.EventType.channelIdle, null));
                this.mChannelBusy = 0;
            }
        }
        MiLinkLog.v(this.TAG, Thread.currentThread().getName() + "now mBuffer.len=" + this.mBuffer.length + ",pos=" + this.mPosition + ",recvLen=" + n2);
        if (this.mBuffer.length - this.mPosition < n2) {
            MiLinkLog.v(this.TAG, "buffer need to be increased");
            try {
                byte[] byArray2 = new byte[this.mPosition + n2];
                System.arraycopy(this.mBuffer, 0, byArray2, 0, this.mPosition);
                System.arraycopy(byArray, 0, byArray2, this.mPosition, n2);
                this.mBuffer = byArray2;
                this.mPosition += n2;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                MiLinkLog.e(this.TAG, "append new byte fail ", outOfMemoryError);
            }
        } else {
            System.arraycopy(byArray, 0, this.mBuffer, this.mPosition, n2);
            this.mPosition += n2;
        }
        this.parsePacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(byte[] byArray) throws InvalidPacketExecption {
        if (byArray == null || byArray.length == 0) {
            MiLinkLog.e(this.TAG, "recv data is null");
            return;
        }
        if (this.mBackupThread == null || byArray.length < 256 && !this.mBtWorkingStatus && this.mBufferBuffer == null) {
            MiLinkLog.e(this.TAG, "===> socket thread directly handle packet");
            this.bufferHandler(byArray);
            return;
        }
        Object object = this.mBufLock;
        synchronized (object) {
            MiLinkLog.e(this.TAG, "==> back thread handle packet");
            if (this.mBufferBuffer == null) {
                this.mBufferBuffer = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.mBufferBuffer, 0, byArray.length);
            } else {
                int n2 = this.mBufferBuffer.length;
                byte[] byArray2 = new byte[n2 + byArray.length];
                System.arraycopy(this.mBufferBuffer, 0, byArray2, 0, n2);
                System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
                this.mBufferBuffer = byArray2;
            }
            this.mBufLock.notify();
            return;
        }
    }

    private void removeToBegin(int n2) {
        if (this.mBuffer == null) {
            return;
        }
        int n3 = this.mPosition - n2;
        this.mPosition = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.mBuffer[this.mPosition++] = this.mBuffer[n2 + i2];
        }
    }

    private void parsePacket() throws InvalidPacketExecption {
        MiLinkLog.v(this.TAG, "parsePacket start");
        MiLinkLog.v("MiLinkReceive", "\u89e3\u6790\u6570\u636e\u5305\u5f00\u59cb ");
        while (this.parseNormalPacket()) {
        }
        int n2 = this.mBuffer.length;
        if (this.mPosition == 0 && n2 > 256) {
            MiLinkLog.v(this.TAG, "reset buffer size: ".concat(String.valueOf(n2)));
            this.mBuffer = new byte[256];
        }
    }

    private long getPacketLen() throws InvalidPacketExecption {
        MiLinkLog.i(this.TAG, "getPacketLen start, mPosition=" + this.mPosition);
        if (this.mPosition < 8) {
            if (this.mPosition != 0) {
                MiLinkLog.i(this.TAG, "getPacketLen [position = " + this.mPosition + "] < TCP_PACKAGE_HEADER_LENGTH(8)");
            }
            return -1L;
        }
        if (BufferUtil.isHttpHead(this.mBuffer)) {
            MiLinkLog.i(this.TAG, "getPacketLen isHttpHead");
            int n2 = BufferUtil.findHttpHeaderEndFromByte(this.mBuffer);
            if (n2 <= 0) {
                if (this.mPosition > 2048) {
                    MiLinkLog.i(this.TAG, "HTTP CONTENT : " + Convert.bytesToASCIIString(this.mBuffer, 2048));
                    throw new InvalidPacketExecption("wrong packet\uff0ccannot find http header end", 4);
                }
                return -1L;
            }
            this.removeToBegin(n2 - 1);
        }
        if (!BufferUtil.isMNSHead(this.mBuffer)) {
            MiLinkLog.i(this.TAG, "no mns head: length=" + this.mBuffer.length + "; " + Convert.bytesToHexStr(this.mBuffer, 2048));
            try {
                MiLinkLog.w(this.TAG, "no mns head , try to get string : " + new String(this.mBuffer, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            throw new InvalidPacketExecption("wrong packet\uff0cno mns head", 1);
        }
        return Convert.bytesToUint(this.mBuffer, 4);
    }

    private boolean parseNormalPacket() throws InvalidPacketExecption {
        MiLinkLog.v("MiLinkReceive", "\u89e3\u6790\u666e\u901a\u6570\u636e\u5305\u5f00\u59cb ");
        long l2 = this.getPacketLen();
        MiLinkLog.i(this.TAG, "parseNormalPacket start, packetLen = " + l2 + ", mPosition=" + this.mPosition);
        if (l2 == -1L) {
            return false;
        }
        if (l2 < 8L) {
            throw new InvalidPacketExecption("[wrong packetlen = " + l2 + "]", 2);
        }
        if (l2 > 0x200000L) {
            throw new InvalidPacketExecption("[wrong packetlen = " + l2 + "]", 3);
        }
        if (l2 > (long)this.mPosition) {
            int n2 = this.mBuffer.length;
            if (l2 > (long)n2) {
                MiLinkLog.v(this.TAG, "increased mBuffer to " + (l2 + 5120L));
                try {
                    byte[] byArray = new byte[(int)(l2 + 5120L)];
                    System.arraycopy(this.mBuffer, 0, byArray, 0, this.mPosition);
                    this.mBuffer = byArray;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    MiLinkLog.e(this.TAG, "append new byte fail ", outOfMemoryError);
                }
            }
            return false;
        }
        MiLinkLog.i(this.TAG, "parseNormalPacket [packetLen = " + l2 + "]");
        byte[] byArray = new byte[(int)l2];
        System.arraycopy(this.mBuffer, 0, byArray, 0, (int)l2);
        this.removeToBegin((int)l2);
        if (this.mSink != null) {
            this.mSink.onRecvDownStream(this.mCreatorSessionNO, byArray);
        }
        return true;
    }

    public void reset() {
        this.mPosition = 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.mBackupThread != null) {
            this.mBackupThreadDead = true;
            Object object = this.mBufLock;
            synchronized (object) {
                this.mBufLock.notifyAll();
            }
            try {
                if (this.mBackupThread != null) {
                    this.mBackupThread.join(200L);
                }
                this.mBackupThread = null;
                return;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static /* synthetic */ byte[] access$102(ReceiveBuffer receiveBuffer, byte[] byArray) {
        receiveBuffer.mBufferBuffer = byArray;
        return byArray;
    }

    public static interface ReceiveBufferSink {
        public boolean onRecvDownStream(int var1, byte[] var2);

        public boolean onAddTimeout(int var1, int var2);
    }
}

