/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import android.os.SystemClock;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.StreamUtil;

public class Request {
    private PacketData data;
    private IAccount ownerAccount;
    private long sentTime = 0L;
    private long createdTime;
    private int timeOut = ConfigManager.getInstance().getRequestTimeout();
    private boolean isPing = false;
    private boolean isInternal = false;
    private ResponseListener listener;
    private byte encodeType = 0;
    private int size = 0;
    private boolean hasCallback = false;
    private boolean hasRetry = false;
    private int retryCount = 0;
    private AfterHandleCallBack afterHandleCallBack = null;
    private int mHandleSessionNO = 0;

    public void setHasRetry() {
        this.hasRetry = true;
    }

    public void setInternal(boolean bl2) {
        this.isInternal = bl2;
    }

    public Request(PacketData packetData, ResponseListener responseListener, byte by2, IAccount iAccount) {
        this.data = packetData;
        this.listener = responseListener;
        this.createdTime = SystemClock.elapsedRealtime();
        this.encodeType = by2;
        this.ownerAccount = iAccount;
    }

    public AfterHandleCallBack getAfterHandleCallBack() {
        return this.afterHandleCallBack;
    }

    public void setAfterHandleCallBack(AfterHandleCallBack afterHandleCallBack) {
        this.afterHandleCallBack = afterHandleCallBack;
    }

    public boolean isInternalRequest() {
        return this.isInternal;
    }

    public void setPing(boolean bl2) {
        this.isPing = bl2;
    }

    public void setSentTime(long l2) {
        this.sentTime = l2;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public int getValidTime() {
        return this.data.getValidTime();
    }

    public int getSeqNo() {
        return this.data.getSeqNo();
    }

    public PacketData getData() {
        return this.data;
    }

    public void setHandleSessionNO(int n2) {
        this.mHandleSessionNO = n2;
    }

    public byte[] toBytes() {
        byte[] byArray = StreamUtil.toUpBytes(String.format("[No:%d]", this.mHandleSessionNO), this.data, this.isPing, this.encodeType, this.ownerAccount);
        if (byArray != null) {
            this.size = byArray.length;
        }
        return byArray;
    }

    public boolean isPingRequest() {
        return this.isPing;
    }

    public int getSize() {
        return this.size;
    }

    public void setTimeOut(int n2) {
        if (n2 > 0 && this.data.needRetry()) {
            this.timeOut = n2 / 2;
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isTimeout() {
        return (float)(SystemClock.elapsedRealtime() - this.sentTime) > (float)this.timeOut * ConfigManager.getInstance().getTimeoutMultiply();
    }

    public boolean requestShouldCached() {
        return this.data.needCached();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void addRetryCount() {
        ++this.retryCount;
    }

    public boolean hasListenter() {
        return this.listener != null;
    }

    public void onDataSendSuccess(int n2, PacketData packetData) {
        if (this.listener == null) {
            return;
        }
        if (!this.hasCallback) {
            this.listener.onDataSendSuccess(n2, packetData);
            this.hasCallback = true;
        }
    }

    public boolean onDataSendFailed(int n2, String string2) {
        if (this.listener == null) {
            return false;
        }
        if (!this.hasCallback) {
            this.listener.onDataSendFailed(n2, string2);
            this.hasCallback = true;
        }
        return true;
    }

    public boolean isValidNow() {
        return SystemClock.elapsedRealtime() - this.createdTime < (long)this.getValidTime();
    }

    public IAccount getOwnerAccount() {
        return this.ownerAccount;
    }

    public boolean canRetry() {
        return !this.isInternal && this.data.needRetry() && !this.hasRetry && !this.hasCallback;
    }

    public static interface AfterHandleCallBack {
        public void onCallBack(String var1, int var2, String var3, int var4, long var5, long var7, int var9, int var10, int var11, String var12, String var13);
    }
}

