/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import com.mi.milink.sdk.session.common.SessionConst;
import java.io.Serializable;

public class ServerProfile
implements Serializable {
    private static final long serialVersionUID = -8956679711781976000L;
    private String mServerIP;
    private int mServerPort;
    private String mProxyIP;
    private int mPorxyPort;
    private int mProtocol;
    private int mServerType;

    public ServerProfile() {
    }

    public ServerProfile(String string2, int n2, int n3, int n4) {
        this(string2, n2, null, 0, n3, n4);
    }

    public ServerProfile(String string2, int n2, String string3, int n3, int n4, int n5) {
        this.mServerIP = string2;
        this.mServerPort = n2;
        this.mProxyIP = string3;
        this.mPorxyPort = n3;
        this.mProtocol = n4;
        this.mServerType = n5;
    }

    public boolean equals(ServerProfile serverProfile) {
        if (this.mServerIP == null || this.mServerPort == 0 || serverProfile == null) {
            return false;
        }
        if (!this.mServerIP.equals(serverProfile.getServerIP())) {
            return false;
        }
        if (this.mServerPort != serverProfile.getServerPort()) {
            return false;
        }
        if (this.mProxyIP == null && serverProfile.getProxyIP() == null) {
            return true;
        }
        if (this.mProxyIP != null && serverProfile.getProxyIP() == null || this.mProxyIP == null && serverProfile.getProxyIP() != null) {
            return false;
        }
        if (this.mProxyIP != null && !this.mProxyIP.equals(serverProfile.getProxyIP())) {
            return false;
        }
        return this.mPorxyPort == serverProfile.getPorxyPort();
    }

    public boolean isBetterThan(ServerProfile serverProfile) {
        if (serverProfile == null) {
            return true;
        }
        if (this.mServerIP == null || this.mServerPort == 0) {
            return false;
        }
        if (this.mProtocol == 1) {
            if (this.mServerType == 2) {
                return true;
            }
            if (serverProfile.getProtocol() == 1) {
                return serverProfile.getServerType() != 2;
            }
            return true;
        }
        return false;
    }

    public int getServerType() {
        return this.mServerType;
    }

    public void setServerType(int n2) {
        this.mServerType = n2;
    }

    public String getServerIP() {
        return this.mServerIP;
    }

    public void setServerIP(String string2) {
        this.mServerIP = string2;
    }

    public int getServerPort() {
        return this.mServerPort;
    }

    public void setServerPort(int n2) {
        this.mServerPort = n2;
    }

    public String getProxyIP() {
        return this.mProxyIP;
    }

    public void setProxyIP(String string2) {
        this.mProxyIP = string2;
    }

    public int getPorxyPort() {
        return this.mPorxyPort;
    }

    public void setPorxyPort(int n2) {
        this.mPorxyPort = n2;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(int n2) {
        this.mProtocol = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append("sIP=").append(this.mServerIP);
        stringBuilder.append(", sPort=").append(this.mServerPort);
        stringBuilder.append(", pIP=").append(this.mProxyIP);
        stringBuilder.append(", pPort=").append(this.mPorxyPort);
        stringBuilder.append(", protocol=").append(SessionConst.getProtocol(this.mProtocol));
        stringBuilder.append(", type=").append(SessionConst.getSeverType(this.mServerType));
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public void parseFromString(String stringArray) {
        if (stringArray == null) {
            return;
        }
        stringArray = stringArray.substring(2, stringArray.length() - 2).split(", ");
        String[] stringArray2 = stringArray[0].split("=");
        this.setServerIP(stringArray2[1]);
        stringArray2 = stringArray[1].split("=");
        this.setServerPort(Integer.parseInt(stringArray2[1]));
        stringArray2 = stringArray[2].split("=");
        this.setProxyIP(stringArray2[1]);
        stringArray2 = stringArray[3].split("=");
        this.setPorxyPort(Integer.parseInt(stringArray2[1]));
        stringArray[4].split("=");
        this.setProtocol(1);
        stringArray2 = stringArray[5].split("=");
        this.setServerType(SessionConst.getTypeSever(stringArray2[1]));
    }
}

