/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import android.util.SparseArray;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionConst {
    private static final String TAG = "SessionConst";
    public static final int NONE_CONNECTION_TYPE = 0;
    public static final int TCP_CONNECTION_TYPE = 1;
    public static final int OPTI_IP = 1;
    public static final int REDIRECT_IP = 2;
    public static final int RECENTLY_IP = 3;
    public static final int DOMAIN_IP = 4;
    public static final int BACKUP_IP = 5;
    public static final int CDN_IP = 6;
    public static final int TEST_IP = 7;
    public static final int SCORE_IP = 8;
    public static final int CONN_FAILED = 1;
    public static final int HANDSHAKE_OTHERERROR_FAILED = 2;
    public static final int HANDSHAKE_PACKERROR_FAILED = 3;
    public static final int PACKET_TYPE_DOWNSTREAM = 0;
    public static final int PACKET_TYPE_TLV = 1;
    public static final byte HEART_BEAT_SCENE_AFTER_HANDSHAKE_START = 1;
    public static final byte HEART_BEAT_SCENE_AFTER_HANDSHAKE_NORMAL = 2;
    public static final byte HEART_BEAT_SCENE_SHORT_TIMEOUT = 3;
    public static final byte HEART_BEAT_SCENE_LONG_TIMEOUT = 4;
    public static final byte HEART_BEAT_SCENE_EXIT_POWERSAVING = 5;
    public static final String ERROR_MSG = "ERROR_MSG";
    private static AtomicInteger uniqueSessionNO = new AtomicInteger(1);
    public static final String CDN_PICTURE_URL = "http://connect-milink.g.mi.com/t.html";
    private static volatile boolean sIsNewApn = true;
    public static final int TIME_OUT_MAX_RETRY_TIMES = 2;
    public static final int ACC_NEED_CLIENT_RETRY_TIMES = 1;
    public static final int CONTINUOUS_RECV_TIMEOUT_PACKAGE_MAX_COUNT = 3;
    private static SparseArray<String> conTypeMap = new SparseArray();
    private static SparseArray<String> serverTypeMap = new SparseArray();
    private static Map<String, Integer> typeServerMap = new HashMap<String, Integer>();
    public static final int TEST_PIC_OK = 0;
    public static final int TEST_PIC_FAIL = 1;
    public static final int TEST_PIC_NEED_REDIRECT = 2;
    private static final int TEST_PIC_CONNECT_TIMEOUT = 5000;
    private static final int TEST_PIC_READ_TIMEOUT = 15000;

    public static int generateSessionNO() {
        return uniqueSessionNO.getAndIncrement();
    }

    public static String getProtocol(int n2) {
        return (String)conTypeMap.get(n2);
    }

    public static String getSeverType(int n2) {
        return (String)serverTypeMap.get(n2);
    }

    public static int getTypeSever(String string2) {
        return typeServerMap.get(string2);
    }

    public static boolean isInternetAvailable() {
        HttpURLConnection httpURLConnection = null;
        try {
            String string2;
            Object object = new StringBuilder();
            ((StringBuilder)object).append(CDN_PICTURE_URL);
            ((StringBuilder)object).append("?time=");
            ((StringBuilder)object).append(System.currentTimeMillis());
            httpURLConnection = (HttpURLConnection)new URL(((StringBuilder)object).toString()).openConnection();
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(15000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string2);
            }
            MiLinkLog.v(TAG, "isInternetAvailable result=" + stringBuilder.toString());
            return stringBuilder.toString().contains("milink.test");
            {
            }
        }
        catch (Throwable throwable) {
            MiLinkLog.v(TAG, "isInternetAvailable error");
            return false;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public static void setNewApn(boolean bl2) {
        sIsNewApn = bl2;
    }

    public static boolean isNewApn() {
        boolean bl2 = sIsNewApn;
        if (bl2) {
            sIsNewApn = false;
        }
        return bl2;
    }

    static {
        conTypeMap.put(0, (Object)"none");
        conTypeMap.put(1, (Object)"tcp");
        serverTypeMap.put(1, (Object)"opt");
        serverTypeMap.put(2, (Object)"redirect");
        serverTypeMap.put(3, (Object)"recently");
        serverTypeMap.put(4, (Object)"dns");
        serverTypeMap.put(5, (Object)"bak");
        serverTypeMap.put(6, (Object)"cdn");
        serverTypeMap.put(7, (Object)"test");
        typeServerMap.put("opt", 1);
        typeServerMap.put("redirect", 2);
        typeServerMap.put("recently", 3);
        typeServerMap.put("dns", 4);
        typeServerMap.put("bak", 5);
        typeServerMap.put("cdn", 6);
        typeServerMap.put("test", 7);
    }
}

