/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.common;

import android.text.TextUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.data.Convert;
import com.mi.milink.sdk.base.os.info.DeviceDash;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.proto.DownstreamPacketProto;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.proto.UpstreamPacketProto;
import com.mi.milink.sdk.session.persistent.SessionManager;
import com.mi.milink.sdk.util.compress.CompressionFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class StreamUtil {
    private static final String CLASSTAG = "StreamUtil";
    public static final byte[] MNS = new byte[]{109, 108, 112, 0};
    public static final byte MNS_ENCODE_NONE = 0;
    public static final byte MNS_ENCODE_B2_TOKEN = 2;
    public static final byte MNS_ENCODE_FAST_LOGIN = 3;
    public static final byte MNS_ENCODE_B2_TOKEN_FOR_HS = 5;
    public static final byte MNS_ENCODE_ANONYMOUS_FAST_LOGIN = 7;
    public static final byte MNS_ENCODE_ANONYMOUS_B2_TOKEN = 8;
    public static final byte MNS_ENCODE_CHANNEL_FAST_LOGIN = 9;
    public static final byte MNS_ENCODE_CHANNEL_B2_TOKEN = 10;
    private static final int GLOBAL_PUSH_FLAG_MASK = 4096;
    private static final int PING_MASK = 256;
    private static final int NO_NEED_RESPONSE_MASK = 16;
    private static final int NEED_PUSH_ACK_MASK = 1;
    private static final String QUA_HEAD = "v1-";
    private static final int DEFAULT_COMPRESS_LEN = 512;
    private static final int BUSI_CONTROL_NO_COMPRESS = 0;
    private static final int BUSI_CONTROL_ZLIB_COMPRESS = 1;
    private static final String B2_FOR_HS = "bsJ0RccDL4JvKAR660A6wzHXxRKRXWPBMowLR4m7mWg=";
    private static final String B2K_FOR_HS = "4N9FcL47REBDdCHL";

    private StreamUtil() {
    }

    public static boolean isPingFlag(int n2) {
        return (n2 & 0x100) == 256;
    }

    public static boolean isNoNeedResponseFlag(int n2) {
        return (n2 & 0x10) == 16;
    }

    public static String getQua(IAccount iAccount) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(QUA_HEAD);
        stringBuilder.append(Global.getClientAppInfo(iAccount.getAppId()).getPlatformName());
        stringBuilder.append("-");
        stringBuilder.append(Global.getClientAppInfo(iAccount.getAppId()).getAppName());
        stringBuilder.append("-");
        stringBuilder.append(Global.getClientAppInfo(iAccount.getAppId()).getVersionName());
        stringBuilder.append("-");
        stringBuilder.append(Global.getClientAppInfo(iAccount.getAppId()).getReleaseChannel());
        stringBuilder.append("-");
        stringBuilder.append(Global.getClientAppInfo(iAccount.getAppId()).getLanguageCode());
        return stringBuilder.toString().toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toUpBytes(String object, PacketData packetData, boolean bl2, byte by2, IAccount iAccount) {
        String string2 = (String)object + CLASSTAG;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(MNS);
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0});
            byteArrayOutputStream.write(Global.getMiLinkProtocolVersion());
            byteArrayOutputStream.write(by2);
            int n2 = Convert.bytesToInt(new byte[]{0, 0, 0, 0});
            if (bl2) {
                n2 |= 0x100;
            }
            if (packetData != null && !packetData.needResponse()) {
                n2 |= 0x10;
            }
            if (SessionManager.getInstance().getGlobalPushFlag()) {
                n2 |= 0x1000;
            }
            byteArrayOutputStream.write(Convert.intToBytes(n2));
            byteArrayOutputStream.write(Convert.intToBytes(iAccount.getAppId()));
            long l2 = 0L;
            if (!TextUtils.isEmpty((CharSequence)iAccount.getUserId())) {
                l2 = Long.parseLong(iAccount.getUserId());
            }
            byteArrayOutputStream.write(Convert.longToBytes(l2));
            String string3 = null;
            switch (by2) {
                case 3: 
                case 7: 
                case 9: {
                    string3 = iAccount.getServiceToken();
                    break;
                }
                case 2: 
                case 8: 
                case 10: {
                    if (!packetData.needClientInfo()) break;
                    string3 = iAccount.getB2Token();
                    break;
                }
                case 5: {
                    string3 = B2_FOR_HS;
                }
            }
            byte[] byArray = null;
            if (string3 != null) {
                byArray = string3.getBytes("utf-8");
            }
            if (byArray != null) {
                short s2 = (short)byArray.length;
                byteArrayOutputStream.write(Convert.shortToBytes(s2));
                byteArrayOutputStream.write(byArray);
            } else {
                byteArrayOutputStream.write(Convert.shortToBytes((short)0));
            }
            byteArrayOutputStream.write(Convert.intToBytes(0));
            byteArrayOutputStream.write(Convert.intToBytes(packetData.getSeqNo()));
            if (packetData != null) {
                if (!bl2) {
                    byte[] byArray2 = StreamUtil.encrypt(StreamUtil.getUpStream((String)object, packetData, by2, iAccount).toByteArray(), by2, iAccount);
                    object = byArray2;
                    if (byArray2 == null) return null;
                    byteArrayOutputStream.write((byte[])object);
                } else {
                    String string4 = StreamUtil.getRandomString(4);
                    byteArrayOutputStream.write(string4.getBytes());
                }
            }
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            object = Convert.intToBytes(byArray3.length);
            byArray3[4] = (byte)object[0];
            byArray3[5] = (byte)object[1];
            byArray3[6] = (byte)object[2];
            byArray3[7] = (byte)object[3];
            MiLinkLog.v(string2, "up stream packet: seq=" + packetData.getSeqNo() + ", isPing=" + bl2 + ", flag=" + n2 + ", len=" + byArray3.length);
            return byArray3;
        }
        catch (IOException iOException) {
            MiLinkLog.e(string2, "byte error", iOException);
            return null;
        }
    }

    public static String getRandomString(int n2) {
        String string2 = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = random.nextInt(string2.length());
            stringBuffer.append(string2.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static PacketData getDownPacket(String string2, byte[] object, GetAccountAdapter object2) throws IOException {
        string2 = string2 + CLASSTAG;
        if (object == null) {
            return null;
        }
        MiLinkLog.v(string2, "recv data: len=" + ((byte[])object).length);
        Object object3 = new ByteArrayInputStream((byte[])object);
        if (!Convert.compare(Convert.readByte((ByteArrayInputStream)object3, 4), MNS)) {
            return null;
        }
        int n2 = Convert.bytesToInt(Convert.readByte((ByteArrayInputStream)object3, 4));
        ((ByteArrayInputStream)object3).read();
        byte by2 = (byte)((ByteArrayInputStream)object3).read();
        int n3 = Convert.bytesToInt(Convert.readByte((ByteArrayInputStream)object3, 4));
        Convert.readByte((ByteArrayInputStream)object3, 4);
        byte[] byArray = new byte[8];
        Convert.readBytes((ByteArrayInputStream)object3, byArray, 0, 8);
        Convert.bytesToLong(byArray);
        byArray = new byte[2];
        Convert.readBytes((ByteArrayInputStream)object3, byArray, 0, 2);
        int n4 = Convert.bytesToUshort(byArray);
        Object object4 = new byte[n4];
        Convert.readBytes((ByteArrayInputStream)object3, (byte[])object4, 0, n4);
        n4 = 28 + n4;
        Convert.readByte((ByteArrayInputStream)object3, 4);
        n4 += 4;
        object3 = Convert.readByte((ByteArrayInputStream)object3, 4);
        n4 += 4;
        int n5 = Convert.bytesToInt((byte[])object3);
        MiLinkLog.v(string2, "down stream packet: seq=" + n5 + ", encodeType=" + by2 + ", flag=" + n3);
        object2 = object2.getAccount(n5);
        if ((n3 & 0x100) == 256) {
            PacketData packetData = new PacketData();
            packetData.setSeqNo(n5);
            packetData.setCommand("milink.ping");
            return packetData;
        }
        byte[] byArray2 = new byte[n2 - n4];
        try {
            System.arraycopy(object, n4, byArray2, 0, n2 - n4);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        object = null;
        try {
            byte[] byArray3 = StreamUtil.decrypt(byArray2, (byte[])object4, by2, (IAccount)object2);
            object2 = byArray3;
            if (byArray3 != null) {
                object = DownstreamPacketProto.DownstreamPacket.parseFrom((byte[])object2);
            } else {
                MiLinkLog.w(string2, "decrypt error, down == null !!!");
                MiLinkLog.w(string2, "decrypt error stream:" + Convert.bytesToHexStr(byArray2, 2048000));
            }
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            MiLinkLog.e(string2, "parser downstream error", invalidProtocolBufferException);
            MiLinkLog.e(string2, "error stream:" + Convert.bytesToHexStr(byArray2, 2048000));
        }
        if (object == null) {
            return null;
        }
        object2 = ((DownstreamPacketProto.DownstreamPacket)object).getServiceCmd();
        MiLinkLog.v(string2, "mnscode:" + ((DownstreamPacketProto.DownstreamPacket)object).getMnsCode() + ", busicode:" + ((DownstreamPacketProto.DownstreamPacket)object).getBusiCode() + ", cmd=" + (String)object2);
        PacketData packetData = new PacketData();
        Serializable serializable = DownstreamPacketProto.ExtraInfo.parseFrom(((DownstreamPacketProto.DownstreamPacket)object).getExtra());
        if (serializable != null && ((DownstreamPacketProto.ExtraInfo)serializable).hasHasClientInfo()) {
            MiLinkLog.v(string2, "cmd=" + (String)object2 + ", hasClientInfo =" + ((DownstreamPacketProto.ExtraInfo)serializable).getHasClientInfo());
            packetData.setHasClientInfo(((DownstreamPacketProto.ExtraInfo)serializable).getHasClientInfo());
        } else {
            packetData.setHasClientInfo(false);
        }
        serializable = ((DownstreamPacketProto.DownstreamPacket)object).getBusiBuff();
        if (((DownstreamPacketProto.DownstreamPacket)object).hasBusiControl()) {
            UpstreamPacketProto.BusiControl busiControl = ((DownstreamPacketProto.DownstreamPacket)object).getBusiControl();
            object4 = busiControl;
            int n6 = busiControl.getCompFlag();
            MiLinkLog.v(string2, "hasBusiContro, compFlag= ".concat(String.valueOf(n6)));
            if (n6 == 1) {
                byte[] byArray4 = CompressionFactory.createCompression(1).decompress(((ByteString)serializable).toByteArray());
                if (byArray4 != null && (long)byArray4.length == ((UpstreamPacketProto.BusiControl)object4).getLenBeforeComp()) {
                    MiLinkLog.v(string2, "len of decompress is " + byArray4.length);
                    serializable = ByteString.copyFrom(byArray4);
                } else {
                    MiLinkLog.v(string2, "len of decompress is not equal origin len, origin len=" + ((UpstreamPacketProto.BusiControl)object4).getLenBeforeComp());
                }
            }
        } else {
            MiLinkLog.v(string2, "hasBusiContro = false");
        }
        if ("milink.push".equals(object2)) {
            if (serializable == null) {
                return null;
            }
            try {
                packetData.setIsPushPacket(true);
                PushPacketProto.SimplePushData simplePushData = PushPacketProto.SimplePushData.parseFrom((ByteString)serializable);
                object4 = simplePushData;
                serializable = simplePushData.getPushdata();
                object2 = ((PushPacketProto.SimplePushData)object4).getCmd();
                if ((n3 & 1) == 1) {
                    n5 = ((DownstreamPacketProto.DownstreamPacket)object).getSeq() * -1;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                MiLinkLog.e(string2, "parser pushdata error", invalidProtocolBufferException);
            }
        }
        packetData.setData(serializable == null ? null : ((ByteString)serializable).toByteArray());
        packetData.setSeqNo(n5);
        packetData.setCommand((String)object2);
        packetData.setMnsCode(((DownstreamPacketProto.DownstreamPacket)object).getMnsCode());
        packetData.setBusiCode(((DownstreamPacketProto.DownstreamPacket)object).getBusiCode());
        packetData.setResponseSize(n2);
        return packetData;
    }

    private static UpstreamPacketProto.UpstreamPacket getUpStream(String string2, PacketData object, int n2, IAccount iAccount) {
        Object object2;
        Object object3;
        string2 = string2 + CLASSTAG;
        UpstreamPacketProto.UpstreamPacket.Builder builder = UpstreamPacketProto.UpstreamPacket.newBuilder();
        builder.setSeq(((PacketData)object).getSeqNo());
        builder.setAppId(iAccount.getAppId());
        if (((PacketData)object).needClientInfo()) {
            object3 = StreamUtil.getQua(iAccount);
            MiLinkLog.v(string2, "send packet, cmd=" + ((PacketData)object).getCommand() + " seq=" + ((PacketData)object).getSeqNo() + " qua=" + (String)object3 + " encodeType=" + n2);
            if (n2 != 0) {
                builder.setDeviceInfo(ByteString.copyFromUtf8(DeviceDash.getInstance().getDeviceSimplifiedInfo()));
            }
            builder.setUa((String)object3);
        } else {
            MiLinkLog.v(string2, "send packet don't need qua and deviceInfo, seq=" + ((PacketData)object).getSeqNo() + ", cmd=" + ((PacketData)object).getCommand());
        }
        builder.setServiceCmd(((PacketData)object).getCommand());
        object3 = ((PacketData)object).getData();
        if (!Const.isMnsCmd(((PacketData)object).getCommand()) && object3 != null) {
            object2 = UpstreamPacketProto.BusiControl.newBuilder();
            int n3 = ((Object)object3).length;
            MiLinkLog.v(string2, "origin busibuff.size=".concat(String.valueOf(n3)));
            if (n3 > 512) {
                object3 = CompressionFactory.createCompression(1).compress((byte[])object3);
                MiLinkLog.v(string2, "after zlib compress, busibuff.size=" + ((Object)object3).length);
                ((UpstreamPacketProto.BusiControl.Builder)object2).setCompFlag(1);
                ((UpstreamPacketProto.BusiControl.Builder)object2).setLenBeforeComp(n3);
            }
            ((UpstreamPacketProto.BusiControl.Builder)object2).setIsSupportComp(true);
            builder.setBusiControl(((UpstreamPacketProto.BusiControl.Builder)object2).build());
        }
        builder.setBusiBuff(ByteString.copyFrom((byte[])object3));
        object2 = iAccount.getUserId();
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            builder.setMiUid((String)object2);
            builder.setMiUin(Long.parseLong((String)object2));
            MiLinkLog.e("\u8bbe\u7f6e\u7684miuin", "\u8bbe\u7f6e\u7684miUId \uff1a ".concat(String.valueOf(object2)));
            if (n2 != 0 && ((PacketData)object).needClientInfo()) {
                UpstreamPacketProto.TokenInfo.Builder builder2 = UpstreamPacketProto.TokenInfo.newBuilder();
                string2 = iAccount.getServiceToken();
                object = new byte[0];
                try {
                    object = string2.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                builder2.setKey(ByteString.copyFrom((byte[])object));
                builder2.setType(3);
                builder.setToken(builder2.build());
            }
        } else {
            builder.setMiUin(0L);
            builder.setMiUid("0");
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    private static byte[] encrypt(byte[] var0, byte var1_1, IAccount var2_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static byte[] decrypt(byte[] var0, byte[] var1_1, byte var2_2, IAccount var3_7) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface GetAccountAdapter {
        public IAccount getAccount(int var1);
    }
}

