/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import androidx.annotation.NonNull;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.proto.SystemPacketProto;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import com.mi.milink.sdk.session.simplechannel.UpdateChannelPubKeyValue;
import org.greenrobot.eventbus.EventBus;

public abstract class IMnsCodeCopeWays {
    public static String TAG = "IMnsCodeCopeWays";
    protected Request mRequeset;
    protected PacketData mRecvData;
    protected Session mSession;
    protected int mRetCode;
    protected String mCmd;

    public IMnsCodeCopeWays(Session session) {
        this.mSession = session;
    }

    public void setParam(PacketData packetData, Request request) {
        this.mRecvData = packetData;
        this.mRequeset = request;
        if (this.mRecvData != null) {
            this.mCmd = this.mRecvData.getCommand();
        }
    }

    protected abstract void onOk();

    protected void onB2TokenExpired() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            ((SessionForSimpleChannel)this.mSession).getSessionManagerForSimpleChannel().getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.B2tokenExpired));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.B2tokenExpired));
    }

    protected void onUpdateChannelPubKey() {
        MiLinkLog.v(TAG, "onUpdateChannelPubKey handler");
        if (this.mRecvData != null && this.mRecvData.getData() != null) {
            try {
                SystemPacketProto.MnsCmdChannelNewPubKeyRsp mnsCmdChannelNewPubKeyRsp = SystemPacketProto.MnsCmdChannelNewPubKeyRsp.parseFrom(this.mRecvData.getData());
                if (this.mSession instanceof SessionForSimpleChannel) {
                    UpdateChannelPubKeyValue updateChannelPubKeyValue = new UpdateChannelPubKeyValue();
                    updateChannelPubKeyValue.setChannelNewPubkey(mnsCmdChannelNewPubKeyRsp);
                    updateChannelPubKeyValue.setmRequeset(this.mRequeset);
                    ((SessionForSimpleChannel)this.mSession).getSessionManagerForSimpleChannel().getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.ChannelPubKeyUpdate, updateChannelPubKeyValue));
                    return;
                }
                EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ChannelPubKeyUpdate, mnsCmdChannelNewPubKeyRsp));
                return;
            }
            catch (Exception exception) {}
        }
    }

    protected void onDeleteChannelPubKey() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            ((SessionForSimpleChannel)this.mSession).getSessionManagerForSimpleChannel().getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.ChannelDelPubKey, this.mRequeset));
        }
    }

    protected abstract void onServerTokenExpired();

    protected abstract void afterHandle();

    protected void onTimeOut() {
        if (this.mRequeset != null) {
            if (this.mRequeset.isInternalRequest()) {
                this.onInternalCmdTimeout();
                return;
            }
            this.onBusinessCmdTimeout();
        }
    }

    protected abstract void onInternalCmdTimeout();

    protected abstract void onBusinessCmdTimeout();

    protected abstract void onAccNeedRetry();

    protected abstract void onUnknowMsnCode(int var1);

    protected void onKickedByServer() {
        try {
            PushPacketProto.KickMessage kickMessage = PushPacketProto.KickMessage.parseFrom(this.mRecvData.getData());
            MiLinkLog.e(TAG, "kickout IMnCodeCopeWays type is\uff1a " + kickMessage.getType());
            EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.KickByServer, kickMessage));
            return;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            MiLinkLog.e(TAG, invalidProtocolBufferException);
            MiLinkLog.e(TAG, "kick but InvalidProtocolBufferException construct a message and post.");
            int n2 = (int)(System.currentTimeMillis() / 1000L);
            PushPacketProto.KickMessage kickMessage = PushPacketProto.KickMessage.newBuilder().setDevice("unknowdevices").setTime(n2).setType(10).build();
            EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.KickByServer, kickMessage));
            return;
        }
    }

    protected void onServerSpecialLineBroken() {
        this.mRequeset.onDataSendFailed(this.getMnsCode(), "MI_LINK_CODE_SERVER_SPECIAL_LINE_BROKEN");
        this.mSession.checkExceedMaxContinuousRecv110Count();
    }

    protected void onServerSpecialLineBrokenUrgent() {
        MiLinkLog.e(TAG, "onServerSpecialLineBrokenUrgent");
        this.mRequeset.onDataSendFailed(this.getMnsCode(), "MI_LINK_CODE_SERVER_SPECIAL_LINE_BROKEN_URGENT");
        if (this.mSession instanceof SessionForSimpleChannel) {
            ((SessionForSimpleChannel)this.mSession).getSessionManagerForSimpleChannel().getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.ServerLineBroken, this.mRequeset));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ServerLineBroken));
    }

    public void handleMnsCode() {
        int n2;
        this.mRetCode = n2 = this.getMnsCode();
        if (!"milink.handshake".equals(this.getCommand())) {
            if (n2 == 110) {
                this.mSession.addContinuousRecv110Count();
            } else {
                this.mSession.resetContinuousRecv110Count();
            }
        }
        if ("milink.loginoff".equals(this.getCommand()) && n2 != 0) {
            if (this.mRequeset != null) {
                this.mRequeset.onDataSendFailed(this.getMnsCode(), "MNS_LOGOFF failed, return");
            }
            return;
        }
        switch (n2) {
            case 0: {
                this.onOk();
                break;
            }
            case 101: {
                this.onB2TokenExpired();
                break;
            }
            case 100: {
                this.onServerTokenExpired();
                break;
            }
            case 109: {
                this.onTimeOut();
                break;
            }
            case 102: {
                this.onKickedByServer();
                break;
            }
            case 118: {
                this.onAccNeedRetry();
                break;
            }
            case 110: {
                this.onServerSpecialLineBroken();
                break;
            }
            case 119: {
                this.onServerSpecialLineBrokenUrgent();
                break;
            }
            case 129: {
                this.onUpdateChannelPubKey();
                break;
            }
            case 223: {
                this.onDeleteChannelPubKey();
                break;
            }
            default: {
                this.onUnknowMsnCode(n2);
            }
        }
        this.afterHandle();
    }

    @NonNull
    private String getCommand() {
        if (this.mRecvData == null) {
            return "";
        }
        return this.mRecvData.getCommand();
    }

    private int getMnsCode() {
        if (this.mRecvData == null) {
            return -1;
        }
        return this.mRecvData.getMnsCode();
    }
}

