/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.text.TextUtils;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManager;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MiLinkBackupServerManager
extends IServerManager {
    private static final String TAG = "MiLinkBackupServerManager";
    private static final int DEFAULT_SESSION_COUNT = 1;
    private static MiLinkBackupServerManager sInstance = null;

    private MiLinkBackupServerManager() {
        super(MiLinkIpInfoManager.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiLinkBackupServerManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<MiLinkBackupServerManager> clazz = MiLinkBackupServerManager.class;
        synchronized (MiLinkBackupServerManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new MiLinkBackupServerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public ServerProfile[] reset(boolean bl2) {
        int n2;
        List<ServerProfile> list;
        this.mTcpServerList = new ArrayList();
        this.mTcpServerListIndex = 0;
        if (ClientAppInfo.isTestChannel()) {
            String string2 = this.mIpInfoManager.getTestBackupIp()[0].getServerIP();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                list = (List<ServerProfile>)Const.ServerPort.PORT_ARRAY;
                int n3 = Const.ServerPort.PORT_ARRAY.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object = list[i2];
                    ServerProfile serverProfile = new ServerProfile(string2, (int)object, 1, 4);
                    this.mTcpServerList.add(serverProfile);
                }
            }
        } else {
            list = this.mIpInfoManager.getBackupServerList();
            if (list != null) {
                Collections.shuffle(list);
                MiLinkBackupServerManager.addServerProfileInSpecifiedList(list, this.mTcpServerList);
            }
        }
        if (this.mTcpServerList.isEmpty()) {
            return null;
        }
        ServerProfile[] serverProfileArray = new ServerProfile[1];
        for (n2 = 0; n2 <= 0; ++n2) {
            serverProfileArray[0] = (ServerProfile)this.mTcpServerList.get(this.mTcpServerListIndex++);
        }
        for (n2 = 0; n2 <= 0; ++n2) {
            MiLinkLog.i(TAG, "reset , so try backuplist1, server No.0:" + serverProfileArray[0]);
        }
        return serverProfileArray;
    }

    @Override
    public ServerProfile[] getNext(ServerProfile serverProfileArray, int n2) {
        if (serverProfileArray == null) {
            MiLinkLog.e(TAG, "getNext, serverProfile == null!!!");
            return null;
        }
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.e(TAG, "getNext, Network is not available!!!");
            return null;
        }
        MiLinkLog.i(TAG, "getNext, failserver info:" + serverProfileArray + ",failReason = " + n2);
        if (serverProfileArray.getProtocol() == 1) {
            if (this.mTcpServerListIndex == this.mTcpServerList.size()) {
                MiLinkLog.i(TAG, "getNext no tcp server to try");
                return null;
            }
            ServerProfile[] serverProfileArray2 = new ServerProfile[1];
            serverProfileArray = serverProfileArray2;
            serverProfileArray2[0] = this.getNextTcpProfile();
            MiLinkLog.i(TAG, "getNext get tcp server," + serverProfileArray[0]);
            return serverProfileArray;
        }
        return null;
    }

    @Override
    public void destroy() {
        sInstance = null;
    }

    @Override
    public void loadCurrentApn() {
        IIpInfoManager.loadCurrentApn();
    }

    public void preLoad() {
        if (this.mIpInfoManager != null) {
            this.mIpInfoManager.getRcentlyIpMap();
            this.mIpInfoManager.getOptimumIpMap();
            this.mIpInfoManager.getRecentlyServerData();
            this.mIpInfoManager.getBackupServerList();
            this.mIpInfoManager.getCurrentApnOptimumServerData();
        }
    }
}

