/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.text.TextUtils;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManager;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.OptimumServerData;
import com.mi.milink.sdk.session.common.RecentlyServerData;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MiLinkServerManager
extends IServerManager {
    private static final String TAG = "MiLinkServerManager";
    private static MiLinkServerManager sInstance = null;

    private MiLinkServerManager() {
        super(MiLinkIpInfoManager.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MiLinkServerManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<MiLinkServerManager> clazz = MiLinkServerManager.class;
        synchronized (MiLinkServerManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new MiLinkServerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public ServerProfile[] reset(boolean bl2) {
        int n2;
        Object object;
        Object object322;
        this.mTcpServerList.clear();
        this.mTcpServerListIndex = 0;
        if (ClientAppInfo.isTestChannel()) {
            object322 = this.mIpInfoManager.getTestBackupIp()[0].getServerIP();
            if (!TextUtils.isEmpty((CharSequence)object322)) {
                int[] object22 = Const.ServerPort.PORT_ARRAY;
                int n3 = Const.ServerPort.PORT_ARRAY.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = object22[i2];
                    object = new ServerProfile((String)object322, n4, 1, 4);
                    this.mTcpServerList.add(object);
                }
            }
        } else {
            n2 = 0;
            object322 = null;
            if (!Global.getClientAppInfo().isHasSetAccServerDomain()) {
                List<ServerProfile> list;
                OptimumServerData optimumServerData;
                RecentlyServerData recentlyServerData = this.mIpInfoManager.getRecentlyServerData();
                if (recentlyServerData != null) {
                    object322 = recentlyServerData.getRecentlyServer();
                }
                if ((optimumServerData = this.mIpInfoManager.getCurrentApnOptimumServerData()) != null && (list = optimumServerData.getOptimumServers()) != null) {
                    Collections.shuffle(list);
                    ArrayList<ServerProfile> arrayList = new ArrayList<ServerProfile>();
                    for (ServerProfile serverProfile : list) {
                        if (serverProfile == null) continue;
                        if (object322 != null && serverProfile.getServerIP().equals(((ServerProfile)object322).getServerIP())) {
                            n2 = 1;
                            continue;
                        }
                        if (arrayList.size() >= Const.ServerPort.PORT_ARRAY.length) continue;
                        arrayList.add(serverProfile);
                    }
                    MiLinkServerManager.addServerProfileInSpecifiedList(arrayList, this.mTcpServerList);
                }
            }
            int[] nArray = Const.ServerPort.PORT_ARRAY;
            int n5 = Const.ServerPort.PORT_ARRAY.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6 = nArray[i3];
                object = new ServerProfile(this.mIpInfoManager.getDefaultServer().getServerIP(), n6, 1, 4);
                this.mTcpServerList.add(object);
            }
            List<ServerProfile> list = this.mIpInfoManager.getBackupServerList();
            if (list != null) {
                for (ServerProfile serverProfile : list) {
                    ArrayList<ServerProfile> arrayList = new ArrayList<ServerProfile>();
                    arrayList.add(serverProfile);
                    MiLinkServerManager.addServerProfileInSpecifiedList(arrayList, this.mTcpServerList);
                }
            }
            if (n2 != 0) {
                ServerProfile[] serverProfileArray = new ServerProfile[1];
                ServerProfile[] serverProfileArray2 = serverProfileArray;
                serverProfileArray[0] = object322;
                MiLinkLog.i(TAG, "reset isBackgroud = " + bl2 + ",has recently tcp server" + object322);
                return serverProfileArray2;
            }
        }
        ServerProfile[] serverProfileArray = new ServerProfile[4];
        for (n2 = 0; n2 < 4; ++n2) {
            serverProfileArray[n2] = (ServerProfile)this.mTcpServerList.get(this.mTcpServerListIndex++);
        }
        for (Object object322 : this.mTcpServerList) {
            MiLinkLog.e(TAG, "[\u9009\u51fa\u7684ip\uff1a " + ((ServerProfile)object322).getServerIP() + ", port: " + ((ServerProfile)object322).getServerPort() + "]");
        }
        for (int i4 = 0; i4 < 4; ++i4) {
            MiLinkLog.i(TAG, "reset isBackgroud = " + bl2 + ", has no recently server, so try 4, server No." + i4 + ":" + serverProfileArray[i4]);
        }
        return serverProfileArray;
    }

    @Override
    public ServerProfile[] getNext(ServerProfile serverProfileArray, int n2) {
        if (serverProfileArray == null) {
            MiLinkLog.e(TAG, "getNext, serverProfile == null!!!");
            return null;
        }
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.e(TAG, "getNext, Network is not available!!!");
            return null;
        }
        MiLinkLog.i(TAG, "getNext, failserver info:" + serverProfileArray + ",failReason = " + n2);
        if (serverProfileArray.getProtocol() == 1) {
            if (serverProfileArray.getServerType() == 3) {
                serverProfileArray = new ServerProfile[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    serverProfileArray[n2] = this.getNextTcpProfile();
                    MiLinkLog.i(TAG, "getNext, recently tcp failed, and has no rencently http server,so try 4, server No." + n2 + ":" + serverProfileArray[n2]);
                }
                return serverProfileArray;
            }
            if (this.mTcpServerListIndex == this.mTcpServerList.size()) {
                MiLinkLog.i(TAG, "getNext no tcp server to try");
                return null;
            }
            ServerProfile[] serverProfileArray2 = new ServerProfile[1];
            serverProfileArray = serverProfileArray2;
            serverProfileArray2[0] = this.getNextTcpProfile();
            MiLinkLog.i(TAG, "getNext get tcp server," + serverProfileArray[0]);
            return serverProfileArray;
        }
        return null;
    }

    @Override
    public void destroy() {
        sInstance = null;
    }

    @Override
    public void loadCurrentApn() {
        IIpInfoManager.loadCurrentApn();
    }

    public void preLoad() {
        if (this.mIpInfoManager != null) {
            this.mIpInfoManager.getRcentlyIpMap();
            this.mIpInfoManager.getOptimumIpMap();
            this.mIpInfoManager.getRecentlyServerData();
            this.mIpInfoManager.getBackupServerList();
            this.mIpInfoManager.getCurrentApnOptimumServerData();
        }
    }
}

