/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.SystemClock;
import android.text.TextUtils;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.session.persistent.IMnsCodeCopeWays;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import org.greenrobot.eventbus.EventBus;

public class MnsCodeCopeWaysHasListener
extends IMnsCodeCopeWays {
    private static final String CLASSTAG = "MnsCodeCopeWaysHasListener";
    private String TAG;

    public MnsCodeCopeWaysHasListener(Session session) {
        super(session);
        this.TAG = String.format("[No:%d]%s", session.getSessionNO(), CLASSTAG);
    }

    @Override
    protected void onOk() {
        this.mRequeset.onDataSendSuccess(0, this.mRecvData);
    }

    @Override
    protected void onServerTokenExpired() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ServiceTokenExpired));
        this.mRequeset.onDataSendFailed(100, "service token expired");
    }

    @Override
    protected void afterHandle() {
        if (this.mRequeset == null) {
            MiLinkLog.e(this.TAG, "MnsCodeCopeWaysHasListener_afterHandler mRequeset is null");
            return;
        }
        String string2 = this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerIP() : "";
        int n2 = this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerPort() : 0;
        String string3 = "";
        int n3 = 0;
        if (this.mRecvData != null) {
            try {
                string3 = this.mRecvData.getCommand();
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = this.mCmd;
                }
                n3 = this.mRecvData.getResponseSize();
                this.mRetCode = this.mRecvData.getBusiCode();
            }
            catch (Exception exception) {
                MiLinkLog.e(this.TAG, "afterHandle recv data exception=" + exception.toString());
            }
        }
        int n4 = this.mRetCode;
        long l2 = this.mRequeset.getSentTime();
        long l3 = SystemClock.elapsedRealtime();
        int n5 = this.mRequeset.getSize();
        int n6 = this.mRequeset.getSeqNo();
        String string4 = this.mSession.getClientIp();
        String string5 = this.mSession.getClientIsp();
        if (this.mRequeset.getAfterHandleCallBack() != null) {
            this.mRequeset.getAfterHandleCallBack().onCallBack(string2, n2, string3, n4, l2, l3, n5, n3, n6, string4, string5);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            String string6 = string3 = this.mRequeset.getData() != null ? this.mRequeset.getData().getCommand() : "";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            InternalDataMonitor.getInstance().trace(string2, n2, string3, n4, l2, l3, n5, n3, n6, string4, string5);
            return;
        }
        MiLinkLog.e(this.TAG, "cmd is empty, don't monitor it, seq=" + this.mRequeset.getSeqNo());
    }

    @Override
    protected void onBusinessCmdTimeout() {
        this.mRequeset.onDataSendFailed(109, "request time out");
    }

    @Override
    protected void onInternalCmdTimeout() {
        this.mRequeset.onDataSendFailed(109, "request time out");
    }

    @Override
    protected void onAccNeedRetry() {
        this.mSession.onAccNeedRetryWithClientInfo(this.mRequeset);
    }

    @Override
    protected void onUnknowMsnCode(int n2) {
        this.mRequeset.onDataSendFailed(n2, "unknow mnscode for milinksdk");
    }
}

