/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.SystemClock;
import android.text.TextUtils;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.session.persistent.IMnsCodeCopeWays;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import org.greenrobot.eventbus.EventBus;

public class MnsCodeCopeWaysNoListener
extends IMnsCodeCopeWays {
    private static final String CLASSTAG = "MnsCodeCopeWaysNoListener";
    private String TAG;

    public MnsCodeCopeWaysNoListener(Session session) {
        super(session);
        this.TAG = String.format("[No:%d]%s", session.getSessionNO(), CLASSTAG);
    }

    @Override
    protected void onOk() {
        MiLinkLog.v(this.TAG, "recv data and to dispatcher");
        MnsPacketDispatcher.getInstance().dispatchPacket(this.mRecvData);
        this.mRetCode = this.mRecvData.getBusiCode();
    }

    @Override
    protected void onServerTokenExpired() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ServiceTokenExpired));
    }

    @Override
    protected void afterHandle() {
        if (this.mRequeset == null) {
            MiLinkLog.e(this.TAG, "MnsCodeCopeWaysNoListener_afterHandler mRequeset is null");
            return;
        }
        String string2 = this.mRecvData.getCommand();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = string2 = this.mRequeset.getData() != null ? this.mRequeset.getData().getCommand() : "";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            InternalDataMonitor.getInstance().trace(this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerIP() : "", this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerPort() : 0, string2, this.mRetCode, this.mRequeset.getSentTime(), SystemClock.elapsedRealtime(), this.mRequeset.getSize(), this.mRecvData.getResponseSize(), this.mRequeset.getSeqNo());
            return;
        }
        MiLinkLog.e(this.TAG, "cmd is empty, don't monitor it, seq=" + this.mRequeset.getSeqNo());
    }

    @Override
    protected void onBusinessCmdTimeout() {
    }

    @Override
    protected void onInternalCmdTimeout() {
    }

    @Override
    protected void onAccNeedRetry() {
        this.mSession.onAccNeedRetryWithClientInfo(this.mRequeset);
    }

    @Override
    protected void onUnknowMsnCode(int n2) {
    }

    @Override
    protected void onUpdateChannelPubKey() {
    }
}

