/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.SystemClock;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.session.persistent.IMnsCodeCopeWays;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import org.greenrobot.eventbus.EventBus;

public class MnsCodeCopeWaysWithPush
extends IMnsCodeCopeWays {
    private static final String CLASSTAG = "MnsCodeCopeWaysWithPush";
    private String TAG;
    private long mBeginStatisticsTime = 0L;
    private int mRecvPushNumber = 0;
    private long mLastRecvPushTimeStamp = 0L;
    private int mLargeIntervalNumber = 0;
    public static final long CHANNEL_BUSY_FLAG_INTERVAL = 3000L;
    public static final long CHANNEL_BUSY_FLAG_NUMBER = 150L;
    public static final long CHANNEL_BUSY_CANCEL_FLAG_NUMBER = 3L;

    public MnsCodeCopeWaysWithPush(Session session) {
        super(session);
        this.TAG = String.format("[No:%d]%s", session.getSessionNO(), CLASSTAG);
    }

    @Override
    protected void onOk() {
        MiLinkLog.v(this.TAG, "recv data and to dispatcher");
        if ("milink.kick".equals(this.mRecvData.getCommand())) {
            MiLinkLog.v(this.TAG, "get kick push");
            try {
                PushPacketProto.KickMessage kickMessage = PushPacketProto.KickMessage.parseFrom(PushPacketProto.SimplePushData.parseFrom(this.mRecvData.getData()).getPushdata());
                MiLinkLog.v(this.TAG, "kickout push type is" + kickMessage.getType());
                EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.KickByServer, kickMessage));
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                MiLinkLog.e(this.TAG, invalidProtocolBufferException.getMessage());
            }
        } else if ("milink.push.log".equals(this.mRecvData.getCommand())) {
            try {
                GeneratedMessage generatedMessage = PushPacketProto.MilinkLogReq.parseFrom(PushPacketProto.SimplePushData.parseFrom(this.mRecvData.getData()).getPushdata());
                int n2 = ((PushPacketProto.MilinkLogReq)generatedMessage).getType();
                if (n2 == 0) {
                    EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.requireUploadLog, generatedMessage));
                    MnsPacketDispatcher.getInstance().dispatchPacket(this.mRecvData);
                } else if (1 == n2) {
                    generatedMessage = ((PushPacketProto.MilinkLogReq)generatedMessage).getLogLevel();
                    MiLinkLog.v(this.TAG, "recv push log level,loglevel=" + ((PushPacketProto.PushLogLevel)generatedMessage).getLoglevel() + ",time=" + ((PushPacketProto.PushLogLevel)generatedMessage).getTimeLong());
                    EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.requireChannelLogLevel, generatedMessage));
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                MiLinkLog.e(this.TAG, invalidProtocolBufferException.getMessage());
            }
        } else {
            MnsPacketDispatcher.getInstance().dispatchPacket(this.mRecvData);
            int n3 = this.mRecvData.getSeqNo();
            if (n3 < 0) {
                this.mSession.pushAck(n3);
                this.mRecvData.setSeqNo(0);
            }
        }
        this.mRetCode = this.mRecvData.getBusiCode();
    }

    private void estimateChannelBusy() {
        long l2 = System.currentTimeMillis();
        if (l2 - this.mBeginStatisticsTime < 3000L) {
            ++this.mRecvPushNumber;
            if ((long)this.mRecvPushNumber > 150L) {
                EventBus.getDefault().post(new MiLinkEvent.ChannelStatusChangeEvent(MiLinkEvent.ChannelStatusChangeEvent.EventType.channelBusy, null));
            }
        } else if ((long)this.mRecvPushNumber <= 150L) {
            this.mBeginStatisticsTime = l2;
            this.mRecvPushNumber = 0;
        }
        if (l2 - this.mLastRecvPushTimeStamp > 3000L) {
            ++this.mLargeIntervalNumber;
            if ((long)this.mLargeIntervalNumber > 3L) {
                this.mBeginStatisticsTime = 0L;
                this.mRecvPushNumber = 0;
                EventBus.getDefault().post(new MiLinkEvent.ChannelStatusChangeEvent(MiLinkEvent.ChannelStatusChangeEvent.EventType.channelIdle, null));
            }
        } else {
            this.mLargeIntervalNumber = 0;
        }
        this.mLastRecvPushTimeStamp = l2;
    }

    @Override
    protected void onB2TokenExpired() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            ((SessionForSimpleChannel)this.mSession).getSessionManagerForSimpleChannel().getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.B2tokenExpired));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.B2tokenExpired));
    }

    @Override
    protected void onServerTokenExpired() {
        if (this.mSession instanceof SessionForSimpleChannel) {
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ServiceTokenExpired));
    }

    @Override
    protected void afterHandle() {
        MiLinkLog.e("MiLinkReceive", "after handler isPush:  " + this.mRecvData.isPushPacket());
        if (this.mRecvData.isPushPacket()) {
            InternalDataMonitor.getInstance().trace(this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerIP() : "", this.mSession.getServerProfileForStatistic() != null ? this.mSession.getServerProfileForStatistic().getServerPort() : 0, this.mRecvData.isPushPacket() ? "milink.push." + this.mRecvData.getCommand() : this.mRecvData.getCommand(), this.mRetCode, SystemClock.elapsedRealtime(), SystemClock.elapsedRealtime(), 0, this.mRecvData.getResponseSize(), this.mRecvData.getSeqNo());
        }
    }

    @Override
    protected void onBusinessCmdTimeout() {
    }

    @Override
    protected void onInternalCmdTimeout() {
    }

    @Override
    protected void onAccNeedRetry() {
    }

    @Override
    protected void onKickedByServer() {
    }

    @Override
    protected void onUnknowMsnCode(int n2) {
    }

    @Override
    protected void onUpdateChannelPubKey() {
    }
}

