/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.Message;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.CustomHandlerThread;
import com.mi.milink.sdk.client.IPacketListener;
import com.mi.milink.sdk.client.IPushPacketListener;
import com.mi.milink.sdk.client.ISinglePacketListener;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.util.ArrayList;
import java.util.List;

public class MnsPacketDispatcher
extends CustomHandlerThread {
    private static final String TAG = "MnsPacketDispatcher";
    private static final int MAX_BATCH_COUNT = 10;
    private static final int MAX_DISPATCH_PACKET_DELAY_TIME = 500;
    private static final int MSG_ADD_PACKET = 1;
    private static final int MSG_DISPATCH_PACKET = 2;
    private static MnsPacketDispatcher sInstance = new MnsPacketDispatcher();
    private IPacketListener mListener;
    private IPushPacketListener mPushListener;
    private ISinglePacketListener mSingleListener;
    private final List<PacketData> mPacketCache = new ArrayList<PacketData>(32);
    private volatile long mDispatchPacketDelayTime = 0L;
    private long mDispatchPacketDelayTimeWhenScreenOn = 0L;

    private MnsPacketDispatcher() {
        super(TAG);
        MiLinkLog.v(TAG, "MnsPacketDispatcher created, threadId=" + Thread.currentThread().getId());
    }

    public static MnsPacketDispatcher getInstance() {
        return sInstance;
    }

    public void setDispatchPacketDelayTime(long l2) {
        this.mDispatchPacketDelayTimeWhenScreenOn = l2 > 500L ? 500L : l2;
        this.mDispatchPacketDelayTime = this.mDispatchPacketDelayTimeWhenScreenOn;
    }

    public void setCallback(IPacketListener iPacketListener) {
        MiLinkLog.e("MiLinkReceive", "\u8bbe\u7f6ecallback:  ".concat(String.valueOf(iPacketListener)));
        if (iPacketListener != null) {
            MiLinkLog.v(TAG, "register packet callback. callback=".concat(String.valueOf(iPacketListener)));
            this.mListener = iPacketListener;
            this.removeMessage(2);
            this.mHandler.sendEmptyMessage(2);
            return;
        }
        MiLinkLog.v(TAG, "register packet callback, but callback is null");
    }

    public void setPushCallback(IPushPacketListener iPushPacketListener) {
        if (iPushPacketListener != null) {
            this.mPushListener = iPushPacketListener;
        }
    }

    public void setSingleCallback(ISinglePacketListener iSinglePacketListener) {
        MiLinkLog.e("MiLinkReceive", "\u8bbe\u7f6esingle callback:  ".concat(String.valueOf(iSinglePacketListener)));
        if (iSinglePacketListener != null) {
            MiLinkLog.v(TAG, "register single packet callback. callback=".concat(String.valueOf(iSinglePacketListener)));
            this.mSingleListener = iSinglePacketListener;
            return;
        }
        MiLinkLog.v(TAG, "register single packet callback, but callback is null");
    }

    public void dispatchPacket(PacketData packetData) {
        if (packetData != null) {
            MiLinkLog.v(TAG, "dispatch packet data, seq=" + packetData.getSeqNo());
            Message message = this.obtainMessage();
            if (this.mDispatchPacketDelayTime > 0L) {
                message.what = 1;
                message.obj = packetData;
            } else {
                message.what = 2;
                message.obj = packetData;
            }
            this.sendMessage(message);
            return;
        }
        MiLinkLog.v(TAG, "dispatch packet data, but data is null");
    }

    private void execDispatch() {
        MiLinkLog.v(TAG, "DISPATCH_PACKET, mPacketCache.size=" + this.mPacketCache.size());
        MiLinkLog.e("MiLinkReceive", "execDispatch:  " + this.mPacketCache.size());
        if (!this.mPacketCache.isEmpty()) {
            ArrayList<PacketData> arrayList = new ArrayList<PacketData>();
            for (PacketData packetData : this.mPacketCache) {
                if (packetData.getCommand() != "milink.push" || this.mPushListener == null) continue;
                this.mPushListener.onReceive(packetData);
            }
            arrayList.addAll(this.mPacketCache);
            this.mPacketCache.clear();
            if (this.mListener != null) {
                this.mListener.onReceive(arrayList);
            }
            for (PacketData packetData : arrayList) {
                if (this.mSingleListener == null) continue;
                this.mSingleListener.onReceive(packetData);
            }
        }
    }

    @Override
    protected void processMessage(Message object) {
        MiLinkLog.e("MiLinkReceive", "MnsPacketDispatcher processMessage msg.what:  " + ((Message)object).what);
        switch (((Message)object).what) {
            case 1: {
                object = (PacketData)((Message)object).obj;
                if (object != null) {
                    MiLinkLog.v(TAG, "ADD_PACKET, seq=" + ((PacketData)object).getSeqNo());
                    this.mPacketCache.add((PacketData)object);
                    this.removeMessage(2);
                    if (this.mDispatchPacketDelayTime > 0L && this.mPacketCache.size() < 10) {
                        this.mHandler.sendEmptyMessageDelayed(2, this.mDispatchPacketDelayTime);
                        return;
                    }
                    this.execDispatch();
                }
                return;
            }
            case 2: {
                if (((Message)object).obj != null) {
                    object = (PacketData)((Message)object).obj;
                    this.mPacketCache.add((PacketData)object);
                }
                this.execDispatch();
                return;
            }
        }
        MiLinkLog.e(TAG, "handleMessage unknown msgid = " + ((Message)object).what);
    }

    public void setDispatchPacketDelayTimeWhenScreenOn() {
        this.mDispatchPacketDelayTime = this.mDispatchPacketDelayTimeWhenScreenOn;
    }

    public void setDispatchPacketDelayTimeWhenScreenOff() {
        this.mDispatchPacketDelayTime = 0L;
    }
}

