/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.SystemClock;
import android.text.TextUtils;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.account.MiAccount;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.data.Convert;
import com.mi.milink.sdk.base.os.Device;
import com.mi.milink.sdk.base.os.info.DeviceDash;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.config.HeartBeatManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManager;
import com.mi.milink.sdk.connection.DomainManager;
import com.mi.milink.sdk.connection.IConnection;
import com.mi.milink.sdk.connection.IConnectionCallback;
import com.mi.milink.sdk.connection.TcpConnection;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.TrafficMonitor;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.proto.DataExtraProto;
import com.mi.milink.sdk.proto.SystemPacketProto;
import com.mi.milink.sdk.session.common.InvalidPacketExecption;
import com.mi.milink.sdk.session.common.MsgProcessor;
import com.mi.milink.sdk.session.common.OpenSessionSucessReturnInfo;
import com.mi.milink.sdk.session.common.ReceiveBuffer;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.SessionConst;
import com.mi.milink.sdk.session.common.StreamUtil;
import com.mi.milink.sdk.session.common.ThreadHelper;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.RecvDataProcessUtil;
import com.mi.milink.sdk.session.persistent.SessionManager;
import com.mi.milink.sdk.util.StatisticsLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.greenrobot.eventbus.EventBus;

public class Session
implements IConnectionCallback,
MsgProcessor {
    private String TAG = "Session";
    protected static final int MSG_CONNECT = 1;
    protected static final int MSG_HANDLE_REQUEST = 2;
    protected static final int MSG_CHECK_TIMEOUT = 3;
    protected static final int MSG_DISCONNECT = 4;
    protected static final int MSG_POST_STATISTICS_TIMEOUT_PACKET = 5;
    protected int mCurState = 0;
    protected static final int NO_CONNECT_STATE = 0;
    protected static final int CONNECTING_STATE = 1;
    protected static final int CONNECTED_STATE = 2;
    protected static final int HANDSHAKE_INITING_STATE = 3;
    protected static final int HANDSHAKE_INITED_STATE = 4;
    protected static final int FAST_CHECK_PING_TIME_OUT = 5000;
    public static final int SESSION_TYPE_DEFAULT = 0;
    public static final int SESSION_TYPE_ASSIST = 1;
    protected int mSessionType = 1;
    protected boolean mNeedClientInfo = true;
    protected IConnection mConn;
    protected ServerProfile mServerProfile;
    protected ServerProfile mServerProfileForStatistic;
    protected ReceiveBuffer mRecBuffer;
    protected int mSessionNO = 0;
    protected long mConnectStartTime = 0L;
    protected long mOpenSessionDoneTime = 0L;
    protected long mDnsWaitTime = 0L;
    protected ConcurrentHashMap<Integer, Request> mRequestMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<Integer, Request> mPendingStatisticTimeoutedRequestMap = new ConcurrentHashMap();
    protected long mLastSendFastCheckPingTime = 0L;
    protected long mLastReceivedFastPingTime = 0L;
    protected long mLastReceivedPacketTime = 0L;
    protected String mLogTag = this.TAG;
    protected RecvDataProcessUtil mRecvDataProcessUtil = new RecvDataProcessUtil(this);
    protected int mContinuousRecv110Count = 0;
    public int mFlagForSessionManager;
    protected boolean mCanClose = true;
    private int appId;
    private long mConsumedTime = 0L;
    private ReceiveBuffer.ReceiveBufferSink mRecBufSink = new ReceiveBuffer.ReceiveBufferSink(){

        @Override
        public boolean onRecvDownStream(int n2, byte[] object) {
            long l2;
            MiLinkLog.e("MiLinkReceive", "session\u6536\u5230\u56de\u8c03\u7684\u6570\u636e\uff1a  ".concat(String.valueOf(n2)));
            if (object == null) {
                return false;
            }
            PacketData packetData = null;
            try {
                packetData = StreamUtil.getDownPacket(String.format("[No:%d]", n2), object, new StreamUtil.GetAccountAdapter(){

                    @Override
                    public IAccount getAccount(int n2) {
                        Request request = Session.this.mRequestMap.get(n2);
                        if (request == null) {
                            return MiAccountManager.getInstance().getCurrentAccount();
                        }
                        return request.getOwnerAccount();
                    }
                });
            }
            catch (IOException iOException) {
                MiLinkLog.e(Session.this.mLogTag, "decode downstream failed", iOException);
            }
            if (packetData == null) {
                return false;
            }
            Session.this.mLastReceivedPacketTime = l2 = SystemClock.elapsedRealtime();
            Session.this.mNeedClientInfo = !packetData.hasClientInfo();
            MiLinkLog.w(Session.this.mLogTag, " onRecvDownStream cmd=" + packetData.getCommand() + " mnscode=" + packetData.getMnsCode() + " seq=" + packetData.getSeqNo() + " and set mNeedClientInfo=" + Session.this.mNeedClientInfo);
            TrafficMonitor.getInstance().traffic(packetData.getCommand(), ((byte[])object).length);
            Request request = Session.this.mPendingStatisticTimeoutedRequestMap.remove(packetData.getSeqNo());
            Request request2 = Session.this.mRequestMap.get(packetData.getSeqNo());
            object = request2;
            if (request2 != null) {
                Session.this.mRequestMap.remove(packetData.getSeqNo());
                if (Session.this.isFastCheckPing((Request)object)) {
                    Session.this.mLastReceivedFastPingTime = l2;
                    Global.getMainHandler().removeCallbacks(Session.this.mHandlePendingStatisticTimeoutedRunnable);
                    Global.getMainHandler().postAtFrontOfQueue(Session.this.mHandlePendingStatisticTimeoutedRunnable);
                }
            } else if (request != null) {
                object = request;
            }
            Session.this.mRecvDataProcessUtil.selectHandleUtil(packetData, (Request)object).handle();
            if (Session.this.mRequestMap.isEmpty()) {
                EventBus.getDefault().post(new MiLinkEvent.SessionOtherEvent(MiLinkEvent.SessionOtherEvent.EventType.RequestMapIsEmpty, Session.this));
            }
            return true;
        }

        @Override
        public boolean onAddTimeout(int n2, int n3) {
            return false;
        }
    };
    private Runnable mHandlePendingStatisticTimeoutedRunnable = new Runnable(){

        @Override
        public void run() {
            EventBus.getDefault().post(new MiLinkEvent.SessionOtherEvent(MiLinkEvent.SessionOtherEvent.EventType.StatisticsTimeoutPacket, Session.this));
        }
    };
    protected ResponseListener mHandShakeRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData object) {
            Object object2;
            StatisticsLog.end("hand_shake_success_no_" + Session.this.mSessionNO);
            MiLinkLog.e(Session.this.TAG, String.format("milink handshake cosumed time %d", SystemClock.elapsedRealtime() - Session.this.mConsumedTime));
            MiLinkLog.v(Session.this.mLogTag, "hand shake success session " + Session.this.mServerProfile + ", seq=" + ((PacketData)object).getSeqNo());
            SystemPacketProto.MnsCmdHandShakeRsp mnsCmdHandShakeRsp = null;
            try {
                mnsCmdHandShakeRsp = SystemPacketProto.MnsCmdHandShakeRsp.parseFrom(((PacketData)object).getData());
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
            if (mnsCmdHandShakeRsp == null) {
                MiLinkLog.e(Session.this.mLogTag, "handshake response is null");
                Session.this.onOpenSessionHandshakeSuccess(null);
                return;
            }
            object = mnsCmdHandShakeRsp.getClientinfo();
            MiLinkLog.v(Session.this.mLogTag, "clientInfo:".concat(String.valueOf(object)));
            Session.this.mClientIp = "";
            Session.this.mClientIsp = "";
            if (!TextUtils.isEmpty((CharSequence)object) && (object = ((String)object).split("#")) != null) {
                Session.this.mClientIp = object[0];
                if (((String[])object).length > 1) {
                    Session.this.mClientIsp = object[1];
                }
            }
            if (!TextUtils.isEmpty((CharSequence)Session.this.mClientIp)) {
                object = DataExtraProto.DataClientIp.newBuilder();
                ((DataExtraProto.DataClientIp.Builder)object).setClientIp(Session.this.mClientIp);
                ((DataExtraProto.DataClientIp.Builder)object).setClientIpIsp(Session.this.mClientIsp);
                object2 = new PacketData();
                ((PacketData)object2).setCommand("data.clientip");
                ((PacketData)object2).setData(((DataExtraProto.DataClientIp.Builder)object).build().toByteArray());
                MiLinkLog.d(Session.this.TAG, " disp clientIP");
                MnsPacketDispatcher.getInstance().dispatchPacket((PacketData)object2);
            }
            object = null;
            object2 = null;
            if (mnsCmdHandShakeRsp.getRedirectList() != null) {
                object = new ArrayList();
                object2 = new ArrayList();
                for (int i2 = 0; i2 < mnsCmdHandShakeRsp.getRedirectCount(); ++i2) {
                    String[] stringArray;
                    SystemPacketProto.MnsIpInfo mnsIpInfo = mnsCmdHandShakeRsp.getRedirect(i2);
                    if (mnsIpInfo.getIp() != 0) {
                        ((ArrayList)object).add(new ServerProfile(Convert.intToIPv4(mnsIpInfo.getIp()), 0, 1, 5));
                    }
                    if (mnsIpInfo.hasIpv6()) {
                        ((ArrayList)object).add(new ServerProfile(mnsIpInfo.getIpv6(), 0, 1, 5));
                    }
                    if (i2 == 0 && !TextUtils.isEmpty((CharSequence)(stringArray = mnsIpInfo.getRemark())) && (stringArray = stringArray.split("#")) != null) {
                        int n3 = stringArray.length;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            String string2 = stringArray[i3];
                            if (TextUtils.isEmpty((CharSequence)string2)) continue;
                            ((ArrayList)object2).add(new ServerProfile(string2, 0, 1, 5));
                        }
                    }
                    if (mnsIpInfo.hasIpv6()) {
                        MiLinkLog.w(Session.this.mLogTag, "milink server ipv6:" + mnsIpInfo.getIpv6() + " port:" + mnsIpInfo.getPort() + " remark:" + mnsIpInfo.getRemark());
                        continue;
                    }
                    MiLinkLog.w(Session.this.mLogTag, "milink server ipv4:" + Convert.intToIPv4(mnsIpInfo.getIp()) + " port:" + mnsIpInfo.getPort() + " remark:" + mnsIpInfo.getRemark());
                }
            }
            Session.this.onOpenSessionHandshakeSuccess(new OpenSessionSucessReturnInfo(Session.this.mClientIp, Session.this.mClientIsp, (ArrayList<ServerProfile>)object, (ArrayList<ServerProfile>)object2));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            MiLinkLog.i(Session.this.mLogTag, "hand shake error session, errCode=" + n2 + ", errMsg=" + string2);
            if (n2 == 516 || n2 == 515 || n2 == 557) {
                Session.this.mIsHandshakeRequestFailed = true;
                Session.this.onOpenSessionHandshakeFail(n2);
                return;
            }
            Session.this.onOpenSessionHandshakeSuccess(null);
        }
    };
    private ResponseListener mAnonymousFastLoginRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData object) {
            if (!MiAccountManager.getInstance().isAnonymousModeCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "current is not anonymous mode");
                return;
            }
            MiLinkLog.v(Session.this.mLogTag, "anonymous fastlogin response mns code: " + ((PacketData)object).getMnsCode());
            if (((PacketData)object).getMnsCode() == 0) {
                Object object2 = null;
                try {
                    object2 = SystemPacketProto.MnsCmdAnonymousRsp.parseFrom(((PacketData)object).getData());
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
                if (object2 == null) {
                    MiLinkLog.w(Session.this.mLogTag, "anonymous fastlogin response = null");
                    EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, 998));
                    return;
                }
                if (((SystemPacketProto.MnsCmdAnonymousRsp)object2).getB2() != null && ((SystemPacketProto.MnsCmdAnonymousRsp)object2).getGTKEYB2() != null) {
                    AnonymousAccount.getInstance().loginMiLink(((SystemPacketProto.MnsCmdAnonymousRsp)object2).getB2().toByteArray(), ((SystemPacketProto.MnsCmdAnonymousRsp)object2).getGTKEYB2().toByteArray());
                } else {
                    MiLinkLog.w(Session.this.mLogTag, "anonymous fastlogin response.getB2() = null or response.getGTKEYB2() = null");
                }
                MiAccountManager.getInstance().setPassportInit(false);
                ConfigManager.getInstance().updateSuidAnonymous(((SystemPacketProto.MnsCmdAnonymousRsp)object2).getSUID());
                object2 = String.valueOf(((SystemPacketProto.MnsCmdAnonymousRsp)object2).getWid());
                AnonymousAccount.getInstance().setUserId((String)object2);
                try {
                    object = DataExtraProto.DataAnonymousWid.newBuilder();
                    ((DataExtraProto.DataAnonymousWid.Builder)object).setWid(Long.valueOf((String)object2));
                    object2 = new PacketData();
                    ((PacketData)object2).setCommand("data.anonymouswid");
                    ((PacketData)object2).setData(((DataExtraProto.DataAnonymousWid.Builder)object).build().toByteArray());
                    MnsPacketDispatcher.getInstance().dispatchPacket((PacketData)object2);
                }
                catch (Exception exception) {}
                EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginSuccess, Session.this, 0));
                return;
            }
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, ((PacketData)object).getMnsCode()));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            if (!MiAccountManager.getInstance().isAnonymousModeCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "current is not anonymous mode");
                return;
            }
            MiLinkLog.i(Session.this.mLogTag, "fastlogin onDataSendFailed errCode= " + n2 + ", errMsg=" + string2);
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, n2));
        }
    };
    private ResponseListener mFastLoginRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData packetData) {
            MiLinkLog.e(Session.this.TAG, String.format("milink annony fast login cosumed time %d", SystemClock.elapsedRealtime() - Session.this.mConsumedTime));
            if (MiAccountManager.getInstance().isAnonymousModeCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "current is not stardard mode");
                return;
            }
            MiLinkLog.v(Session.this.mLogTag, "fastlogin response mns code: " + packetData.getMnsCode());
            if (packetData.getMnsCode() == 0) {
                SystemPacketProto.MnsCmdFastloginRsp mnsCmdFastloginRsp = null;
                try {
                    mnsCmdFastloginRsp = SystemPacketProto.MnsCmdFastloginRsp.parseFrom(packetData.getData());
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
                if (mnsCmdFastloginRsp == null) {
                    MiLinkLog.w(Session.this.mLogTag, "fastlogin response = null");
                    EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, 998));
                    return;
                }
                if (mnsCmdFastloginRsp.getB2() != null && mnsCmdFastloginRsp.getGTKEYB2() != null) {
                    MiAccount.getInstance().loginMiLink(mnsCmdFastloginRsp.getB2().toByteArray(), mnsCmdFastloginRsp.getGTKEYB2().toByteArray());
                } else {
                    MiLinkLog.w(Session.this.mLogTag, "fastlogin response.getB2() = null or response.getGTKEYB2() = null");
                }
                MiAccountManager.getInstance().setPassportInit(false);
                ConfigManager.getInstance().updateSuid(mnsCmdFastloginRsp.getSUID());
                EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginSuccess, Session.this, 0));
                return;
            }
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, packetData.getMnsCode()));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            if (MiAccountManager.getInstance().isAnonymousModeCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "current is not stardard mode");
                return;
            }
            MiLinkLog.i(Session.this.mLogTag, "fastlogin onDataSendFailed errCode= " + n2 + ", errMsg=" + string2);
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, n2));
        }
    };
    private ResponseListener mChannelFastLoginRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData packetData) {
            if (!MiAccountManager.getInstance().isChannelModCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "current is not channel mode " + MiAccountManager.getInstance().getCurrentAccountType());
                return;
            }
            MiLinkLog.v(Session.this.mLogTag, "channel fastlogin response mns code: " + packetData.getMnsCode());
            if (packetData.getMnsCode() == 0) {
                Object object = null;
                try {
                    object = SystemPacketProto.MnsCmdChannelRsp.parseFrom(packetData.getData());
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
                if (object == null) {
                    MiLinkLog.w(Session.this.mLogTag, "chanel fastlogin response = null");
                    EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, 998));
                    return;
                }
                if (((SystemPacketProto.MnsCmdChannelRsp)object).getB2() != null && ((SystemPacketProto.MnsCmdChannelRsp)object).getGTKEYB2() != null) {
                    AnonymousAccount.getInstance().loginMiLink(((SystemPacketProto.MnsCmdChannelRsp)object).getB2().toByteArray(), ((SystemPacketProto.MnsCmdChannelRsp)object).getGTKEYB2().toByteArray());
                } else {
                    MiLinkLog.w(Session.this.mLogTag, "channel fastlogin response.getB2() = null or response.getGTKEYB2() = null");
                }
                MiAccountManager.getInstance().setPassportInit(false);
                object = String.valueOf(((SystemPacketProto.MnsCmdChannelRsp)object).getWid());
                AnonymousAccount.getInstance().setUserId((String)object);
                EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginSuccess, Session.this, 0));
                return;
            }
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, packetData.getMnsCode()));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            if (!MiAccountManager.getInstance().isChannelModCurrent()) {
                MiLinkLog.i(Session.this.mLogTag, "failed current is not channel mode " + MiAccountManager.getInstance().getCurrentAccountType());
                return;
            }
            MiLinkLog.i(Session.this.mLogTag, "channel fastlogin onDataSendFailed errCode= " + n2 + ", errMsg=" + string2);
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LoginFailed, Session.this, n2));
        }
    };
    private ResponseListener mLogoffRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData packetData) {
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LogoffCmdReturn, Session.this, 0));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            EventBus.getDefault().post(new MiLinkEvent.SessionLoginEvent(MiLinkEvent.SessionLoginEvent.EventType.LogoffCmdReturn, Session.this, 0));
        }
    };
    private boolean mIsHandshakeRequestFailed = false;
    private OpenSessionSucessReturnInfo mOpenSessionSucessReturnInfo;
    private String mClientIp = "";
    private String mClientIsp = "";

    public void setAppId(int n2) {
        this.appId = n2;
    }

    public Session() {
        this(0);
        this.appId = Global.getClientAppInfo().getAppId();
        this.TAG = this.TAG + this.appId;
    }

    public Session(int n2) {
        this.mSessionType = n2;
        this.mSessionNO = SessionConst.generateSessionNO();
        this.mLogTag = this.mSessionType == 1 ? String.format("[as_No:%d]", this.mSessionNO) + this.TAG : String.format("[No:%d]", this.mSessionNO) + this.TAG;
        this.mConn = null;
        this.mServerProfile = null;
        this.mRecBuffer = new ReceiveBuffer(this.mRecBufSink, this.mSessionNO, this.mSessionType == 1);
        this.mCurState = 0;
    }

    public int getSessionNO() {
        return this.mSessionNO;
    }

    public long getOpenSessionTimecost() {
        return this.mOpenSessionDoneTime - this.mConnectStartTime;
    }

    public long getDnsWaitTime() {
        return this.mDnsWaitTime;
    }

    public boolean openSession(ServerProfile serverProfile) {
        this.resetContinuousRecv110Count();
        this.mIsHandshakeRequestFailed = false;
        this.mNeedClientInfo = true;
        if (serverProfile == null || serverProfile.getProtocol() == 0) {
            MiLinkLog.v(this.mLogTag, "openSession fail, serverprofile=".concat(String.valueOf(serverProfile)));
            this.onOpenSessionBuildConnectFail(557);
            return false;
        }
        this.mCurState = 1;
        boolean bl2 = false;
        this.mLastSendFastCheckPingTime = 0L;
        if (this.mServerProfile == null || this.mServerProfile.getProtocol() != serverProfile.getProtocol()) {
            if (this.mConn != null) {
                this.mConn.stop();
            }
            if (serverProfile.getProtocol() == 1) {
                this.mConn = new TcpConnection(this.mSessionNO, this);
            }
            this.mServerProfile = serverProfile;
            try {
                bl2 = this.mConn.start();
            }
            catch (Exception exception) {
                MiLinkLog.e(this.mLogTag, "connection start failed", exception);
            }
            if (!bl2) {
                this.onOpenSessionBuildConnectFail(562);
                return false;
            }
        } else {
            if (this.mConn == null && serverProfile.getProtocol() == 1) {
                this.mConn = new TcpConnection(this.mSessionNO, this);
            }
            if (!this.mConn.isRunning()) {
                this.mServerProfile = serverProfile;
                try {
                    bl2 = this.mConn.start();
                }
                catch (Exception exception) {
                    MiLinkLog.e(this.mLogTag, "connection start failed", exception);
                }
                if (!bl2) {
                    this.onOpenSessionBuildConnectFail(562);
                    return false;
                }
            }
        }
        this.mServerProfile = serverProfile;
        this.postMessage(1, null, 0);
        return true;
    }

    public ServerProfile getServerProfile() {
        return this.mServerProfile;
    }

    public ServerProfile getServerProfileForStatistic() {
        return this.mServerProfileForStatistic;
    }

    public boolean isAvailable() {
        switch (this.mCurState) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isConnected() {
        switch (this.mCurState) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean handleRequest(Request request) {
        if (request == null) {
            MiLinkLog.e(this.mLogTag, "handleRequest request == null");
            return false;
        }
        HeartBeatManager.getInstance().setLastPacketSendTime(request.getData().getSeqNo(), request.getData().getCommand());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("handleRequest seq=").append(request.getSeqNo()).append(" cmd=").append(request.getData().getCommand()).append(" mServerProfile=").append(this.mServerProfile.toString()).append(" mNeedClientInfo=").append(this.mNeedClientInfo);
        MiLinkLog.w(this.mLogTag, stringBuilder.toString());
        request.setHandleSessionNO(this.mSessionNO);
        boolean bl2 = this.postMessage(2, request, 0);
        if (this.mConn != null) {
            this.mConn.wakeUp();
        }
        if (!SessionManager.getInstance().isTimerOpen()) {
            EventBus.getDefault().post(new MiLinkEvent.SessionOtherEvent(MiLinkEvent.SessionOtherEvent.EventType.RequestMapIsNotEmpty, this));
        }
        return bl2;
    }

    private boolean postMessage(int n2, Object object, int n3) {
        boolean bl2;
        if (this.mConn == null) {
            MiLinkLog.e(this.mLogTag, "postMessage " + n2 + " mConn == null!!!!");
            return false;
        }
        try {
            bl2 = this.mConn.postMessage(n2, object, n3, this);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!bl2) {
            MiLinkLog.e(this.mLogTag, "mMessage must be full ! uMsg = ".concat(String.valueOf(n2)));
            return bl2;
        }
        return bl2;
    }

    public synchronized boolean close() {
        this.clear();
        if (!this.mCanClose) {
            MiLinkLog.i(this.mLogTag, "connecting! can not close");
            return false;
        }
        if (this.mConn != null) {
            MiLinkLog.w(this.mLogTag, "stop begin");
            ThreadHelper.NETWORK.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MiLinkLog.i(Session.this.TAG, "thread-pool: close start");
                    Class<Session> clazz = Session.class;
                    synchronized (Session.class) {
                        try {
                            if (Session.this.mConn != null) {
                                Session.this.mConn.stop();
                                Session.this.mConn = null;
                            }
                        }
                        catch (Exception exception) {
                            MiLinkLog.e(Session.this.mLogTag, "close null pointer " + exception.toString());
                        }
                        MiLinkLog.i(Session.this.TAG, "thread-pool: close end");
                        return;
                    }
                }
            });
            this.mServerProfile = null;
            this.mCurState = 0;
            MiLinkLog.w(this.mLogTag, "stop over");
        }
        return true;
    }

    public void disConnect() {
        this.disConnect(-1);
    }

    public void disConnect(int n2) {
        MiLinkLog.i(this.mLogTag, "disConnect, errorCallBackErrorCode=".concat(String.valueOf(n2)));
        this.postMessage(4, null, n2);
    }

    @Override
    public void onMsgProc(int n2, Object object, int n3) {
        MiLinkLog.v(this.mLogTag, "onMsgProc, uMsg=" + n2 + ", wParam=" + n3);
        switch (n2) {
            case 1: {
                String string2;
                if (this.mServerProfile == null) {
                    MiLinkLog.e(this.mLogTag, "OnMsgProc mServerProfile == null!!!");
                    this.onOpenSessionBuildConnectFail(1);
                    return;
                }
                this.mServerProfileForStatistic = this.mServerProfile;
                long l2 = SystemClock.elapsedRealtime();
                object = MiLinkIpInfoManager.getInstance().getDefaultHost();
                if (this.mServerProfile.getServerIP().equals(object)) {
                    string2 = DomainManager.getInstance().getDomainIP(this.mServerProfile.getServerIP());
                    if (string2 == null) {
                        this.onOpenSessionBuildConnectFail(1);
                        return;
                    }
                    this.mServerProfile.setServerIP(string2);
                } else {
                    string2 = this.mServerProfile.getServerIP();
                }
                MiLinkLog.e(this.mLogTag, "connect to " + this.mServerProfile);
                this.mConnectStartTime = SystemClock.elapsedRealtime();
                this.mDnsWaitTime = this.mConnectStartTime - l2;
                if (this.mConn != null) {
                    this.mCanClose = false;
                    this.mConn.connect(string2, this.mServerProfile.getServerPort(), this.mServerProfile.getProxyIP(), this.mServerProfile.getPorxyPort(), ConfigManager.getInstance().getConnetionTimeout(), 0);
                }
                return;
            }
            case 2: {
                Request request = (Request)object;
                if (request == null) {
                    return;
                }
                if (!request.isValidNow()) {
                    MiLinkLog.e(this.mLogTag, String.format("seq=%d,cmd=%s is invalid", request.getSeqNo(), request.getData().getCommand()));
                    this.mRequestMap.remove(request.getSeqNo());
                    request.onDataSendFailed(998, "package is already over the valid time");
                    return;
                }
                request.setSentTime(SystemClock.elapsedRealtime());
                PacketData packetData = request.getData();
                String string3 = packetData.getCommand();
                if ("milink.fastlogin".equals(string3) || "milink.anonymous".equals(string3)) {
                    this.mNeedClientInfo = true;
                    MiLinkLog.v(this.mLogTag, "set mNeedClientInfo=true when send login or fastlogin");
                }
                packetData.setNeedClientInfo(this.mNeedClientInfo);
                object = request.toBytes();
                if (packetData.needResponse()) {
                    this.mRequestMap.put(request.getSeqNo(), request);
                }
                if (this.isFastCheckPing(request)) {
                    this.mLastSendFastCheckPingTime = SystemClock.elapsedRealtime();
                    Global.getMainHandler().postDelayed(this.mHandlePendingStatisticTimeoutedRunnable, 5200L);
                }
                if (object != null) {
                    if (this.mConn.sendData((byte[])object, request.getSeqNo(), request.getTimeOut())) {
                        TrafficMonitor.getInstance().traffic(string3, ((Object)object).length);
                        return;
                    }
                } else {
                    this.mRequestMap.remove(request.getSeqNo());
                    request.onDataSendFailed(518, "data encryption failed");
                    MiLinkLog.w(this.mLogTag, "connection send data, but data = null");
                }
                return;
            }
            case 3: {
                this.checkIsReadTimeOut();
                return;
            }
            case 4: {
                if (this.mConn != null) {
                    this.mConn.disconnect();
                }
                this.mCurState = 0;
                MiLinkLog.w(this.mLogTag, "OnMsgProc disconnect = " + n3 + " mCurState=" + this.mCurState);
                if (n3 <= 0) break;
                this.onSessionError(n3);
                return;
            }
            case 5: {
                this.handlePendingStatisticTimeoutedRequestMap();
                return;
            }
            default: {
                MiLinkLog.e(this.mLogTag, "OnMsgProc unknow uMsgID = ".concat(String.valueOf(n2)));
            }
        }
    }

    protected void handShake(IAccount object) {
        StatisticsLog.begin("hand_shake_success_no_" + this.mSessionNO);
        this.mConsumedTime = SystemClock.elapsedRealtime();
        this.mCurState = 3;
        SystemPacketProto.MnsCmdHandShakeReqOrBuilder mnsCmdHandShakeReqOrBuilder = SystemPacketProto.MnsCmdHandShakeReq.newBuilder();
        ((SystemPacketProto.MnsCmdHandShakeReq.Builder)mnsCmdHandShakeReqOrBuilder).setType(1);
        mnsCmdHandShakeReqOrBuilder = ((SystemPacketProto.MnsCmdHandShakeReq.Builder)mnsCmdHandShakeReqOrBuilder).build();
        PacketData packetData = new PacketData();
        packetData.setCommand("milink.handshake");
        packetData.setSeqNo(Global.getSequence());
        packetData.setData(((AbstractMessageLite)((Object)mnsCmdHandShakeReqOrBuilder)).toByteArray());
        object = new Request(packetData, this.mHandShakeRspListener, 5, (IAccount)object);
        ((Request)object).setInternal(true);
        MiLinkLog.v(this.mLogTag, "start hand shake, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
        StatisticsLog.end("hand_shake_init_no_" + this.mSessionNO);
    }

    public void ping() {
        Object object = new PacketData();
        ((PacketData)object).setCommand("milink.ping");
        ((PacketData)object).setSeqNo(Global.getSequence());
        object = new Request((PacketData)object, null, 0, MiAccountManager.getInstance().getCurrentAccount());
        ((Request)object).setInternal(true);
        ((Request)object).setPing(true);
        MiLinkLog.v(this.mLogTag, "start ping, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
    }

    private void fastCheckPing() {
        Object object = new PacketData();
        ((PacketData)object).setCommand("milink.ping");
        ((PacketData)object).setSeqNo(Global.getSequence());
        object = new Request((PacketData)object, null, 0, MiAccountManager.getInstance().getCurrentAccount());
        ((Request)object).setInternal(true);
        ((Request)object).setPing(true);
        ((Request)object).setTimeOut(5000);
        MiLinkLog.v(this.mLogTag, "start fast ping, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
    }

    public void fastLogin() {
        Object object = null;
        switch (MiAccountManager.getInstance().getCurrentAccountType()) {
            case 1: {
                this.mConsumedTime = SystemClock.elapsedRealtime();
                object = SystemPacketProto.MnsCmdAnonymousReq.newBuilder();
                Object object2 = ConfigManager.getInstance().getSuidAnonymous();
                if (!TextUtils.isEmpty((CharSequence)object2)) {
                    ((SystemPacketProto.MnsCmdAnonymousReq.Builder)object).setSUID((String)object2);
                    MiLinkLog.w(this.TAG, "start Anonymous fastlogin, suid=".concat(String.valueOf(object2)));
                } else {
                    MiLinkLog.w(this.TAG, "start Anonymous fastlogin, suid is empty");
                }
                ((SystemPacketProto.MnsCmdAnonymousReq.Builder)object).setPrivacyKey(AnonymousAccount.getInstance().getPrivacyKey());
                ((SystemPacketProto.MnsCmdAnonymousReq.Builder)object).setDeviceinfo(DeviceDash.getInstance().getDeviceSimplifiedInfo());
                ((SystemPacketProto.MnsCmdAnonymousReq.Builder)object).setOnoff(true);
                object2 = new PacketData();
                ((PacketData)object2).setSeqNo(Global.getSequence());
                ((PacketData)object2).setData(((SystemPacketProto.MnsCmdAnonymousReq.Builder)object).build().toByteArray());
                ((PacketData)object2).setCommand("milink.anonymous");
                object = new Request((PacketData)object2, this.mAnonymousFastLoginRspListener, 7, AnonymousAccount.getInstance());
                MiLinkLog.v(this.mLogTag, "start anonymous fastlogin, seq=" + ((Request)object).getSeqNo());
                break;
            }
            case 0: {
                object = SystemPacketProto.MnsCmdFastloginReq.newBuilder();
                Object object3 = ConfigManager.getInstance().getSuid();
                if (!TextUtils.isEmpty((CharSequence)object3)) {
                    ((SystemPacketProto.MnsCmdFastloginReq.Builder)object).setSUID((String)object3);
                    MiLinkLog.w(this.TAG, "start fastlogin, suid=".concat(String.valueOf(object3)));
                } else {
                    MiLinkLog.w(this.TAG, "start fastlogin, suid is empty");
                }
                ((SystemPacketProto.MnsCmdFastloginReq.Builder)object).setPassportlogin(MiAccountManager.getInstance().getPassportInit());
                ((SystemPacketProto.MnsCmdFastloginReq.Builder)object).setOnoff(true);
                byte[] byArray = MiAccount.getInstance().getFastLoginExtra();
                object3 = byArray;
                if (byArray != null) {
                    ((SystemPacketProto.MnsCmdFastloginReq.Builder)object).setExtra(ByteString.copyFrom((byte[])object3));
                }
                object3 = new PacketData();
                ((PacketData)object3).setSeqNo(Global.getSequence());
                ((PacketData)object3).setData(((SystemPacketProto.MnsCmdFastloginReq.Builder)object).build().toByteArray());
                ((PacketData)object3).setCommand("milink.fastlogin");
                object = new Request((PacketData)object3, this.mFastLoginRspListener, 3, MiAccount.getInstance());
                MiLinkLog.v(this.mLogTag, "start fastlogin, seq=" + ((Request)object).getSeqNo());
            }
        }
        ((Request)object).setInternal(true);
        this.handleRequest((Request)object);
        MiAccountManager.getInstance().setIsLogining(true);
    }

    public void heartBeat(boolean bl2) {
        Object object;
        MiLinkLog.e("HeartBeat", "\u7b2c\u4e00\u6b21\u6536\u5230\u5fc3\u8df3 ".concat(String.valueOf(bl2)));
        if (!Global.getClientAppInfo().isHeartBeatEnable()) {
            return;
        }
        Object object2 = SystemPacketProto.MnsCmdHeartBeat.newBuilder().setTimeStamp(ConfigManager.getInstance().getConfigTimeStamp());
        Object object3 = MiAccountManager.getInstance().isAnonymousModeCurrent() ? ConfigManager.getInstance().getSuidAnonymous() : ConfigManager.getInstance().getSuid();
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            ((SystemPacketProto.MnsCmdHeartBeat.Builder)object2).setSUID((String)object3);
            MiLinkLog.v(this.mLogTag, "start heartbeat, suid=".concat(String.valueOf(object3)));
        } else {
            MiLinkLog.v(this.mLogTag, "start heartbeat, suid is empty");
        }
        object3 = new B();
        if (ClientAppInfo.isSupportMiPush() && !MiAccountManager.getInstance().hasUploadRegIdToServer() && !TextUtils.isEmpty((CharSequence)(object = MiAccountManager.getInstance().getMiPushRegId()))) {
            try {
                MiLinkLog.v(this.TAG, "heartbeat regid:".concat(String.valueOf(object)));
                ((SystemPacketProto.MnsCmdHeartBeat.Builder)object2).setDevicetoken(ByteString.copyFrom(((String)object).getBytes("utf-8")));
                ((B)object3).b = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        object = new PacketData();
        ((PacketData)object).setCommand("milink.heartbeat");
        ((PacketData)object).setSeqNo(Global.getSequence());
        ((PacketData)object).setData(((SystemPacketProto.MnsCmdHeartBeat.Builder)object2).build().toByteArray());
        object2 = new Request((PacketData)object, new ResponseListener((B)object3){
            final /* synthetic */ B val$b;
            {
                this.val$b = b2;
            }

            @Override
            public void onDataSendSuccess(int n2, PacketData packetData) {
                if (this.val$b.b) {
                    MiLinkLog.v(Session.this.TAG, "upload regid to server success");
                    MiAccountManager.getInstance().setHasUploadRegIdToServer(true);
                }
                MiLinkLog.v(Session.this.mLogTag, "heartbeat success");
                if (packetData != null && packetData.getData() != null) {
                    try {
                        MessageOrBuilder messageOrBuilder = SystemPacketProto.MnsCmdHeartBeatRsp.parseFrom(packetData.getData());
                        if (messageOrBuilder != null && ConfigManager.getInstance().updateConfig(((SystemPacketProto.MnsCmdHeartBeatRsp)messageOrBuilder).getTimeStamp(), ((SystemPacketProto.MnsCmdHeartBeatRsp)messageOrBuilder).getJsonconfig())) {
                            messageOrBuilder = DataExtraProto.DataExtra.newBuilder();
                            float f2 = ConfigManager.getInstance().getEngineConfigRatio();
                            MiLinkLog.v(Session.this.mLogTag, "engineConfigRatio=".concat(String.valueOf(f2)));
                            ((DataExtraProto.DataExtra.Builder)messageOrBuilder).setEngineratio(f2);
                            Object object = ConfigManager.getInstance().getEngineMatch();
                            if (object != null) {
                                MiLinkLog.v(Session.this.mLogTag, "engineMatchJson=".concat(String.valueOf(object)));
                                ((DataExtraProto.DataExtra.Builder)messageOrBuilder).setEngineConfigJson(object.toString());
                            }
                            object = new PacketData();
                            ((PacketData)object).setCommand("data.extra");
                            ((PacketData)object).setData(((DataExtraProto.DataExtra.Builder)messageOrBuilder).build().toByteArray());
                            MnsPacketDispatcher.getInstance().dispatchPacket((PacketData)object);
                        }
                        return;
                    }
                    catch (Exception exception) {}
                }
            }

            @Override
            public void onDataSendFailed(int n2, String string2) {
                MiLinkLog.v(Session.this.mLogTag, "heartbeat failed");
            }
        }, MiAccountManager.getInstance().getBusinessEncByMode(), MiAccountManager.getInstance().getCurrentAccount());
        ((Request)object2).setInternal(true);
        if (bl2) {
            ((Request)object2).setAfterHandleCallBack(new Request.AfterHandleCallBack(){

                @Override
                public void onCallBack(String string2, int n2, String string3, int n3, long l2, long l3, int n4, int n5, int n6, String string4, String string5) {
                    string3 = "milink.firstheartbeat";
                    InternalDataMonitor.getInstance(Session.this.appId).trace(string2, n2, string3, n3, l2, l3, n4, n5, n6, string4, string5);
                }
            });
            HeartBeatManager.getInstance().startHeartBeatProbeManager(((PacketData)object).getSeqNo());
        } else {
            HeartBeatManager.getInstance().sendHeartBeat(((PacketData)object).getSeqNo());
        }
        MiLinkLog.v(this.mLogTag, "start heartbeat, seq=" + ((Request)object2).getSeqNo());
        this.handleRequest((Request)object2);
    }

    public void pushAck(int n2) {
        Object object = new PacketData();
        ((PacketData)object).setCommand("milink.push.ack");
        ((PacketData)object).setSeqNo(n2 *= -1);
        ((PacketData)object).setData(new byte[0]);
        ((PacketData)object).setNeedResponse(false);
        ((PacketData)object).setNeedClientInfo(false);
        object = new Request((PacketData)object, null, MiAccountManager.getInstance().getBusinessEncByMode(), MiAccountManager.getInstance().getCurrentAccount());
        ((Request)object).setInternal(true);
        MiLinkLog.v(this.mLogTag, "start push ack, seq=".concat(String.valueOf(n2)));
        this.handleRequest((Request)object);
    }

    public void logoff() {
        Object object = SystemPacketProto.MnsCmdLoginOff.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)ConfigManager.getInstance().getSuid())) {
            ((SystemPacketProto.MnsCmdLoginOff.Builder)object).setSUID(ConfigManager.getInstance().getSuid());
        }
        object = ((SystemPacketProto.MnsCmdLoginOff.Builder)object).build();
        PacketData packetData = new PacketData();
        packetData.setNeedResponse(false);
        packetData.setCommand("milink.loginoff");
        packetData.setSeqNo(Global.getSequence());
        packetData.setData(((AbstractMessageLite)object).toByteArray());
        object = new Request(packetData, this.mLogoffRspListener, MiAccountManager.getInstance().getBusinessEncByMode(), MiAccountManager.getInstance().getCurrentAccount());
        ((Request)object).setInternal(true);
        MiLinkLog.v(this.mLogTag, "start logoff, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
    }

    @Override
    public boolean onStart() {
        return false;
    }

    @Override
    public boolean onConnect(boolean bl2, int n2) {
        this.mCanClose = true;
        if (bl2) {
            this.onOpenSessionBuildConnectSuccess();
        } else {
            this.onOpenSessionBuildConnectFail(n2);
        }
        return true;
    }

    @Override
    public boolean onDisconnect() {
        MiLinkLog.i(this.mLogTag, "OnDisconnect");
        if (this.mRecBuffer != null) {
            this.mRecBuffer.reset();
        }
        for (Object object : this.mRequestMap.keySet()) {
            if ((object = this.mRequestMap.get(object)) == null) continue;
            MiLinkLog.e(this.mLogTag, "Const.InternalErrorCode.CONNECT_FAIL, seq=" + ((Request)object).getSeqNo() + ",cmd=" + ((Request)object).getData().getCommand());
            ((Request)object).onDataSendFailed(516, "native network broken");
        }
        this.mRequestMap.clear();
        this.handlePendingStatisticTimeoutedRequestMap();
        this.mPendingStatisticTimeoutedRequestMap.clear();
        return true;
    }

    @Override
    public boolean onError(int n2) {
        if (this.mIsHandshakeRequestFailed) {
            MiLinkLog.e(this.mLogTag, "onError but handshake failed has already notice SM, socketStatus:" + n2 + ", mCurState=" + this.mCurState);
            this.mIsHandshakeRequestFailed = false;
            return true;
        }
        MiLinkLog.e(this.mLogTag, "onError socketStatus " + n2 + ", mCurState=" + this.mCurState);
        switch (this.mCurState) {
            case 0: 
            case 1: 
            case 2: {
                this.onOpenSessionBuildConnectFail(1);
                break;
            }
            case 3: {
                if (n2 == 526) {
                    this.onOpenSessionHandshakeFail(3);
                    break;
                }
                this.onOpenSessionHandshakeFail(2);
                break;
            }
            case 4: {
                this.onSessionError(n2);
                break;
            }
            default: {
                MiLinkLog.e(this.mLogTag, "onError wrong state = " + this.mCurState);
            }
        }
        return true;
    }

    @Override
    public boolean onTimeOut(int n2, int n3) {
        MiLinkLog.v(this.mLogTag, "send time out: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onRecv(byte[] byArray) {
        MiLinkLog.w(this.mLogTag, "recv data:" + byArray.length);
        MiLinkLog.e("MiLinkReceive", "\u6536\u5230\u6d88\u606f\uff1a " + byArray.length);
        if (this.mRecBuffer != null) {
            try {
                this.mRecBuffer.append(byArray);
            }
            catch (InvalidPacketExecption invalidPacketExecption) {
                if (this.mCurState != 3 && this.mCurState != 4) {
                    this.disConnect(517);
                }
                MiLinkLog.e("MiLinkReceive", "\u65e0\u6548\u6d88\u606f\uff1a " + (invalidPacketExecption.errCode == 1) + "  " + (this.mSessionType == 0));
                if (invalidPacketExecption.errCode == 1 && this.mSessionType == 0) {
                    EventBus.getDefault().post(new MiLinkEvent.SessionOtherEvent(MiLinkEvent.SessionOtherEvent.EventType.RecvInvalidPacket, this));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onSendBegin(int n2) {
        MiLinkLog.v(this.mLogTag, "send begin: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onSendEnd(int n2) {
        MiLinkLog.w(this.mLogTag, "send end: seq=".concat(String.valueOf(n2)));
        return false;
    }

    private void onOpenSessionBuildConnectFail(int n2) {
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        this.mCurState = 0;
        if (this.mSessionType == 1) {
            EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.AssistSessionConnectFailed, this, n2));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.SessionBuildFailed, this, n2));
    }

    private void onOpenSessionBuildConnectSuccess() {
        this.mCurState = 2;
        if (this.mSessionType == 1) {
            EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.AssistSessionConnectSuccess, this, 0));
            return;
        }
        this.handShake(MiAccountManager.getInstance().getCurrentAccount());
    }

    protected void onOpenSessionHandshakeFail(int n2) {
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        this.mCurState = 2;
        EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.SessionBuildFailed, this, n2));
    }

    public OpenSessionSucessReturnInfo getOpenSessionSucessReturnInfo() {
        return this.mOpenSessionSucessReturnInfo;
    }

    protected void onOpenSessionHandshakeSuccess(OpenSessionSucessReturnInfo openSessionSucessReturnInfo) {
        MiLinkLog.e(this.TAG, "onOpenSessionHandshakeSuccess send event begin");
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        this.mCurState = 4;
        this.mOpenSessionSucessReturnInfo = openSessionSucessReturnInfo;
        EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.SessionBuildSuccess, this, 0));
        MiLinkLog.e(this.TAG, "onOpenSessionHandshakeSuccess send event end");
    }

    private void onSessionError(int n2) {
        this.mCurState = 0;
        if (this.mSessionType == 1) {
            EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.AssistSessionRunError, this, n2));
            return;
        }
        EventBus.getDefault().post(new MiLinkEvent.SessionConnectEvent(MiLinkEvent.SessionConnectEvent.EventType.SessionRunError, this, n2));
    }

    public boolean checkRequestsTimeout() {
        if (this.shouldCheckRequestsTimeout()) {
            return this.postMessage(3, null, 0);
        }
        EventBus.getDefault().post(new MiLinkEvent.SessionOtherEvent(MiLinkEvent.SessionOtherEvent.EventType.RequestMapIsEmpty, this));
        return false;
    }

    public boolean shouldCheckRequestsTimeout() {
        return this.isConnected() && !this.mRequestMap.isEmpty();
    }

    private boolean isFastCheckPing(Request request) {
        return request.isPingRequest() && request.getTimeOut() == 5000;
    }

    private void checkIsReadTimeOut() {
        boolean bl2;
        int n2;
        boolean bl3 = false;
        boolean bl4 = false;
        ConcurrentLinkedQueue<Request> concurrentLinkedQueue = new ConcurrentLinkedQueue<Request>();
        int n3 = 0;
        Iterator iterator = this.mRequestMap.keySet().iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            Request request = this.mRequestMap.get(n2);
            if (request == null) continue;
            if (this.isFastCheckPing(request)) {
                bl3 = true;
                if (request.isTimeout()) {
                    if (this.mLastReceivedPacketTime < request.getCreatedTime()) {
                        bl4 = true;
                        MiLinkLog.e(this.mLogTag, "mLastReceivedPacketTime = " + this.mLastReceivedPacketTime + ",createTime = " + request.getCreatedTime() + ", fastping is timeout");
                    } else {
                        MiLinkLog.e(this.mLogTag, "mLastReceivedPacketTime = " + this.mLastReceivedPacketTime + ",createTime = " + request.getCreatedTime() + ", fastping timeout,but can recv msg");
                    }
                }
            }
            if (!request.isTimeout()) continue;
            ++n3;
            this.mRequestMap.remove(n2);
            concurrentLinkedQueue.add(request);
            if ("milink.heartbeat" != request.getData().getCommand()) continue;
            HeartBeatManager.getInstance().reciveTimeoutHeartBeat(request.getData().getSeqNo());
        }
        boolean bl5 = false;
        n2 = 0;
        long l2 = SystemClock.elapsedRealtime();
        for (Request request : concurrentLinkedQueue) {
            MiLinkLog.e(this.mLogTag, "Request read time out, seq=" + request.getSeqNo() + ",cmd=" + request.getData().getCommand());
            if (request.getTimeOut() >= 10000) {
                bl5 = true;
            }
            if (l2 - request.getSentTime() > 40000L) {
                n2 = 1;
                MiLinkLog.e(this.mLogTag, "hasLongLongTimeoutRequest=true");
            }
            request.onDataSendFailed(515, "request time out");
            this.mPendingStatisticTimeoutedRequestMap.put(request.getSeqNo(), request);
        }
        concurrentLinkedQueue.clear();
        if (bl5) {
            MiLinkLog.e(this.mLogTag, Device.Network.getCurrentNetworkDetailInfo().toString());
        }
        boolean bl6 = bl2 = SystemClock.elapsedRealtime() - this.mLastReceivedPacketTime > 300000L;
        if (bl4 || n2 || bl2 || n3 > 2) {
            MiLinkLog.e(this.mLogTag, "checkIsReadTimeOut,isFastCheckPingTimeout=" + bl4 + " hasLongLongTimeoutRequest=" + (n2 != 0) + " isFastCheckPingTimeout || hasLongLongTimeoutRequest || isBadConnect=" + bl2 + " timeoutNum=" + n3);
            this.disConnect(515);
            return;
        }
        if (!bl3 && bl5) {
            this.fastCheckPing();
        }
    }

    private boolean isJustSentFastCheckPing() {
        return SystemClock.elapsedRealtime() - this.mLastSendFastCheckPingTime <= 10000L;
    }

    public void postStatisticsTimeoutPacketAction() {
        this.postMessage(5, null, 0);
    }

    private void handlePendingStatisticTimeoutedRequestMap() {
        long l2 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<Integer, Request>> iterator = this.mPendingStatisticTimeoutedRequestMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Request request = iterator.next().getValue();
            MiLinkLog.v(this.mLogTag, "handleTimeoutedRequest seq=" + request.getSeqNo());
            if (!this.isJustSentFastCheckPing()) break;
            if (this.mLastSendFastCheckPingTime > this.mLastReceivedFastPingTime) {
                if (request.getSentTime() >= this.mLastSendFastCheckPingTime) continue;
                MiLinkLog.e(this.mLogTag, "seq=" + request.getSeqNo() + " timeouted, ping also timeout,Reported 3");
                string2 = request.getData() == null ? "milink.ping" : request.getData().getCommand();
                InternalDataMonitor.getInstance(this.appId).trace(this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerIP() : "", this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerPort() : 0, string2, 3, request.getSentTime(), l2, request.getSize(), 0, request.getSeqNo());
                iterator.remove();
                continue;
            }
            MiLinkLog.e(this.mLogTag, "seq=" + request.getSeqNo() + " timeouted, ping not timeout,Reported 1");
            string2 = request.getData() == null ? "milink.ping" : request.getData().getCommand();
            InternalDataMonitor.getInstance(this.appId).trace(this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerIP() : "", this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerPort() : 0, string2, 1, request.getSentTime(), l2, request.getSize(), 0, request.getSeqNo());
            iterator.remove();
        }
    }

    public void onAccNeedRetryWithClientInfo(Request request) {
        MiLinkLog.w(this.TAG, "onAccNeedRetryWithClientInfo");
        this.mNeedClientInfo = true;
        if (request.getRetryCount() <= 0) {
            request.addRetryCount();
            this.handleRequest(request);
            return;
        }
        MiLinkLog.w(this.TAG, "try 118 too many times");
    }

    public void addContinuousRecv110Count() {
        ++this.mContinuousRecv110Count;
    }

    public void resetContinuousRecv110Count() {
        this.mContinuousRecv110Count = 0;
    }

    public boolean checkExceedMaxContinuousRecv110Count() {
        MiLinkLog.v(this.mLogTag, "mContinuousRecv110Count = " + this.mContinuousRecv110Count);
        if (this.mContinuousRecv110Count >= 3) {
            if (this.mSessionType == 0) {
                EventBus.getDefault().post(new MiLinkEvent.ServerNotificationEvent(MiLinkEvent.ServerNotificationEvent.EventType.ServerLineBroken));
            }
            return false;
        }
        return true;
    }

    public String getClientIp() {
        return this.mClientIp;
    }

    public String getClientIsp() {
        return this.mClientIsp;
    }

    public boolean isDeadConnection(long l2, long l3) {
        return SystemClock.elapsedRealtime() - this.mLastReceivedPacketTime > l3;
    }

    protected void clear() {
        MiLinkLog.e(this.getClass().getName(), "\u6267\u884csession\u7ebf\u7a0b\u6e05\u7406, \u6c92\u6709\u4ec0\u9ebd\u8981\u6e05\u7406\u7684?[NO" + this.mSessionNO + "]");
        if (this.mRecBuffer != null) {
            this.mRecBuffer.clear();
        }
    }

    public void startBackReceiveThread() {
        if (this.mRecBuffer != null) {
            this.mRecBuffer.startBufferThread();
        }
    }

    static class B {
        public boolean b = false;

        B() {
        }
    }
}

