/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.os.SystemClock;
import android.text.TextUtils;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.connection.DomainManager;
import com.mi.milink.sdk.connection.IConnection;
import com.mi.milink.sdk.connection.IConnectionCallback;
import com.mi.milink.sdk.connection.TcpConnection;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.TrafficMonitor;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.session.common.InvalidPacketExecption;
import com.mi.milink.sdk.session.common.MsgProcessor;
import com.mi.milink.sdk.session.common.ReceiveBuffer;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.StreamUtil;
import com.mi.milink.sdk.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SessionForUploadLog
implements IConnectionCallback,
MsgProcessor {
    private static final String TAG = "SessionForUploadLog";
    private static final int MSG_CONNECT = 1;
    private static final int MSG_HANDLE_REQUEST = 2;
    private static final int MSG_DISCONNECT = 4;
    private int mCurState = 0;
    private static final int NO_CONNECT_STATE = 0;
    private static final int CONNECTING_STATE = 1;
    private static final int CONNECTED_STATE = 2;
    private IConnection mConn = null;
    private ServerProfile mServerProfile = null;
    public int mFlagForSessionManager;
    private boolean mCanClose = true;
    private PushPacketProto.MilinkLogReq mLogReq = null;
    private IAccount mIAccount;
    UploadLogListener mUploadLogListener;
    protected ReceiveBuffer mRecBuffer;
    Request request;
    private ReceiveBuffer.ReceiveBufferSink mRecBufSink = new ReceiveBuffer.ReceiveBufferSink(){

        @Override
        public boolean onRecvDownStream(int n2, byte[] byArray) {
            MiLinkLog.e("MiLinkReceive", "sessionForUpLoadLog\u6536\u5230\u56de\u8c03\u7684\u6570\u636e\uff1a  ".concat(String.valueOf(n2)));
            if (byArray == null) {
                return false;
            }
            PacketData packetData = null;
            try {
                packetData = StreamUtil.getDownPacket(String.format("[No:%d]", n2), byArray, new StreamUtil.GetAccountAdapter(){

                    @Override
                    public IAccount getAccount(int n2) {
                        return SessionForUploadLog.this.mIAccount;
                    }
                });
            }
            catch (IOException iOException) {
                MiLinkLog.e(SessionForUploadLog.TAG, "decode downstream failed", iOException);
            }
            if (packetData == null) {
                return false;
            }
            System.currentTimeMillis();
            if (SessionForUploadLog.this.request != null && packetData != null) {
                SessionForUploadLog.this.request.onDataSendSuccess(0, packetData);
                SessionForUploadLog.this.request.addRetryCount();
            }
            return true;
        }

        @Override
        public boolean onAddTimeout(int n2, int n3) {
            return false;
        }
    };

    public SessionForUploadLog(PushPacketProto.MilinkLogReq milinkLogReq, IAccount iAccount, UploadLogListener uploadLogListener) {
        this.mLogReq = milinkLogReq;
        if (this.mLogReq == null) {
            this.mLogReq = PushPacketProto.MilinkLogReq.newBuilder().setIp("58.83.160.103:80").setTime(-1).build();
        }
        this.mIAccount = iAccount;
        this.mUploadLogListener = uploadLogListener;
        this.mRecBuffer = new ReceiveBuffer(this.mRecBufSink, 0, true);
    }

    public boolean openSession() {
        if (this.mLogReq == null) {
            MiLinkLog.v(TAG, "mLogReq is null");
            return false;
        }
        Object object = this.mLogReq.getIp();
        MiLinkLog.v(TAG, "ipAndPortStr".concat(String.valueOf(object)));
        String[] stringArray = null;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            stringArray = ((String)object).split(":");
        }
        if (stringArray == null || stringArray.length != 2) {
            return false;
        }
        try {
            object = new ServerProfile(stringArray[0], Integer.parseInt(stringArray[1]), 1, 4);
        }
        catch (Exception exception) {
            object = null;
        }
        if (object == null || ((ServerProfile)object).getProtocol() == 0) {
            MiLinkLog.v(TAG, "openSession fail, serverprofile=".concat(String.valueOf(object)));
            this.onOpenSessionBuildConnectFail(557);
            return false;
        }
        this.mCurState = 1;
        boolean bl2 = false;
        if (this.mServerProfile == null || this.mServerProfile.getProtocol() != ((ServerProfile)object).getProtocol()) {
            MiLinkLog.v(TAG, "openSession if");
            if (this.mConn != null) {
                this.mConn.stop();
            }
            if (((ServerProfile)object).getProtocol() == 1) {
                this.mConn = new TcpConnection(0, this);
            }
            this.mServerProfile = object;
            try {
                bl2 = this.mConn.start();
            }
            catch (Exception exception) {
                MiLinkLog.e(TAG, "connection start failed", exception);
            }
            if (!bl2) {
                this.onOpenSessionBuildConnectFail(562);
                return false;
            }
        } else {
            MiLinkLog.v(TAG, "openSession else");
            if (this.mConn == null && ((ServerProfile)object).getProtocol() == 1) {
                this.mConn = new TcpConnection(0, this);
            }
            if (!this.mConn.isRunning()) {
                this.mServerProfile = object;
                try {
                    bl2 = this.mConn.start();
                }
                catch (Exception exception) {
                    MiLinkLog.e(TAG, "connection start failed", exception);
                }
                if (!bl2) {
                    this.onOpenSessionBuildConnectFail(562);
                    return false;
                }
            }
        }
        this.mServerProfile = object;
        this.postMessage(1, null, 0);
        return true;
    }

    public ServerProfile getServerProfile() {
        return this.mServerProfile;
    }

    public boolean isConnected() {
        switch (this.mCurState) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean postMessage(int n2, Object object, int n3) {
        boolean bl2;
        if (this.mConn == null) {
            MiLinkLog.e(TAG, "postMessage " + n2 + " mConn == null!!!!");
            return false;
        }
        try {
            bl2 = this.mConn.postMessage(n2, object, n3, this);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!bl2) {
            MiLinkLog.e(TAG, "mMessage must be full ! uMsg = ".concat(String.valueOf(n2)));
            return bl2;
        }
        return bl2;
    }

    public boolean close() {
        if (!this.mCanClose) {
            MiLinkLog.i(TAG, "connecting! can not close");
            return false;
        }
        if (this.mConn != null) {
            MiLinkLog.w(TAG, "stop begin");
            this.mConn.stop();
            this.mConn = null;
            this.mServerProfile = null;
            this.mCurState = 0;
            MiLinkLog.w(TAG, "stop over");
        }
        return true;
    }

    public void disConnect() {
        this.disConnect(-1);
    }

    public void disConnect(int n2) {
        MiLinkLog.i(TAG, "disConnect, errorCallBackErrorCode=".concat(String.valueOf(n2)));
        this.postMessage(4, null, n2);
    }

    @Override
    public void onMsgProc(int n2, Object object, int n3) {
        MiLinkLog.v(TAG, "onMsgProc, uMsg=" + n2 + ", wParam=" + n3);
        switch (n2) {
            case 1: {
                String string2;
                if (!CommonUtils.isLegalIp(this.mServerProfile.getServerIP())) {
                    string2 = DomainManager.getInstance().getDomainIP(this.mServerProfile.getServerIP());
                    if (string2 == null) {
                        this.onOpenSessionBuildConnectFail(1);
                        return;
                    }
                    this.mServerProfile.setServerIP(string2);
                } else {
                    string2 = this.mServerProfile.getServerIP();
                }
                MiLinkLog.e(TAG, "connect to " + this.mServerProfile);
                if (this.mConn != null) {
                    this.mCanClose = false;
                    this.mConn.connect(string2, this.mServerProfile.getServerPort(), this.mServerProfile.getProxyIP(), this.mServerProfile.getPorxyPort(), ConfigManager.getInstance().getConnetionTimeout(), 0);
                }
                return;
            }
            case 2: {
                Request request = (Request)object;
                if (request == null) {
                    return;
                }
                if (!request.isValidNow()) {
                    MiLinkLog.e(TAG, String.format("seq=%d,cmd=%s is invalid", request.getSeqNo(), request.getData().getCommand()));
                    request.onDataSendFailed(998, "package is already over the valid time");
                    return;
                }
                request.setSentTime(SystemClock.elapsedRealtime());
                object = request.getData().getCommand();
                byte[] byArray = request.toBytes();
                if (byArray != null) {
                    MiLinkLog.v(TAG, "connection send data, seq=" + request.getSeqNo());
                    if (this.mConn.sendData(byArray, request.getSeqNo(), request.getTimeOut())) {
                        TrafficMonitor.getInstance().traffic((String)object, byArray.length);
                        return;
                    }
                } else {
                    request.onDataSendFailed(518, "data encryption failed");
                    MiLinkLog.w(TAG, "connection send data, but data = null");
                    if (this.mUploadLogListener != null) {
                        this.mUploadLogListener.failed();
                    }
                }
                return;
            }
            case 4: {
                if (this.mConn != null) {
                    this.mConn.disconnect();
                }
                this.mCurState = 0;
                if (n3 <= 0) break;
                this.onSessionError(n3);
                return;
            }
            default: {
                MiLinkLog.e(TAG, "OnMsgProc unknow uMsgID = ".concat(String.valueOf(n2)));
            }
        }
    }

    public void uploadLog() {
        PacketData packetData = new PacketData();
        packetData.setSeqNo(Global.getSequence());
        packetData.setHasClientInfo(false);
        packetData.setCommand("milink.uploadlog");
        File file = UploadLogUtils.createTemp(UploadLogUtils.getLogFile(this.mLogReq.getTime()));
        byte[] byArray = UploadLogUtils.getFileBytes(file);
        if (byArray == null) {
            this.close();
            if (this.mUploadLogListener != null) {
                this.mUploadLogListener.failed();
            }
            return;
        }
        packetData.setData(byArray);
        this.request = new Request(packetData, new ResponseListener(){

            @Override
            public void onDataSendSuccess(int n2, PacketData packetData) {
                if (SessionForUploadLog.this.mUploadLogListener != null) {
                    SessionForUploadLog.this.mUploadLogListener.success();
                }
            }

            @Override
            public void onDataSendFailed(int n2, String string2) {
                if (SessionForUploadLog.this.mUploadLogListener != null) {
                    SessionForUploadLog.this.mUploadLogListener.failed();
                }
            }
        }, 5, this.mIAccount);
        this.postMessage(2, this.request, 0);
        if (this.mConn != null) {
            this.mConn.wakeUp();
        }
        file.delete();
        System.gc();
    }

    @Override
    public boolean onStart() {
        return false;
    }

    @Override
    public boolean onConnect(boolean bl2, int n2) {
        this.mCanClose = true;
        if (bl2) {
            this.onOpenSessionBuildConnectSuccess();
        } else {
            this.onOpenSessionBuildConnectFail(n2);
        }
        return true;
    }

    @Override
    public boolean onDisconnect() {
        MiLinkLog.i(TAG, "OnDisconnect");
        this.mRecBuffer.reset();
        return true;
    }

    @Override
    public boolean onError(int n2) {
        MiLinkLog.e(TAG, "onError socketStatus " + n2 + ", mCurState=" + this.mCurState);
        switch (this.mCurState) {
            case 0: 
            case 1: 
            case 2: {
                this.onOpenSessionBuildConnectFail(1);
                break;
            }
            default: {
                MiLinkLog.e(TAG, "onError wrong state = " + this.mCurState);
            }
        }
        return true;
    }

    @Override
    public boolean onTimeOut(int n2, int n3) {
        MiLinkLog.v(TAG, "send time out: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onRecv(byte[] byArray) {
        MiLinkLog.w(TAG, "recv data:" + byArray.length);
        if (this.mRecBuffer != null) {
            try {
                this.mRecBuffer.append(byArray);
            }
            catch (InvalidPacketExecption invalidPacketExecption) {
                this.disConnect(517);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onSendBegin(int n2) {
        MiLinkLog.v(TAG, "send begin: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onSendEnd(int n2) {
        MiLinkLog.v(TAG, "send end: seq=".concat(String.valueOf(n2)));
        return false;
    }

    private void onOpenSessionBuildConnectFail(int n2) {
        this.mCurState = 0;
    }

    private void onOpenSessionBuildConnectSuccess() {
        this.mCurState = 2;
        this.uploadLog();
    }

    private void onSessionError(int n2) {
        this.mCurState = 0;
    }

    static class UploadLogUtils {
        public static final int ALL = -1;
        public static final int TODAY = 0;
        public static final int YESTODAY = 1;
        public static final int BEFORE_YEST = 2;

        UploadLogUtils() {
        }

        private static void getFileRecursion(File fileArray, List<File> list) {
            if (!fileArray.isDirectory()) {
                if (fileArray.getName().endsWith(".log")) {
                    list.add((File)fileArray);
                }
                return;
            }
            fileArray = fileArray.listFiles();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                UploadLogUtils.getFileRecursion(fileArray[i2], list);
            }
        }

        public static File[] getLogFile(int n2) {
            Object object = Global.getClientAppInfo().getLogPath();
            MiLinkLog.v(SessionForUploadLog.TAG, "dir:".concat(String.valueOf(object)));
            object = new File((String)object);
            if (((File)object).exists() && ((File)object).isDirectory()) {
                long l2 = System.currentTimeMillis();
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        l2 -= 86400000L;
                        break;
                    }
                    case 2: {
                        l2 -= 172800000L;
                        break;
                    }
                    default: {
                        Object object2 = new LinkedList<File>();
                        UploadLogUtils.getFileRecursion((File)object, object2);
                        File[] fileArray = new File[object2.size()];
                        int n3 = 0;
                        object2 = object2.iterator();
                        while (object2.hasNext()) {
                            File file = (File)object2.next();
                            fileArray[n3++] = file;
                        }
                        return fileArray;
                    }
                }
                String string2 = CommonUtils.createDataFormat("yyyy-MM-dd").format(new Date(l2));
                object = new File((File)object, string2);
                if (((File)object).exists() && ((File)object).isDirectory()) {
                    return ((File)object).listFiles(new FilenameFilter(){

                        @Override
                        public final boolean accept(File file, String string2) {
                            return string2.endsWith(".log");
                        }
                    });
                }
            }
            return null;
        }

        public static File createTemp(File[] fileArray) {
            File file = null;
            try {
                file = new File(Global.getClientAppInfo().getLogPath(), "temp.zip");
                Closeable closeable = new FileOutputStream(file);
                ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)closeable));
                byte[] byArray = new byte[1024];
                int n2 = 0;
                int n3 = 0xA00000;
                if (NetworkDash.isWifi()) {
                    n3 = 0x5000000;
                }
                for (int i2 = fileArray.length - 1; i2 >= 0 && n2 < n3; --i2) {
                    closeable = new FileInputStream(fileArray[i2]);
                    closeable = new BufferedInputStream((InputStream)closeable, 1024);
                    Object object = fileArray[i2].getAbsolutePath();
                    int n4 = 0;
                    int n5 = 0;
                    for (int i3 = ((String)object).length() - 1; i3 >= 0; --i3) {
                        if (((String)object).charAt(i3) != '/' || ++n4 != 3) continue;
                        n5 = i3;
                        break;
                    }
                    String string2 = ((String)object).substring(n5 + 1, ((String)object).length());
                    System.out.println(string2);
                    object = new ZipEntry(string2);
                    zipOutputStream.putNextEntry((ZipEntry)object);
                    int n6 = 0;
                    while ((n4 = ((BufferedInputStream)closeable).read(byArray, 0, 1024)) != -1) {
                        zipOutputStream.write(byArray, 0, n4);
                        n2 += n4;
                        n6 += n4;
                    }
                    System.out.println("sigleFileSize:".concat(String.valueOf(n6)));
                    ((BufferedInputStream)closeable).close();
                }
                System.out.println("fileTotalSize:".concat(String.valueOf(n2)));
                zipOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.gc();
            return file;
        }

        static byte[] getFileBytes(File object) {
            byte[] byArray = null;
            int n2 = 0;
            try {
                int n3;
                object = new BufferedInputStream(new FileInputStream((File)object));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512000);
                byte[] byArray2 = new byte[10240];
                while ((n3 = ((FilterInputStream)object).read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                    n2 += n3;
                }
                ((BufferedInputStream)object).close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            MiLinkLog.d(SessionForUploadLog.TAG, "compress file len=".concat(String.valueOf(n2)));
            return byArray;
        }
    }

    public static interface UploadLogListener {
        public void success();

        public void failed();
    }
}

