/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.persistent;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.text.TextUtils;
import com.mi.milink.sdk.account.AnonymousAccount;
import com.mi.milink.sdk.account.manager.MiAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.CustomHandlerThread;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.Device;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.WifiDash;
import com.mi.milink.sdk.base.os.timer.AlarmClockService;
import com.mi.milink.sdk.config.HeartBeatManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManager;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.TrafficMonitor;
import com.mi.milink.sdk.event.MiLinkEvent;
import com.mi.milink.sdk.proto.DataExtraProto;
import com.mi.milink.sdk.proto.PushPacketProto;
import com.mi.milink.sdk.proto.SystemPacketProto;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.OpenSessionSucessReturnInfo;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.SessionConst;
import com.mi.milink.sdk.session.common.ThreadHelper;
import com.mi.milink.sdk.session.persistent.ManualServerManager;
import com.mi.milink.sdk.session.persistent.MiLinkBackupServerManager;
import com.mi.milink.sdk.session.persistent.MiLinkServerManager;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.persistent.UploadLogManager;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class SessionManager
extends CustomHandlerThread {
    public static final int MILINK_OPEN_RET_CODE_OK = 0;
    public static final int MILINK_OPEN_RET_CODE_FAIL = 1;
    public static final int MILINK_OPEN_RET_CODE_NO_ROUTE = 2;
    public static final int MILINK_OPEN_RET_CODE_REFUSED = 3;
    public static final int MILINK_OPEN_RET_CODE_NETWORK_CHANGE = 4;
    public static final int MILINK_OPEN_RET_CODE_NET_UNREACHABLE = 5;
    public static final int MILINK_OPEN_RET_CODE_ALL_TIME_OUT = 6;
    public static final int MILINK_OPEN_RET_CODE_MULTI_UNAVAILABLE = 7;
    public static final int MILINK_OPEN_RET_CODE_PERMISSION_DENIED = 8;
    public static final int MILINK_OPEN_RET_CODE_LOAD_SO_FAILED = 9;
    private static final String TAG = "SessionManager";
    private static final int MEDIUM_CONNECTION_CLOSE_INTERNAL = 600000;
    private static final int MSG_TYPE_SESSION_EVENT = 1;
    private static final int MSG_TYPE_SESSION_LOGIN_EVENT = 2;
    private static final int MSG_TYPE_SESSION_OTHER_EVENT = 3;
    private static final int MSG_TYPE_SERVER_NOTIFICATON_EVENT = 4;
    private static final int MSG_TYPE_CLIENT_ACTION_EVENT = 5;
    private static final int MSG_TYPE_SYSTEM_NOTIFICATION_EVENT = 6;
    private static final int MSG_CHECK_SESSION_TIMER = 20;
    private static final int MSG_TYPE_RELEASE_WAKE_LOCK = 22;
    private static final int MSG_TYPE_GET_SERVICE_TOKEN = 23;
    private static final int MSG_TYPE_LOGIN_RETRY = 24;
    private static final int MSG_TYPE_SEND_MSG = 25;
    private static final int MSG_TYPE_APP_NOT_INIT = 26;
    private static final int NO_SESSION_STATE = 0;
    private static final int TRING_SESSION_STATE = 1;
    private static final int SINGLE_SESSION_STATE = 2;
    private static final int NOLOGIN_SESSION_STATE = 0;
    private static final int LOGINED_SESSION_STATE = 2;
    private static final int ERRNO_PERMISSION_DENIED = 13;
    private static final int ERRNO_NET_UNREACHABLE = 101;
    private static final int ERRNO_CONNECT_TIME_OUT = 110;
    private static final int ERRNO_REFUSED = 111;
    private static final int ERRNO_NO_ROUTE = 113;
    private static final int OPEN_SESSION_TRY_TIMES = 5;
    private static final int LOGIN_TRY_TIMES = 5;
    private static final int SESSION_RECONNECT_TIMES = 2;
    private static final int CHECK_SESSION_INTERVAL = 3000;
    private static final int CHECK_WAKE_LOCK_TIMEOUT = 5;
    private static final int AUTO_INTERNAL_OPEN_DELAY = 3000;
    private static final int FLAG_TRTING_SESSION = 1;
    private static final int FLAG_ABANDON_SESSION = 3;
    private static final int FLAG_MASTER_SESSION = 4;
    private static SessionManager sInstance;
    private final ConcurrentLinkedQueue<Request> mSendQueue = new ConcurrentLinkedQueue();
    private final List<Session> mSessionList = Collections.synchronizedList(new ArrayList());
    private final HashMap<String, Integer> mSessionAddress2ErrorCodeMap = new HashMap();
    long mLastUploadTime = 0L;
    long mLastUserSendDataTime = System.currentTimeMillis();
    boolean mGlobalPushFlag = false;
    private boolean mCheckTimeOutTimerOpen = false;
    private Session mMasterSession;
    private Session mAssistSession;
    private boolean mAllowAssitSessionWork = false;
    Runnable channelIdleReset = new Runnable(){

        @Override
        public void run() {
            SessionManager.this.mAllowAssitSessionWork = false;
        }
    };
    private IServerManager mServerManager = null;
    private PowerManager.WakeLock mWakeLock = null;
    private NetworkChangeReceiver mNetworkReveiver = null;
    private ScreenOnChangeReceiver mScreenOnReveiver = null;
    private Device.Network.NetworkDetailInfo mNetworkDetailInfoOnOpen;
    private Object mLock = null;
    private boolean mEnableConnectionManualMode = false;
    private int mState = 0;
    private int mLoginState = 0;
    private int mAssistSessionState = 0;
    private int mOpenSessionTryTimes = 0;
    private int mSessionReconnectTryTimes = 0;
    private int mLoginTryTimes = 0;
    private boolean mAppInited = false;
    private long mOpenStartTime = 0L;
    private Runnable mTryStopTimerRunnable = new Runnable(){

        @Override
        public void run() {
            if (!SessionManager.this.mCheckTimeOutTimerOpen) {
                return;
            }
            boolean bl2 = true;
            if (SessionManager.this.mMasterSession != null && SessionManager.this.mMasterSession.shouldCheckRequestsTimeout()) {
                bl2 = false;
            }
            if (bl2 && SessionManager.this.mAllowAssitSessionWork && SessionManager.this.mAssistSession != null && SessionManager.this.mAssistSession.shouldCheckRequestsTimeout()) {
                bl2 = false;
            }
            if (bl2) {
                for (Session session : SessionManager.this.mSessionList) {
                    int n2 = session.mFlagForSessionManager;
                    if (n2 != 1 && n2 != 4 || !session.shouldCheckRequestsTimeout()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                MiLinkLog.v(SessionManager.TAG, "all session request map is empty, stopTimer");
                SessionManager.this.stopTimer();
            }
        }
    };
    private long mConnectionBuildTimestamp = 0L;
    private Runnable mInternalAutoOpenRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkLog.v(SessionManager.TAG, "internalAutoOpen mOpenSessionTryTimes=" + SessionManager.this.mOpenSessionTryTimes + ",mState=" + SessionManager.this.mState);
            if (SessionManager.this.mOpenSessionTryTimes < 5 && SessionManager.this.mState == 0) {
                SessionManager.this.mOpenSessionTryTimes++;
                SessionManager.this.internalOpen();
            }
        }
    };
    private Object mReportLock = new Object();
    private Runnable mLogoffRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkLog.v(SessionManager.TAG, "milink mLogoffRunnable run");
            if (!MiAccountManager.getInstance().isAllowAnonymousMode() || MiAccountManager.getInstance().isAnonymousModeCurrent()) {
                SessionManager.this.internalClose();
            }
            MiAccountManager.getInstance().logoff();
            SessionManager.this.resetAllTryTimes();
            SessionManager.this.mSendQueue.clear();
        }
    };

    private SessionManager() {
        super(TAG);
        MiLinkLog.e(TAG, "SessionManager created, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        EventBus.getDefault().register(this);
        TrafficMonitor.getInstance().start();
        this.mServerManager = MiLinkServerManager.getInstance();
        this.setState(0);
        this.mLock = new Object();
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(SessionManager.TAG, "thread-pool: SessionManager start");
                ((MiLinkServerManager)SessionManager.this.mServerManager).preLoad();
                SessionManager.this.mNetworkReveiver = new NetworkChangeReceiver();
                SessionManager.this.mScreenOnReveiver = new ScreenOnChangeReceiver();
                SessionManager.this.mNetworkReveiver.setCurrentNetworkInfo();
                Global.registerReceiver(SessionManager.this.mNetworkReveiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_ON");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                Global.registerReceiver(SessionManager.this.mScreenOnReveiver, intentFilter);
                MiLinkIpInfoManager.getInstance().getDefaultHost();
                MiLinkLog.i(SessionManager.TAG, "thread-pool: SessionManager end");
            }
        });
        MiLinkLog.w(TAG, "SessionManager created finish");
    }

    private void setState(int n2) {
        switch (n2) {
            case 0: {
                Iterator<Session> iterator = this.mSessionList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().mFlagForSessionManager = 3;
                }
                this.closeAllBandonSession();
                if (this.mMasterSession != null) {
                    this.mMasterSession.mFlagForSessionManager = 3;
                    this.mMasterSession.close();
                    this.mMasterSession = null;
                }
                this.mLoginState = 0;
                MiAccountManager.getInstance().setIsLogining(false);
                break;
            }
            case 2: {
                this.closeAllBandonSession();
                this.mConnectionBuildTimestamp = System.currentTimeMillis();
            }
        }
        MiLinkLog.i(TAG, "setState mState = " + this.mState + ",newState = " + n2);
        MiLinkLog.v(TAG, "mSessionList.size=" + this.mSessionList.size());
        int n3 = this.mState;
        this.mState = n2;
        if (this.mState != n3) {
            EventBus.getDefault().post(new MiLinkEvent.SessionManagerStateChangeEvent(MiLinkEvent.SessionManagerStateChangeEvent.EventType.SessionStateChange, n3, this.mState));
        }
    }

    private void closeAllBandonSession() {
        ArrayList<Session> arrayList = new ArrayList<Session>();
        for (Session session : this.mSessionList) {
            if (session.mFlagForSessionManager != 3 || !session.close()) continue;
            arrayList.add(session);
        }
        for (Session session : arrayList) {
            this.mSessionList.remove(session);
        }
    }

    public static synchronized SessionManager getInstance() {
        if (sInstance == null) {
            sInstance = new SessionManager();
        }
        return sInstance;
    }

    public void initApp() {
        this.mAppInited = true;
        this.mHandler.removeCallbacks(this.mLogoffRunnable);
        this.resetAllTryTimes();
    }

    private void resetAllTryTimes() {
        this.mOpenSessionTryTimes = 0;
        this.mSessionReconnectTryTimes = 0;
        this.mLoginTryTimes = 0;
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionConnectEvent sessionConnectEvent) {
        sessionConnectEvent = this.mHandler.obtainMessage(1, (Object)sessionConnectEvent);
        this.mHandler.sendMessage((Message)sessionConnectEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionLoginEvent sessionLoginEvent) {
        sessionLoginEvent = this.mHandler.obtainMessage(2, (Object)sessionLoginEvent);
        this.mHandler.sendMessage((Message)sessionLoginEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SessionOtherEvent sessionOtherEvent) {
        sessionOtherEvent = this.mHandler.obtainMessage(3, (Object)sessionOtherEvent);
        this.mHandler.sendMessage((Message)sessionOtherEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.ServerNotificationEvent serverNotificationEvent) {
        serverNotificationEvent = this.mHandler.obtainMessage(4, (Object)serverNotificationEvent);
        this.mHandler.sendMessage((Message)serverNotificationEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.ClientActionEvent clientActionEvent) {
        clientActionEvent = this.mHandler.obtainMessage(5, (Object)clientActionEvent);
        this.mHandler.sendMessage((Message)clientActionEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.SystemNotificationEvent systemNotificationEvent) {
        systemNotificationEvent = this.mHandler.obtainMessage(6, (Object)systemNotificationEvent);
        this.mHandler.sendMessage((Message)systemNotificationEvent);
    }

    @Subscribe
    public void onEvent(MiLinkEvent.ChannelStatusChangeEvent channelStatusChangeEvent) {
        switch (channelStatusChangeEvent.mEventType) {
            case channelBusy: {
                this.mAllowAssitSessionWork = true;
                this.mHandler.removeCallbacks(this.channelIdleReset);
                this.mHandler.postDelayed(this.channelIdleReset, 30000L);
                return;
            }
            case channelIdle: {
                if (!this.mAllowAssitSessionWork) break;
                MiLinkLog.w(TAG, "mode change,mAllowAssitSessionWork==false");
                this.mAllowAssitSessionWork = false;
                this.mHandler.removeCallbacks(this.channelIdleReset);
            }
        }
    }

    public int getSessionState() {
        return this.mState;
    }

    public boolean isTimerOpen() {
        return this.mCheckTimeOutTimerOpen;
    }

    public void onOpenSessionResult(int n2, final long l2) {
        MiLinkLog.w(TAG, "onOpenSessionResult, errorCode = ".concat(String.valueOf(n2)));
        if (n2 != 0) {
            this.stopTimer();
            if (this.isMultiUnavailable()) {
                MiLinkLog.w(TAG, "statistic milink.open, code=7");
                InternalDataMonitor.getInstance().trace("", 0, "milink.open", 7, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                return;
            }
            int[] nArray = new int[]{13, 110, 113, 111, 101, 562};
            int[] nArray2 = new int[]{8, 6, 2, 3, 5, 9};
            for (int i2 = 0; i2 < 6 && i2 < 6; ++i2) {
                if (!this.isAllSessionErrorCode(nArray[i2])) continue;
                MiLinkLog.w(TAG, "statistic milink.open, code=" + nArray2[i2]);
                InternalDataMonitor.getInstance().trace("", 0, "milink.open", nArray2[i2], l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                return;
            }
            if (NetworkDash.isAvailable()) {
                ThreadHelper.NETWORK.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MiLinkLog.i(SessionManager.TAG, "thread-pool: onOpenSessionResult start");
                        long l22 = System.currentTimeMillis();
                        MiLinkLog.w(SessionManager.TAG, "check isInternetAvailable begin ,id=" + l22 + ", mInfoOnOpen=" + SessionManager.this.mNetworkDetailInfoOnOpen);
                        if (SessionConst.isInternetAvailable()) {
                            int n2;
                            Object object = Device.Network.getCurrentNetworkDetailInfo();
                            MiLinkLog.v(SessionManager.TAG, "NetworkDetailInfo current=" + object + ",id=" + l22);
                            if (((Device.Network.NetworkDetailInfo)object).equals(SessionManager.this.mNetworkDetailInfoOnOpen)) {
                                MiLinkLog.v(SessionManager.TAG, "at most wait 15s\uff0cid=".concat(String.valueOf(l22)));
                                object = SessionManager.this.mReportLock;
                                synchronized (object) {
                                    try {
                                        SessionManager.this.mReportLock.wait(15000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                n2 = SessionManager.this.mMasterSession == null ? 1 : 4;
                            } else {
                                n2 = 4;
                            }
                            MiLinkLog.w(SessionManager.TAG, "statistic milink.open, code=" + n2 + ",id=" + l22);
                            InternalDataMonitor.getInstance().trace("", 0, "milink.open", n2, l2, System.currentTimeMillis(), 0, 0, 0);
                        }
                        MiLinkLog.w(SessionManager.TAG, "check isInternetAvailable end, id=".concat(String.valueOf(l22)));
                        MiLinkLog.i(SessionManager.TAG, "thread-pool: onOpenSessionResult start");
                    }
                });
            } else {
                MiLinkLog.w(TAG, "check isInternetAvailable, but network is unavailable");
            }
            if (NetworkDash.isAvailable()) {
                this.mHandler.removeCallbacks(this.mInternalAutoOpenRunnable);
                this.mHandler.postAtTime(this.mInternalAutoOpenRunnable, 3000L);
                MiLinkLog.v(TAG, "onOpenSessionResult reconnect times:" + this.mOpenSessionTryTimes);
            }
            return;
        }
        if (this.mMasterSession != null) {
            MiLinkLog.w(TAG, String.format("mMasterSession = [Session No:%d] ", this.mMasterSession.getSessionNO()));
            InternalDataMonitor.getInstance().trace(this.mMasterSession.getServerProfile().getServerIP(), this.mMasterSession.getServerProfile().getServerPort(), "milink.open", 0, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
        }
    }

    public boolean sendData(PacketData packetData, int n2, ResponseListener responseListener) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)packetData.getCommand())) {
            MiLinkLog.v(TAG, "send data ,cmd can not be null");
            return false;
        }
        if (!MiAccountManager.getInstance().appHasLogined()) {
            MiLinkLog.v(TAG, "send data ,appHasLogined=false,request get st");
            object = this.mHandler.obtainMessage(23);
            this.mHandler.sendMessageAtFrontOfQueue(object);
        }
        this.mLastUserSendDataTime = System.currentTimeMillis();
        packetData.setSeqNo(Global.getSequence());
        MiLinkLog.v(TAG, "send data cmd=" + packetData.getCommand() + ", seq=" + packetData.getSeqNo());
        object = new Request(packetData, responseListener, MiAccountManager.getInstance().getBusinessEncByMode(), MiAccountManager.getInstance().getCurrentAccount());
        object.setTimeOut(n2);
        packetData = this.mHandler.obtainMessage(25, object);
        this.mHandler.sendMessage((Message)packetData);
        return true;
    }

    public boolean getGlobalPushFlag() {
        return this.mGlobalPushFlag;
    }

    public void setGlobalPushFlag(boolean bl2) {
        this.mGlobalPushFlag = bl2;
    }

    public void login(String object) {
        MiLinkLog.w(TAG, "login from=" + (String)object + " mState=" + this.mState + " isLogining=" + MiAccountManager.getInstance().isLogining() + " appHasLogined=" + MiAccountManager.getInstance().appHasLogined() + " mAppInited=" + this.mAppInited);
        this.mHandler.removeCallbacks(this.mLogoffRunnable);
        if (MiAccountManager.getInstance().isLogining()) {
            MiLinkLog.v(TAG, "milink is logining");
            return;
        }
        if (!MiAccountManager.getInstance().appHasLogined()) {
            MiLinkLog.v(TAG, "app not login, cancel milink login");
            object = this.mHandler.obtainMessage(23);
            this.mHandler.sendMessageAtFrontOfQueue((Message)object);
            return;
        }
        if (!this.mAppInited) {
            MiLinkLog.v(TAG, "app not init");
            object = this.mHandler.obtainMessage(26);
            this.mHandler.sendMessageAtFrontOfQueue((Message)object);
        }
        if (this.mState == 0) {
            this.internalManualOpen();
            return;
        }
        if (this.mState == 1) {
            return;
        }
        MiLinkLog.v(TAG, "milink login, session manager state: " + this.mState);
        object = this.getSession();
        if (object == null || !((Session)object).isAvailable()) {
            MiLinkLog.v(TAG, "login session is not available.");
            return;
        }
        if (this.mLoginTryTimes < 5) {
            ++this.mLoginTryTimes;
            MiLinkLog.v(TAG, "milink login start, mLoginTryTimes=" + this.mLoginTryTimes);
            ((Session)object).fastLogin();
            return;
        }
        MiLinkLog.v(TAG, "milink login has exceeded max times");
    }

    public void logoff() {
        MiLinkLog.v(TAG, "milink logoff");
        InternalDataMonitor.getInstance().doPostDataAtOnce();
        if (this.mMasterSession != null && this.mMasterSession.isAvailable()) {
            this.mMasterSession.logoff();
            this.mHandler.removeCallbacks(this.mLogoffRunnable);
            this.mHandler.postDelayed(this.mLogoffRunnable, 10L);
            return;
        }
        this.mLogoffRunnable.run();
    }

    public boolean enableConnectionManualMode(boolean bl2) {
        MiLinkLog.v(TAG, "enableConnectionManualMode, enable=".concat(String.valueOf(bl2)));
        if (bl2 == this.mEnableConnectionManualMode) {
            return true;
        }
        this.mServerManager = bl2 ? ManualServerManager.getInstance() : MiLinkServerManager.getInstance();
        this.mEnableConnectionManualMode = bl2;
        this.close();
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientForceOpen));
        return true;
    }

    public boolean close() {
        return this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.internalClose();
            }
        });
    }

    private void internalClose() {
        MiLinkLog.w(TAG, "internalClose");
        this.setState(0);
        this.stopTimer();
        if (this.mNetworkReveiver != null) {
            Global.unregisterReceiver(this.mNetworkReveiver);
        }
        if (this.mScreenOnReveiver != null) {
            Global.unregisterReceiver(this.mScreenOnReveiver);
        }
    }

    private void stopTimer() {
        this.mCheckTimeOutTimerOpen = false;
        this.mHandler.removeMessages(20);
    }

    public void suspectBadConnection() {
        EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientSuspectBadConnection));
    }

    public void setIpAndPortInManualMode(String string2, int n2) {
        MiLinkLog.v(TAG, "setIpAndPortInManualMode, ip=" + string2 + ":" + n2);
        ManualServerManager.getInstance().setIp(string2);
        ManualServerManager.getInstance().setPort(n2);
        if (this.mEnableConnectionManualMode) {
            ServerProfile serverProfile;
            if (this.mMasterSession != null && (serverProfile = this.mMasterSession.getServerProfile()).getServerIP() == string2 && serverProfile.getServerPort() == n2) {
                return;
            }
            this.close();
            EventBus.getDefault().post(new MiLinkEvent.ClientActionEvent(MiLinkEvent.ClientActionEvent.EventType.ClientForceOpen));
        }
    }

    public boolean tryConnectIfNeed() {
        if (this.mState == 0) {
            this.internalOpen();
            return true;
        }
        if (this.mState == 1) {
            if (this.mOpenStartTime > 0L && SystemClock.elapsedRealtime() - this.mOpenStartTime > 180000L) {
                MiLinkLog.w(TAG, "tryConnectIfNeed, connect time too long=" + (System.currentTimeMillis() - this.mOpenStartTime) + "ms");
                this.mState = 0;
                this.internalOpen();
                return true;
            }
            return false;
        }
        if (this.mLoginState == 0) {
            this.mLoginTryTimes = 0;
            this.login("tryConnectIfNeed");
            return true;
        }
        return false;
    }

    public boolean isMiLinkLogined() {
        return this.mLoginState == 2;
    }

    @Override
    protected void processMessage(Message object) {
        MiLinkLog.e("MiLinkReceive", "sessionManager processMessage msg.what:  " + ((Message)object).what);
        switch (((Message)object).what) {
            case 1: {
                this.processEvent((MiLinkEvent.SessionConnectEvent)((Message)object).obj);
                return;
            }
            case 2: {
                this.processEvent((MiLinkEvent.SessionLoginEvent)((Message)object).obj);
                return;
            }
            case 3: {
                this.processEvent((MiLinkEvent.SessionOtherEvent)((Message)object).obj);
                return;
            }
            case 4: {
                this.processEvent((MiLinkEvent.ServerNotificationEvent)((Message)object).obj);
                return;
            }
            case 5: {
                this.processEvent((MiLinkEvent.ClientActionEvent)((Message)object).obj);
                return;
            }
            case 6: {
                this.processEvent((MiLinkEvent.SystemNotificationEvent)((Message)object).obj);
                return;
            }
            case 20: {
                MiLinkLog.w(TAG, "MSG_CHECK_SESSION_TIMER");
                object = this.getSession();
                if (object != null) {
                    ((Session)object).checkRequestsTimeout();
                }
                Object object2 = this.mSessionList.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((Session)object).mFlagForSessionManager != 1) continue;
                    ((Session)object).checkRequestsTimeout();
                }
                if (this.mAllowAssitSessionWork && (object2 = this.getAssistSession()) != null) {
                    ((Session)object2).checkRequestsTimeout();
                }
                this.mHandler.sendEmptyMessageDelayed(20, 3000L);
                return;
            }
            case 22: {
                MiLinkLog.w(TAG, "release wake lock");
                this.releaseWakeLock();
                return;
            }
            case 24: {
                this.login("LOGIN_RETRY");
                return;
            }
            case 23: {
                MiLinkLog.v(TAG, "MSG_TYPE_GET_SERVICE_TOKEN,no service token, call app onEventGetServiceToken");
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.GetServiceToken));
                return;
            }
            case 26: {
                MiLinkLog.v(TAG, "MSG_TYPE_APP_NOT_INIT,app not init, call app init by onEventGetServiceToken");
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.GetServiceToken));
                return;
            }
            case 25: {
                Session session;
                object = (Request)((Message)object).obj;
                if (!NetworkDash.isAvailable()) {
                    ((Request)object).onDataSendFailed(533, "abandon package,network not available state=" + this.mState);
                    return;
                }
                if (this.mAllowAssitSessionWork) {
                    session = this.getAssistSession();
                    if (session == null || !session.isConnected()) {
                        this.internalAssistSessionOpen();
                    } else {
                        MiLinkLog.v(TAG, "send data to assistsession, seq=" + ((Request)object).getSeqNo());
                        if (session.isDeadConnection(6000L, 300000L)) {
                            MiLinkLog.w(TAG, "assistsession isDeadConnection=true");
                            this.setAssistSessionState(0);
                        } else {
                            session.handleRequest((Request)object);
                            return;
                        }
                    }
                }
                session = this.getSession();
                MiLinkLog.v(TAG, "send data, session manager state: " + this.mState);
                if (session != null && session.isDeadConnection(6000L, 300000L)) {
                    MiLinkLog.w(TAG, "session isDeadConnection=true");
                    this.setState(0);
                    session = null;
                }
                if (session == null || !session.isAvailable()) {
                    if (((Request)object).requestShouldCached()) {
                        MiLinkLog.w(TAG, "push request in cache, seq=" + ((Request)object).getSeqNo());
                        this.mSendQueue.add((Request)object);
                    } else {
                        MiLinkLog.v(TAG, "abandon data because session is not available, seq=" + ((Request)object).getSeqNo());
                        if (((Request)object).getData() != null) {
                            ((Request)object).onDataSendFailed(533, "abandon package,session is not available state=" + this.mState);
                            InternalDataMonitor.getInstance().trace("", 0, ((Request)object).getData().getCommand(), 4, ((Request)object).getCreatedTime(), SystemClock.elapsedRealtime(), ((Request)object).getSize(), 0, ((Request)object).getSeqNo());
                        }
                    }
                    this.login("handleRequest");
                    return;
                }
                MiLinkLog.v(TAG, "send data to session, seq=" + ((Request)object).getSeqNo());
                session.handleRequest((Request)object);
            }
        }
    }

    private boolean isMultiUnavailable() {
        if (this.mSessionAddress2ErrorCodeMap.isEmpty()) {
            return false;
        }
        for (String string2 : this.mSessionAddress2ErrorCodeMap.keySet()) {
            Integer object = this.mSessionAddress2ErrorCodeMap.get(string2);
            if (object != null && (object == 111 || object == 101 || object == 113 || object == 110)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllSessionErrorCode(int n2) {
        if (this.mSessionAddress2ErrorCodeMap.isEmpty()) {
            return false;
        }
        for (String string2 : this.mSessionAddress2ErrorCodeMap.keySet()) {
            Integer object = this.mSessionAddress2ErrorCodeMap.get(string2);
            if (object != null && object == n2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(MiLinkEvent.SessionConnectEvent object) {
        Session session = ((MiLinkEvent.SessionConnectEvent)object).mSession;
        int n2 = ((MiLinkEvent.SessionConnectEvent)object).mRetCode;
        switch (((MiLinkEvent.SessionConnectEvent)object).mEventType) {
            case SessionBuildFailed: {
                MiLinkLog.w(TAG, "SessionConnectEvent SessionBuildFailed");
                object = this.mReportLock;
                synchronized (object) {
                    this.mReportLock.notifyAll();
                }
                object = session.getServerProfileForStatistic();
                MiLinkLog.w(TAG, "SessionBuildFailed ServerProfile " + ((ServerProfile)object).toString());
                if (object != null) {
                    String string2 = String.format("%s:%s", ((ServerProfile)object).getServerIP(), ((ServerProfile)object).getServerPort());
                    this.mSessionAddress2ErrorCodeMap.put(string2, n2);
                }
                if (this.isAbandonSession(session)) {
                    return;
                }
                MiLinkLog.w(TAG, "MSG_TYPE_OPEN_SESSION_FAIL errCode:".concat(String.valueOf(n2)));
                if (session.mFlagForSessionManager == 4) {
                    MiLinkLog.e(TAG, String.format("handleMessage MSG_TYPE_OPEN_SESSION_FAIL is mMasterSession No:%d, mState = %d", session.getSessionNO(), this.mState));
                    this.setState(0);
                    if (NetworkDash.isAvailable()) {
                        this.mInternalAutoOpenRunnable.run();
                    }
                    return;
                }
                if (session.mFlagForSessionManager == 1) {
                    MiLinkLog.e(TAG, String.format("handleMessage MSG_TYPE_OPEN_SESSION_FAIL is isTryingSession No:%d, mState = %d", session.getSessionNO(), this.mState));
                    this.getNextServerProfile(session, n2);
                    return;
                }
                MiLinkLog.e(TAG, "handleMessage MSG_TYPE_OPEN_SESSION_FAIL is unknown session No:" + session.getSessionNO());
                session.close();
                return;
            }
            case SessionBuildSuccess: {
                MiLinkLog.w(TAG, "SessionConnectEvent SessionBuildSuccess");
                if (this.isAbandonSession(session)) {
                    return;
                }
                MiLinkLog.v(TAG, "handleMessage OPEN_SESSION_SUCCESS No:" + session.getSessionNO());
                if (session.mFlagForSessionManager == 1 || session.mFlagForSessionManager == 4) {
                    MiLinkLog.v(TAG, "update session");
                    this.updateSession(session);
                    this.resetAllTryTimes();
                    object = this.mReportLock;
                    synchronized (object) {
                        this.mReportLock.notifyAll();
                        return;
                    }
                }
                session.close();
                MiLinkLog.e(TAG, "handleMessage OPEN_SESSION_SUCCESS is unknown session No:" + session.getSessionNO());
                return;
            }
            case SessionRunError: {
                MiLinkLog.w(TAG, "SessionConnectEvent SessionRunError");
                if (this.isAbandonSession(session)) {
                    return;
                }
                MiLinkLog.e(TAG, String.format("handleMessage SESSION_ERROR reason = %d, No:%d", n2, session.getSessionNO()));
                this.setState(0);
                if (n2 == 562) {
                    return;
                }
                if (NetworkDash.isAvailable()) {
                    MiLinkLog.e(TAG, " SESSION_ERROR mSessionReconnectTimes=" + this.mSessionReconnectTryTimes + ", mOpenSessionTryTimes=" + this.mOpenSessionTryTimes);
                    if (this.mSessionReconnectTryTimes < 2) {
                        if (n2 == 104) {
                            this.mOpenStartTime = SystemClock.elapsedRealtime();
                        }
                        MiLinkLog.e(TAG, "\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4 : " + this.mOpenStartTime + " \u662f\u5426\u662f\u77ed\u8fde\u63a5\uff1a " + Global.getClientAppInfo().isMediumConnection() + " errCode : " + n2);
                        if (!Global.getClientAppInfo().isMediumConnection()) {
                            object = new Session();
                            new Session().mFlagForSessionManager = 1;
                            this.mSessionList.add((Session)object);
                            this.setState(1);
                            ((Session)object).openSession(session.getServerProfileForStatistic());
                            ++this.mSessionReconnectTryTimes;
                        }
                    } else {
                        this.mInternalAutoOpenRunnable.run();
                    }
                    HeartBeatManager.getInstance().reciveConnectRunError(n2);
                    return;
                }
                MiLinkLog.e(TAG, "on seesion error network isAvailable = false");
                return;
            }
            case AssistSessionConnectSuccess: {
                MiLinkLog.w(TAG, "SessionConnectEvent AssistSessionConnectSuccess");
                session.mFlagForSessionManager = 4;
                MiLinkLog.v(TAG, "updateSession in no session or tring session");
                if (this.mAssistSession != null && this.mAssistSession != session) {
                    this.mAssistSession.close();
                }
                this.mAssistSession = session;
                this.setAssistSessionState(2);
                return;
            }
            case AssistSessionConnectFailed: {
                MiLinkLog.w(TAG, "SessionConnectEvent AssistSessionConnectFailed");
                session.mFlagForSessionManager = 3;
                this.setAssistSessionState(0);
                return;
            }
            case AssistSessionRunError: {
                MiLinkLog.w(TAG, "SessionConnectEvent AssistSessionRunError");
                session.mFlagForSessionManager = 3;
                this.setAssistSessionState(0);
            }
        }
    }

    private void processEvent(MiLinkEvent.SessionLoginEvent sessionLoginEvent) {
        Session session = sessionLoginEvent.mSession;
        if (this.isAbandonSession(session)) {
            return;
        }
        switch (sessionLoginEvent.mEventType) {
            case LoginFailed: {
                MiLinkLog.w(TAG, "SessionLoginEvent LoginFailed");
                MiAccountManager.getInstance().setIsLogining(false);
                this.mLoginState = 0;
                if (sessionLoginEvent.mRetCode == 302) break;
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerStateChangeEvent(MiLinkEvent.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 0));
                this.mHandler.removeMessages(24);
                this.mHandler.sendEmptyMessageDelayed(24, 10000L);
                return;
            }
            case LoginSuccess: {
                MiLinkLog.w(TAG, "SessionLoginEvent LoginSuccess");
                MiAccountManager.getInstance().setIsLogining(false);
                this.mLoginState = 2;
                this.sendCacheRequest();
                MiLinkLog.v(TAG, "onLoginResult loginState=2");
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerStateChangeEvent(MiLinkEvent.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 2));
                if (session == null || !session.isAvailable()) {
                    MiLinkLog.w(TAG, "LoginSuccess session is not available.");
                    return;
                }
                this.acquireWakeLock();
                session.heartBeat(true);
                return;
            }
            case LogoffCmdReturn: {
                MiLinkLog.w(TAG, "SessionLoginEvent LogoffCmdReturn");
                this.mHandler.removeCallbacks(this.mLogoffRunnable);
                this.mLogoffRunnable.run();
            }
        }
    }

    private void processEvent(MiLinkEvent.SessionOtherEvent sessionOtherEvent) {
        Session session = sessionOtherEvent.mSession;
        if (this.isAbandonSession(session)) {
            return;
        }
        switch (sessionOtherEvent.mEventType) {
            case RecvInvalidPacket: {
                MiLinkLog.w(TAG, "SessionOtherEvent RecvInvalidPacket");
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.RecvInvalidPacket));
                return;
            }
            case RequestMapIsEmpty: {
                MiLinkLog.w(TAG, "SessionOtherEvent RequestMapIsEmpty");
                if (!this.mCheckTimeOutTimerOpen) {
                    return;
                }
                this.mTryStopTimerRunnable.run();
                return;
            }
            case RequestMapIsNotEmpty: {
                MiLinkLog.w(TAG, "SessionOtherEvent RequestMapIsNotEmpty");
                if (this.mCheckTimeOutTimerOpen) break;
                MiLinkLog.v(TAG, "mCheckTimeOutTimerOpen=false,startTimer");
                this.startTimer();
                return;
            }
            case StatisticsTimeoutPacket: {
                MiLinkLog.w(TAG, "SessionOtherEvent StatisticsTimeoutPacket");
                session.postStatisticsTimeoutPacketAction();
            }
        }
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void processEvent(MiLinkEvent.ServerNotificationEvent iterator) {
        switch (((MiLinkEvent.ServerNotificationEvent)((Object)iterator)).mEventType) {
            case ServerLineBroken: {
                MiLinkLog.e(TAG, "ServerNotificationEvent ServerLineBroken");
                this.setState(0);
                if (NetworkDash.isAvailable()) {
                    this.mServerManager = MiLinkBackupServerManager.getInstance();
                    this.internalOpen();
                    return;
                }
                MiLinkLog.e(TAG, "on server line broken network isAvailable = false");
                return;
            }
            case B2tokenExpired: {
                MiLinkLog.e(TAG, "ServerNotificationEvent B2tokenExpired");
                MiAccountManager.getInstance().logoffMiLink();
                this.login("B2_TOKEN_EXPIRED");
                return;
            }
            case ChannelPubKeyUpdate: {
                Session session;
                MiLinkLog.e(TAG, "ServerNotificationEvent ChannelPubKeyUpdate");
                iterator = (SystemPacketProto.MnsCmdChannelNewPubKeyRsp)((MiLinkEvent.ServerNotificationEvent)((Object)iterator)).mObject;
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                if (iterator != null) {
                    for (SystemPacketProto.PublicKeyInfo packetData : ((SystemPacketProto.MnsCmdChannelNewPubKeyRsp)((Object)iterator)).getPubInfoList()) {
                        int n2 = packetData.getKeyId();
                        byte[] object2 = packetData.getPublicKey().toByteArray();
                        try {
                            hashMap.put(n2, new String(object2, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    AnonymousAccount.getInstance().setChannelPubKey(hashMap);
                    MiLinkLog.e(TAG, " onUpdateChannelPubKey update  " + hashMap.size() + " pubkey ");
                }
                if ((session = this.getSession()) == null || !session.isAvailable()) {
                    MiLinkLog.v(TAG, "login session is not available.");
                    return;
                }
                session.fastLogin();
                return;
            }
            case ServiceTokenExpired: {
                MiLinkLog.e(TAG, "ServerNotificationEvent ServiceTokenExpired");
                this.mLogoffRunnable.run();
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.ServiceTokenExpired));
                return;
            }
            case ShouldUpdate: {
                MiLinkLog.e(TAG, "ServerNotificationEvent ShouldUpdate");
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.ShouldUpdate));
                return;
            }
            case KickByServer: {
                MiLinkLog.e(TAG, "ServerNotificationEvent KickByServer");
                this.mHandler.postDelayed(this.mLogoffRunnable, 5000L);
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.KickByServer, ((MiLinkEvent.ServerNotificationEvent)((Object)iterator)).mObject));
                return;
            }
            case requireUploadLog: {
                try {
                    UploadLogManager.uploadMilinkLog((PushPacketProto.MilinkLogReq)((MiLinkEvent.ServerNotificationEvent)((Object)iterator)).mObject, MiAccountManager.getInstance().getCurrentAccount(), false);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
            case requireChannelLogLevel: {
                iterator = (PushPacketProto.PushLogLevel)((MiLinkEvent.ServerNotificationEvent)((Object)iterator)).mObject;
                MiLinkLog.d(TAG, "requireChannelLogLevel.");
                if (!((PushPacketProto.PushLogLevel)((Object)iterator)).hasLoglevel()) break;
                DataExtraProto.DataLoglevel.Builder builder = DataExtraProto.DataLoglevel.newBuilder();
                builder.setLoglevel(((PushPacketProto.PushLogLevel)((Object)iterator)).getLoglevel());
                builder.setTimeLong(((PushPacketProto.PushLogLevel)((Object)iterator)).getTimeLong());
                PacketData packetData = new PacketData();
                packetData.setCommand("data.loglevel");
                packetData.setData(builder.build().toByteArray());
                MnsPacketDispatcher.getInstance().dispatchPacket(packetData);
                MiLinkLog.e(TAG, "notify app to change log level.level=" + ((PushPacketProto.PushLogLevel)((Object)iterator)).getLoglevel() + ", time=" + ((PushPacketProto.PushLogLevel)((Object)iterator)).getTimeLong());
            }
        }
    }

    private void processEvent(MiLinkEvent.ClientActionEvent clientActionEvent) {
        switch (clientActionEvent.mEventType) {
            case ClientNotSameUserLogin: {
                MiLinkLog.e(TAG, "ClientActionEvent ClientNotSameUserLogin");
                this.internalClose();
                return;
            }
            case ClientRequestCheckConnection: {
                MiLinkLog.w(TAG, "ClientActionEvent ClientRequestCheckConnection");
                this.tryConnectIfNeed();
                if (this.mState == 2) {
                    EventBus.getDefault().post(new MiLinkEvent.SessionManagerStateChangeEvent(MiLinkEvent.SessionManagerStateChangeEvent.EventType.SessionStateChange, Integer.MIN_VALUE, 2));
                }
                if (this.mLoginState != 2) break;
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerStateChangeEvent(MiLinkEvent.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 2));
                return;
            }
            case ClientRequestLogin: {
                MiLinkLog.w(TAG, "ClientActionEvent ClientRequestLogin");
                if (this.mNetworkReveiver != null) {
                    Global.unregisterReceiver(this.mNetworkReveiver);
                    Global.registerReceiver(this.mNetworkReveiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                }
                if (this.mScreenOnReveiver != null) {
                    Global.unregisterReceiver(this.mScreenOnReveiver);
                    clientActionEvent = new IntentFilter("android.intent.action.SCREEN_ON");
                    clientActionEvent.addAction("android.intent.action.SCREEN_OFF");
                    Global.registerReceiver(this.mScreenOnReveiver, (IntentFilter)clientActionEvent);
                }
                this.login("UserAction");
                return;
            }
            case ClientRequestLogoff: {
                MiLinkLog.w(TAG, "ClientActionEvent ClientRequestLogoff");
                this.logoff();
                return;
            }
            case ClientForceOpen: {
                MiLinkLog.w(TAG, "ClientActionEvent ClientForceOpen");
                this.setState(0);
                this.resetAllTryTimes();
                this.acquireWakeLock();
                MiAccountManager.getInstance().setIsLogining(false);
                this.login("ClientForceOpen");
                return;
            }
            case ClientSuspectBadConnection: {
                MiLinkLog.w(TAG, "ClientActionEvent ClientSuspectBadConnection");
                if (this.mState != 2 || System.currentTimeMillis() - this.mConnectionBuildTimestamp <= 300000L) break;
                this.setState(0);
                this.resetAllTryTimes();
                this.acquireWakeLock();
                this.login("ClientSuspectBadConnection");
            }
        }
    }

    private void processEvent(MiLinkEvent.SystemNotificationEvent object) {
        switch (((MiLinkEvent.SystemNotificationEvent)object).mEventType) {
            case AlarmArrived: {
                MiLinkLog.e("HeartBeat", "\u5fc3\u8df3\u5f00\u59cb\u4e86");
                this.closeAllBandonSession();
                InternalDataMonitor.getInstance().onAlarmArrive();
                if (Global.getClientAppInfo().isMediumConnection() && System.currentTimeMillis() - this.mLastUserSendDataTime > 600000L) {
                    MiLinkLog.w(TAG, "medium connection mode,user not send any packet in 10 min,close connection");
                    this.internalClose();
                    return;
                }
                if (!MiAccountManager.getInstance().appHasLogined()) {
                    MiLinkLog.w(TAG, "onAlarmArrived, app not login");
                    return;
                }
                MiLinkLog.w(TAG, "SystemNotificationEvent onAlarmArrived mState=" + this.mState + " sendCacheRequest size = " + this.mSendQueue.size());
                this.resetAllTryTimes();
                this.acquireWakeLock();
                MiLinkLog.v(TAG, "session manager state: " + this.mState);
                object = this.getSession();
                if (this.tryConnectIfNeed()) {
                    return;
                }
                MiLinkLog.v(TAG, "send heart beat to session");
                if (object == null || !((Session)object).isAvailable()) {
                    MiLinkLog.w(TAG, "session is not available.");
                    return;
                }
                ((Session)object).heartBeat(false);
                return;
            }
            case ScreenOn: {
                MiLinkLog.v(TAG, "SystemNotificationEvent screen_on");
                if (!MiAccountManager.getInstance().appHasLogined()) {
                    MiLinkLog.w(TAG, "screen_on, app not login");
                    return;
                }
                if (Global.getClientAppInfo().isMediumConnection()) break;
                this.tryConnectIfNeed();
                return;
            }
            case NetWorkChange: {
                MiLinkLog.v(TAG, "SystemNotificationEvent NetWorkChange");
                this.acquireWakeLock();
                this.tryConnectIfNeed();
                return;
            }
            case ServiceCreated: {
                MiLinkLog.v(TAG, "SystemNotificationEvent ServiceCreated");
                if (this.mAppInited) {
                    this.acquireWakeLock();
                    this.tryConnectIfNeed();
                    return;
                }
                EventBus.getDefault().post(new MiLinkEvent.SessionManagerNotificationEvent(MiLinkEvent.SessionManagerNotificationEvent.EventType.GetServiceToken));
            }
        }
    }

    private boolean isAbandonSession(Session session) {
        if (session == null || session.mFlagForSessionManager == 3) {
            MiLinkLog.w(TAG, String.format("Session No:%d is AbandonSession return ", session.getSessionNO()));
            if (session.close()) {
                this.mSessionList.remove(session);
            }
            return true;
        }
        return false;
    }

    private void internalManualOpen() {
        MiLinkLog.v(TAG, "internalManualOpen,mState=" + this.mState);
        this.resetAllTryTimes();
        this.mServerManager = this.mEnableConnectionManualMode ? ManualServerManager.getInstance() : MiLinkServerManager.getInstance();
        this.internalOpen();
    }

    private void internalOpen() {
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.w(TAG, "can not open session, network is not available.");
            return;
        }
        if (!MiAccountManager.getInstance().appHasLogined()) {
            MiLinkLog.w(TAG, "app not login internalOpen cancel");
            return;
        }
        if (this.mHandler == null) {
            MiLinkLog.w(TAG, "can not open session, mHandler == null.");
            return;
        }
        MiLinkLog.i(TAG, "open session, internalOpen with mState = " + this.mState);
        if (this.mState != 0) {
            MiLinkLog.w(TAG, "mState is not No_Sesssion state,cancel paoma");
            return;
        }
        this.mSessionAddress2ErrorCodeMap.clear();
        this.mOpenStartTime = SystemClock.elapsedRealtime();
        ServerProfile[] serverProfileArray = this.mServerManager.reset(false);
        this.mServerManager = MiLinkServerManager.getInstance();
        if (serverProfileArray == null || serverProfileArray.length == 0) {
            MiLinkLog.e(TAG, "serverProfileList is null ,internalOpne cancel");
            return;
        }
        MiLinkLog.d(TAG, "internalOpen 4");
        this.setState(1);
        for (int i2 = 0; i2 < serverProfileArray.length; ++i2) {
            if (serverProfileArray[i2] == null) continue;
            Session session = new Session();
            new Session().mFlagForSessionManager = 1;
            this.mSessionList.add(session);
            session.openSession(serverProfileArray[i2]);
        }
        this.mNetworkDetailInfoOnOpen = Device.Network.getCurrentNetworkDetailInfo();
    }

    private void internalAssistSessionOpen() {
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.i(TAG, "can not open session, network is not available.");
            return;
        }
        if (!MiAccountManager.getInstance().appHasLogined()) {
            MiLinkLog.i(TAG, "app not login internalOpen cancel");
            return;
        }
        if (this.mHandler == null) {
            MiLinkLog.i(TAG, "can not open session, mHandler == null.");
            return;
        }
        MiLinkLog.i(TAG, "open assistsession, internalAssistSessionOpen with mState = " + this.mState);
        if (this.mAssistSessionState != 0) {
            MiLinkLog.i(TAG, "mAssistSessionState is not No_Sesssion state,cancel link");
            return;
        }
        this.setAssistSessionState(1);
        this.mAssistSession = new Session(1);
        this.mAssistSession.mFlagForSessionManager = 1;
        ServerProfile serverProfile = this.mMasterSession.getServerProfileForStatistic();
        if (serverProfile == null) {
            serverProfile = this.mServerManager.reset(true)[0];
        }
        this.mAssistSession.openSession(serverProfile);
    }

    private boolean updateSession(Session arrayList) {
        if (arrayList == null) {
            return false;
        }
        MiLinkLog.v(TAG, "update session function.");
        ((Session)((Object)arrayList)).mFlagForSessionManager = 4;
        this.mSessionList.remove(arrayList);
        if (((Session)((Object)arrayList)).getServerProfile().getProtocol() == 1) {
            this.abandonAllSession();
        }
        if (this.mServerManager != null) {
            this.mServerManager.save(((Session)((Object)arrayList)).getServerProfile());
        }
        MiLinkLog.v(TAG, "updateSession in no session or tring session");
        if (this.mMasterSession != null && this.mMasterSession != arrayList) {
            this.mMasterSession.close();
        }
        this.mMasterSession = arrayList;
        this.mMasterSession.startBackReceiveThread();
        this.setState(2);
        MiLinkLog.v(TAG, "connected, start milink login");
        MiAccountManager.getInstance().setIsLogining(false);
        this.login("updateSession");
        this.onOpenSessionResult(0, this.mOpenStartTime);
        arrayList = ((Session)((Object)arrayList)).getOpenSessionSucessReturnInfo();
        if (arrayList != null) {
            String string2 = ((OpenSessionSucessReturnInfo)((Object)arrayList)).getClientIp();
            String string3 = ((OpenSessionSucessReturnInfo)((Object)arrayList)).getClientIsp();
            ArrayList<ServerProfile> arrayList2 = ((OpenSessionSucessReturnInfo)((Object)arrayList)).getBackupServerList();
            arrayList = ((OpenSessionSucessReturnInfo)((Object)arrayList)).getOptmumServerList();
            MiLinkLog.w(TAG, String.format("clientip:%s clientIsp;%s", string2, string3));
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Global.setClientIp(string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                Global.setClientIsp(string3);
            }
            MiLinkIpInfoManager.getInstance().setOptmumServerList(Global.getClientIsp(), arrayList);
            MiLinkIpInfoManager.getInstance().setBackupServerList(arrayList2);
        } else {
            MiLinkLog.w(TAG, "info is null");
        }
        return true;
    }

    private void startTimer() {
        this.mCheckTimeOutTimerOpen = true;
        this.mHandler.removeMessages(20);
        this.mHandler.sendEmptyMessageDelayed(20, 3000L);
    }

    private Session getSession() {
        switch (this.mState) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return this.mMasterSession;
            }
        }
        return null;
    }

    private Session getAssistSession() {
        switch (this.mAssistSessionState) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return this.mAssistSession;
            }
        }
        return null;
    }

    private void setAssistSessionState(int n2) {
        switch (n2) {
            case 0: {
                if (this.mAssistSession == null) break;
                this.mAssistSession.mFlagForSessionManager = 3;
                this.mAssistSession.close();
                this.mAssistSession = null;
            }
        }
        MiLinkLog.i(TAG, "setAssistSessionState mAssistSessionState = " + this.mAssistSessionState + ",newState = " + n2);
        this.mAssistSessionState = n2;
    }

    private void abandonAllSession() {
        for (Session session : this.mSessionList) {
            if (session.mFlagForSessionManager != 1) continue;
            session.mFlagForSessionManager = 3;
            if (session.getServerProfile() != null) {
                MiLinkLog.w(TAG, "abandon all session, ip=" + session.getServerProfile().getServerIP() + ", port=" + session.getServerProfile().getServerPort() + ", protocol=" + session.getServerProfile().getProtocol() + ",No=" + session.getSessionNO());
                continue;
            }
            MiLinkLog.w(TAG, "abandon all session, s.getServerProfile()=null, sessionNO=" + session.getSessionNO());
        }
    }

    private void getNextServerProfile(Session session, int n2) {
        MiLinkLog.i(TAG, "getNextServerProfile " + String.format("[Session No:%d] ", session.getSessionNO()));
        ServerProfile[] serverProfileArray = this.mServerManager.getNext(session.getServerProfile(), n2);
        if (serverProfileArray == null) {
            MiLinkLog.i(TAG, "newServerProfile == null");
            session.mFlagForSessionManager = 3;
            if (session.close()) {
                this.mSessionList.remove(session);
            }
            if (!this.isHaveTryingSession()) {
                MiLinkLog.i(TAG, "already no trying session");
                if (this.mMasterSession == null) {
                    this.setState(0);
                    this.onOpenSessionResult(516, this.mOpenStartTime);
                    return;
                }
                MiLinkLog.e(TAG, "this session is trying session but masterSession is not null");
                return;
            }
        } else {
            for (int i2 = 0; i2 < serverProfileArray.length; ++i2) {
                if (serverProfileArray[i2] == null) continue;
                Session session2 = new Session();
                new Session().mFlagForSessionManager = 1;
                this.mSessionList.add(session2);
                session2.openSession(serverProfileArray[i2]);
            }
            session.mFlagForSessionManager = 3;
            if (session.close()) {
                this.mSessionList.remove(session);
            }
        }
    }

    private boolean isHaveTryingSession() {
        Iterator<Session> iterator = this.mSessionList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().mFlagForSessionManager != 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLock() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mWakeLock != null) {
                    MiLinkLog.w(TAG, "Wakelock RELEASED :)");
                    this.mWakeLock.release();
                    this.mWakeLock = null;
                }
            }
            catch (Exception exception) {
                MiLinkLog.e(TAG, "releaseWakeLock exception", exception);
                this.mWakeLock = null;
            }
            return;
        }
    }

    private void acquireWakeLock() {
        this.acquireWakeLock(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLock(int n2) {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(22);
            Object object = this.mLock;
            synchronized (object) {
                try {
                    Context context = Global.getApplicationContext();
                    if (context != null && this.mWakeLock == null) {
                        MiLinkLog.w(TAG, "Wakelock ACQUIRED :)");
                        context = (PowerManager)context.getApplicationContext().getSystemService("power");
                        this.mWakeLock = context.newWakeLock(1, "milink");
                        this.mWakeLock.acquire();
                    }
                }
                catch (Exception exception) {
                    MiLinkLog.e(TAG, "acquireWakeLock exception", exception);
                }
            }
            if (this.mHandler != null) {
                this.mHandler.sendEmptyMessageDelayed(22, (long)n2);
            }
        }
    }

    private boolean sendCacheRequest() {
        Session session = this.getSession();
        if (session == null) {
            MiLinkLog.e(TAG, "sendCacheRequest session == null impossible!!!");
            return false;
        }
        MiLinkLog.w(TAG, "sendCacheRequest size = " + this.mSendQueue.size());
        Iterator<Request> iterator = this.mSendQueue.iterator();
        while (iterator.hasNext()) {
            Request request = iterator.next();
            if (request == null) {
                iterator.remove();
                continue;
            }
            session.handleRequest(request);
            iterator.remove();
        }
        return true;
    }

    private class NetworkChangeReceiver
    extends BroadcastReceiver {
        private int currentType = -1;
        private String apnName = "";
        Runnable runable = new Runnable(){

            @Override
            public void run() {
                try {
                    Object object = ((ConnectivityManager)Global.getSystemService("connectivity")).getActiveNetworkInfo();
                    MiLinkLog.w(SessionManager.TAG, "NetworkChangeReceiver, networkInfo=".concat(String.valueOf(object)));
                    boolean bl2 = NetworkChangeReceiver.this.isNetworkChanged((NetworkInfo)object);
                    MiLinkLog.w(SessionManager.TAG, "isNetworkChange : ".concat(String.valueOf(bl2)));
                    NetworkChangeReceiver.this.setCurrentNetworkInfo((NetworkInfo)object);
                    if (object != null && object.isAvailable()) {
                        AlarmClockService.startIfNeed();
                        if (bl2) {
                            MiLinkLog.i(SessionManager.TAG, "NetworkChangeReceiver, network change need forceOpen");
                            SessionConst.setNewApn(true);
                            MiLinkIpInfoManager.getInstance().getDefaultHost();
                            MiAccountManager.getInstance().appHasLogined();
                            Global.getMainHandler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    EventBus.getDefault().post(new MiLinkEvent.SystemNotificationEvent(MiLinkEvent.SystemNotificationEvent.EventType.NetWorkChange));
                                }
                            }, 2000L);
                            return;
                        }
                        MiLinkLog.i(SessionManager.TAG, "NetworkChangeReceiver, network not change, mState=" + SessionManager.this.mState);
                        if (SessionManager.this.mState == 0) {
                            MiLinkIpInfoManager.getInstance().getDefaultHost();
                            Global.getMainHandler().postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    EventBus.getDefault().post(new MiLinkEvent.SystemNotificationEvent(MiLinkEvent.SystemNotificationEvent.EventType.NetWorkChange));
                                }
                            }, 2000L);
                            return;
                        }
                        object = SessionManager.this.getSession();
                        if (object != null && ((Session)object).isAvailable()) {
                            ((Session)object).ping();
                            return;
                        }
                        MiLinkLog.d(SessionManager.TAG, "Session :" + (object == null ? "true" : "false") + "session state : " + SessionManager.this.mState);
                        SessionManager.this.setState(0);
                        SessionManager.this.resetAllTryTimes();
                        SessionManager.this.acquireWakeLock();
                        SessionManager.this.login("ClientForceOpen");
                        return;
                    }
                    if (SessionManager.this.mState != 0) {
                        SessionManager.this.close();
                    }
                    MiLinkLog.i(SessionManager.TAG, "network is disconnected()");
                    return;
                }
                catch (Exception exception) {
                    NetworkChangeReceiver.this.setCurrentNetworkInfo(null);
                    MiLinkLog.e(SessionManager.TAG, "Get networkInfo fail", exception);
                    return;
                }
            }
        };

        private NetworkChangeReceiver() {
        }

        public void setCurrentNetworkInfo() {
            try {
                NetworkInfo networkInfo = ((ConnectivityManager)Global.getSystemService("connectivity")).getActiveNetworkInfo();
                MiLinkLog.i(SessionManager.TAG, "NetworkChangeReceiver, setCurrentNetworkInfo=".concat(String.valueOf(networkInfo)));
                this.setCurrentNetworkInfo(networkInfo);
                return;
            }
            catch (Exception exception) {
                this.setCurrentNetworkInfo(null);
                MiLinkLog.e(SessionManager.TAG, "Get networkInfo fail", exception);
                return;
            }
        }

        private void setCurrentNetworkInfo(NetworkInfo networkInfo) {
            if (networkInfo != null) {
                this.currentType = networkInfo.getType();
                if (this.currentType == 0) {
                    this.apnName = networkInfo.getSubtypeName();
                    return;
                }
                this.apnName = WifiDash.getBSSID();
                return;
            }
            this.currentType = -1;
            this.apnName = "";
        }

        public void onReceive(Context context, Intent intent) {
            if (!MiAccountManager.getInstance().appHasLogined()) {
                MiLinkLog.v(SessionManager.TAG, "app not login, ignore network change broadcast");
                return;
            }
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                SessionManager.this.mHandler.post(this.runable);
            }
        }

        private boolean isNetworkChanged(NetworkInfo networkInfo) {
            if (networkInfo == null) {
                return this.currentType != -1 || !TextUtils.isEmpty((CharSequence)this.apnName);
            }
            boolean bl2 = true;
            if (this.currentType == networkInfo.getType()) {
                if (this.currentType == 0) {
                    if (this.apnName != null && this.apnName.equals(networkInfo.getSubtypeName())) {
                        bl2 = false;
                    }
                } else if (this.apnName != null && this.apnName.equals(WifiDash.getBSSID())) {
                    bl2 = false;
                }
            }
            return bl2;
        }
    }

    private class ScreenOnChangeReceiver
    extends BroadcastReceiver {
        private ScreenOnChangeReceiver() {
        }

        public void onReceive(Context context, final Intent intent) {
            ThreadHelper.NETWORK.execute(new Runnable(){

                @Override
                public void run() {
                    MiLinkLog.i(SessionManager.TAG, "thread-pool: ScreenOnChangeReceiver start");
                    if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                        EventBus.getDefault().post(new MiLinkEvent.SystemNotificationEvent(MiLinkEvent.SystemNotificationEvent.EventType.ScreenOn));
                        MnsPacketDispatcher.getInstance().setDispatchPacketDelayTimeWhenScreenOn();
                    } else if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                        MiLinkLog.v(SessionManager.TAG, "ScreenOnChangeReceiver screen_off");
                        MnsPacketDispatcher.getInstance().setDispatchPacketDelayTimeWhenScreenOff();
                    }
                    MiLinkLog.i(SessionManager.TAG, "thread-pool: ScreenOnChangeReceiver end");
                }
            });
        }
    }
}

