/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.simplechannel;

import android.text.TextUtils;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManagerForSimpleChannel;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MiLinkBackupServerManagerForSimpleChannel
extends IServerManager {
    private String TAG = "MiLinkBackupServerManagerForSimpleChannel_";

    public MiLinkBackupServerManagerForSimpleChannel(MiLinkIpInfoManagerForSimpleChannel miLinkIpInfoManagerForSimpleChannel) {
        super(miLinkIpInfoManagerForSimpleChannel);
        this.TAG = this.TAG + miLinkIpInfoManagerForSimpleChannel.getAppId();
    }

    @Override
    public ServerProfile[] reset(boolean bl2) {
        int n2;
        List<ServerProfile> list;
        this.mTcpServerList = new ArrayList();
        this.mTcpServerListIndex = 0;
        if (ClientAppInfo.isTestChannel()) {
            String string2 = this.mIpInfoManager.getTestBackupIp()[0].getServerIP();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                list = (List<ServerProfile>)Const.ServerPort.PORT_ARRAY;
                int n3 = Const.ServerPort.PORT_ARRAY.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object = list[i2];
                    ServerProfile serverProfile = new ServerProfile(string2, (int)object, 1, 4);
                    this.mTcpServerList.add(serverProfile);
                }
            }
        } else {
            list = this.mIpInfoManager.getBackupServerList();
            if (list != null) {
                Collections.shuffle(list);
                MiLinkBackupServerManagerForSimpleChannel.addServerProfileInSpecifiedList(list, this.mTcpServerList);
            }
        }
        if (this.mTcpServerList.isEmpty()) {
            return null;
        }
        ServerProfile[] serverProfileArray = new ServerProfile[4];
        for (n2 = 0; n2 < 4; ++n2) {
            serverProfileArray[n2] = (ServerProfile)this.mTcpServerList.get(this.mTcpServerListIndex++);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            MiLinkLog.i(this.TAG, "reset , so try backuplist4, server No." + n2 + ":" + serverProfileArray[n2]);
        }
        return serverProfileArray;
    }

    @Override
    public ServerProfile[] getNext(ServerProfile serverProfileArray, int n2) {
        if (serverProfileArray == null) {
            MiLinkLog.e(this.TAG, "getNext, serverProfile == null!!!");
            return null;
        }
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.e(this.TAG, "getNext, Network is not available!!!");
            return null;
        }
        MiLinkLog.i(this.TAG, "getNext, failserver info:" + serverProfileArray + ",failReason = " + n2);
        if (serverProfileArray.getProtocol() == 1) {
            if (this.mTcpServerListIndex == this.mTcpServerList.size()) {
                MiLinkLog.i(this.TAG, "getNext no tcp server to try");
                return null;
            }
            ServerProfile[] serverProfileArray2 = new ServerProfile[1];
            serverProfileArray = serverProfileArray2;
            serverProfileArray2[0] = this.getNextTcpProfile();
            MiLinkLog.i(this.TAG, "getNext get tcp server," + serverProfileArray[0]);
            return serverProfileArray;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void loadCurrentApn() {
        IIpInfoManager.loadCurrentApn();
    }

    public void preLoad() {
        if (this.mIpInfoManager != null) {
            this.mIpInfoManager.getRcentlyIpMap();
            this.mIpInfoManager.getOptimumIpMap();
            this.mIpInfoManager.getRecentlyServerData();
            this.mIpInfoManager.getBackupServerList();
            this.mIpInfoManager.getCurrentApnOptimumServerData();
        }
    }
}

