/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.simplechannel;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.config.IIpInfoManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManagerForSimpleChannel;
import com.mi.milink.sdk.connection.DomainManager;
import com.mi.milink.sdk.data.ClientAppInfo;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.OptimumServerData;
import com.mi.milink.sdk.session.common.RecentlyServerData;
import com.mi.milink.sdk.session.common.ServerProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MiLinkServerManagerForSimpleChannel
extends IServerManager {
    private String TAG = "MiLinkServerManagerForSimpleChannel_";

    public MiLinkServerManagerForSimpleChannel(MiLinkIpInfoManagerForSimpleChannel miLinkIpInfoManagerForSimpleChannel) {
        super(miLinkIpInfoManagerForSimpleChannel);
        this.TAG = this.TAG + miLinkIpInfoManagerForSimpleChannel.getAppId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public ServerProfile[] reset(boolean bl2) {
        Iterator iterator;
        Serializable serializable2;
        this.mTcpServerList.clear();
        this.mTcpServerListIndex = 0;
        if (ClientAppInfo.isTestChannel()) {
            int n2;
            Object object2;
            String string2 = this.mIpInfoManager.getTestBackupIp()[0].getServerIP();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                object2 = Const.ServerPort.PORT_ARRAY;
                n2 = Const.ServerPort.PORT_ARRAY.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = object2[i2];
                    ServerProfile object4 = new ServerProfile(string2, n3, 1, 4);
                    this.mTcpServerList.add(object4);
                }
            }
            ServerProfile[] serverProfileArray = new ServerProfile[4];
            List list = this.mTcpServerList;
            object2 = list;
            synchronized (list) {
                for (n2 = 0; n2 < 4; ++n2) {
                    if (this.mTcpServerList.size() <= this.mTcpServerListIndex || this.mTcpServerListIndex < 0) continue;
                    serverProfileArray[n2] = (ServerProfile)this.mTcpServerList.get(this.mTcpServerListIndex++);
                }
                for (ServerProfile serverProfile : this.mTcpServerList) {
                    MiLinkLog.e(this.TAG, "[\u9009\u51fa\u7684ip\uff1a " + serverProfile.getServerIP() + ", port: " + serverProfile.getServerPort() + "]");
                }
                // ** MonitorExit[object2 /* !! */ ] (shouldn't be in output)
            }
        }
        long l2 = SystemClock.elapsedRealtime();
        boolean bl3 = false;
        Object object3 = null;
        MiLinkLog.i(this.TAG, "reset appid = " + this.mIpInfoManager.getAppId() + ", set domain server=[" + Global.getClientAppInfo(this.mIpInfoManager.getAppId()).getDomain() + "] set backip =[" + Global.getClientAppInfo(this.mIpInfoManager.getAppId()).getBackServer() + "]");
        long l3 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format(" get id 1-2 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        if (!Global.getClientAppInfo(this.mIpInfoManager.getAppId()).isHasSetAccServerDomain()) {
            List<ServerProfile> list;
            RecentlyServerData recentlyServerData = this.mIpInfoManager.getRecentlyServerData();
            l2 = SystemClock.elapsedRealtime();
            Log.e((String)this.TAG, (String)String.format(" get id 1-3-1 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
            if (recentlyServerData != null) {
                object3 = recentlyServerData.getRecentlyServer();
            }
            l3 = SystemClock.elapsedRealtime();
            Log.e((String)this.TAG, (String)String.format(" get id 1-3-2 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
            OptimumServerData optimumServerData = this.mIpInfoManager.getCurrentApnOptimumServerData();
            l2 = SystemClock.elapsedRealtime();
            Log.e((String)this.TAG, (String)String.format(" get id 1-3-3 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
            if (optimumServerData != null && (list = optimumServerData.getOptimumServers()) != null) {
                Collections.shuffle(list);
                serializable2 = new ArrayList();
                for (ServerProfile serverProfile : list) {
                    if (serverProfile == null) continue;
                    if (object3 != null && serverProfile.getServerIP().equals(((ServerProfile)object3).getServerIP())) {
                        bl3 = true;
                        continue;
                    }
                    ((ArrayList)serializable2).add(serverProfile);
                }
                iterator = ((ArrayList)serializable2).iterator();
                while (iterator.hasNext()) {
                    ServerProfile serverProfile = (ServerProfile)iterator.next();
                    ArrayList<ServerProfile> arrayList = new ArrayList<ServerProfile>();
                    arrayList.add(serverProfile);
                    MiLinkServerManagerForSimpleChannel.addServerProfileInSpecifiedList(arrayList, this.mTcpServerList);
                }
            }
            l3 = SystemClock.elapsedRealtime();
            Log.e((String)this.TAG, (String)String.format(" get id 1-4 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        }
        int[] nArray = Const.ServerPort.PORT_ARRAY;
        int n4 = Const.ServerPort.PORT_ARRAY.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            iterator = new ServerProfile(this.mIpInfoManager.getDefaultServer().getServerIP(), n5, 1, 4);
            this.mTcpServerList.add(iterator);
        }
        l2 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format(" get id 1-5 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
        List<ServerProfile> list = this.mIpInfoManager.getBackupServerList();
        if (list != null) {
            for (ServerProfile serverProfile : list) {
                serializable2 = new ArrayList<ServerProfile>();
                serializable2.add(serverProfile);
                MiLinkServerManagerForSimpleChannel.addServerProfileInSpecifiedList(serializable2, this.mTcpServerList);
            }
        }
        ServerProfile[] serverProfileArray = new ServerProfile[4];
        List list2 = this.mTcpServerList;
        synchronized (list2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                if (this.mTcpServerList.size() <= this.mTcpServerListIndex || this.mTcpServerListIndex < 0) continue;
                serverProfileArray[i3] = (ServerProfile)this.mTcpServerList.get(this.mTcpServerListIndex++);
            }
            for (Serializable serializable2 : this.mTcpServerList) {
                MiLinkLog.e(this.TAG, "[\u9009\u51fa\u7684ip\uff1a " + ((ServerProfile)serializable2).getServerIP() + ", port: " + ((ServerProfile)serializable2).getServerPort() + "]");
            }
        }
        l3 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format(" get id 1-6 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        if (bl3) {
            ServerProfile[] serverProfileArray2 = new ServerProfile[1];
            ServerProfile[] serverProfileArray3 = serverProfileArray2;
            serverProfileArray2[0] = object3;
            MiLinkLog.i(this.TAG, "reset isBackgroud = " + bl2 + ",has recently tcp server" + object3);
            MiLinkLog.i(this.TAG, " \u76f4\u63a5\u8d70\u6700\u8fd1\u6700\u4f18ip has recently tcp server".concat(String.valueOf(object3)));
            return serverProfileArray3;
        }
        l2 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format(" get id 1-7 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
        {
            void var2_23;
            for (int i4 = 0; i4 < 4; ++i4) {
                MiLinkLog.i(this.TAG, "reset isBackgroud = " + bl2 + ", has no recently server, so try 4, server No." + i4 + ":" + var2_23[i4]);
            }
            return var2_23;
        }
    }

    @Override
    public ServerProfile[] getNext(ServerProfile serverProfileArray, int n2) {
        if (serverProfileArray == null) {
            MiLinkLog.e(this.TAG, "getNext, serverProfile == null!!!");
            return null;
        }
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.e(this.TAG, "getNext, Network is not available!!!");
            return null;
        }
        MiLinkLog.i(this.TAG, "getNext, failserver info:" + serverProfileArray + ",failReason = " + n2);
        if (serverProfileArray.getProtocol() == 1) {
            if (serverProfileArray.getServerType() == 3) {
                serverProfileArray = new ServerProfile[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    serverProfileArray[n2] = this.getNextTcpProfile();
                    MiLinkLog.i(this.TAG, "getNext, recently tcp failed, and has no rencently http server,so try 4, server No." + n2 + ":" + serverProfileArray[n2]);
                }
                return serverProfileArray;
            }
            if (this.mTcpServerListIndex == this.mTcpServerList.size()) {
                MiLinkLog.i(this.TAG, "getNext no tcp server to try");
                return null;
            }
            ServerProfile[] serverProfileArray2 = new ServerProfile[1];
            serverProfileArray = serverProfileArray2;
            serverProfileArray2[0] = this.getNextTcpProfile();
            MiLinkLog.i(this.TAG, "getNext get tcp server," + serverProfileArray[0]);
            return serverProfileArray;
        }
        return null;
    }

    public void preLoad() {
        if (this.mIpInfoManager != null) {
            this.mIpInfoManager.getRcentlyIpMap();
            this.mIpInfoManager.getOptimumIpMap();
            this.mIpInfoManager.getRecentlyServerData();
            this.mIpInfoManager.getBackupServerList();
            this.mIpInfoManager.getCurrentApnOptimumServerData();
        }
    }

    @Override
    public void loadCurrentApn() {
        IIpInfoManager.loadCurrentApn();
    }

    @Override
    public boolean save(ServerProfile serverProfile) {
        if (serverProfile == null) {
            return false;
        }
        serverProfile.setServerIP(DomainManager.getInstance().queryDomainIP(serverProfile.getServerIP()));
        if (serverProfile.getProtocol() != 1) {
            return false;
        }
        this.mIpInfoManager.setRecentlyServer(new ServerProfile(serverProfile.getServerIP(), serverProfile.getServerPort(), serverProfile.getProtocol(), 3));
        return true;
    }

    @Override
    public void destroy() {
    }
}

