/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.simplechannel;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mi.milink.sdk.account.IAccount;
import com.mi.milink.sdk.account.manager.MiChannelAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.Device;
import com.mi.milink.sdk.base.os.info.DeviceDash;
import com.mi.milink.sdk.config.ConfigManager;
import com.mi.milink.sdk.config.MiLinkIpInfoManager;
import com.mi.milink.sdk.connection.DomainManager;
import com.mi.milink.sdk.connection.IConnectionCallback;
import com.mi.milink.sdk.connection.TcpConnection;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.TrafficMonitor;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import com.mi.milink.sdk.proto.DataExtraProto;
import com.mi.milink.sdk.proto.SystemPacketProto;
import com.mi.milink.sdk.session.common.InvalidPacketExecption;
import com.mi.milink.sdk.session.common.MsgProcessor;
import com.mi.milink.sdk.session.common.OpenSessionSucessReturnInfo;
import com.mi.milink.sdk.session.common.ReceiveBuffer;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.SessionConst;
import com.mi.milink.sdk.session.common.StreamUtil;
import com.mi.milink.sdk.session.persistent.MnsPacketDispatcher;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.simplechannel.SessionManagerForSimpleChannel;
import com.mi.milink.sdk.util.StatisticsLog;
import java.io.IOException;
import java.util.Iterator;

public class SessionForSimpleChannel
extends Session
implements IConnectionCallback,
MsgProcessor {
    private String TAG = "SessionForSimpleChannel_";
    private int appId;
    private SessionManagerForSimpleChannel sessionManager;
    private MiChannelAccountManager accountManager;
    private boolean mIsFastLogining = false;
    @SuppressLint(value={"DefaultLocale"})
    private ReceiveBuffer.ReceiveBufferSink mRecBufSink = new ReceiveBuffer.ReceiveBufferSink(){

        @Override
        public boolean onRecvDownStream(int n2, byte[] object) {
            MiLinkLog.e("MiLinkReceive", "SessionForSimpleChannel\uff1a  ".concat(String.valueOf(n2)));
            if (object == null) {
                return false;
            }
            PacketData packetData = null;
            try {
                packetData = StreamUtil.getDownPacket(String.format("[No:%d]", n2), object, new StreamUtil.GetAccountAdapter(){

                    @Override
                    public IAccount getAccount(int n2) {
                        return SessionForSimpleChannel.this.accountManager.getCurrentAccount();
                    }
                });
            }
            catch (IOException iOException) {
                MiLinkLog.e(SessionForSimpleChannel.this.mLogTag, "decode downstream failed", iOException);
            }
            if (packetData == null) {
                return false;
            }
            long l2 = SystemClock.elapsedRealtime();
            SessionForSimpleChannel.this.mLastReceivedPacketTime = l2;
            SessionForSimpleChannel.this.mNeedClientInfo = !packetData.hasClientInfo();
            MiLinkLog.v(SessionForSimpleChannel.this.mLogTag, " onRecvDownStream cmd=" + packetData.getCommand() + " mnscode=" + packetData.getMnsCode() + " seq=" + packetData.getSeqNo() + " and set mNeedClientInfo=" + SessionForSimpleChannel.this.mNeedClientInfo);
            TrafficMonitor.getInstance().traffic(packetData.getCommand(), ((byte[])object).length);
            Request request = (Request)SessionForSimpleChannel.this.mPendingStatisticTimeoutedRequestMap.remove(packetData.getSeqNo());
            Request request2 = (Request)SessionForSimpleChannel.this.mRequestMap.get(packetData.getSeqNo());
            object = request2;
            if (request2 != null) {
                SessionForSimpleChannel.this.mRequestMap.remove(packetData.getSeqNo());
                if (SessionForSimpleChannel.this.isFastCheckPing((Request)object)) {
                    SessionForSimpleChannel.this.mLastReceivedFastPingTime = SystemClock.elapsedRealtime();
                    Global.getMainHandler().removeCallbacks(SessionForSimpleChannel.this.mHandlePendingStatisticTimeoutedRunnable);
                    Global.getMainHandler().postAtFrontOfQueue(SessionForSimpleChannel.this.mHandlePendingStatisticTimeoutedRunnable);
                }
            } else if (request != null) {
                object = request;
            }
            SessionForSimpleChannel.this.mRecvDataProcessUtil.selectHandleUtil(packetData, (Request)object).handle();
            if (SessionForSimpleChannel.this.mRequestMap.isEmpty()) {
                SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.RequestMapIsEmpty, SessionForSimpleChannel.this));
            }
            return true;
        }

        @Override
        public boolean onAddTimeout(int n2, int n3) {
            return false;
        }
    };
    private Runnable mHandlePendingStatisticTimeoutedRunnable = new Runnable(){

        @Override
        public void run() {
            SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.StatisticsTimeoutPacket, SessionForSimpleChannel.this));
        }
    };
    private ResponseListener mChannelFastLoginRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData object) {
            SessionForSimpleChannel.this.mIsFastLogining = false;
            StatisticsLog.end("fast_login_success");
            StatisticsLog.begin("fast_login_success_handle");
            if (!SessionForSimpleChannel.this.accountManager.isChannelModCurrent()) {
                MiLinkLog.i(SessionForSimpleChannel.this.mLogTag, "current is not channel mode " + SessionForSimpleChannel.this.accountManager.getCurrentAccountType());
                return;
            }
            MiLinkLog.v(SessionForSimpleChannel.this.mLogTag, "channel fastlogin response mns code: " + ((PacketData)object).getMnsCode());
            if (((PacketData)object).getMnsCode() == 0) {
                Object object2 = null;
                try {
                    object2 = SystemPacketProto.MnsCmdChannelRsp.parseFrom(((PacketData)object).getData());
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
                if (object2 == null) {
                    MiLinkLog.w(SessionForSimpleChannel.this.mLogTag, "chanel fastlogin response = null");
                    SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LoginFailed, SessionForSimpleChannel.this, 998));
                    return;
                }
                if (((SystemPacketProto.MnsCmdChannelRsp)object2).getB2() != null && ((SystemPacketProto.MnsCmdChannelRsp)object2).getGTKEYB2() != null) {
                    SessionForSimpleChannel.this.accountManager.getCurrentAccount().loginMiLink(((SystemPacketProto.MnsCmdChannelRsp)object2).getB2().toByteArray(), ((SystemPacketProto.MnsCmdChannelRsp)object2).getGTKEYB2().toByteArray());
                } else {
                    MiLinkLog.w(SessionForSimpleChannel.this.mLogTag, "channel fastlogin response.getB2() = null or response.getGTKEYB2() = null");
                }
                object2 = String.valueOf(((SystemPacketProto.MnsCmdChannelRsp)object2).getWid());
                MiLinkLog.w(SessionForSimpleChannel.this.TAG, "userId=" + (String)object2 + ",accountManager.getCurrentAccount():" + SessionForSimpleChannel.this.accountManager.getCurrentAccount());
                SessionForSimpleChannel.this.accountManager.getCurrentAccount().setUserId((String)object2);
                try {
                    object = DataExtraProto.DataAnonymousWid.newBuilder();
                    ((DataExtraProto.DataAnonymousWid.Builder)object).setWid(Long.valueOf((String)object2));
                    PacketData packetData = new PacketData();
                    packetData.setCommand("data.channel.anonymouswid");
                    packetData.setData(((DataExtraProto.DataAnonymousWid.Builder)object).build().toByteArray());
                    MnsPacketDispatcher.getInstance().dispatchPacket(packetData);
                    MiLinkLog.d(SessionForSimpleChannel.this.TAG, " dispwid to app success wid = ".concat(String.valueOf(object2)));
                }
                catch (Exception exception) {}
                MiLinkLog.w(SessionForSimpleChannel.this.TAG, "wid=".concat(String.valueOf(object2)));
                SessionForSimpleChannel.this.sessionManager.processEvent(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LoginSuccess, SessionForSimpleChannel.this, 0));
                return;
            }
            SessionForSimpleChannel.this.sessionManager.processEvent(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LoginFailed, SessionForSimpleChannel.this, ((PacketData)object).getMnsCode()));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            SessionForSimpleChannel.this.mIsFastLogining = false;
            if (!SessionForSimpleChannel.this.accountManager.isChannelModCurrent()) {
                MiLinkLog.i(SessionForSimpleChannel.this.mLogTag, "failed current is not channel mode " + SessionForSimpleChannel.this.accountManager.getCurrentAccountType());
                return;
            }
            MiLinkLog.i(SessionForSimpleChannel.this.mLogTag, "channel fastlogin onDataSendFailed errCode= " + n2 + ", errMsg=" + string2);
            SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LoginFailed, SessionForSimpleChannel.this, n2));
        }
    };
    private ResponseListener mLogoffRspListener = new ResponseListener(){

        @Override
        public void onDataSendSuccess(int n2, PacketData packetData) {
            SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LogoffCmdReturn, SessionForSimpleChannel.this, 0));
        }

        @Override
        public void onDataSendFailed(int n2, String string2) {
            SessionForSimpleChannel.this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionLoginEvent(MiLinkEventForSimpleChannel.SessionLoginEvent.EventType.LogoffCmdReturn, SessionForSimpleChannel.this, 0));
        }
    };
    private boolean mIsHandshakeRequestFailed = false;
    private OpenSessionSucessReturnInfo mOpenSessionSucessReturnInfo;
    private String mClientIp = "";
    private String mClientIsp = "";

    public boolean isFastLogining() {
        return this.mIsFastLogining;
    }

    public SessionManagerForSimpleChannel getSessionManagerForSimpleChannel() {
        return this.sessionManager;
    }

    public SessionForSimpleChannel(SessionManagerForSimpleChannel sessionManagerForSimpleChannel, MiChannelAccountManager miChannelAccountManager, int n2) {
        this.TAG = this.TAG + n2;
        this.mSessionNO = SessionConst.generateSessionNO();
        this.mLogTag = String.format("[No:%d]", this.mSessionNO) + this.TAG;
        this.mConn = new TcpConnection(this.mSessionNO, this);
        this.mServerProfile = null;
        this.mRecBuffer = new ReceiveBuffer(this.mRecBufSink, this.mSessionNO, true);
        this.mCurState = 0;
        this.sessionManager = sessionManagerForSimpleChannel;
        this.accountManager = miChannelAccountManager;
        this.appId = n2;
    }

    @Override
    public int getSessionNO() {
        return this.mSessionNO;
    }

    @Override
    public long getOpenSessionTimecost() {
        return this.mOpenSessionDoneTime - this.mConnectStartTime;
    }

    @Override
    public long getDnsWaitTime() {
        return this.mDnsWaitTime;
    }

    @Override
    public boolean openSession(ServerProfile serverProfile) {
        StatisticsLog.begin("open_session_init_no_" + this.mSessionNO);
        this.resetContinuousRecv110Count();
        this.mIsHandshakeRequestFailed = false;
        this.mNeedClientInfo = true;
        if (serverProfile == null || serverProfile.getProtocol() == 0) {
            MiLinkLog.v(this.mLogTag, "openSession fail, serverprofile=".concat(String.valueOf(serverProfile)));
            this.onOpenSessionBuildConnectFail(557);
            return false;
        }
        this.mCurState = 1;
        boolean bl2 = false;
        this.mLastSendFastCheckPingTime = 0L;
        if (this.mServerProfile == null || this.mServerProfile.getProtocol() != serverProfile.getProtocol()) {
            MiLinkLog.v(this.mLogTag, "openSession if");
            this.mServerProfile = serverProfile;
            try {
                bl2 = this.mConn.start();
            }
            catch (Exception exception) {
                MiLinkLog.e(this.mLogTag, "connection start failed", exception);
            }
            if (!bl2) {
                this.onOpenSessionBuildConnectFail(562);
                return false;
            }
        } else {
            MiLinkLog.v(this.mLogTag, "openSession else");
            if (this.mConn == null && serverProfile.getProtocol() == 1) {
                this.mConn = new TcpConnection(this.mSessionNO, this);
            }
            if (!this.mConn.isRunning()) {
                this.mServerProfile = serverProfile;
                try {
                    bl2 = this.mConn.start();
                }
                catch (Exception exception) {
                    MiLinkLog.e(this.mLogTag, "connection start failed", exception);
                }
                if (!bl2) {
                    this.onOpenSessionBuildConnectFail(562);
                    return false;
                }
            }
        }
        this.mServerProfile = serverProfile;
        this.postMessage(1, null, 0);
        StatisticsLog.end("open_session_init_no_" + this.mSessionNO);
        return true;
    }

    @Override
    public ServerProfile getServerProfile() {
        return this.mServerProfile;
    }

    @Override
    public ServerProfile getServerProfileForStatistic() {
        return this.mServerProfileForStatistic;
    }

    @Override
    public boolean isAvailable() {
        switch (this.mCurState) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        switch (this.mCurState) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleRequest(Request request) {
        if (request == null) {
            MiLinkLog.e(this.mLogTag, "handleRequest request == null");
            return false;
        }
        MiLinkLog.v(this.mLogTag, "handleRequest seq=" + request.getSeqNo() + " mNeedClientInfo=" + this.mNeedClientInfo + " " + this.mServerProfile);
        request.setHandleSessionNO(this.mSessionNO);
        boolean bl2 = this.postMessage(2, request, 0);
        if (this.mConn != null) {
            this.mConn.wakeUp();
        }
        if (!this.sessionManager.isTimerOpen()) {
            this.sessionManager.onEvent(new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.RequestMapIsNotEmpty, this));
        }
        return bl2;
    }

    @Override
    public void fastLogin() {
        StatisticsLog.begin("fast_login_init");
        Object object = null;
        switch (this.accountManager.getCurrentAccountType()) {
            case 2: {
                object = SystemPacketProto.MnsCmdChannelReq.newBuilder();
                ((SystemPacketProto.MnsCmdChannelReq.Builder)object).setPrivacyKey(this.accountManager.getCurrentAccount().getPrivacyKey());
                ((SystemPacketProto.MnsCmdChannelReq.Builder)object).setDeviceinfo(DeviceDash.getInstance().getDeviceSimplifiedInfo());
                PacketData packetData = new PacketData();
                packetData.setSeqNo(Global.getSequence());
                packetData.setData(((SystemPacketProto.MnsCmdChannelReq.Builder)object).build().toByteArray());
                ((SystemPacketProto.MnsCmdChannelReq.Builder)object).getDeviceinfo();
                packetData.setCommand("milink.channel");
                StatisticsLog.end("fast_login_init");
                StatisticsLog.begin("fast_login_success");
                object = new Request(packetData, this.mChannelFastLoginRspListener, 9, this.accountManager.getCurrentAccount());
                MiLinkLog.v(this.mLogTag, "start channel fastlogin, seq=" + ((Request)object).getSeqNo());
            }
        }
        ((Request)object).setInternal(true);
        this.mIsFastLogining = true;
        this.handleRequest((Request)object);
        this.accountManager.setIsLogining(true);
    }

    private boolean postMessage(int n2, Object object, int n3) {
        boolean bl2;
        if (this.mConn == null) {
            MiLinkLog.e(this.mLogTag, "postMessage " + n2 + " mConn == null!!!!");
            return false;
        }
        try {
            bl2 = this.mConn.postMessage(n2, object, n3, this);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (!bl2) {
            MiLinkLog.e(this.mLogTag, "mMessage must be full ! uMsg = ".concat(String.valueOf(n2)));
            return bl2;
        }
        return bl2;
    }

    @Override
    public synchronized boolean close() {
        return super.close();
    }

    @Override
    public void disConnect() {
        this.disConnect(-1);
    }

    @Override
    public void disConnect(int n2) {
        MiLinkLog.i(this.mLogTag, "disConnect, errorCallBackErrorCode=".concat(String.valueOf(n2)));
        this.postMessage(4, null, n2);
    }

    @Override
    public void onMsgProc(int n2, Object object, int n3) {
        MiLinkLog.v(this.mLogTag, "onMsgProc, uMsg=" + n2 + ", wParam=" + n3);
        switch (n2) {
            case 1: {
                String string2;
                StatisticsLog.begin("session_connect_success_no_" + this.mSessionNO);
                if (this.mServerProfile == null) {
                    MiLinkLog.e(this.mLogTag, "OnMsgProc mServerProfile == null!!!");
                    this.onOpenSessionBuildConnectFail(1);
                    return;
                }
                this.mServerProfileForStatistic = this.mServerProfile;
                long l2 = SystemClock.elapsedRealtime();
                object = MiLinkIpInfoManager.getInstance().getDefaultHost();
                if (this.mServerProfile.getServerIP().equals(object)) {
                    string2 = DomainManager.getInstance().getDomainIP(this.mServerProfile.getServerIP());
                    if (string2 == null) {
                        this.onOpenSessionBuildConnectFail(1);
                        return;
                    }
                    this.mServerProfile.setServerIP(string2);
                } else {
                    string2 = this.mServerProfile.getServerIP();
                }
                MiLinkLog.e(this.mLogTag, "connect to " + this.mServerProfile);
                this.mConnectStartTime = SystemClock.elapsedRealtime();
                this.mDnsWaitTime = this.mConnectStartTime - l2;
                if (this.mConn != null) {
                    this.mCanClose = false;
                    this.mConn.connect(string2, this.mServerProfile.getServerPort(), this.mServerProfile.getProxyIP(), this.mServerProfile.getPorxyPort(), ConfigManager.getInstance().getConnetionTimeout(), 0);
                }
                return;
            }
            case 2: {
                Request request = (Request)object;
                if (request == null) {
                    return;
                }
                if (!request.isValidNow()) {
                    MiLinkLog.e(this.mLogTag, String.format("seq=%d, cmd=%s is invalid", request.getSeqNo(), request.getData().getCommand()));
                    this.mRequestMap.remove(request.getSeqNo());
                    request.onDataSendFailed(998, "package is already over the valid time");
                    return;
                }
                request.setSentTime(SystemClock.elapsedRealtime());
                PacketData packetData = request.getData();
                String string3 = packetData.getCommand();
                if ("milink.fastlogin".equals(string3) || "milink.anonymous".equals(string3)) {
                    this.mNeedClientInfo = true;
                    MiLinkLog.v(this.mLogTag, "set mNeedClientInfo=true when send login or fastlogin");
                }
                packetData.setNeedClientInfo(this.mNeedClientInfo);
                object = request.toBytes();
                if (packetData.needResponse()) {
                    this.mRequestMap.put(request.getSeqNo(), request);
                }
                if (this.isFastCheckPing(request)) {
                    this.mLastSendFastCheckPingTime = SystemClock.elapsedRealtime();
                    Global.getMainHandler().postDelayed(this.mHandlePendingStatisticTimeoutedRunnable, 5200L);
                }
                if (object != null) {
                    MiLinkLog.v(this.mLogTag, "connection send data, seq=" + request.getSeqNo());
                    if (this.mConn.sendData((byte[])object, request.getSeqNo(), request.getTimeOut())) {
                        TrafficMonitor.getInstance().traffic(string3, ((Object)object).length);
                        return;
                    }
                } else {
                    this.mRequestMap.remove(request.getSeqNo());
                    request.onDataSendFailed(518, "data encryption failed");
                    MiLinkLog.w(this.mLogTag, "connection send data, but data = null");
                }
                return;
            }
            case 3: {
                this.checkIsReadTimeOut();
                return;
            }
            case 4: {
                if (this.mConn != null) {
                    this.mConn.disconnect();
                }
                this.mCurState = 0;
                if (n3 <= 0) break;
                this.onSessionError(n3);
                return;
            }
            case 5: {
                this.handlePendingStatisticTimeoutedRequestMap();
                return;
            }
            default: {
                MiLinkLog.e(this.mLogTag, "OnMsgProc unknow uMsgID = ".concat(String.valueOf(n2)));
            }
        }
    }

    @Override
    public void logoff() {
        Object object = SystemPacketProto.MnsCmdLoginOff.newBuilder();
        if (!TextUtils.isEmpty((CharSequence)ConfigManager.getInstance().getSuid())) {
            ((SystemPacketProto.MnsCmdLoginOff.Builder)object).setSUID(ConfigManager.getInstance().getSuid());
        }
        object = ((SystemPacketProto.MnsCmdLoginOff.Builder)object).build();
        PacketData packetData = new PacketData();
        packetData.setNeedResponse(false);
        packetData.setCommand("milink.loginoff");
        packetData.setSeqNo(Global.getSequence());
        packetData.setData(((AbstractMessageLite)object).toByteArray());
        object = new Request(packetData, this.mLogoffRspListener, 8, this.accountManager.getCurrentAccount());
        ((Request)object).setInternal(true);
        MiLinkLog.v(this.mLogTag, "start logoff, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
    }

    @Override
    public boolean onStart() {
        return false;
    }

    @Override
    public boolean onConnect(boolean bl2, int n2) {
        StatisticsLog.end("session_connect_success_no_" + this.mSessionNO);
        this.mCanClose = true;
        MiLinkLog.d(this.mLogTag, "=======> isSuccess=".concat(String.valueOf(bl2)));
        if (bl2) {
            this.onOpenSessionBuildConnectSuccess();
        } else {
            this.onOpenSessionBuildConnectFail(n2);
        }
        return true;
    }

    @Override
    public boolean onDisconnect() {
        MiLinkLog.i(this.mLogTag, "OnDisconnect");
        if (this.mRecBuffer != null) {
            this.mRecBuffer.reset();
        }
        for (Object object : this.mRequestMap.keySet()) {
            if ((object = (Request)this.mRequestMap.get(object)) == null) continue;
            MiLinkLog.e(this.mLogTag, "Const.InternalErrorCode.CONNECT_FAIL, seq=" + ((Request)object).getSeqNo() + ",cmd=" + ((Request)object).getData().getCommand());
            if (((Request)object).canRetry()) {
                ((Request)object).setHasRetry();
                MiLinkLog.e(this.mLogTag, "seq=" + ((Request)object).getSeqNo() + ",cmd=" + ((Request)object).getData().getCommand() + " will be retry send from onDisconnect.");
                MiLinkEventForSimpleChannel.SessionOtherEvent sessionOtherEvent = new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.PackageNeedRetry, this);
                new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.PackageNeedRetry, this).obj = object;
                this.sessionManager.getChannelEventBus().post(sessionOtherEvent);
                continue;
            }
            ((Request)object).onDataSendFailed(516, "native network broken");
        }
        this.mRequestMap.clear();
        this.handlePendingStatisticTimeoutedRequestMap();
        this.mPendingStatisticTimeoutedRequestMap.clear();
        return true;
    }

    @Override
    public boolean onError(int n2) {
        if (this.mIsHandshakeRequestFailed) {
            MiLinkLog.e(this.mLogTag, "onError but handshake failed has already notice SM, socketStatus:" + n2 + ", mCurState=" + this.mCurState);
            this.mIsHandshakeRequestFailed = false;
            return true;
        }
        MiLinkLog.e(this.mLogTag, "onError socketStatus " + n2 + ", mCurState=" + this.mCurState);
        switch (this.mCurState) {
            case 0: 
            case 1: 
            case 2: {
                this.onOpenSessionBuildConnectFail(1);
                break;
            }
            case 3: {
                if (n2 == 526) {
                    this.onOpenSessionHandshakeFail(3);
                    break;
                }
                this.onOpenSessionHandshakeFail(2);
                break;
            }
            case 4: {
                this.onSessionError(n2);
                break;
            }
            default: {
                MiLinkLog.e(this.mLogTag, "onError wrong state = " + this.mCurState);
            }
        }
        return true;
    }

    @Override
    public boolean onTimeOut(int n2, int n3) {
        MiLinkLog.v(this.mLogTag, "send time out: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onRecv(byte[] byArray) {
        MiLinkLog.v(this.mLogTag, "recv data:" + byArray.length);
        if (this.mRecBuffer == null) {
            this.mRecBuffer = new ReceiveBuffer(this.mRecBufSink, this.mSessionNO, true);
        }
        try {
            this.mRecBuffer.append(byArray);
        }
        catch (InvalidPacketExecption invalidPacketExecption) {
            this.disConnect(517);
            if (invalidPacketExecption.errCode == 1) {
                this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.RecvInvalidPacket, this));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean onSendBegin(int n2) {
        MiLinkLog.v(this.mLogTag, "send begin: seq=".concat(String.valueOf(n2)));
        return false;
    }

    @Override
    public boolean onSendEnd(int n2) {
        MiLinkLog.v(this.mLogTag, "send end: seq=".concat(String.valueOf(n2)));
        return false;
    }

    private void onOpenSessionBuildConnectFail(int n2) {
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        MiLinkLog.v(this.mLogTag, "onOpenSessionBuildConnectFail");
        this.mCurState = 0;
        this.sessionManager.onEvent(new MiLinkEventForSimpleChannel.SessionConnectEvent(MiLinkEventForSimpleChannel.SessionConnectEvent.EventType.SessionBuildFailed, this, n2));
    }

    protected void onOpenSessionBuildConnectSuccess() {
        StatisticsLog.begin("hand_shake_init_no_" + this.mSessionNO);
        this.mCurState = 2;
        SessionForSimpleChannel sessionForSimpleChannel = this;
        sessionForSimpleChannel.handShake(sessionForSimpleChannel.accountManager.getCurrentAccount());
    }

    @Override
    protected void onOpenSessionHandshakeFail(int n2) {
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        this.mCurState = 2;
        this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionConnectEvent(MiLinkEventForSimpleChannel.SessionConnectEvent.EventType.SessionBuildFailed, this, n2));
    }

    @Override
    public OpenSessionSucessReturnInfo getOpenSessionSucessReturnInfo() {
        return this.mOpenSessionSucessReturnInfo;
    }

    @Override
    protected void onOpenSessionHandshakeSuccess(OpenSessionSucessReturnInfo openSessionSucessReturnInfo) {
        MiLinkLog.e(this.TAG, "onOpenSessionHandshakeSuccess channel send event begin");
        this.mOpenSessionDoneTime = SystemClock.elapsedRealtime();
        this.mCurState = 4;
        this.mOpenSessionSucessReturnInfo = openSessionSucessReturnInfo;
        this.sessionManager.onEvent(new MiLinkEventForSimpleChannel.SessionConnectEvent(MiLinkEventForSimpleChannel.SessionConnectEvent.EventType.SessionBuildSuccess, this, 0));
        MiLinkLog.e(this.TAG, "onOpenSessionHandshakeSuccess channel send event end");
    }

    private void onSessionError(int n2) {
        this.mCurState = 0;
        this.sessionManager.onEvent(new MiLinkEventForSimpleChannel.SessionConnectEvent(MiLinkEventForSimpleChannel.SessionConnectEvent.EventType.SessionRunError, this, n2));
    }

    @Override
    public boolean checkRequestsTimeout() {
        if (this.shouldCheckRequestsTimeout()) {
            return this.postMessage(3, null, 0);
        }
        this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.RequestMapIsEmpty, this));
        return false;
    }

    @Override
    public boolean shouldCheckRequestsTimeout() {
        return this.isConnected() && !this.mRequestMap.isEmpty();
    }

    private void fastCheckPing() {
        Object object = new PacketData();
        ((PacketData)object).setCommand("milink.ping");
        ((PacketData)object).setSeqNo(Global.getSequence());
        object = new Request((PacketData)object, null, 0, this.accountManager.getCurrentAccount());
        ((Request)object).setInternal(true);
        ((Request)object).setPing(true);
        ((Request)object).setTimeOut(5000);
        MiLinkLog.v(this.mLogTag, "start fast ping, seq=" + ((Request)object).getSeqNo());
        this.handleRequest((Request)object);
    }

    private boolean isFastCheckPing(Request request) {
        return request.isPingRequest() && request.getTimeOut() == 5000;
    }

    private void checkIsReadTimeOut() {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Iterator iterator = this.mRequestMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            Request request = (Request)this.mRequestMap.get(n2);
            if (request == null) continue;
            if (this.isFastCheckPing(request)) {
                bl2 = true;
                if (request.isTimeout()) {
                    bl3 = true;
                }
            }
            if (!request.isTimeout()) continue;
            if (request.getTimeOut() >= 10000) {
                bl4 = true;
            }
            this.mRequestMap.remove(n2);
            if (request.canRetry()) {
                request.setHasRetry();
                MiLinkLog.e(this.mLogTag, "seq=" + request.getSeqNo() + ",cmd=" + request.getData().getCommand() + " will be retry send from timeout check.");
                MiLinkEventForSimpleChannel.SessionOtherEvent sessionOtherEvent = new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.PackageNeedRetry, this);
                new MiLinkEventForSimpleChannel.SessionOtherEvent(MiLinkEventForSimpleChannel.SessionOtherEvent.EventType.PackageNeedRetry, this).obj = request;
                this.sessionManager.getChannelEventBus().post(sessionOtherEvent);
                continue;
            }
            MiLinkLog.e(this.mLogTag, "Request read time out, seq=" + request.getSeqNo() + ",cmd=" + request.getData().getCommand());
            request.onDataSendFailed(515, "request time out");
            this.mPendingStatisticTimeoutedRequestMap.put(request.getSeqNo(), request);
            request.onDataSendFailed(516, "native network broken");
        }
        if (bl4) {
            MiLinkLog.e(this.mLogTag, Device.Network.getCurrentNetworkDetailInfo().toString());
        }
        if (bl3 || bl4) {
            MiLinkLog.e(this.mLogTag, "checkIsReadTimeOut, fast ping timeout, reconnect");
            this.disConnect(515);
            return;
        }
        if (!bl2 && bl4) {
            this.fastCheckPing();
        }
    }

    private boolean isJustSentFastCheckPing() {
        return SystemClock.elapsedRealtime() - this.mLastSendFastCheckPingTime <= 10000L;
    }

    @Override
    public void postStatisticsTimeoutPacketAction() {
        this.postMessage(5, null, 0);
    }

    private void handlePendingStatisticTimeoutedRequestMap() {
        long l2 = SystemClock.elapsedRealtime();
        Iterator iterator = this.mPendingStatisticTimeoutedRequestMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            Request request = (Request)iterator.next().getValue();
            MiLinkLog.v(this.mLogTag, "handleTimeoutedRequest seq=" + request.getSeqNo());
            if (!this.isJustSentFastCheckPing()) break;
            if (this.mLastSendFastCheckPingTime > this.mLastReceivedFastPingTime) {
                if (request.getSentTime() >= this.mLastSendFastCheckPingTime) continue;
                MiLinkLog.e(this.mLogTag, "seq=" + request.getSeqNo() + " timeouted, ping also timeout,Reported 3");
                string2 = request.getData() == null ? "milink.ping" : request.getData().getCommand();
                InternalDataMonitor.getInstance(this.appId).trace(this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerIP() : "", this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerPort() : 0, string2, 3, request.getSentTime(), l2, request.getSize(), 0, request.getSeqNo());
                iterator.remove();
                continue;
            }
            MiLinkLog.e(this.mLogTag, "seq=" + request.getSeqNo() + " timeouted, ping not timeout,Reported 1");
            string2 = request.getData() == null ? "milink.ping" : request.getData().getCommand();
            InternalDataMonitor.getInstance(this.appId).trace(this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerIP() : "", this.mServerProfileForStatistic != null ? this.mServerProfileForStatistic.getServerPort() : 0, string2, 1, request.getSentTime(), l2, request.getSize(), 0, request.getSeqNo());
            iterator.remove();
        }
    }

    @Override
    public void onAccNeedRetryWithClientInfo(Request request) {
        MiLinkLog.w(this.TAG, "onAccNeedRetryWithClientInfo");
        this.mNeedClientInfo = true;
        if (request.getRetryCount() <= 0) {
            request.addRetryCount();
            this.handleRequest(request);
            return;
        }
        MiLinkLog.w(this.TAG, "try 118 too many times");
    }

    @Override
    public void addContinuousRecv110Count() {
        ++this.mContinuousRecv110Count;
    }

    @Override
    public void resetContinuousRecv110Count() {
        this.mContinuousRecv110Count = 0;
    }

    @Override
    public boolean checkExceedMaxContinuousRecv110Count() {
        MiLinkLog.v(this.mLogTag, "mContinuousRecv110Count = " + this.mContinuousRecv110Count);
        if (this.mContinuousRecv110Count >= 3) {
            this.sessionManager.getChannelEventBus().post(new MiLinkEventForSimpleChannel.ServerNotificationEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent.EventType.ServerLineBroken));
            return false;
        }
        return true;
    }

    @Override
    public String getClientIp() {
        return this.mClientIp;
    }

    @Override
    public String getClientIsp() {
        return this.mClientIsp;
    }

    @Override
    public boolean isDeadConnection(long l2, long l3) {
        return SystemClock.elapsedRealtime() - this.mLastReceivedPacketTime > l3;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        MiLinkLog.e(this.TAG, "session \u9500\u6bc1");
    }
}

