/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.session.simplechannel;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.mi.milink.sdk.account.manager.MiChannelAccountManager;
import com.mi.milink.sdk.aidl.PacketData;
import com.mi.milink.sdk.base.CustomHandlerThread;
import com.mi.milink.sdk.base.Global;
import com.mi.milink.sdk.base.os.Device;
import com.mi.milink.sdk.base.os.info.NetworkDash;
import com.mi.milink.sdk.base.os.info.WifiDash;
import com.mi.milink.sdk.config.MiLinkIpInfoManagerForSimpleChannel;
import com.mi.milink.sdk.data.Const;
import com.mi.milink.sdk.debug.InternalDataMonitor;
import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.debug.TrafficMonitor;
import com.mi.milink.sdk.event.MiLinkEventForSimpleChannel;
import com.mi.milink.sdk.proto.SystemPacketProto;
import com.mi.milink.sdk.session.common.IServerManager;
import com.mi.milink.sdk.session.common.OpenSessionSucessReturnInfo;
import com.mi.milink.sdk.session.common.Request;
import com.mi.milink.sdk.session.common.ResponseListener;
import com.mi.milink.sdk.session.common.ServerProfile;
import com.mi.milink.sdk.session.common.SessionConst;
import com.mi.milink.sdk.session.common.ThreadHelper;
import com.mi.milink.sdk.session.persistent.Session;
import com.mi.milink.sdk.session.sessionstate.SessionStateObserver;
import com.mi.milink.sdk.session.simplechannel.MiLinkBackupServerManagerForSimpleChannel;
import com.mi.milink.sdk.session.simplechannel.MiLinkServerManagerForSimpleChannel;
import com.mi.milink.sdk.session.simplechannel.SessionForSimpleChannel;
import com.mi.milink.sdk.session.simplechannel.UpdateChannelPubKeyValue;
import com.mi.milink.sdk.util.StatisticsLog;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class SessionManagerForSimpleChannel
extends CustomHandlerThread {
    private static String TAG_PRE = "SessionManagerForSimpleChannel_";
    private String TAG = "SessionManagerForSimpleChannel_";
    private static final int MSG_TYPE_SESSION_EVENT = 1;
    private static final int MSG_TYPE_SESSION_LOGIN_EVENT = 2;
    private static final int MSG_TYPE_SESSION_OTHER_EVENT = 3;
    private static final int MSG_TYPE_SERVER_NOTIFICATON_EVENT = 4;
    private static final int MSG_TYPE_CLIENT_ACTION_EVENT = 5;
    private static final int MSG_TYPE_SYSTEM_NOTIFICATION_EVENT = 6;
    private static final int MSG_CHECK_SESSION_TIMER = 20;
    private static final int MSG_TYPE_RELEASE_WAKE_LOCK = 22;
    private static final int MSG_TYPE_LOGIN_RETRY = 24;
    private static final int MSG_TYPE_SEND_MSG = 25;
    private static final int MSG_TYPE_APP_NOT_INIT = 26;
    private static final int NO_SESSION_STATE = 0;
    private static final int TRING_SESSION_STATE = 1;
    private static final int SINGLE_SESSION_STATE = 2;
    private static final int NOLOGIN_SESSION_STATE = 0;
    private static final int LOGINED_SESSION_STATE = 2;
    public static final int MILINK_OPEN_RET_CODE_OK = 0;
    public static final int MILINK_OPEN_RET_CODE_FAIL = 1;
    public static final int MILINK_OPEN_RET_CODE_NO_ROUTE = 2;
    public static final int MILINK_OPEN_RET_CODE_REFUSED = 3;
    public static final int MILINK_OPEN_RET_CODE_NETWORK_CHANGE = 4;
    public static final int MILINK_OPEN_RET_CODE_NET_UNREACHABLE = 5;
    public static final int MILINK_OPEN_RET_CODE_ALL_TIME_OUT = 6;
    public static final int MILINK_OPEN_RET_CODE_MULTI_UNAVAILABLE = 7;
    public static final int MILINK_OPEN_RET_CODE_PERMISSION_DENIED = 8;
    public static final int MILINK_OPEN_RET_CODE_LOAD_SO_FAILED = 9;
    private static final int ERRNO_PERMISSION_DENIED = 13;
    private static final int ERRNO_NET_UNREACHABLE = 101;
    private static final int ERRNO_CONNECT_TIME_OUT = 110;
    private static final int ERRNO_REFUSED = 111;
    private static final int ERRNO_NO_ROUTE = 113;
    private static final int OPEN_SESSION_TRY_TIMES = 2;
    private static final int LOGIN_TRY_TIMES = 5;
    private static final int SESSION_RECONNECT_TIMES = 2;
    private static final int CHECK_SESSION_INTERVAL = 3000;
    private boolean mCheckTimeOutTimerOpen = false;
    private static final int CHECK_WAKE_LOCK_TIMEOUT = 5;
    private static final int AUTO_INTERNAL_OPEN_DELAY = 3000;
    private final ConcurrentLinkedQueue<Request> mSendQueue = new ConcurrentLinkedQueue();
    private static final int FLAG_TRTING_SESSION = 1;
    private static final int FLAG_ABANDON_SESSION = 3;
    private static final int FLAG_MASTER_SESSION = 4;
    private final List<SessionForSimpleChannel> mSessionList = Collections.synchronizedList(new ArrayList());
    private final HashMap<String, Integer> mSessionAddress2ErrorCodeMap = new HashMap();
    private SessionForSimpleChannel mMasterSession;
    private IServerManager mServerManager = null;
    private IServerManager mServerManagerNormal = null;
    private IServerManager mServerManagerBackup = null;
    private PowerManager.WakeLock mWakeLock = null;
    private NetworkChangeReceiver mNetworkReveiver = null;
    private Device.Network.NetworkDetailInfo mNetworkDetailInfoOnOpen;
    private Object mLock = null;
    private int mState = 0;
    private int mLoginState = 0;
    private boolean mEnableConnectionManualMode = false;
    private int mOpenSessionTryTimes = 0;
    private int mSessionReconnectTryTimes = 0;
    private int mLoginTryTimes = 0;
    private boolean mAppInited = false;
    private long mOpenStartTime = 0L;
    private MiChannelAccountManager accountManager;
    private MiLinkIpInfoManagerForSimpleChannel ipInfoManage;
    private EventBus channelEventbus;
    private int appId;
    private SessionStateObserver mStateObserver;
    private Runnable mInternalAutoOpenRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "internalAutoOpen mOpenSessionTryTimes=" + SessionManagerForSimpleChannel.this.mOpenSessionTryTimes + ",mState=" + SessionManagerForSimpleChannel.this.mState);
            if (SessionManagerForSimpleChannel.this.mOpenSessionTryTimes < 2 && SessionManagerForSimpleChannel.this.mState == 0) {
                SessionManagerForSimpleChannel.this.mOpenSessionTryTimes++;
                SessionManagerForSimpleChannel.this.internalOpen();
            }
        }
    };
    private Runnable mTryStopTimerRunnable = new Runnable(){

        @Override
        public void run() {
            if (!SessionManagerForSimpleChannel.this.mCheckTimeOutTimerOpen) {
                return;
            }
            boolean bl2 = true;
            if (SessionManagerForSimpleChannel.this.mMasterSession != null && SessionManagerForSimpleChannel.this.mMasterSession.shouldCheckRequestsTimeout()) {
                bl2 = false;
            }
            if (bl2) {
                for (SessionForSimpleChannel sessionForSimpleChannel : SessionManagerForSimpleChannel.this.mSessionList) {
                    int n2 = sessionForSimpleChannel.mFlagForSessionManager;
                    if (n2 != 1 && n2 != 4 || !sessionForSimpleChannel.shouldCheckRequestsTimeout()) continue;
                    bl2 = false;
                    break;
                }
            }
            if (bl2) {
                MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "all session request map is empty, stopTimer");
                SessionManagerForSimpleChannel.this.stopTimer();
            }
        }
    };
    private Object mReportLock = new Object();
    long mLastUserSendDataTime = System.currentTimeMillis();
    private boolean isFirstFail = false;
    private Runnable mClearConnRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "milink clearConn run");
            SessionManagerForSimpleChannel.this.accountManager.logoff();
            SessionManagerForSimpleChannel.this.close();
            SessionManagerForSimpleChannel.this.resetAllTryTimes();
            SessionManagerForSimpleChannel.this.mSendQueue.clear();
        }
    };
    private Runnable mLogoffRunnable = new Runnable(){

        @Override
        public void run() {
            MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "======> milink mLogoffRunnable run");
            SessionManagerForSimpleChannel.this.internalClose();
            SessionManagerForSimpleChannel.this.accountManager.logoff();
            SessionManagerForSimpleChannel.this.resetAllTryTimes();
            SessionManagerForSimpleChannel.this.mSendQueue.clear();
            if (SessionManagerForSimpleChannel.this.mMasterSession != null) {
                SessionManagerForSimpleChannel.this.mMasterSession.logoff();
            }
            if (SessionManagerForSimpleChannel.this.mHandlerThread != null) {
                SessionManagerForSimpleChannel.this.mHandlerThread.quitSafely();
            }
        }
    };

    public EventBus getChannelEventBus() {
        if (this.channelEventbus != null && !this.channelEventbus.isRegistered(this)) {
            this.channelEventbus.register(this);
        }
        return this.channelEventbus;
    }

    private boolean isMultiUnavailable() {
        if (this.mSessionAddress2ErrorCodeMap.isEmpty()) {
            return false;
        }
        for (String string2 : this.mSessionAddress2ErrorCodeMap.keySet()) {
            Integer object = this.mSessionAddress2ErrorCodeMap.get(string2);
            if (object != null && (object == 111 || object == 101 || object == 113 || object == 110)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllSessionErrorCode(int n2) {
        if (this.mSessionAddress2ErrorCodeMap.isEmpty()) {
            return false;
        }
        for (String string2 : this.mSessionAddress2ErrorCodeMap.keySet()) {
            Integer object = this.mSessionAddress2ErrorCodeMap.get(string2);
            if (object != null && object == n2) continue;
            return false;
        }
        return true;
    }

    public void initApp() {
        this.mAppInited = true;
        this.resetAllTryTimes();
    }

    public SessionManagerForSimpleChannel(EventBus eventBus, MiChannelAccountManager miChannelAccountManager, int n2) {
        super(TAG_PRE);
        long l2 = SystemClock.elapsedRealtime();
        this.TAG = this.TAG + n2;
        this.appId = n2;
        MiLinkLog.w(this.TAG, "SessionManagerForSimpleChannel created, milinkversion=" + Global.getMiLinkVersion() + "_" + Global.getMiLinkSubVersion());
        long l3 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format("init 2_1 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        TrafficMonitor.getInstance().start();
        this.channelEventbus = eventBus;
        if (!this.channelEventbus.isRegistered(this)) {
            this.channelEventbus.register(this);
        }
        this.accountManager = miChannelAccountManager;
        this.ipInfoManage = new MiLinkIpInfoManagerForSimpleChannel(n2);
        this.mServerManagerNormal = new MiLinkServerManagerForSimpleChannel(this.ipInfoManage);
        this.mServerManagerBackup = new MiLinkBackupServerManagerForSimpleChannel(this.ipInfoManage);
        l2 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format("init 2_2 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
        this.mServerManager = this.mServerManagerNormal;
        this.initObserver();
        this.setState(0);
        this.mLock = new Object();
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: SessionManagerForSimpleChannel start");
                ((MiLinkServerManagerForSimpleChannel)SessionManagerForSimpleChannel.this.mServerManagerNormal).preLoad();
                SessionManagerForSimpleChannel.this.mNetworkReveiver = new NetworkChangeReceiver();
                SessionManagerForSimpleChannel.this.mNetworkReveiver.setCurrentNetworkInfo();
                Global.registerReceiver(SessionManagerForSimpleChannel.this.mNetworkReveiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: SessionManagerForSimpleChannel end");
            }
        });
        l3 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format("init 2_3 \u6d88\u8017\u65f6\u95f4\uff1a%s", l3 - l2));
        MiLinkLog.w(this.TAG, "SessionManager created finish");
        l2 = SystemClock.elapsedRealtime();
        Log.e((String)this.TAG, (String)String.format("init 2_4 \u6d88\u8017\u65f6\u95f4\uff1a%s", l2 - l3));
    }

    private void initObserver() {
        this.mStateObserver = new SessionStateObserver(new SessionStateObserver.ObserverListener(){

            @Override
            public void onEvent(SessionStateObserver.ObserverEvent observerEvent) {
                if (observerEvent == SessionStateObserver.ObserverEvent.BLOCKING) {
                    MiLinkLog.e("SessionStateObserver", "milink session \u72b6\u6001\u5f02\u5e38\uff0c\u5173\u95ed\u6240\u6709\u8fde\u63a5\uff0c\u91cd\u8fde");
                    SessionManagerForSimpleChannel.this.internalClose();
                    SessionManagerForSimpleChannel.this.internalManualOpen();
                }
            }
        });
    }

    public void addPacketInSendQueue(Request request) {
        this.mSendQueue.add(request);
        MiLinkLog.d(this.TAG, "add packet in send queue");
    }

    @Override
    protected void processMessage(Message object) {
        MiLinkLog.w(this.TAG, "processMessage +" + ((Message)object).what);
        MiLinkLog.e("MiLinkReceive", "sessionManagerForSimpleChannel processMessage msg.what:  " + ((Message)object).what);
        switch (((Message)object).what) {
            case 1: {
                this.processEvent((MiLinkEventForSimpleChannel.SessionConnectEvent)((Message)object).obj);
                return;
            }
            case 2: {
                this.processEvent((MiLinkEventForSimpleChannel.SessionLoginEvent)((Message)object).obj);
                return;
            }
            case 3: {
                this.processEvent((MiLinkEventForSimpleChannel.SessionOtherEvent)((Message)object).obj);
                return;
            }
            case 4: {
                this.processEvent((MiLinkEventForSimpleChannel.ServerNotificationEvent)((Message)object).obj);
                return;
            }
            case 5: {
                this.processEvent((MiLinkEventForSimpleChannel.ClientActionEvent)((Message)object).obj);
                return;
            }
            case 6: {
                this.processEvent((MiLinkEventForSimpleChannel.SystemNotificationEvent)((Message)object).obj);
                return;
            }
            case 20: {
                MiLinkLog.w(this.TAG, "MSG_CHECK_SESSION_TIMER");
                SessionForSimpleChannel sessionForSimpleChannel2 = this.getSession();
                if (sessionForSimpleChannel2 != null) {
                    sessionForSimpleChannel2.checkRequestsTimeout();
                }
                for (SessionForSimpleChannel sessionForSimpleChannel2 : this.mSessionList) {
                    if (sessionForSimpleChannel2.mFlagForSessionManager != 1) continue;
                    sessionForSimpleChannel2.checkRequestsTimeout();
                }
                this.getHandler().sendEmptyMessageDelayed(20, 3000L);
                return;
            }
            case 22: {
                MiLinkLog.w(this.TAG, "release wake lock");
                this.releaseWakeLock();
                return;
            }
            case 24: {
                this.login("LOGIN_RETRY");
                return;
            }
            case 26: {
                MiLinkLog.v(this.TAG, "MSG_TYPE_APP_NOT_INIT,app not init, call app init by onEventGetServiceToken");
                this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerNotificationEvent(MiLinkEventForSimpleChannel.SessionManagerNotificationEvent.EventType.GetServiceToken));
                return;
            }
            case 25: {
                SessionForSimpleChannel sessionForSimpleChannel = this.getSession();
                MiLinkLog.v(this.TAG, "send data, session manager state: " + this.mState);
                if (sessionForSimpleChannel != null && sessionForSimpleChannel.isDeadConnection(6000L, 180000L)) {
                    MiLinkLog.w(this.TAG, "session isDeadConnection=true");
                    this.setState(0);
                    sessionForSimpleChannel = null;
                }
                object = (Request)((Message)object).obj;
                if (sessionForSimpleChannel == null || !sessionForSimpleChannel.isAvailable() || this.mLoginState != 2) {
                    MiLinkLog.v(this.TAG, "push request in cache, seq=" + ((Request)object).getSeqNo());
                    this.mSendQueue.add((Request)object);
                    this.login("handleRequest");
                    return;
                }
                MiLinkLog.v(this.TAG, "send data to session, seq=" + ((Request)object).getSeqNo());
                sessionForSimpleChannel.handleRequest((Request)object);
            }
        }
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.SessionConnectEvent sessionConnectEvent) {
        MiLinkLog.v(this.TAG, "OnEvent SessionConnectEvent1 => " + (Object)((Object)sessionConnectEvent.mEventType));
        Message message = new Message();
        new Message().what = 1;
        message.obj = sessionConnectEvent;
        this.sendMessageDelayed(message, 50L);
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.SessionLoginEvent sessionLoginEvent) {
        sessionLoginEvent = this.getHandler().obtainMessage(2, (Object)sessionLoginEvent);
        this.sendMessage((Message)sessionLoginEvent);
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.SessionOtherEvent sessionOtherEvent) {
        sessionOtherEvent = this.getHandler().obtainMessage(3, (Object)sessionOtherEvent);
        this.sendMessage((Message)sessionOtherEvent);
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent serverNotificationEvent) {
        serverNotificationEvent = this.getHandler().obtainMessage(4, (Object)serverNotificationEvent);
        this.sendMessage((Message)serverNotificationEvent);
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.ClientActionEvent clientActionEvent) {
        clientActionEvent = this.getHandler().obtainMessage(5, (Object)clientActionEvent);
        this.sendMessage((Message)clientActionEvent);
    }

    @Subscribe
    public synchronized void onEvent(MiLinkEventForSimpleChannel.SystemNotificationEvent systemNotificationEvent) {
        systemNotificationEvent = this.getHandler().obtainMessage(6, (Object)systemNotificationEvent);
        this.sendMessage((Message)systemNotificationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processEvent(MiLinkEventForSimpleChannel.SessionConnectEvent object) {
        SessionForSimpleChannel sessionForSimpleChannel = ((MiLinkEventForSimpleChannel.SessionConnectEvent)object).mSession;
        int n2 = ((MiLinkEventForSimpleChannel.SessionConnectEvent)object).mRetCode;
        switch (((MiLinkEventForSimpleChannel.SessionConnectEvent)object).mEventType) {
            case SessionBuildFailed: {
                MiLinkLog.w(this.TAG, "SessionConnectEvent SessionBuildFailed");
                object = this.mReportLock;
                synchronized (object) {
                    this.mReportLock.notifyAll();
                }
                if (sessionForSimpleChannel.getServerProfileForStatistic() != null) {
                    object = String.format("%s:%s", sessionForSimpleChannel.getServerProfileForStatistic().getServerIP(), sessionForSimpleChannel.getServerProfileForStatistic().getServerPort());
                    this.mSessionAddress2ErrorCodeMap.put((String)object, n2);
                }
                if (this.isAbandonSession(sessionForSimpleChannel)) {
                    return;
                }
                MiLinkLog.w(this.TAG, "MSG_TYPE_OPEN_SESSION_FAIL errCode:".concat(String.valueOf(n2)));
                if (sessionForSimpleChannel.mFlagForSessionManager == 4) {
                    MiLinkLog.w(this.TAG, String.format("handleMessage MSG_TYPE_OPEN_SESSION_FAIL is mMasterSession No:%d, mState = %d", sessionForSimpleChannel.getSessionNO(), this.mState));
                    this.setState(0);
                    if (NetworkDash.isAvailable()) {
                        this.mInternalAutoOpenRunnable.run();
                    }
                    return;
                }
                if (sessionForSimpleChannel.mFlagForSessionManager == 1) {
                    MiLinkLog.w(this.TAG, String.format("handleMessage MSG_TYPE_OPEN_SESSION_FAIL is isTryingSession No:%d, mState = %d", sessionForSimpleChannel.getSessionNO(), this.mState));
                    this.getNextServerProfile(sessionForSimpleChannel, n2);
                    return;
                }
                MiLinkLog.e(this.TAG, "handleMessage MSG_TYPE_OPEN_SESSION_FAIL is unknown session No:" + sessionForSimpleChannel.getSessionNO());
                sessionForSimpleChannel.close();
                return;
            }
            case SessionBuildSuccess: {
                MiLinkLog.w(this.TAG, "SessionConnectEvent SessionBuildSuccess");
                if (this.isAbandonSession(sessionForSimpleChannel)) {
                    return;
                }
                MiLinkLog.v(this.TAG, "handleMessage OPEN_SESSION_SUCCESS No:" + sessionForSimpleChannel.getSessionNO());
                if (sessionForSimpleChannel.mFlagForSessionManager == 1 || sessionForSimpleChannel.mFlagForSessionManager == 4) {
                    MiLinkLog.v(this.TAG, "update session");
                    StatisticsLog.begin("update_session");
                    this.updateSession(sessionForSimpleChannel);
                    StatisticsLog.end("update_session");
                    object = this.mReportLock;
                    synchronized (object) {
                        this.mReportLock.notifyAll();
                        return;
                    }
                }
                sessionForSimpleChannel.close();
                MiLinkLog.e(this.TAG, "handleMessage OPEN_SESSION_SUCCESS is unknown session No:" + sessionForSimpleChannel.getSessionNO());
                return;
            }
            case SessionRunError: {
                MiLinkLog.w(this.TAG, "SessionConnectEvent SessionRunError");
                if (this.isAbandonSession(sessionForSimpleChannel)) {
                    return;
                }
                MiLinkLog.e(this.TAG, String.format("handleMessage SESSION_ERROR reason = %d, No:%d", n2, sessionForSimpleChannel.getSessionNO()));
                this.setState(0);
                if (n2 == 562) {
                    return;
                }
                if (NetworkDash.isAvailable()) {
                    MiLinkLog.e(this.TAG, " SESSION_ERROR mSessionReconnectTimes=" + this.mSessionReconnectTryTimes + ", mOpenSessionTryTimes=" + this.mOpenSessionTryTimes);
                    if (this.mSessionReconnectTryTimes < 2) {
                        if (n2 == 104) {
                            this.mOpenStartTime = SystemClock.elapsedRealtime();
                        }
                        MiLinkLog.e(this.TAG, "\u91cd\u65b0\u8bbe\u7f6e\u65f6\u95f4 : " + this.mOpenStartTime + " \u662f\u5426\u662f\u77ed\u8fde\u63a5\uff1a " + Global.getClientAppInfo().isMediumConnection() + " errCode : " + n2);
                        if (Global.getClientAppInfo().isMediumConnection()) break;
                        SessionManagerForSimpleChannel sessionManagerForSimpleChannel = this;
                        object = new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId);
                        new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId).mFlagForSessionManager = 1;
                        this.mSessionList.add((SessionForSimpleChannel)object);
                        this.setState(1);
                        ((SessionForSimpleChannel)object).openSession(sessionForSimpleChannel.getServerProfileForStatistic());
                        ++this.mSessionReconnectTryTimes;
                        return;
                    }
                    this.mInternalAutoOpenRunnable.run();
                    return;
                }
                MiLinkLog.e(this.TAG, "on seesion error network isAvailable = false");
            }
        }
    }

    public void processEvent(MiLinkEventForSimpleChannel.SessionLoginEvent sessionLoginEvent) {
        SessionForSimpleChannel sessionForSimpleChannel = sessionLoginEvent.mSession;
        if (this.isAbandonSession(sessionForSimpleChannel)) {
            return;
        }
        switch (sessionLoginEvent.mEventType) {
            case LoginFailed: {
                MiLinkLog.w(this.TAG, "SessionLoginEvent LoginFailed");
                this.accountManager.setIsLogining(false);
                this.mLoginState = 0;
                this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 0));
                this.getHandler().removeMessages(24);
                this.getHandler().sendEmptyMessageDelayed(24, 10000L);
                return;
            }
            case LoginSuccess: {
                MiLinkLog.w(this.TAG, "SessionLoginEvent LoginSuccess");
                this.accountManager.setIsLogining(false);
                this.mLoginState = 2;
                this.sendCacheRequest();
                MiLinkLog.v(this.TAG, "onLoginResult loginState=2");
                this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 2));
                this.addClearConnRunnalbe();
                StatisticsLog.end("fast_login_success_handle");
                return;
            }
            case LogoffCmdReturn: {
                MiLinkLog.w(this.TAG, "SessionLoginEvent LogoffCmdReturn");
                this.getHandler().removeCallbacks(this.mLogoffRunnable);
                this.mLogoffRunnable.run();
            }
        }
    }

    private void processEvent(MiLinkEventForSimpleChannel.SessionOtherEvent object) {
        SessionForSimpleChannel sessionForSimpleChannel = ((MiLinkEventForSimpleChannel.SessionOtherEvent)object).mSession;
        if (this.isAbandonSession(sessionForSimpleChannel)) {
            return;
        }
        switch (((MiLinkEventForSimpleChannel.SessionOtherEvent)object).mEventType) {
            case RecvInvalidPacket: {
                MiLinkLog.w(this.TAG, "SessionOtherEvent RecvInvalidPacket");
                this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerNotificationEvent(MiLinkEventForSimpleChannel.SessionManagerNotificationEvent.EventType.RecvInvalidPacket));
                return;
            }
            case RequestMapIsEmpty: {
                MiLinkLog.w(this.TAG, "SessionOtherEvent RequestMapIsEmpty");
                if (!this.mCheckTimeOutTimerOpen) {
                    return;
                }
                this.mTryStopTimerRunnable.run();
                return;
            }
            case RequestMapIsNotEmpty: {
                MiLinkLog.w(this.TAG, "SessionOtherEvent RequestMapIsNotEmpty");
                if (this.mCheckTimeOutTimerOpen) break;
                MiLinkLog.v(this.TAG, "mCheckTimeOutTimerOpen=false,startTimer");
                this.startTimer();
                return;
            }
            case StatisticsTimeoutPacket: {
                MiLinkLog.w(this.TAG, "SessionOtherEvent StatisticsTimeoutPacket");
                sessionForSimpleChannel.postStatisticsTimeoutPacketAction();
                return;
            }
            case PackageNeedRetry: {
                MiLinkLog.w(this.TAG, "SessionOtherEvent PackageNeedRetry");
                object = (Request)((MiLinkEventForSimpleChannel.SessionOtherEvent)object).obj;
                object = this.getHandler().obtainMessage(25, object);
                this.getHandler().sendMessageDelayed((Message)object, 2000L);
            }
        }
    }

    private void addChannelPubKeyQueue(Request request) {
        String string2 = request.getData().getCommand();
        if (!"milink.channel".equals(string2)) {
            this.addPacketInSendQueue(request);
        }
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void processEvent(MiLinkEventForSimpleChannel.ServerNotificationEvent hashMap) {
        switch (((MiLinkEventForSimpleChannel.ServerNotificationEvent)((Object)hashMap)).mEventType) {
            case B2tokenExpired: {
                MiLinkLog.w(this.TAG, "ServerNotificationEvent B2tokenExpired");
                this.accountManager.logoffMiLink();
                this.login("B2_TOKEN_EXPIRED");
                return;
            }
            case ChannelPubKeyUpdate: {
                MiLinkLog.e(this.TAG, "ServerNotificationEvent ChannelPubKeyUpdate");
                hashMap = (UpdateChannelPubKeyValue)((MiLinkEventForSimpleChannel.ServerNotificationEvent)((Object)hashMap)).mObject;
                Object object = ((UpdateChannelPubKeyValue)((Object)hashMap)).getChannelNewPubkey();
                this.addChannelPubKeyQueue(((UpdateChannelPubKeyValue)((Object)hashMap)).getmRequeset());
                hashMap = new HashMap<Integer, String>();
                if (object != null) {
                    object = ((SystemPacketProto.MnsCmdChannelNewPubKeyRsp)object).getPubInfoList().iterator();
                    while (object.hasNext()) {
                        Object object2 = (SystemPacketProto.PublicKeyInfo)object.next();
                        int n2 = ((SystemPacketProto.PublicKeyInfo)object2).getKeyId();
                        object2 = ((SystemPacketProto.PublicKeyInfo)object2).getPublicKey().toByteArray();
                        try {
                            hashMap.put(n2, new String((byte[])object2, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    this.accountManager.getCurrentAccount().setChannelPubKey(hashMap);
                    MiLinkLog.e(this.TAG, " onUpdateChannelPubKey update  " + hashMap.size() + " pubkey ");
                }
                if ((object = this.getSession()) == null || !((Session)object).isAvailable()) {
                    MiLinkLog.v(this.TAG, "login session is not available.");
                    return;
                }
                ((Session)object).fastLogin();
                return;
            }
            case ChannelDelPubKey: {
                hashMap = (Request)((MiLinkEventForSimpleChannel.ServerNotificationEvent)((Object)hashMap)).mObject;
                this.addChannelPubKeyQueue((Request)((Object)hashMap));
                this.accountManager.getCurrentAccount().DelChannelPubKey();
                SessionForSimpleChannel sessionForSimpleChannel = this.getSession();
                if (sessionForSimpleChannel == null || !((Session)sessionForSimpleChannel).isAvailable()) {
                    MiLinkLog.v(this.TAG, "login session is not available.");
                    return;
                }
                ((Session)sessionForSimpleChannel).fastLogin();
                return;
            }
            case ServerLineBroken: {
                MiLinkLog.e(this.TAG, "ServerNotificationEvent ServerLineBroken");
                this.setState(0);
                if (NetworkDash.isAvailable()) {
                    this.mServerManager = this.mServerManagerBackup;
                    this.internalOpen();
                    return;
                }
                MiLinkLog.e(this.TAG, "on server line broken network isAvailable = false");
            }
        }
    }

    private void processEvent(MiLinkEventForSimpleChannel.ClientActionEvent clientActionEvent) {
        switch (clientActionEvent.mEventType) {
            case ClientRequestCheckConnection: {
                MiLinkLog.w(this.TAG, "ClientActionEvent ClientRequestCheckConnection");
                this.tryConnectIfNeed();
                if (this.mState == 2) {
                    this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent.EventType.SessionStateChange, Integer.MIN_VALUE, 2));
                }
                if (this.mLoginState != 2) break;
                this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent.EventType.LoginStateChange, Integer.MIN_VALUE, 2));
                return;
            }
            case ClientRequestLogin: {
                MiLinkLog.w(this.TAG, "ClientActionEvent ClientRequestLogin");
                if (this.mNetworkReveiver != null) {
                    Global.unregisterReceiver(this.mNetworkReveiver);
                    Global.registerReceiver(this.mNetworkReveiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                }
                this.login("UserAction");
                return;
            }
            case ClientRequestLogoff: {
                MiLinkLog.w(this.TAG, "ClientActionEvent ClientRequestLogoff");
                this.logoff();
                return;
            }
            case ClientForceOpen: {
                MiLinkLog.w(this.TAG, "ClientActionEvent ClientForceOpen");
                this.setState(0);
                this.resetAllTryTimes();
                this.acquireWakeLock();
                this.accountManager.setIsLogining(false);
                this.login("ClientForceOpen");
            }
        }
    }

    private void processEvent(MiLinkEventForSimpleChannel.SystemNotificationEvent systemNotificationEvent) {
        switch (systemNotificationEvent.mEventType) {
            case ScreenOn: {
                MiLinkLog.v(this.TAG, "SystemNotificationEvent screen_on");
                this.tryConnectIfNeed();
                return;
            }
            case NetWorkChange: {
                MiLinkLog.v(this.TAG, "SystemNotificationEvent NetWorkChange");
                this.acquireWakeLock();
                this.tryConnectIfNeed();
            }
        }
    }

    private boolean isAbandonSession(SessionForSimpleChannel sessionForSimpleChannel) {
        if (sessionForSimpleChannel == this.mMasterSession) {
            return false;
        }
        if (sessionForSimpleChannel == null || sessionForSimpleChannel.mFlagForSessionManager == 3) {
            MiLinkLog.w(this.TAG, String.format("Session No:%d is AbandonSession return ", sessionForSimpleChannel.getSessionNO()));
            if (sessionForSimpleChannel.close()) {
                this.mSessionList.remove(sessionForSimpleChannel);
            }
            return true;
        }
        return false;
    }

    public int getSessionState() {
        return this.mState;
    }

    private void internalManualOpen() {
        MiLinkLog.v(this.TAG, "internalManualOpen,mState=" + this.mState);
        this.resetAllTryTimes();
        this.internalOpen();
    }

    private void internalOpen() {
        StatisticsLog.begin("horse_init");
        if (!NetworkDash.isAvailable()) {
            MiLinkLog.i(this.TAG, "can not open session, network is not available.");
            return;
        }
        if (this.getHandler() == null) {
            MiLinkLog.i(this.TAG, "can not open session, mHandler == null.");
            return;
        }
        MiLinkLog.i(this.TAG, "open session, internalOpen with mState = " + this.mState);
        if (this.mState != 0) {
            MiLinkLog.i(this.TAG, "mState is not No_Sesssion state,cancel paoma");
            return;
        }
        MiLinkLog.d(this.TAG, "internalOpen first");
        this.mSessionAddress2ErrorCodeMap.clear();
        this.mOpenStartTime = SystemClock.elapsedRealtime();
        ThreadHelper.NETWORK.submit(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: internalOpen1 start");
                SessionManagerForSimpleChannel.this.mNetworkDetailInfoOnOpen = Device.Network.getCurrentNetworkDetailInfo();
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: internalOpen1 end");
            }
        });
        MiLinkLog.d(this.TAG, "internalOpen first -0");
        StatisticsLog.end("horse_init");
        StatisticsLog.begin("get_ip");
        final ServerProfile[] serverProfileArray = this.mServerManager.reset(false);
        StatisticsLog.end("get_ip");
        StatisticsLog.begin("open_session_init");
        this.mServerManager = this.mServerManagerNormal;
        MiLinkLog.d(this.TAG, "internalOpen first -1");
        if (serverProfileArray == null || serverProfileArray.length == 0) {
            MiLinkLog.e(this.TAG, "serverProfileList is null ,internalOpne cancel");
            return;
        }
        MiLinkLog.d(this.TAG, "internalOpen second");
        if (this.mState == 1) {
            MiLinkLog.e(this.TAG, "have connecting session, internalOpen with mState =: " + this.mState);
            return;
        }
        this.setState(1);
        for (int i2 = 0; i2 < serverProfileArray.length; ++i2) {
            if (serverProfileArray[i2] == null) continue;
            final int n2 = i2;
            ThreadHelper.CONNECT.submit(new Runnable(){

                @Override
                public void run() {
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: internalOpen2 start");
                    SessionForSimpleChannel sessionForSimpleChannel = new SessionForSimpleChannel(SessionManagerForSimpleChannel.this, SessionManagerForSimpleChannel.this.accountManager, SessionManagerForSimpleChannel.this.appId);
                    new SessionForSimpleChannel(SessionManagerForSimpleChannel.this, SessionManagerForSimpleChannel.this.accountManager, SessionManagerForSimpleChannel.this.appId).mFlagForSessionManager = 1;
                    SessionManagerForSimpleChannel.this.mSessionList.add(sessionForSimpleChannel);
                    sessionForSimpleChannel.openSession(serverProfileArray[n2]);
                    MiLinkLog.d(SessionManagerForSimpleChannel.this.TAG, "internalOpen third +" + n2);
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: internalOpen2 end");
                }
            });
        }
        StatisticsLog.end("open_session_init");
    }

    private synchronized boolean updateSession(SessionForSimpleChannel object) {
        if (object == null) {
            return false;
        }
        if (this.mMasterSession != null && this.mState == 2 && this.mMasterSession.isFastLogining()) {
            MiLinkLog.e(this.TAG, " \u6709\u94fe\u63a5\u6b63\u5728fastlogin\uff0c \u4e0d\u80fd\u6740\u6b7b\u8fd9\u4e2a\u8fde\u63a5\uff0c\u90a3\u53ea\u80fd\u6740\u6b7b\u81ea\u5df1\u4e86");
            ((SessionForSimpleChannel)object).mFlagForSessionManager = 3;
            return false;
        }
        MiLinkLog.v(this.TAG, "update session function.");
        ((SessionForSimpleChannel)object).mFlagForSessionManager = 4;
        this.mSessionList.remove(object);
        if (((SessionForSimpleChannel)object).getServerProfile().getProtocol() == 1) {
            this.abandonAllSession();
        }
        if (this.mServerManager != null) {
            this.mServerManager.save(((SessionForSimpleChannel)object).getServerProfile());
        }
        MiLinkLog.v(this.TAG, "updateSession in no session or string session");
        if (this.mMasterSession != null && this.mMasterSession != object) {
            this.mMasterSession.close();
        }
        this.mMasterSession = object;
        this.mMasterSession.startBackReceiveThread();
        StatisticsLog.addKey("session", this.mMasterSession.getSessionNO());
        this.setState(2);
        MiLinkLog.v(this.TAG, "connected, start milink login");
        this.accountManager.setIsLogining(false);
        this.login("updateSession");
        this.onOpenSessionResult(0, this.mOpenStartTime);
        object = ((SessionForSimpleChannel)object).getOpenSessionSucessReturnInfo();
        if (object != null) {
            ThreadHelper.NETWORK.submit(new Runnable((OpenSessionSucessReturnInfo)object){
                final /* synthetic */ OpenSessionSucessReturnInfo val$info;
                {
                    this.val$info = openSessionSucessReturnInfo;
                }

                @Override
                public void run() {
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: updateSession start");
                    String string2 = this.val$info.getClientIp();
                    String string3 = this.val$info.getClientIsp();
                    ArrayList<ServerProfile> arrayList = this.val$info.getBackupServerList();
                    ArrayList<ServerProfile> arrayList2 = this.val$info.getOptmumServerList();
                    MiLinkLog.w(SessionManagerForSimpleChannel.this.TAG, String.format("clientip:%s clientIsp;%s", string2, string3));
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        Global.setClientIp(string2);
                    }
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        Global.setClientIsp(string3);
                    }
                    if (SessionManagerForSimpleChannel.this.ipInfoManage != null) {
                        if (arrayList2 != null) {
                            SessionManagerForSimpleChannel.this.ipInfoManage.setOptmumServerList(Global.getClientIsp(), arrayList2);
                        }
                        if (arrayList != null) {
                            SessionManagerForSimpleChannel.this.ipInfoManage.setBackupServerList(arrayList);
                        }
                    }
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: updateSession end");
                }
            });
        }
        return true;
    }

    public boolean isTimerOpen() {
        return this.mCheckTimeOutTimerOpen;
    }

    private void startTimer() {
        this.mCheckTimeOutTimerOpen = true;
        this.getHandler().removeMessages(20);
        this.getHandler().sendEmptyMessageDelayed(20, 3000L);
    }

    private void stopTimer() {
        this.mCheckTimeOutTimerOpen = false;
        this.getHandler().removeMessages(20);
    }

    public boolean close() {
        return this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                SessionManagerForSimpleChannel.this.internalClose();
            }
        });
    }

    private void internalClose() {
        MiLinkLog.w(this.TAG, "=====> internalClose");
        this.setState(0);
        this.stopTimer();
        if (this.mNetworkReveiver != null) {
            Global.unregisterReceiver(this.mNetworkReveiver);
        }
    }

    private SessionForSimpleChannel getSession() {
        switch (this.mState) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: {
                return this.mMasterSession;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int n2) {
        switch (n2) {
            case 0: {
                List<SessionForSimpleChannel> list = this.mSessionList;
                synchronized (list) {
                    ArrayList<SessionForSimpleChannel> arrayList = new ArrayList<SessionForSimpleChannel>();
                    for (SessionForSimpleChannel sessionForSimpleChannel : this.mSessionList) {
                        if (sessionForSimpleChannel == null) continue;
                        sessionForSimpleChannel.mFlagForSessionManager = 3;
                        if (!sessionForSimpleChannel.close()) continue;
                        arrayList.add(sessionForSimpleChannel);
                    }
                    for (SessionForSimpleChannel sessionForSimpleChannel : arrayList) {
                        this.mSessionList.remove(sessionForSimpleChannel);
                    }
                    if (this.mMasterSession != null) {
                        this.mMasterSession.mFlagForSessionManager = 3;
                        this.mMasterSession.close();
                        this.mMasterSession = null;
                    }
                    this.mLoginState = 0;
                    this.accountManager.setIsLogining(false);
                    break;
                }
            }
        }
        MiLinkLog.i(this.TAG, "setState mState = " + this.mState + ",newState = " + n2);
        MiLinkLog.v(this.TAG, "mSessionList.size=" + this.mSessionList.size());
        int n3 = this.mState;
        this.mState = n2;
        this.mStateObserver.setSessionState(this.mState);
        if (this.mState != n3) {
            this.channelEventbus.post(new MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent(MiLinkEventForSimpleChannel.SessionManagerStateChangeEvent.EventType.SessionStateChange, n3, this.mState));
        }
    }

    public void onOpenSessionResult(int n2, final long l2) {
        MiLinkLog.w(this.TAG, "onOpenSessionResult, errorCode = ".concat(String.valueOf(n2)));
        if (n2 != 0) {
            this.stopTimer();
            if (this.isMultiUnavailable()) {
                MiLinkLog.w(this.TAG, "statistic milink.open, code=7");
                InternalDataMonitor.getInstance(this.appId).trace("", 0, "milink.open", 7, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                return;
            }
            int[] nArray = new int[]{13, 110, 113, 111, 101, 562};
            int[] nArray2 = new int[]{8, 6, 2, 3, 5, 9};
            boolean bl2 = false;
            for (int i2 = 0; i2 < 6 && i2 < 6; ++i2) {
                if (!this.isAllSessionErrorCode(nArray[i2])) continue;
                MiLinkLog.w(this.TAG, "statistic milink.open, code=" + nArray2[i2]);
                InternalDataMonitor.getInstance(this.appId).trace("", 0, "milink.open", nArray2[i2], l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (NetworkDash.isAvailable()) {
                    ThreadHelper.NETWORK.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: onOpenSessionResult start");
                            long l22 = System.currentTimeMillis();
                            MiLinkLog.w(SessionManagerForSimpleChannel.this.TAG, "check isInternetAvailable begin ,id=" + l22 + ", mInfoOnOpen=" + SessionManagerForSimpleChannel.this.mNetworkDetailInfoOnOpen);
                            if (SessionConst.isInternetAvailable()) {
                                int n2;
                                Object object = Device.Network.getCurrentNetworkDetailInfo();
                                MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "NetworkDetailInfo current=" + object + ",id=" + l22);
                                if (((Device.Network.NetworkDetailInfo)object).equals(SessionManagerForSimpleChannel.this.mNetworkDetailInfoOnOpen)) {
                                    MiLinkLog.v(SessionManagerForSimpleChannel.this.TAG, "at most wait 15s\uff0cid=".concat(String.valueOf(l22)));
                                    object = SessionManagerForSimpleChannel.this.mReportLock;
                                    synchronized (object) {
                                        try {
                                            SessionManagerForSimpleChannel.this.mReportLock.wait(5000L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    n2 = SessionManagerForSimpleChannel.this.mMasterSession == null ? 1 : 4;
                                } else {
                                    n2 = 4;
                                }
                                MiLinkLog.w(SessionManagerForSimpleChannel.this.TAG, "statistic milink.open, code=" + n2 + ",id=" + l22);
                                InternalDataMonitor.getInstance(SessionManagerForSimpleChannel.this.appId).trace("", 0, "milink.open", n2, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
                            }
                            MiLinkLog.w(SessionManagerForSimpleChannel.this.TAG, "check isInternetAvailable end, id=".concat(String.valueOf(l22)));
                            MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: onOpenSessionResult end");
                        }
                    });
                } else {
                    MiLinkLog.w(this.TAG, "check isInternetAvailable, but network is unavailable");
                }
            }
            if (NetworkDash.isAvailable()) {
                this.getHandler().removeCallbacks(this.mInternalAutoOpenRunnable);
                this.getHandler().postAtTime(this.mInternalAutoOpenRunnable, 3000L);
                MiLinkLog.v(this.TAG, "onOpenSessionResult reconnect times:" + this.mOpenSessionTryTimes);
            }
            return;
        }
        if (this.mMasterSession != null) {
            MiLinkLog.w(this.TAG, String.format("mMasterSession = [Session No:%d] ", this.mMasterSession.getSessionNO()));
            InternalDataMonitor.getInstance(this.appId).trace(this.mMasterSession.getServerProfile().getServerIP(), this.mMasterSession.getServerProfile().getServerPort(), "milink.open", 0, l2, SystemClock.elapsedRealtime(), 0, 0, 0);
        }
    }

    private void addClearConnRunnalbe() {
        this.getHandler().removeCallbacks(this.mClearConnRunnable);
        this.getHandler().postDelayed(this.mClearConnRunnable, (long)this.accountManager.getKeepAliveTime());
        MiLinkLog.d(this.TAG, "add clearrunnable .");
    }

    public synchronized boolean sendData(PacketData object, int n2, ResponseListener responseListener) {
        if (TextUtils.isEmpty((CharSequence)((PacketData)object).getCommand())) {
            MiLinkLog.v(this.TAG, "send data ,cmd can not be null");
            return false;
        }
        this.mLastUserSendDataTime = System.currentTimeMillis();
        ((PacketData)object).setSeqNo(Global.getSequence());
        MiLinkLog.v(this.TAG, "send data cmd=" + ((PacketData)object).getCommand() + ", seq=" + ((PacketData)object).getSeqNo());
        object = new Request((PacketData)object, responseListener, this.accountManager.getBusinessEncByMode(), this.accountManager.getCurrentAccount());
        ((Request)object).setTimeOut(n2);
        SessionForSimpleChannel sessionForSimpleChannel = this.getSession();
        MiLinkLog.v(this.TAG, "send data, session manager state: " + this.mState + ", current thread id: " + Thread.currentThread().getName());
        if (sessionForSimpleChannel != null && sessionForSimpleChannel.isDeadConnection(6000L, 180000L)) {
            MiLinkLog.w(this.TAG, "session isDeadConnection=true, current thread id: " + Thread.currentThread().getName());
            this.setState(0);
            sessionForSimpleChannel = null;
        }
        if (sessionForSimpleChannel == null || !sessionForSimpleChannel.isAvailable() || this.mLoginState != 2) {
            MiLinkLog.v(this.TAG, "push request in cache, seq=" + ((Request)object).getSeqNo() + ", current thread id: " + Thread.currentThread().getName());
            this.mSendQueue.add((Request)object);
            this.login("handleRequest");
            return true;
        }
        MiLinkLog.v(this.TAG, "send data to session, seq=" + ((Request)object).getSeqNo() + ", current thread id: " + Thread.currentThread().getName());
        sessionForSimpleChannel.handleRequest((Request)object);
        this.addClearConnRunnalbe();
        return true;
    }

    private void abandonAllSession() {
        for (SessionForSimpleChannel sessionForSimpleChannel : this.mSessionList) {
            if (sessionForSimpleChannel != null) {
                if (sessionForSimpleChannel.mFlagForSessionManager != 1) continue;
                sessionForSimpleChannel.mFlagForSessionManager = 3;
                if (sessionForSimpleChannel.getServerProfile() != null) {
                    MiLinkLog.w(this.TAG, "abandon all session, ip=" + sessionForSimpleChannel.getServerProfile().getServerIP() + ", port=" + sessionForSimpleChannel.getServerProfile().getServerPort() + ", protocol=" + sessionForSimpleChannel.getServerProfile().getProtocol() + ",No=" + sessionForSimpleChannel.getSessionNO());
                    continue;
                }
                MiLinkLog.w(this.TAG, "abandon all session, s.getServerProfile()=null, sessionNO=" + sessionForSimpleChannel.getSessionNO());
                continue;
            }
            MiLinkLog.w(this.TAG, "abandon all session, s =null ");
        }
    }

    private void getNextServerProfile(SessionForSimpleChannel sessionForSimpleChannel, int n2) {
        MiLinkLog.i(this.TAG, "getNextServerProfile " + String.format("[Session No:%d] ", sessionForSimpleChannel.getSessionNO()));
        ServerProfile[] serverProfileArray = this.mServerManager.getNext(sessionForSimpleChannel.getServerProfile(), n2);
        if (serverProfileArray == null) {
            MiLinkLog.i(this.TAG, "newServerProfile == null");
            sessionForSimpleChannel.mFlagForSessionManager = 3;
            if (sessionForSimpleChannel.close()) {
                this.mSessionList.remove(sessionForSimpleChannel);
            }
            if (!this.isHaveTryingSession()) {
                MiLinkLog.i(this.TAG, "already no trying session");
                if (this.mMasterSession == null) {
                    if (!this.isFirstFail) {
                        this.isFirstFail = true;
                        MiLinkLog.w(this.TAG, "session connect failed for first time. try to do dns resolve.");
                        List<ServerProfile> list = Collections.synchronizedList(new ArrayList());
                        int[] nArray = Const.ServerPort.PORT_ARRAY;
                        int n3 = Const.ServerPort.PORT_ARRAY.length;
                        for (int i2 = 0; i2 < n3; ++i2) {
                            int n4 = nArray[i2];
                            ServerProfile serverProfile = new ServerProfile(this.ipInfoManage.getDefaultServer().getServerIP(), n4, 1, 4);
                            list.add(serverProfile);
                        }
                        this.setState(1);
                        for (int i3 = 0; i3 < list.size(); ++i3) {
                            if (list.get(i3) == null) continue;
                            SessionManagerForSimpleChannel sessionManagerForSimpleChannel = this;
                            SessionForSimpleChannel sessionForSimpleChannel2 = new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId);
                            new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId).mFlagForSessionManager = 1;
                            this.mSessionList.add(sessionForSimpleChannel2);
                            sessionForSimpleChannel2.openSession((ServerProfile)list.get(i3));
                            MiLinkLog.d(this.TAG, "internalOpen thrid +".concat(String.valueOf(i3)));
                        }
                        return;
                    }
                    this.setState(0);
                    this.onOpenSessionResult(516, this.mOpenStartTime);
                    return;
                }
                MiLinkLog.e(this.TAG, "this session is trying session but masterSession is not null");
                return;
            }
        } else {
            for (int i4 = 0; i4 < serverProfileArray.length; ++i4) {
                MiLinkLog.e(this.TAG, "\u8fde\u63a5\u5931\u8d25\uff0c\u7ee7\u7eed\u8dd1\u9a6cip\uff1a" + serverProfileArray[i4].getServerIP());
                if (serverProfileArray[i4] == null) continue;
                SessionManagerForSimpleChannel sessionManagerForSimpleChannel = this;
                SessionForSimpleChannel sessionForSimpleChannel3 = new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId);
                new SessionForSimpleChannel(sessionManagerForSimpleChannel, sessionManagerForSimpleChannel.accountManager, this.appId).mFlagForSessionManager = 1;
                this.mSessionList.add(sessionForSimpleChannel3);
                sessionForSimpleChannel3.openSession(serverProfileArray[i4]);
            }
            sessionForSimpleChannel.mFlagForSessionManager = 3;
            if (sessionForSimpleChannel.close()) {
                this.mSessionList.remove(sessionForSimpleChannel);
            }
        }
    }

    private boolean isHaveTryingSession() {
        Iterator<SessionForSimpleChannel> iterator = this.mSessionList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().mFlagForSessionManager != 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLock() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mWakeLock != null) {
                    MiLinkLog.w(this.TAG, "Wakelock RELEASED :)");
                    this.mWakeLock.release();
                    this.mWakeLock = null;
                }
            }
            catch (Exception exception) {
                MiLinkLog.e(this.TAG, "releaseWakeLock exception", exception);
                this.mWakeLock = null;
            }
            return;
        }
    }

    private void acquireWakeLock() {
        this.acquireWakeLock(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"InvalidWakeLockTag"})
    private void acquireWakeLock(int n2) {
        if (this.getHandler() != null) {
            this.getHandler().removeMessages(22);
            Object object = this.mLock;
            synchronized (object) {
                try {
                    Context context = Global.getApplicationContext();
                    if (context != null && this.mWakeLock == null) {
                        MiLinkLog.w(this.TAG, "Wakelock ACQUIRED :)");
                        context = (PowerManager)context.getApplicationContext().getSystemService("power");
                        this.mWakeLock = context.newWakeLock(1, "milink");
                        this.mWakeLock.acquire();
                    }
                }
                catch (Exception exception) {
                    MiLinkLog.e(this.TAG, "acquireWakeLock exception", exception);
                }
            }
            if (null != this.getHandler()) {
                this.getHandler().sendEmptyMessageDelayed(22, (long)n2);
            }
        }
    }

    public void login(String object) {
        MiLinkLog.v(this.TAG, "login from=".concat(String.valueOf(object)));
        MiLinkLog.v(this.TAG, "login from=" + this.mState);
        if (this.accountManager.isLogining()) {
            MiLinkLog.v(this.TAG, "milink is logining");
            return;
        }
        if (!this.mAppInited) {
            MiLinkLog.v(this.TAG, "app not init");
            object = this.getHandler().obtainMessage(26);
            this.getHandler().sendMessageAtFrontOfQueue((Message)object);
            return;
        }
        MiLinkLog.v(this.TAG, "milink login, session manager state: " + this.mState + "\uff0c this: " + this);
        if (this.mState == 0) {
            this.internalManualOpen();
            return;
        }
        if (this.mState == 1) {
            return;
        }
        object = this.getSession();
        if (object == null || !((SessionForSimpleChannel)object).isAvailable()) {
            MiLinkLog.v(this.TAG, "login session is not available.");
            return;
        }
        if (this.mLoginTryTimes < 5) {
            ++this.mLoginTryTimes;
            MiLinkLog.v(this.TAG, "milink login start, mLoginTryTimes=" + this.mLoginTryTimes + "\uff0c this: " + this);
            ((SessionForSimpleChannel)object).fastLogin();
            return;
        }
        MiLinkLog.v(this.TAG, "milink login has exceeded max times\uff1a " + this.mLoginTryTimes + ", max time: 5\uff0c this: " + this);
    }

    public void logoff() {
        MiLinkLog.v(this.TAG, "=======> milink logoff");
        InternalDataMonitor.getInstance(this.appId).doPostDataAtOnce();
        ThreadHelper.NETWORK.execute(new Runnable(){

            @Override
            public void run() {
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: mLogoffRunnable start");
                SessionManagerForSimpleChannel.this.mLogoffRunnable.run();
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: mLogoffRunnable end");
            }
        });
    }

    private void resetAllTryTimes() {
        this.mOpenSessionTryTimes = 0;
        this.mSessionReconnectTryTimes = 0;
        this.mLoginTryTimes = 0;
    }

    private boolean sendCacheRequest() {
        final SessionForSimpleChannel sessionForSimpleChannel = this.getSession();
        if (sessionForSimpleChannel == null) {
            MiLinkLog.e(this.TAG, "sendCacheRequest session == null impossible!!!");
            return false;
        }
        MiLinkLog.i(this.TAG, "sendCacheRequest size = " + this.mSendQueue.size());
        Iterator<Request> iterator = this.mSendQueue.iterator();
        while (iterator.hasNext()) {
            final Request request = iterator.next();
            if (request == null) {
                iterator.remove();
                continue;
            }
            MiLinkLog.i(this.TAG, "sendCacheRequest11111, cmd = " + request.getData().getCommand());
            ThreadHelper.NETWORK.submit(new Runnable(){

                @Override
                public void run() {
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: sendCacheRequest start");
                    sessionForSimpleChannel.handleRequest(request);
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "thread-pool: sendCacheRequest end");
                }
            });
            iterator.remove();
        }
        return true;
    }

    public boolean tryConnectIfNeed() {
        if (this.mState == 0) {
            this.internalOpen();
            return false;
        }
        if (this.mState == 1) {
            return false;
        }
        if (this.mLoginState == 0) {
            this.mLoginTryTimes = 0;
            this.login("tryConnectIfNeed");
            return false;
        }
        return true;
    }

    public boolean isMilinkLogined() {
        return this.mLoginState == 2;
    }

    private class NetworkChangeReceiver
    extends BroadcastReceiver {
        private int currentType = -1;
        private String apnName = "";

        private NetworkChangeReceiver() {
        }

        private boolean isNetworkChanged(NetworkInfo networkInfo) {
            if (networkInfo == null) {
                return this.currentType != -1 || !TextUtils.isEmpty((CharSequence)this.apnName);
            }
            boolean bl2 = true;
            if (this.currentType == networkInfo.getType()) {
                if (this.currentType == 0) {
                    if (this.apnName != null && this.apnName.equals(networkInfo.getSubtypeName())) {
                        bl2 = false;
                    }
                } else if (this.apnName != null && this.apnName.equals(WifiDash.getBSSID())) {
                    bl2 = false;
                }
            }
            return bl2;
        }

        public void setCurrentNetworkInfo() {
            try {
                NetworkInfo networkInfo = ((ConnectivityManager)Global.getSystemService("connectivity")).getActiveNetworkInfo();
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "NetworkChangeReceiver, setCurrentNetworkInfo=".concat(String.valueOf(networkInfo)));
                this.setCurrentNetworkInfo(networkInfo);
                return;
            }
            catch (Exception exception) {
                this.setCurrentNetworkInfo(null);
                MiLinkLog.e(SessionManagerForSimpleChannel.this.TAG, "Get networkInfo fail", exception);
                return;
            }
        }

        private void setCurrentNetworkInfo(NetworkInfo networkInfo) {
            if (networkInfo != null) {
                this.currentType = networkInfo.getType();
                if (this.currentType == 0) {
                    this.apnName = networkInfo.getSubtypeName();
                    return;
                }
                this.apnName = WifiDash.getBSSID();
                return;
            }
            this.currentType = -1;
            this.apnName = "";
        }

        public void onReceive(Context context, Intent intent) {
            if (SessionManagerForSimpleChannel.this.mServerManager != null) {
                SessionManagerForSimpleChannel.this.mServerManager.loadCurrentApn();
            }
            intent.getComponent();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                try {
                    context = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    this.onNetworkConnectivityAction((NetworkInfo)context);
                    return;
                }
                catch (Exception exception) {
                    this.setCurrentNetworkInfo(null);
                    MiLinkLog.e(SessionManagerForSimpleChannel.this.TAG, "Get networkInfo fail", exception);
                }
            }
        }

        private void onNetworkConnectivityAction(NetworkInfo object) {
            MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "NetworkChangeReceiver, networkInfo=".concat(String.valueOf(object)));
            boolean bl2 = this.isNetworkChanged((NetworkInfo)object);
            MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "isNetworkChange : ".concat(String.valueOf(bl2)));
            this.setCurrentNetworkInfo((NetworkInfo)object);
            if (object != null && object.isAvailable()) {
                if (bl2) {
                    MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "NetworkChangeReceiver, network change need forceOpen");
                    SessionConst.setNewApn(true);
                    Global.getMainHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SessionManagerForSimpleChannel.this.channelEventbus.post(new MiLinkEventForSimpleChannel.SystemNotificationEvent(MiLinkEventForSimpleChannel.SystemNotificationEvent.EventType.NetWorkChange));
                        }
                    }, 2000L);
                    return;
                }
                MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "NetworkChangeReceiver, network not change, mState=" + SessionManagerForSimpleChannel.this.mState);
                if (SessionManagerForSimpleChannel.this.mState == 0) {
                    Global.getMainHandler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            SessionManagerForSimpleChannel.this.channelEventbus.post(new MiLinkEventForSimpleChannel.SystemNotificationEvent(MiLinkEventForSimpleChannel.SystemNotificationEvent.EventType.NetWorkChange));
                        }
                    }, 2000L);
                    return;
                }
                object = SessionManagerForSimpleChannel.this.getSession();
                if (object != null && ((SessionForSimpleChannel)object).isAvailable()) {
                    ((Session)object).ping();
                }
                return;
            }
            if (SessionManagerForSimpleChannel.this.mState != 0) {
                SessionManagerForSimpleChannel.this.close();
            }
            MiLinkLog.i(SessionManagerForSimpleChannel.this.TAG, "network is disconnected()");
        }
    }
}

