/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.util;

import android.os.Parcel;
import android.text.format.Time;
import android.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;

public abstract class CommonUtils {
    public static final String EMPTY = "";
    public static final String NOT_AVALIBLE = "N/A";

    public static boolean isTextEmpty(String string2) {
        return string2 == null || string2.length() <= 0;
    }

    public static SimpleDateFormat createDataFormat(String string2) {
        return new SimpleDateFormat(string2);
    }

    public static String join(Collection<?> object, String string2) {
        if (object == null) {
            return null;
        }
        if ((object = object.iterator()) == null) {
            return null;
        }
        if (!object.hasNext()) {
            return EMPTY;
        }
        Object e2 = object.next();
        if (!object.hasNext()) {
            return e2.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (e2 != null) {
            stringBuilder.append(e2);
        }
        while (object.hasNext()) {
            stringBuilder.append(string2);
            e2 = object.next();
            if (e2 == null) continue;
            stringBuilder.append(e2);
        }
        return stringBuilder.toString();
    }

    public static String getTimeStr(long l2) {
        long l3 = l2 % 1000L;
        Time time = new Time();
        time.set(l2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(time.format("%Y-%m-%d %H:%M:%S")).append('.');
        if (l3 < 10L) {
            stringBuilder.append("00");
        } else if (l3 < 100L) {
            stringBuilder.append('0');
        }
        stringBuilder.append(l3);
        return stringBuilder.toString();
    }

    public static byte[] strToMd5(String string2) {
        Object object;
        try {
            object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(string2.getBytes());
            object = ((MessageDigest)object).digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = string2.getBytes();
        }
        return object;
    }

    public static String miuiSHA1(String string2) {
        try {
            return Base64.encodeToString((byte[])MessageDigest.getInstance("SHA1").digest(string2.getBytes()), (int)8).substring(0, 16);
        }
        catch (Exception exception) {
            return EMPTY;
        }
    }

    public static void writeParcelBytes(Parcel parcel, byte[] byArray) {
        if (byArray == null) {
            parcel.writeInt(-1);
            return;
        }
        parcel.writeInt(byArray.length);
        parcel.writeByteArray(byArray);
    }

    public static byte[] readParcelBytes(Parcel parcel) {
        int n2 = parcel.readInt();
        if (n2 >= 0) {
            byte[] byArray = new byte[n2];
            parcel.readByteArray(byArray);
            return byArray;
        }
        return null;
    }

    public static void zeroMemory(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    public static boolean closeDataObject(Object object) {
        if (object == null) {
            return false;
        }
        try {
            if (object instanceof InputStream) {
                ((InputStream)object).close();
            } else if (object instanceof OutputStream) {
                ((OutputStream)object).close();
            } else if (object instanceof Reader) {
                ((Reader)object).close();
            } else if (object instanceof Writer) {
                ((Writer)object).close();
            } else if (object instanceof RandomAccessFile) {
                ((RandomAccessFile)object).close();
            } else {
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final boolean isLegalIp(String string2) {
        if (string2 == null) {
            return false;
        }
        return string2.matches("((?:(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(?:25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d))))");
    }

    public static final boolean isLegalPort(int n2) {
        return n2 >= 0 && n2 < 65536;
    }
}

