/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.util;

import com.mi.milink.sdk.util.CommonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static final int ZIP_BUFFER_SIZE = 4096;
    public static final int CPY_BUFFER_SIZE = 4096;
    public static final String ZIP_FILE_EXT = ".zip";

    public static boolean copyFile(File object, File file) {
        boolean bl2;
        FileInputStream fileInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n2;
            fileInputStream = new FileInputStream((File)object);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            object = new byte[4096];
            while (-1 != (n2 = fileInputStream.read((byte[])object))) {
                bufferedOutputStream.write((byte[])object, 0, n2);
            }
            bufferedOutputStream.flush();
            bl2 = true;
        }
        catch (IOException iOException) {
            bl2 = false;
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(fileInputStream);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(fileInputStream);
            throw throwable;
        }
        CommonUtils.closeDataObject(bufferedOutputStream);
        CommonUtils.closeDataObject(fileInputStream);
        return bl2;
    }

    public static boolean deleteFile(File file) {
        if (file != null) {
            if (file.isFile()) {
                if (!file.delete()) {
                    file.deleteOnExit();
                    return false;
                }
                return true;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    int n2 = fileArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FileUtils.deleteFile(fileArray[i2]);
                    }
                }
                return file.delete();
            }
            return false;
        }
        return false;
    }

    public static boolean zip(File[] fileArray, File file) {
        boolean bl2;
        if (fileArray == null || fileArray.length <= 0 || file == null) {
            return false;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            byte[] byArray = new byte[4096];
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file, false)));
            for (File file2 : fileArray) {
                FileUtils.doZip(zipOutputStream, file2, null, byArray);
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            bl2 = true;
        }
        catch (IOException iOException) {
            bl2 = false;
            CommonUtils.closeDataObject(zipOutputStream);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(zipOutputStream);
            throw throwable;
        }
        CommonUtils.closeDataObject(zipOutputStream);
        return bl2;
    }

    public static boolean zip(File file, File file2) {
        return FileUtils.zip(new File[]{file}, file2);
    }

    public static boolean unzip(File file, File file2) {
        boolean bl2;
        if (file == null || file.length() < 1L || !file.canRead()) {
            return false;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        ZipInputStream zipInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            Object object;
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            while (null != (object = zipInputStream.getNextEntry())) {
                int n2;
                System.out.println(((ZipEntry)object).getName());
                if (((ZipEntry)object).isDirectory()) {
                    new File(file2, ((ZipEntry)object).getName()).mkdirs();
                    continue;
                }
                object = new File(file2, ((ZipEntry)object).getName());
                ((File)object).getParentFile().mkdirs();
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
                while (-1 != (n2 = zipInputStream.read(byArray, 0, 8192))) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
            bl2 = true;
        }
        catch (IOException iOException) {
            bl2 = false;
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(zipInputStream);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(zipInputStream);
            throw throwable;
        }
        CommonUtils.closeDataObject(bufferedOutputStream);
        CommonUtils.closeDataObject(zipInputStream);
        return bl2;
    }

    public static void doZip(ZipOutputStream zipOutputStream, File fileArray, String string2, byte[] byArray) throws IOException {
        if (zipOutputStream == null || fileArray == null) {
            throw new IOException("I/O Object got NullPointerException");
        }
        if (!fileArray.exists()) {
            throw new FileNotFoundException("Target File is missing");
        }
        BufferedInputStream bufferedInputStream = null;
        String string3 = string2 = CommonUtils.isTextEmpty(string2) ? fileArray.getName() : string2 + File.separator + fileArray.getName();
        if (fileArray.isFile()) {
            try {
                int n2;
                bufferedInputStream = new BufferedInputStream(new FileInputStream((File)fileArray));
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                while (-1 != (n2 = bufferedInputStream.read(byArray, 0, byArray.length))) {
                    zipOutputStream.write(byArray, 0, n2);
                }
                CommonUtils.closeDataObject(bufferedInputStream);
                return;
            }
            catch (IOException iOException) {
                CommonUtils.closeDataObject(bufferedInputStream);
                throw iOException;
            }
        }
        if (fileArray.isDirectory()) {
            for (File file : fileArray.listFiles()) {
                FileUtils.doZip(zipOutputStream, file, string2, byArray);
            }
        }
    }

    public static boolean unjar(File file, File file2) {
        boolean bl2;
        if (file == null || file.length() < 1L || !file.canRead()) {
            return false;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        JarInputStream jarInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            JarEntry jarEntry;
            jarInputStream = new JarInputStream(new FileInputStream(file));
            while (null != (jarEntry = jarInputStream.getNextJarEntry())) {
                int n2;
                System.out.println(jarEntry.getName());
                if (jarEntry.isDirectory()) {
                    new File(file2, jarEntry.getName()).mkdirs();
                    continue;
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file2, jarEntry.getName())));
                while (-1 != (n2 = jarInputStream.read(byArray, 0, 8192))) {
                    bufferedOutputStream.write(byArray, 0, n2);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            jarInputStream.closeEntry();
            jarInputStream.close();
            bl2 = true;
        }
        catch (IOException iOException) {
            bl2 = false;
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(jarInputStream);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(bufferedOutputStream);
            CommonUtils.closeDataObject(jarInputStream);
            throw throwable;
        }
        CommonUtils.closeDataObject(bufferedOutputStream);
        CommonUtils.closeDataObject(jarInputStream);
        return bl2;
    }

    public static void saveBytes2File(File object, byte[] byArray) throws Exception {
        if (object == null) {
            throw new NullPointerException("file is null ");
        }
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
        }
        if (!((File)object).canWrite()) {
            throw new IOException("file " + ((File)object).getAbsolutePath() + " is not writeable");
        }
        object = new FileOutputStream((File)object);
        try {
            ((FileOutputStream)object).write(byArray);
            return;
        }
        finally {
            CommonUtils.closeDataObject(object);
        }
    }

    public static byte[] readBytesFromFile(File object) throws Exception {
        if (object == null) {
            throw new NullPointerException("file is null ");
        }
        if (!((File)object).exists()) {
            throw new FileNotFoundException("file " + ((File)object).getAbsolutePath() + " is not exist");
        }
        if (!((File)object).canRead()) {
            throw new IOException("file " + ((File)object).getAbsolutePath() + " is not readable");
        }
        object = new FileInputStream((File)object);
        byte[] byArray = new byte[512];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            while ((n2 = ((FileInputStream)object).read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            CommonUtils.closeDataObject(object);
            CommonUtils.closeDataObject(byteArrayOutputStream);
        }
    }

    public static void writeToFile(File file, String string2) throws IOException {
        if (file == null || string2 == null) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string2);
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(bufferedWriter);
            throw throwable;
        }
        CommonUtils.closeDataObject(bufferedWriter);
    }

    public static String readStringFromFile(File object) throws IOException {
        if (object == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader((File)object));
            object = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("\n");
            }
            object = ((StringBuilder)object).toString();
        }
        catch (Throwable throwable) {
            CommonUtils.closeDataObject(bufferedReader);
            throw throwable;
        }
        CommonUtils.closeDataObject(bufferedReader);
        return object;
    }
}

