/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.util;

import android.os.Build;
import android.os.Process;
import com.mi.milink.sdk.base.debug.CustomLogcat;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;

public final class PRNGFixes {
    private static final int VERSION_CODE_JELLY_BEAN = 16;
    private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
    private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL = PRNGFixes.getBuildFingerprintAndDeviceSerial();

    private PRNGFixes() {
    }

    public static void apply() {
        PRNGFixes.applyOpenSSLFix();
        PRNGFixes.installLinuxPRNGSecureRandom();
    }

    private static void applyOpenSSLFix() throws SecurityException {
        if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
            return;
        }
        try {
            Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, new Object[]{PRNGFixes.generateSeed()});
            int n2 = (Integer)Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, "/dev/urandom", 1024);
            if (n2 != 1024) {
                throw new IOException("Unexpected number of bytes read from Linux PRNG: ".concat(String.valueOf(n2)));
            }
            return;
        }
        catch (Exception exception) {
            throw new SecurityException("Failed to seed OpenSSL PRNG", exception);
        }
    }

    private static void installLinuxPRNGSecureRandom() throws SecurityException {
        if (Build.VERSION.SDK_INT > 18) {
            return;
        }
        Object object = Security.getProviders("SecureRandom.SHA1PRNG");
        if (object == null || ((Provider[])object).length <= 0 || !LinuxPRNGSecureRandomProvider.class.equals(object[0].getClass())) {
            Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals(((SecureRandom)(object = new SecureRandom())).getProvider().getClass())) {
            throw new SecurityException("new SecureRandom() backed by wrong Provider: " + ((SecureRandom)object).getProvider().getClass());
        }
        try {
            object = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("SHA1PRNG not available", noSuchAlgorithmException);
        }
        if (!LinuxPRNGSecureRandomProvider.class.equals(((SecureRandom)object).getProvider().getClass())) {
            throw new SecurityException("SecureRandom.g(\"SHA1PRNG\") backed by wrong Provider: " + ((SecureRandom)object).getProvider().getClass());
        }
    }

    private static byte[] generateSeed() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            dataOutputStream.writeLong(System.nanoTime());
            dataOutputStream.writeInt(Process.myPid());
            dataOutputStream.writeInt(Process.myUid());
            dataOutputStream.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SecurityException("Failed to generate seed", iOException);
        }
    }

    private static String getDeviceSerialNumber() {
        try {
            return (String)Build.class.getField("SERIAL").get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static byte[] getBuildFingerprintAndDeviceSerial() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Build.FINGERPRINT;
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        if ((string2 = PRNGFixes.getDeviceSerialNumber()) != null) {
            stringBuilder.append(string2);
        }
        try {
            return stringBuilder.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public static class LinuxPRNGSecureRandom
    extends SecureRandomSpi {
        private static final File URANDOM_FILE = new File("/dev/urandom");
        private static final Object sLock = new Object();
        private static DataInputStream sUrandomIn;
        private static OutputStream sUrandomOut;
        private boolean mSeeded;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] byArray) {
            try {
                OutputStream outputStream;
                Object object = sLock;
                synchronized (object) {
                    outputStream = this.getUrandomOutputStream();
                }
                outputStream.write(byArray);
                outputStream.flush();
                return;
            }
            catch (IOException iOException) {
                CustomLogcat.w(PRNGFixes.class.getSimpleName(), "Failed to mix seed into " + URANDOM_FILE);
                return;
            }
            finally {
                this.mSeeded = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] byArray) {
            if (!this.mSeeded) {
                this.engineSetSeed(PRNGFixes.generateSeed());
            }
            try {
                DataInputStream dataInputStream;
                Object object = sLock;
                synchronized (object) {
                    dataInputStream = this.getUrandomInputStream();
                }
                object = dataInputStream;
                synchronized (object) {
                    dataInputStream.readFully(byArray);
                    return;
                }
            }
            catch (IOException iOException) {
                throw new SecurityException("Failed to read from " + URANDOM_FILE, iOException);
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int n2) {
            byte[] byArray = new byte[n2];
            this.engineNextBytes(byArray);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataInputStream getUrandomInputStream() {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomIn == null) {
                    try {
                        sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                    }
                    catch (IOException iOException) {
                        throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", iOException);
                    }
                }
                return sUrandomIn;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private OutputStream getUrandomOutputStream() throws IOException {
            Object object = sLock;
            synchronized (object) {
                if (sUrandomOut == null) {
                    sUrandomOut = new FileOutputStream(URANDOM_FILE);
                }
                return sUrandomOut;
            }
        }
    }

    private static class LinuxPRNGSecureRandomProvider
    extends Provider {
        public LinuxPRNGSecureRandomProvider() {
            super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
            this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
            this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        }
    }
}

