/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.util;

import android.annotation.SuppressLint;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.LongSparseArray;
import android.util.SparseArray;
import com.mi.milink.sdk.debug.MiLinkLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PreloadClearUtil {
    public static void clearResources() {
        try {
            MiLinkLog.v("PreloadClearUtil", "clear resource");
            PreloadClearUtil.clearPreloadedDrawables();
            PreloadClearUtil.clearPreloadedColorDrawables();
            PreloadClearUtil.clearPreloadedColorStateLists();
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e("PreloadClearUtil", exception);
            return;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static void clearPreloadedDrawables() {
        try {
            LongSparseArray[] longSparseArrayArray = PreloadClearUtil.getField(Resources.class, "sPreloadedDrawables");
            if (longSparseArrayArray != null) {
                longSparseArrayArray.setAccessible(true);
                if (Build.VERSION.SDK_INT <= 17) {
                    if ((longSparseArrayArray = (LongSparseArray)longSparseArrayArray.get(null)) != null) {
                        PreloadClearUtil.clearLongSparseArray((LongSparseArray<Drawable.ConstantState>)longSparseArrayArray);
                    }
                    return;
                }
                if (Build.VERSION.SDK_INT >= 18 && (longSparseArrayArray = (LongSparseArray[])longSparseArrayArray.get(null)) != null) {
                    for (int i2 = 0; i2 < longSparseArrayArray.length; ++i2) {
                        PreloadClearUtil.clearLongSparseArray((LongSparseArray<Drawable.ConstantState>)longSparseArrayArray[i2]);
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e("PreloadClearUtil", exception);
            return;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static void clearPreloadedColorDrawables() {
        try {
            Field field = PreloadClearUtil.getField(Resources.class, "sPreloadedColorDrawables");
            if (field != null) {
                field.setAccessible(true);
                field = (LongSparseArray)field.get(null);
                if (field != null) {
                    PreloadClearUtil.clearLongSparseArray((LongSparseArray<Drawable.ConstantState>)field);
                }
            }
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e("PreloadClearUtil", exception);
            return;
        }
    }

    @SuppressLint(value={"NewApi"})
    private static void clearPreloadedColorStateLists() {
        try {
            Field field = PreloadClearUtil.getField(Resources.class, "sPreloadedColorStateLists");
            if (field == null) {
                field = PreloadClearUtil.getField(Resources.class, "mPreloadedColorStateLists");
            }
            if (field != null) {
                field.setAccessible(true);
                if (Build.VERSION.SDK_INT <= 15) {
                    if ((field = (SparseArray)field.get(null)) != null) {
                        PreloadClearUtil.clearSparseArray(field);
                    }
                    return;
                }
                if ((field = (LongSparseArray)field.get(null)) != null) {
                    PreloadClearUtil.clearColorStateListArray((LongSparseArray<ColorStateList>)field);
                }
            }
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e("PreloadClearUtil", exception);
            return;
        }
    }

    private static Field getField(Class<?> clazz, String string2) {
        Field field = null;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                field = clazz.getDeclaredField(string2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                MiLinkLog.i("PreloadClearUtil", noSuchFieldException.getMessage());
            }
        }
        return field;
    }

    private static void clearColorStateListArray(LongSparseArray<ColorStateList> longSparseArray) {
        if (longSparseArray != null) {
            int n2 = longSparseArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                longSparseArray.setValueAt(i2, null);
            }
        }
    }

    private static void clearLongSparseArray(LongSparseArray<Drawable.ConstantState> longSparseArray) {
        if (longSparseArray != null) {
            int n2 = longSparseArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Bitmap bitmap;
                Drawable.ConstantState constantState = (Drawable.ConstantState)longSparseArray.valueAt(i2);
                if (constantState == null || (constantState = constantState.newDrawable()) == null || !(constantState instanceof BitmapDrawable) || (bitmap = (constantState = (BitmapDrawable)constantState).getBitmap()) == null) continue;
                bitmap.recycle();
                PreloadClearUtil.setBitmap((BitmapDrawable)constantState, null);
            }
        }
    }

    private static void setBitmap(BitmapDrawable bitmapDrawable, Bitmap bitmap) {
        try {
            Method method = PreloadClearUtil.getMethod(BitmapDrawable.class, "setBitmap", new Class[]{Bitmap.class});
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)bitmapDrawable, bitmap);
            }
            return;
        }
        catch (Exception exception) {
            MiLinkLog.e("PreloadClearUtil", exception);
            return;
        }
    }

    private static Method getMethod(Class clazz, String string2, Class[] classArray) throws Exception {
        Method method;
        try {
            method = clazz.getDeclaredMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getMethod(string2, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                if (clazz.getSuperclass() == null) {
                    return null;
                }
                method = PreloadClearUtil.getMethod(clazz.getSuperclass(), string2, classArray);
            }
        }
        return method;
    }

    private static void clearSparseArray(SparseArray<?> sparseArray) {
        if (sparseArray != null) {
            int n2 = sparseArray.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                sparseArray.setValueAt(i2, null);
            }
        }
    }
}

