/*
 * Decompiled with CFR 0.152.
 */
package com.mi.milink.sdk.util.compress;

import com.mi.milink.sdk.debug.MiLinkLog;
import com.mi.milink.sdk.util.compress.ICompression;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class ZLibCompression
implements ICompression {
    private static final String TAG = ZLibCompression.class.getName();

    @Override
    public byte[] compress(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Deflater deflater = new Deflater();
        deflater.reset();
        deflater.setInput(byArray);
        deflater.finish();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        try {
            byte[] byArray2 = new byte[1024];
            while (!deflater.finished()) {
                int n2 = deflater.deflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            byArray = null;
            MiLinkLog.e(TAG, "compress fail", exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            byArray = null;
            MiLinkLog.e(TAG, "compress out of memory", outOfMemoryError);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                MiLinkLog.e(TAG, "close fail", iOException);
            }
        }
        deflater.end();
        return byArray;
    }

    @Override
    public byte[] decompress(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Inflater inflater = new Inflater();
        inflater.reset();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        try {
            byte[] byArray2 = new byte[1024];
            while (!inflater.finished()) {
                int n2 = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            byArray = null;
            MiLinkLog.e(TAG, "decompress fail", exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            byArray = null;
            MiLinkLog.e(TAG, "decompress out of memory", outOfMemoryError);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                MiLinkLog.e(TAG, "close fail", iOException);
            }
        }
        inflater.end();
        return byArray;
    }
}

