/*
 * Decompiled with CFR 0.152.
 */
package com.wali.gamecenter.report;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.wali.gamecenter.report.ReportBaseParams;
import com.wali.gamecenter.report.ReportManager;
import com.wali.gamecenter.report.ReportOrigin;
import com.wali.gamecenter.report.ReportParams;
import com.wali.gamecenter.report.ReportType;
import com.wali.gamecenter.report.utils.Base64;
import com.wali.gamecenter.report.utils.ReportUtils;
import java.net.URLEncoder;
import java.util.Calendar;
import org.json.JSONObject;

public class Report
implements Parcelable {
    public static final Parcelable.Creator<Report> CREATOR = new Parcelable.Creator<Report>(){

        public final Report createFromParcel(Parcel parcel) {
            return new Report(parcel);
        }

        public final Report[] newArray(int n2) {
            return new Report[n2];
        }
    };
    public String level;
    public String action;
    public ReportType type;
    public String origin;
    public String client;
    public String gamecenterVersion;
    public String pp1;
    public String pp2;
    public String imei;
    public String from;
    public String fromId;
    public String fromLabel;
    public String curPage;
    public String curPageId;
    public String position;
    public String adsId;
    public String tm;
    public String tt;
    public String cid;
    public String adsType;
    public String adsCv;
    public String moduleId;
    public String trace;
    public String curPagePkgName;
    public boolean mHasCallCreate = false;

    public Report() {
    }

    public Report(Parcel parcel) {
        this.level = parcel.readString();
        this.action = parcel.readString();
        this.type = ReportType.fromInt(parcel.readInt());
        this.origin = parcel.readString();
        this.client = parcel.readString();
        this.gamecenterVersion = parcel.readString();
        this.pp1 = parcel.readString();
        this.pp2 = parcel.readString();
        this.imei = parcel.readString();
        this.from = parcel.readString();
        this.fromId = parcel.readString();
        this.fromLabel = parcel.readString();
        this.curPage = parcel.readString();
        this.curPageId = parcel.readString();
        this.position = parcel.readString();
        this.adsId = parcel.readString();
        this.tm = parcel.readString();
        this.tt = parcel.readString();
        this.cid = parcel.readString();
        this.adsType = parcel.readString();
        this.adsCv = parcel.readString();
        this.moduleId = parcel.readString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getParamsToJSON(Context context) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        try {
            String string2;
            String string3;
            JSONObject jSONObject3;
            if (TextUtils.isEmpty((CharSequence)this.action)) {
                this.action = "gamecenter";
            }
            jSONObject2.put("ac", (Object)this.action);
            if (!TextUtils.isEmpty((CharSequence)this.adsType)) {
                jSONObject3 = jSONObject2;
                string3 = "type";
                string2 = this.adsType;
            } else {
                if (this.type == null) {
                    this.type = ReportType.STATISTICS;
                }
                jSONObject3 = jSONObject2;
                string3 = "type";
                string2 = this.type.toString();
            }
            jSONObject3.put(string3, (Object)string2);
            if (!TextUtils.isEmpty((CharSequence)this.adsId)) {
                jSONObject2.put("adId", (Object)URLEncoder.encode(this.adsId, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.adsCv)) {
                jSONObject2.put("cv", (Object)URLEncoder.encode(this.adsCv, "UTF-8"));
            }
            if (TextUtils.isEmpty((CharSequence)this.origin)) {
                this.origin = ReportOrigin.getOrigin(context);
            }
            if (TextUtils.isEmpty((CharSequence)this.origin)) {
                this.origin = "other";
            }
            jSONObject2.put("origin", (Object)URLEncoder.encode(this.origin, "UTF-8"));
            if (!TextUtils.isEmpty((CharSequence)this.client)) {
                jSONObject2.put("client", (Object)this.client);
            }
            if (!TextUtils.isEmpty((CharSequence)this.from)) {
                jSONObject2.put("from", (Object)URLEncoder.encode(this.from, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.fromId)) {
                jSONObject2.put("fromId", (Object)URLEncoder.encode(this.fromId, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.fromLabel)) {
                jSONObject2.put("fromLabel", (Object)URLEncoder.encode(this.fromLabel, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPage)) {
                if (this.curPage.startsWith("http") || this.curPage.startsWith("https")) {
                    this.curPage = Base64.encode(this.curPage.getBytes("UTF-8"));
                }
                jSONObject2.put("curPage", (Object)URLEncoder.encode(this.curPage, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPageId)) {
                jSONObject2.put("curPageId", (Object)URLEncoder.encode(this.curPageId, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.position)) {
                jSONObject2.put("position", (Object)URLEncoder.encode(this.position, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.tt)) {
                jSONObject2.put("tt", (Object)this.tt);
            }
            if (!TextUtils.isEmpty((CharSequence)this.moduleId)) {
                jSONObject2.put("moduleId", (Object)this.moduleId);
            }
            if (!TextUtils.isEmpty((CharSequence)this.trace)) {
                jSONObject2.put("trace", (Object)URLEncoder.encode(this.trace, "UTF-8"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPagePkgName)) {
                jSONObject2.put("curPagePkgName", (Object)URLEncoder.encode(this.curPagePkgName, "UTF-8"));
            }
            ReportBaseParams.getInstance().setBaseParamsToJSON(jSONObject2);
            if (!TextUtils.isEmpty((CharSequence)this.cid)) {
                jSONObject2.put("cid", (Object)URLEncoder.encode(this.cid, "UTF-8"));
            }
            if ((this = ReportUtils.getSecurityParameters(ReportBaseParams.getInstance().uid, this.curPageId, this.type.toString())) != null && this.length > 0) {
                JSONObject jSONObject4 = jSONObject2;
                jSONObject4.put("pp1", (Object)this[0]);
                jSONObject4.put("pp2", (Object)this[1]);
            }
            jSONObject2.put("tm", Calendar.getInstance().getTimeInMillis());
            return jSONObject2.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return jSONObject2.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getParamsToString(Context context) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        try {
            StringBuilder stringBuilder3;
            if (TextUtils.isEmpty((CharSequence)this.action)) {
                this.action = "gamecenter";
            }
            stringBuilder2.append("ac=").append(this.action).append("&");
            if (!TextUtils.isEmpty((CharSequence)this.adsType)) {
                stringBuilder3 = stringBuilder2.append("type=").append(this.adsType);
            } else {
                if (this.type == null) {
                    this.type = ReportType.STATISTICS;
                }
                stringBuilder3 = stringBuilder2.append("type=").append(this.type.toString());
            }
            stringBuilder3.append("&");
            if (!TextUtils.isEmpty((CharSequence)this.adsId)) {
                stringBuilder2.append("adId").append(URLEncoder.encode(this.adsId, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.adsCv)) {
                stringBuilder2.append("cv=").append(URLEncoder.encode(this.adsCv, "UTF-8")).append("&");
            }
            if (TextUtils.isEmpty((CharSequence)this.origin)) {
                this.origin = ReportOrigin.getOrigin(context);
            }
            if (TextUtils.isEmpty((CharSequence)this.origin)) {
                this.origin = "other";
            }
            stringBuilder2.append("origin=").append(URLEncoder.encode(this.origin, "UTF-8")).append("&");
            if (!TextUtils.isEmpty((CharSequence)this.client)) {
                stringBuilder2.append("client=").append(this.client).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.from)) {
                stringBuilder2.append("from=").append(URLEncoder.encode(this.from, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.fromId)) {
                stringBuilder2.append("fromId=").append(URLEncoder.encode(this.fromId, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.fromLabel)) {
                stringBuilder2.append("fromLabel=").append(URLEncoder.encode(this.fromLabel, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPage)) {
                if (this.curPage.startsWith("http") || this.curPage.startsWith("https")) {
                    this.curPage = Base64.encode(this.curPage.getBytes("UTF-8"));
                }
                stringBuilder2.append("curPage=").append(URLEncoder.encode(this.curPage, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPageId)) {
                stringBuilder2.append("curPageId=").append(URLEncoder.encode(this.curPageId, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.position)) {
                stringBuilder2.append("position=").append(URLEncoder.encode(this.position, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.tt)) {
                stringBuilder2.append("tt=").append(this.tt).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.moduleId)) {
                stringBuilder2.append("moduleId=").append(this.moduleId).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.trace)) {
                stringBuilder2.append("trace=").append(URLEncoder.encode(this.trace, "UTF-8")).append("&");
            }
            if (!TextUtils.isEmpty((CharSequence)this.curPagePkgName)) {
                stringBuilder2.append("curPagePkgName=").append(URLEncoder.encode(this.curPagePkgName, "UTF-8")).append("&");
            }
            stringBuilder2.append(ReportBaseParams.getInstance().getBaseParamsString(false));
            if (!TextUtils.isEmpty((CharSequence)this.cid)) {
                stringBuilder2.append("cid=").append(this.cid).append("&");
            }
            if ((this = ReportUtils.getSecurityParameters(ReportBaseParams.getInstance().uid, this.curPageId, this.type.toString())) != null && this.length > 0) {
                StringBuilder stringBuilder4 = stringBuilder2;
                stringBuilder4.append("pp1=").append(this[0]).append("&");
                stringBuilder4.append("pp2=").append(this[1]).append("&");
            }
            stringBuilder2.append("tm=").append(Calendar.getInstance().getTimeInMillis());
            return stringBuilder2.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return stringBuilder2.toString();
    }

    public void apply(ReportParams reportParams) {
        Object object = reportParams.action;
        this.action = object == null ? "gamecenter" : object;
        object = reportParams.type;
        this.type = object == null ? ReportType.STATISTICS : object;
        this.client = reportParams.client;
        this.from = reportParams.from;
        this.fromId = reportParams.fromId;
        this.fromLabel = reportParams.fromLabel;
        this.curPage = reportParams.curPage;
        this.curPageId = reportParams.curPageId;
        this.position = reportParams.position;
        this.cid = reportParams.cid;
        this.tt = reportParams.tt;
        this.moduleId = reportParams.moduleId;
        this.trace = reportParams.trace;
        this.curPagePkgName = reportParams.curPagePkgName;
        if (!TextUtils.isEmpty((CharSequence)reportParams.originManual)) {
            this.origin = reportParams.originManual;
        }
        this.mHasCallCreate = true;
    }

    public String getAction() {
        return this.action;
    }

    public ReportType getType() {
        return this.type;
    }

    public String getClient() {
        return this.client;
    }

    public void send() {
        if (ReportManager.getInstance().isDebugging && !this.mHasCallCreate) {
            throw new IllegalArgumentException("have not call create method");
        }
        ReportManager.getInstance().sendReport(this);
    }

    public void save() {
        ReportManager.getInstance().saveReport(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.level);
        parcel.writeString(this.action);
        parcel.writeInt(this.type.ordinal());
        parcel.writeString(this.origin);
        parcel.writeString(this.client);
        parcel.writeString(this.gamecenterVersion);
        parcel.writeString(this.pp1);
        parcel.writeString(this.pp2);
        parcel.writeString(this.imei);
        parcel.writeString(this.from);
        parcel.writeString(this.fromId);
        parcel.writeString(this.fromLabel);
        parcel.writeString(this.curPage);
        parcel.writeString(this.curPageId);
        parcel.writeString(this.position);
        parcel.writeString(this.adsId);
        parcel.writeString(this.tm);
        parcel.writeString(this.tt);
        parcel.writeString(this.cid);
        parcel.writeString(this.adsType);
        parcel.writeString(this.adsCv);
        parcel.writeString(this.moduleId);
    }

    public static class Builder {
        public ReportParams P = new ReportParams();

        public Builder setFrom(String string2) {
            this.P.from = string2;
            return this;
        }

        public Builder setFromId(String string2) {
            this.P.fromId = string2;
            return this;
        }

        public Builder setFromLabel(String string2) {
            this.P.fromLabel = string2;
            return this;
        }

        public Builder setCurPage(String string2) {
            this.P.curPage = string2;
            return this;
        }

        public Builder setCurPageId(String string2) {
            this.P.curPageId = string2;
            return this;
        }

        public Builder setPosition(String string2) {
            this.P.position = string2;
            return this;
        }

        public Builder setDownloadMode(String string2) {
            this.P.tt = string2;
            return this;
        }

        public Builder setAction(String string2) {
            this.P.action = string2;
            return this;
        }

        public Builder setType(ReportType reportType) {
            this.P.type = reportType;
            return this;
        }

        public Builder setClient(String string2) {
            this.P.client = string2;
            return this;
        }

        public Builder setCid(String string2) {
            this.P.cid = string2;
            return this;
        }

        public Builder setAdsId(String string2) {
            this.P.adsId = string2;
            return this;
        }

        public Builder setAdsType(String string2) {
            this.P.adsType = string2;
            return this;
        }

        public Builder setAdsCv(String string2) {
            this.P.adsCv = string2;
            return this;
        }

        public Builder setModuleId(String string2) {
            this.P.moduleId = string2;
            return this;
        }

        public Builder setTrace(String string2) {
            this.P.trace = string2;
            return this;
        }

        public Builder setCurPagePkgName(String string2) {
            this.P.curPagePkgName = string2;
            return this;
        }

        public Builder setOriginManual(String string2) {
            this.P.originManual = string2;
            return this;
        }

        public Report create() {
            Report report = new Report();
            report.apply(this.P);
            return report;
        }
    }
}

