/*
 * Decompiled with CFR 0.152.
 */
package com.wali.gamecenter.report;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.wali.gamecenter.report.InsertRecord;
import com.wali.gamecenter.report.Report;
import com.wali.gamecenter.report.ReportBaseParams;
import com.wali.gamecenter.report.ReportDBObserver;
import com.wali.gamecenter.report.ReportType;
import com.wali.gamecenter.report.db.DBManager;
import com.wali.gamecenter.report.db.ReportData;
import com.wali.gamecenter.report.log.ReportLog;
import com.wali.gamecenter.report.model.BaseReport;
import com.wali.gamecenter.report.utils.AutoThreadFactory;
import com.wali.gamecenter.report.utils.ReportUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportManager {
    public static final String TAG = "ReportManager";
    public static final String GET_URL = "https://data.game.xiaomi.com/1px.gif?";
    public static final String POST_URL = "https://data.game.xiaomi.com/p.do";
    public static final int MAX_REPORT_COUNT = 10;
    public static final String REPORT_VERSION = "report_sdk_1.0.1";
    public static ReportManager mInstance;
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    public static Object mDBSyncObj;
    public static int MSG_FORCE_SEND_REPORT = 48;
    public static long DELAY_LOOP_TIME = 60000L;
    public static String[] SYNCUPLOADAC;
    public Context ctx;
    public ReportDBObserver mDBObserver;
    public ReportLog mReportLog;
    public HandlerThread mReportThread;
    public Handler mHandler;
    public boolean isCTAluseable;
    public boolean isDebugging;

    public static void Init(Context context) {
        if (mInstance == null) {
            mInstance = new ReportManager(context);
        }
    }

    public static void Init(Context context, boolean bl2) {
        if (mInstance == null) {
            mInstance = new ReportManager(context);
            if (bl2) {
                mInstance.forceSendReport();
            }
        }
    }

    public static ReportManager getInstance() {
        return mInstance;
    }

    public ReportManager(Context context) {
        block3: {
            this.isCTAluseable = false;
            this.isDebugging = false;
            this.ctx = context;
            this.mReportThread = new HandlerThread("gamecenter_report");
            if (this.mReportThread == null) break block3;
            try {
                this.mReportThread.start();
                ReportManager reportManager = this;
                this.mHandler = new Handler(reportManager.mReportThread.getLooper()){

                    public void handleMessage(Message message) {
                        super.handleMessage(message);
                        if (MSG_FORCE_SEND_REPORT == message.what) {
                            ReportManager.getInstance().forceSendReport();
                        }
                    }
                };
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        ReportManager reportManager = this;
        DBManager.init(context);
        reportManager.mDBObserver = new ReportDBObserver(context);
        reportManager.mReportLog = new ReportLog(context, "report.log");
    }

    private String report_string_post(ArrayList<String> arrayList) {
        JSONObject jSONObject;
        block10: {
            int n2;
            JSONArray jSONArray;
            JSONObject jSONObject2;
            jSONObject = jSONObject2;
            new JSONObject().put("uid", (Object)ReportBaseParams.getInstance().uid);
            jSONObject.put("os", (Object)ReportBaseParams.getInstance().os);
            jSONObject.put("app_version", (Object)ReportBaseParams.getInstance().version_name);
            JSONArray jSONArray2 = jSONArray;
            try {
                jSONArray = new JSONArray();
                jSONObject.put("content", (Object)jSONArray2);
                n2 = 0;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            while (true) {
                block11: {
                    if (n2 >= arrayList.size()) break block10;
                    if (TextUtils.isEmpty((CharSequence)arrayList.get(n2))) break block11;
                    jSONArray2.put(n2, (Object)new JSONObject(arrayList.get(n2)));
                }
                ++n2;
            }
        }
        if (this.isDebugging) {
            Log.e((String)"report_string_post", (String)jSONObject.toString());
        }
        return jSONObject.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<String> spiltReportToJson(String string2) {
        int n2;
        JSONObject jSONObject;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        JSONObject jSONObject2 = jSONObject;
        if (!new JSONObject(string2).has("content")) return null;
        try {
            string2 = jSONObject2.optJSONArray("content");
            n2 = 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        while (true) {
            if (n2 >= string2.length()) return arrayList2;
            arrayList2.add(string2.getJSONObject(n2).toString());
            ++n2;
            continue;
            break;
        }
        return null;
    }

    static {
        mDBSyncObj = new Object();
        SYNCUPLOADAC = new String[]{"bid522", "xmsdk", "xm_client"};
    }

    public void checkTime() {
        Handler handler = this.mHandler;
        if (handler != null) {
            if (handler.hasMessages(MSG_FORCE_SEND_REPORT)) {
                this.mHandler.removeMessages(MSG_FORCE_SEND_REPORT);
            }
            this.mHandler.sendEmptyMessageDelayed(MSG_FORCE_SEND_REPORT, DELAY_LOOP_TIME);
        }
    }

    public void stopCheck() {
        Handler handler = this.mHandler;
        if (handler != null && handler.hasMessages(MSG_FORCE_SEND_REPORT)) {
            this.mHandler.removeMessages(MSG_FORCE_SEND_REPORT);
        }
    }

    public ReportLog reportLog() {
        return this.mReportLog;
    }

    public void sendReport(Report report) {
        InsertRecord insertRecord;
        if (report == null) {
            return;
        }
        Object object = report.getType();
        if (this.isDebugging) {
            Log.e((String)TAG, (String)"type=".concat(String.valueOf(object)));
        }
        ReportType reportType = object;
        object = report.getClient();
        if (reportType == ReportType.VIEW && !TextUtils.equals((CharSequence)object, (CharSequence)"track")) {
            this.saveReportToDB("post", report.getParamsToJSON(this.ctx), true);
            return;
        }
        if (this.isCTAluseable) {
            this.saveReportToDB("get", report.getParamsToString(this.ctx), false);
            return;
        }
        object = insertRecord;
        insertRecord = new InsertRecord(report.getParamsToString(this.ctx), 0);
        AutoThreadFactory.AppendTask("_rr_", (Runnable)object, 1);
    }

    public void sendReport(BaseReport baseReport) {
        if (baseReport == null) {
            return;
        }
        ReportType reportType = baseReport.getType();
        if (((ReportManager)((Object)insertRecord2)).isDebugging) {
            Log.e((String)TAG, (String)"type=".concat(String.valueOf((Object)reportType)));
        }
        if (((ReportManager)((Object)insertRecord2)).isSyncUpload(baseReport.getAc())) {
            InsertRecord insertRecord;
            if (((ReportManager)((Object)insertRecord2)).isCTAluseable) {
                ((ReportManager)((Object)insertRecord2)).saveReportToDB("get", baseReport.toString(), false);
                return;
            }
            if (reportType == ReportType.JARCRASH) {
                ReportManager reportManager = insertRecord2;
                reportManager.saveReportToDB("post", baseReport.toJson(), true);
                reportManager.forceSendReport();
                return;
            }
            InsertRecord insertRecord2 = insertRecord;
            insertRecord = new InsertRecord(baseReport.toString(), 0);
            AutoThreadFactory.AppendTask("_rr_", insertRecord2, 1);
            return;
        }
        ((ReportManager)((Object)insertRecord2)).saveReportToDB("post", baseReport.toJson(), true);
    }

    public void saveReport(Report report) {
        if (report == null) {
            return;
        }
        this.saveReportToDB("post", report.getParamsToJSON(this.ctx), false);
    }

    public void syncReport() {
        ReportDBObserver reportDBObserver = ((ReportManager)((Object)reportDBObserver)).mDBObserver;
        if (reportDBObserver != null) {
            reportDBObserver.onChange(true);
        }
    }

    public void forceSendReport() {
        ReportDBObserver reportDBObserver = ((ReportManager)((Object)reportDBObserver)).mDBObserver;
        if (reportDBObserver != null) {
            reportDBObserver.onChange(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveReportToDB(String string2, String string3, boolean bl2) {
        ReportData reportData;
        ReportManager reportManager = this;
        ReportData reportData2 = reportData;
        reportData = new ReportData(null, string2, ReportUtils.encryptUrl(string3));
        Object object = mDBSyncObj;
        DBManager.getReportDao().insert(reportData2);
        // MONITOREXIT : object
        {
            catch (Throwable throwable) {
                // MONITOREXIT : object
                throw throwable;
            }
        }
        try {
            if (reportManager.isDebugging) {
                Log.e((String)TAG, (String)("save data:" + string2 + "<<>>" + string3));
            }
            if (this.mDBObserver == null) return;
            if (!bl2) return;
            this.mDBObserver.onChange(true);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void postReport(ArrayList<String> object) {
        InsertRecord insertRecord;
        String string2 = ((ReportManager)((Object)string2)).report_string_post((ArrayList<String>)object);
        object = insertRecord;
        insertRecord = new InsertRecord(string2, 1);
        AutoThreadFactory.AppendTask("_rr_", (Runnable)object, 1);
    }

    public void setCTAUseable(boolean bl2) {
        this.isCTAluseable = bl2;
    }

    public void release() {
        if (this.mDBObserver != null) {
            this.mDBObserver = null;
        }
    }

    public void setDebug(boolean bl2) {
        this.isDebugging = bl2;
    }

    public boolean isDebug() {
        return this.isDebugging;
    }

    public boolean isSyncUpload(String string2) {
        String[] stringArray = SYNCUPLOADAC;
        int n2 = SYNCUPLOADAC.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.equals(stringArray[i2])) continue;
            return true;
        }
        return false;
    }
}

