/*
 * Decompiled with CFR 0.152.
 */
package com.wali.gamecenter.report.log;

import android.content.Context;
import android.util.Log;
import com.wali.gamecenter.report.log.ILogAppender;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.Locale;

public class ReportLog
implements ILogAppender {
    public static final int MAX_FILE_SIZE = 0x3200000;
    public FileWriter logfile;
    public BufferedWriter writer;
    public File mFile = null;

    public ReportLog(Context context, String string2) {
        try {
            this.mFile = new File(context.getFilesDir(), string2);
            this.logfile = new FileWriter(this.mFile.getAbsolutePath(), true);
            this.writer = new BufferedWriter(this.logfile, 1024);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private synchronized void appendLog(LOG_LEVEL lOG_LEVEL, String string2, String string3, Throwable serializable) {
        block14: {
            block13: {
                Date date;
                if (this.logfile == null) {
                    return;
                }
                if (string3 == null) {
                    string3 = "";
                }
                if (serializable != null) {
                    string3 = string3 + "\n" + Log.getStackTraceString((Throwable)serializable);
                }
                LOG_LEVEL lOG_LEVEL2 = lOG_LEVEL;
                ReportLog reportLog = this;
                serializable = date;
                date = new Date();
                Locale locale = Locale.US;
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                Object[] objectArray4 = objectArray;
                Object[] objectArray5 = objectArray;
                objectArray[0] = serializable;
                objectArray3[1] = lOG_LEVEL.toString();
                objectArray4[2] = string2;
                objectArray5[3] = string3;
                string2 = String.format(locale, "%1$tY/%1$tm/%1$td %1$tH:%1$tM [%2$-5s]-[%3$s] %4$s\r\n", objectArray2);
                reportLog.writer.append(string2);
                if (lOG_LEVEL2 == LOG_LEVEL.ERROR) break block13;
                if (lOG_LEVEL != LOG_LEVEL.DEBUG) break block14;
            }
            try {
                this.writer.flush();
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void error(String string2, String string3, Throwable throwable) {
        this.appendLog(LOG_LEVEL.ERROR, string2, string3, throwable);
    }

    @Override
    public void debug(String string2, String string3) {
        this.appendLog(LOG_LEVEL.DEBUG, string2, string3, null);
    }

    @Override
    public void close() {
        this.mFile = null;
        if (this.logfile != null) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
            try {
                this.logfile.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ReportLog reportLog = this;
            reportLog.logfile = null;
            reportLog.writer = null;
        }
    }

    public static enum LOG_LEVEL {
        NONE,
        ERROR,
        DEBUG;

    }
}

