/*
 * Decompiled with CFR 0.152.
 */
package com.wali.gamecenter.report.model;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.wali.gamecenter.report.ReportManager;
import com.wali.gamecenter.report.ReportType;
import com.wali.gamecenter.report.model.EXT;
import com.wali.gamecenter.report.utils.TelUtils;
import java.net.URLEncoder;
import java.util.Map;

public class BaseReport {
    public String ver;
    @SerializedName(value="IMEI")
    public String imei;
    public String index;
    public String carrier;
    @SerializedName(value="3gmac")
    public String gmac;
    public String jarver;
    public String ua;
    public ReportType type;
    public String ac;
    public String client;
    public EXT ext;
    public String udid;
    public String oaid;
    public String uuid;

    public BaseReport(Context context) {
        BaseReport baseReport = this;
        BaseReport baseReport2 = this;
        this.type = ReportType.STATISTICS;
        this.ver = "" + TelUtils.getVersionCode(context);
        baseReport2.imei = TelUtils.getDeviceId(context);
        baseReport2.index = TelUtils.getRandomIndex();
        this.carrier = TelUtils.getSIMOperatorName(context);
        baseReport.gmac = TelUtils.get3gMacAddress(context);
        baseReport.jarver = "" + TelUtils.versionCode;
        this.ua = TelUtils.get_device_agent_(context);
    }

    public ReportType getType() {
        return this.type;
    }

    public void setType(ReportType reportType) {
        this.type = reportType;
    }

    public String getAc() {
        return this.ac;
    }

    public void setAc(String string2) {
        this.ac = string2;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String string2) {
        this.client = string2;
    }

    public EXT getExt() {
        return this.ext;
    }

    public void setExt(EXT eXT) {
        this.ext = eXT;
    }

    public String getUdid() {
        return this.udid;
    }

    public void setUdid(String string2) {
        this.udid = string2;
    }

    public String getOaid() {
        return this.oaid;
    }

    public void setOaid(String string2) {
        this.oaid = string2;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string2) {
        this.uuid = string2;
    }

    public String toJson() {
        return new Gson().toJson((Object)this);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        String string2 = ((BaseReport)((Object)stringBuilder2)).toJson();
        TypeToken<Map<String, String>> typeToken = new TypeToken<Map<String, String>>(){};
        stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (Map.Entry entry : ((Map)new Gson().fromJson(string2, typeToken.getType())).entrySet()) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("&");
            }
            if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            Object object = stringBuilder2;
            ((StringBuilder)object).append((String)entry.getKey());
            ((StringBuilder)object).append("=");
            try {
                stringBuilder2.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return stringBuilder2.toString();
    }

    public void send() {
        ReportManager.getInstance().sendReport(this);
    }
}

