/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.accountsdk.utils;

import android.text.TextUtils;
import com.xiaomi.accountsdk.account.exception.CryptoException;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSACoder {
    public static PublicKey a(String string2) throws CryptoException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalStateException("public key should not be empty");
        }
        try {
            return RSACoder.a(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CryptoException("getPublicKey", unsupportedEncodingException.getCause());
        }
    }

    private static PublicKey a(byte[] byArray) throws CryptoException {
        if (byArray == null) {
            throw new IllegalStateException("public key bytes should not be empty");
        }
        try {
            return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray))).getPublicKey();
        }
        catch (CertificateException certificateException) {
            throw new CryptoException("getPublicKey", certificateException.getCause());
        }
    }

    public static byte[] a(byte[] byArray, Key key) throws CryptoException {
        try {
            return RSACoder.b(byArray, key);
        }
        catch (CryptoException cryptoException) {
            throw new CryptoException("encrypt", cryptoException.getCause());
        }
    }

    private static byte[] b(byte[] byArray, Key key) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, key);
            return cipher.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CryptoException(illegalBlockSizeException.getCause());
        }
        catch (BadPaddingException badPaddingException) {
            throw new CryptoException(badPaddingException.getCause());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(noSuchAlgorithmException.getCause());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CryptoException(noSuchPaddingException.getCause());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(invalidKeyException.getCause());
        }
    }
}

