/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.ad.common.util;

import android.app.ActivityManager;
import android.app.Notification;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.xiaomi.ad.common.device.c;
import com.xiaomi.ad.common.io.b;
import com.xiaomi.ad.common.util.MLog;
import com.xiaomi.ad.common.util.d;
import com.xiaomi.ad.common.util.f;
import com.xiaomi.ad.common.util.h;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class AndroidUtils {
    public static final String TAG = "AndroidUtils";
    public static final int PACKAGE_NOT_INSTALL = -1;
    public static final int PACKAGE_DISABLE = -2;
    public static final String PREF_FILE = "_m_rec";
    public static final String KEY_IMEI = "imei";
    public static final String KEY_WLAN_MAC = "wlan_mac";
    public static final String SKIP_AD_REMOTE_WEBVIEW = "__sarw__";
    public static final String UNKNOWN_STATE = "UNKNOWN";
    public static final int ANDROID_M_6_0 = 23;
    public static volatile int sScreenWidth;
    public static volatile int sScreenHeight;
    public static volatile int sStatusBarHeight;
    public static volatile int sNavBarHeight;
    public static volatile f sSPWrapper;
    public static volatile String sHashedMAC;
    public static volatile String sIMEI;

    public static Context getApplicationContext(Context context) {
        if (context != null && context.getApplicationContext() != null) {
            return context.getApplicationContext();
        }
        return context;
    }

    public static PackageInfo getPackageInfo(Context context, String string2, int n2) {
        try {
            return context.getPackageManager().getPackageInfo(string2, n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getVersionName(Context context) {
        Context context2 = context;
        return AndroidUtils.getVersionName(context2, context2.getPackageName());
    }

    public static String getVersionName(Context context, String string2) {
        if ((context = AndroidUtils.getPackageInfo(context, string2, 0)) != null) {
            return context.versionName;
        }
        return null;
    }

    public static long calculateFileSizeInK(File file) {
        if (file == null) {
            return 0L;
        }
        return file.length() / 1024L;
    }

    public static long getPartitionRemainCapacitySizeInK() {
        return AndroidUtils.calculateDirectorySizeInK(Environment.getDataDirectory());
    }

    public static long calculateDirectorySizeInK(File file) {
        StatFs statFs;
        if (file == null) {
            return 0L;
        }
        StatFs statFs2 = statFs;
        return (long)new StatFs(file.getPath()).getBlockSize() * (long)statFs2.getAvailableBlocks() / 1024L;
    }

    public static int getVersionCode(Context context) {
        Context context2 = context;
        return AndroidUtils.getVersionCode(context2, context2.getPackageName());
    }

    public static int getVersionCode(Context context, String string2) {
        if ((context = AndroidUtils.getPackageInfo(context, string2, 0)) == null) {
            return -1;
        }
        if (!context.applicationInfo.enabled) {
            return -2;
        }
        return context.versionCode;
    }

    public static Signature[] getSignature(Context context, String string2) {
        if ((context = AndroidUtils.getPackageInfo(context, string2, 64)) != null) {
            return context.signatures;
        }
        return null;
    }

    public static PackageInfo getArchivePackageInfo(Context context, String string2, int n2) {
        if (context != null && string2 != null) {
            try {
                return context.getPackageManager().getPackageArchiveInfo(string2, n2);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static String getArchivePackageName(Context context, String string2) {
        if ((context = AndroidUtils.getArchivePackageInfo(context, string2, 0)) != null) {
            return context.packageName;
        }
        return null;
    }

    public static String getArchiveVersionName(Context context, String string2) {
        if ((context = AndroidUtils.getArchivePackageInfo(context, string2, 0)) != null) {
            return context.versionName;
        }
        return null;
    }

    public static int getArchiveVersionCode(Context context, String string2) {
        if ((context = AndroidUtils.getArchivePackageInfo(context, string2, 0)) != null) {
            return context.versionCode;
        }
        return -1;
    }

    public static Signature[] getArchiveSignature(Context context, String string2) {
        if ((context = AndroidUtils.getArchivePackageInfo(context, string2, 64)) != null) {
            return context.signatures;
        }
        return null;
    }

    public static String getArchiveSignatureString(Context signatureArray, String string2) {
        if ((signatureArray = AndroidUtils.getArchiveSignature((Context)signatureArray, string2)) != null && signatureArray.length > 0) {
            return b.a(signatureArray[0].toByteArray());
        }
        return null;
    }

    public static void avoidOnMainThread() {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            return;
        }
        throw new RuntimeException("Should not run on main thread.");
    }

    public static void assureOnMainThread() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            return;
        }
        throw new RuntimeException("Must run on main thread.");
    }

    public static boolean judgeForegroundBelowLollipop(Context object, String string2) {
        return (object = ((ActivityManager)object.getSystemService("activity")).getRunningTasks(1)) != null && !object.isEmpty() && object.get(0) != null && ((ActivityManager.RunningTaskInfo)object.get((int)0)).topActivity != null && TextUtils.equals((CharSequence)((ActivityManager.RunningTaskInfo)object.get((int)0)).topActivity.getPackageName(), (CharSequence)string2);
    }

    public static boolean isProcessRunning(Context object, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        object = ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses();
        for (int i2 = 0; object != null && i2 < object.size(); ++i2) {
            String[] stringArray = (String[])object.get(i2);
            if (string2.equals(stringArray.processName)) {
                return true;
            }
            stringArray = stringArray.pkgList;
            for (int i3 = 0; stringArray != null && i3 < stringArray.length; ++i3) {
                if (!string2.equals(stringArray[i3])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPackageInstalled(Context context, String string2) {
        return (context = AndroidUtils.getPackageInfo(context, string2, 0)) != null && context.applicationInfo != null;
    }

    public static boolean grantedPermission(Context context, String string2) {
        boolean bl2 = false;
        try {
            bl2 = context.getPackageManager().checkPermission(string2, context.getPackageName()) == 0;
        }
        catch (Exception exception) {
            MLog.e(TAG, "Check permission exception", exception);
        }
        String string3 = TAG;
        String string4 = "Check permission %s %s %s";
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = context.getPackageName();
        objectArray[1] = string2;
        int n2 = 2;
        string2 = bl2 ? "granted" : "denied";
        objectArray2[n2] = string2;
        MLog.i(string3, String.format(string4, objectArray2));
        return bl2;
    }

    public static boolean usedInstallPackagesPermission(Context stringArray, String string2) {
        stringArray = stringArray.getPackageManager().getPackageArchiveInfo((String)string2, (int)4096).requestedPermissions;
        int n2 = stringArray.getPackageManager().getPackageArchiveInfo((String)string2, (int)4096).requestedPermissions.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"android.permission.INSTALL_PACKAGES".equals(stringArray[i2])) continue;
            return true;
        }
        MLog.d(TAG, "no INSTALL_PACKAGES permission!");
        return false;
    }

    public static boolean isDefaultProcess(Context object) {
        Context context = object;
        object = AndroidUtils.getProcessName(context);
        return TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)object);
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static String getProcessName(Context context) {
        String string2;
        int n2;
        block7: {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
            n2 = Process.myPid();
            string2 = "";
            Iterator iterator = ((ActivityManager)context.getSystemService("activity")).getRunningAppProcesses().iterator();
            while (true) {
                if (!iterator.hasNext()) break block7;
                runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                if (runningAppProcessInfo.pid != n2) continue;
                break;
            }
            try {
                string2 = runningAppProcessInfo.processName;
            }
            catch (Exception exception) {
                MLog.e(TAG, "get current process name exception ", exception);
            }
        }
        MLog.i(TAG, "current process name " + string2 + ", pid=" + n2);
        return string2;
    }

    public static boolean isSystemApp(ApplicationInfo applicationInfo) {
        return applicationInfo != null && (applicationInfo.flags & 1) != 0;
    }

    public static boolean isSystemApp(Context context, String string2) {
        try {
            return AndroidUtils.isSystemApp(AndroidUtils.getPackageInfo((Context)context, (String)string2, (int)0).applicationInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        int n2 = drawable3.getIntrinsicWidth();
        int n3 = drawable3.getIntrinsicHeight();
        Bitmap.Config config = drawable3.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        config = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        Canvas canvas = new Canvas((Bitmap)config);
        int n4 = n2 + 2;
        n2 = n3 + 2;
        drawable2.setBounds(-2, -2, n4, n2);
        drawable2.draw(canvas);
        return config;
    }

    public static void fakeNotificationTargetPackage(Notification notification, String object) {
        Class<?> clazz = Class.forName("android.app.MiuiNotification");
        Class<?> clazz2 = clazz;
        Class<?> clazz3 = clazz;
        Object obj = clazz.newInstance();
        Field field = clazz3.getDeclaredField("targetPkg");
        field.setAccessible(true);
        field.set(obj, object);
        Field field2 = clazz2.getDeclaredField("customizedIcon");
        field2.setAccessible(true);
        field2.set(obj, true);
        object = notification.getClass().getField("extraNotification");
        try {
            ((Field)object).setAccessible(true);
            ((Field)object).set(notification, obj);
        }
        catch (Exception exception) {
            MLog.e(TAG, "fakeNotificationTargetPackage exception", exception);
        }
    }

    public static boolean openUrl(String string2, Context context) {
        block6: {
            MLog.d(TAG, "open Url " + string2);
            if (TextUtils.isEmpty((CharSequence)string2)) break block6;
            Context context2 = context;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            intent.setFlags(0x10000000);
            try {
                context2.startActivity(intent);
                return true;
            }
            catch (Exception exception) {
                MLog.e(TAG, "openUrl exception", exception);
            }
        }
        return false;
    }

    public static boolean startAppWithPackageName(Context context, String string2) {
        block3: {
            string2 = context.getPackageManager().getLaunchIntentForPackage(string2);
            if (string2 == null) break block3;
            try {
                context.startActivity((Intent)string2);
                return true;
            }
            catch (Exception exception) {
                MLog.e(TAG, "startAppWithPackageName exception", exception);
            }
        }
        return false;
    }

    public static List<String> getCallerPackageNames(Context stringArray, int n2) {
        block3: {
            stringArray = stringArray.getPackageManager().getPackagesForUid(n2);
            if (stringArray == null) break block3;
            try {
                return Arrays.asList(stringArray);
            }
            catch (Exception exception) {
                MLog.e(TAG, "getCallerPackageNames exception", exception);
            }
        }
        return null;
    }

    public static String getCallerPackageName(Context stringArray, int n2, int n3) {
        List<String> list = AndroidUtils.getCallerPackageNames((Context)stringArray, n2);
        if (list != null && !list.isEmpty()) {
            block11: {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
                if (list.size() == 1) {
                    return list.get(0);
                }
                String[] stringArray2 = stringArray;
                stringArray = null;
                Iterator iterator = ((ActivityManager)stringArray2.getSystemService("activity")).getRunningAppProcesses().iterator();
                while (true) {
                    if (!iterator.hasNext()) break block11;
                    runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                    if (runningAppProcessInfo.pid != n3) continue;
                    break;
                }
                try {
                    stringArray = runningAppProcessInfo.pkgList;
                }
                catch (Exception exception) {
                    MLog.e(TAG, "get caller pkgList exception ", exception);
                }
            }
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!list.contains(string2)) continue;
                    return string2;
                }
            }
            return list.get(0);
        }
        return null;
    }

    public static Drawable getAppIconDrawable(Context context, String string2) {
        try {
            return context.getPackageManager().getApplicationIcon(string2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            MLog.e(TAG, "getAppIconDrawable exception", nameNotFoundException);
            return null;
        }
    }

    public static String getLauncherActivity(Context object, String string2) {
        block4: {
            Intent intent;
            Context context = object;
            object = intent;
            object("android.intent.action.MAIN");
            intent.setPackage(string2);
            intent.addCategory("android.intent.category.LAUNCHER");
            object = context.getPackageManager().queryIntentActivities((Intent)object, 0);
            if (object == null) break block4;
            if (object.isEmpty()) break block4;
            try {
                return ((ResolveInfo)object.get((int)0)).activityInfo.name;
            }
            catch (Exception exception) {
                MLog.e(TAG, "getLauncherActivity exception", exception);
            }
        }
        return null;
    }

    public static String getApplicationName(Context context, String string2) {
        try {
            PackageManager packageManager = context.getPackageManager();
            return (String)packageManager.getApplicationLabel(packageManager.getApplicationInfo(string2, 0));
        }
        catch (Exception exception) {
            MLog.e(TAG, "getApplicationName exception", exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDeviceProvisioned(Context context) {
        try {
            context = context.getContentResolver();
            if (Build.VERSION.SDK_INT >= 17 ? Settings.Global.getInt((ContentResolver)context, (String)"device_provisioned", (int)0) != 0 : Settings.System.getInt((ContentResolver)context, (String)"device_provisioned", (int)0) != 0) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return bl2;
            MLog.w(TAG, "Provisioned: " + bl2);
            return bl2;
        }
        catch (Exception exception) {
            MLog.e(TAG, "isDeviceProvisioned exception", exception);
            return true;
        }
    }

    public static String getIMEI(Context context) {
        block6: {
            f f2;
            if (TextUtils.isEmpty((CharSequence)sIMEI) && TextUtils.isEmpty((CharSequence)(sIMEI = (f2 = AndroidUtils.getSPWrapper(context)).a(KEY_IMEI, null)))) {
                block5: {
                    try {
                        if (context.checkPermission("android.permission.READ_PHONE_STATE", Process.myPid(), Process.myUid()) == 0) break block5;
                        return null;
                    }
                    catch (Exception exception) {}
                }
                sIMEI = ((TelephonyManager)context.getSystemService("phone")).getDeviceId();
                if (TextUtils.isEmpty((CharSequence)sIMEI)) break block6;
                f2.b(KEY_IMEI, sIMEI);
            }
        }
        return sIMEI;
    }

    public static String getHashedIMEI(Context object) {
        if (!TextUtils.isEmpty((CharSequence)(object = AndroidUtils.getIMEI(object)))) {
            return d.a((String)object);
        }
        return null;
    }

    public static String getHashedMac(Context context) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)sHashedMAC) && TextUtils.isEmpty((CharSequence)(sHashedMAC = AndroidUtils.getSPWrapper(context).a(KEY_WLAN_MAC, null))) && !TextUtils.isEmpty((CharSequence)(string2 = AndroidUtils.getMAC(context)))) {
            sHashedMAC = d.a(string2);
            AndroidUtils.getSPWrapper(context).b(KEY_WLAN_MAC, sHashedMAC);
        }
        MLog.i(TAG, "hashedMac: " + sHashedMAC);
        return sHashedMAC;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMAC(Context object) {
        void var0_4;
        Object var1_5 = null;
        try {
            String string2 = Build.VERSION.SDK_INT < 23 ? ((WifiManager)object.getSystemService("wifi")).getConnectionInfo().getMacAddress() : AndroidUtils.getMachineHardwareAddressAboveM();
            return var0_4;
        }
        catch (Exception exception) {
            MLog.e(TAG, "Get the mac exception", exception);
            Object var0_3 = var1_5;
        }
        return var0_4;
    }

    public static String getMachineHardwareAddressAboveM() {
        String string2;
        block18: {
            Object object;
            block19: {
                StringBuilder stringBuilder;
                Object object2;
                string2 = null;
                object = NetworkInterface.getNetworkInterfaces();
                if (object == null) {
                    return string2;
                }
                String string3 = "wlan0";
                while (true) {
                    if (!object.hasMoreElements()) break block18;
                    object2 = object.nextElement();
                    if (object2 == null) continue;
                    if (!TextUtils.equals((CharSequence)string3, (CharSequence)((NetworkInterface)object2).getName())) continue;
                    byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
                    object2 = byArray;
                    if (byArray == null) continue;
                    if (((Object)object2).length > 0) break;
                    continue;
                    break;
                }
                Object object3 = object2;
                object = stringBuilder;
                stringBuilder = new StringBuilder();
                int n2 = ((Object)object3).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object4 = object;
                    Object object5 = object2[i2];
                    Object[] objectArray = new Object[1];
                    objectArray[0] = (byte)object5;
                    ((StringBuilder)object4).append(String.format("%02X:", objectArray));
                }
                n2 = ((StringBuilder)object).length();
                if (n2 <= 0) break block19;
                ((StringBuilder)object).deleteCharAt(n2 - 1);
            }
            try {
                string2 = ((StringBuilder)object).toString();
            }
            catch (Exception exception) {
                MLog.e(TAG, "Get the mac address on android M failed.", exception);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static f getSPWrapper(Context context) {
        if (sSPWrapper != null) return sSPWrapper;
        Class<AndroidUtils> clazz = AndroidUtils.class;
        synchronized (AndroidUtils.class) {
            if (sSPWrapper != null) return sSPWrapper;
            sSPWrapper = new f(context, PREF_FILE);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sSPWrapper;
        }
    }

    public static String getHashedAndroidId(Context context) {
        try {
            return d.a(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id"));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getRomVersion(Context context) {
        return Build.VERSION.RELEASE;
    }

    public static String getPlatformName() {
        if (c.a()) {
            return "xiaomi";
        }
        return "android";
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static String getDevice() {
        return Build.DEVICE;
    }

    public static String getLocale() {
        if (Locale.getDefault() != null) {
            return Locale.getDefault().toString();
        }
        return "";
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getUA() {
        return System.getProperty("http.agent");
    }

    public static String getRegion() {
        String string2;
        block20: {
            block21: {
                string2 = h.a("ro.miui.region", "");
                if (!TextUtils.isEmpty((CharSequence)string2)) break block20;
                if (Build.VERSION.SDK_INT < 24) break block21;
                Class<?> clazz = Class.forName("android.os.LocaleList");
                Method method = clazz.getMethod("getDefault", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Class<?> clazz2 = object.getClass();
                Object object2 = clazz2.getMethod("size", new Class[0]).invoke(object, new Object[0]);
                if (!(object2 instanceof Integer)) break block21;
                if ((Integer)object2 <= 0) break block21;
                Class<?> clazz3 = object.getClass();
                Class[] classArray = new Class[1];
                classArray[0] = Integer.TYPE;
                Method method2 = clazz3.getMethod("get", classArray);
                Object object3 = object;
                Object[] objectArray = new Object[1];
                objectArray[0] = 0;
                object = method2.invoke(object3, objectArray);
                Class<?> clazz4 = object.getClass();
                object = clazz4.getMethod("getCountry", new Class[0]).invoke(object, new Object[0]);
                if (!(object instanceof String)) break block21;
                string2 = (String)object;
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) break block20;
            try {
                string2 = Locale.getDefault().getCountry();
            }
            catch (Exception exception) {
                MLog.e(TAG, "getRegion e : ", exception);
            }
        }
        return string2;
    }

    public static String getCarrierName() {
        return h.a("ro.carrier.name", "");
    }

    public static float getDeviceDensity(Context context) {
        try {
            return context.getResources().getDisplayMetrics().density;
        }
        catch (Exception exception) {
            MLog.e(TAG, "getDeviceDensity exception", exception);
            return -1.0f;
        }
    }

    public static int getScreenWidth(Context context) {
        if (sScreenWidth == 0) {
            if (Build.VERSION.SDK_INT >= 19) {
                DisplayMetrics displayMetrics;
                Context context2 = context;
                context = displayMetrics;
                displayMetrics = new DisplayMetrics();
                ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getRealMetrics((DisplayMetrics)context);
                sScreenWidth = Math.min(context.heightPixels, context.widthPixels);
            } else {
                sScreenWidth = Math.min(context.getResources().getDisplayMetrics().widthPixels, context.getResources().getDisplayMetrics().heightPixels);
            }
        }
        return sScreenWidth;
    }

    public static int getScreenHeight(Context context) {
        if (sScreenHeight == 0) {
            if (Build.VERSION.SDK_INT >= 19) {
                DisplayMetrics displayMetrics;
                Context context2 = context;
                context = displayMetrics;
                displayMetrics = new DisplayMetrics();
                ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getRealMetrics((DisplayMetrics)context);
                sScreenHeight = Math.max(context.heightPixels, context.widthPixels);
            } else {
                sScreenHeight = Math.max(context.getResources().getDisplayMetrics().widthPixels, context.getResources().getDisplayMetrics().heightPixels);
            }
        }
        return sScreenHeight;
    }

    public static int dpToPx(Context context, int n2) {
        context = context.getResources().getDisplayMetrics();
        return Math.round((float)n2 * context.density);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStatusBarHeight(Context context) {
        if (sStatusBarHeight > 0) {
            return sStatusBarHeight;
        }
        Class<AndroidUtils> clazz = AndroidUtils.class;
        synchronized (AndroidUtils.class) {
            if (sStatusBarHeight == 0) {
                int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
                if (n2 > 0) {
                    sStatusBarHeight = context.getResources().getDimensionPixelSize(n2);
                    return sStatusBarHeight;
                }
            }
            finally {
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNavigationBarHeight(Context context) {
        if (sNavBarHeight > 0) {
            return sNavBarHeight;
        }
        Class<AndroidUtils> clazz = AndroidUtils.class;
        synchronized (AndroidUtils.class) {
            if (sNavBarHeight == 0) {
                int n2 = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
                if (n2 > 0) {
                    sNavBarHeight = context.getResources().getDimensionPixelSize(n2);
                    return sNavBarHeight;
                }
            }
            finally {
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public static void setBackground(View view, Drawable drawable2) {
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static String getAndroidId(Context context) {
        try {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            MLog.e(TAG, "getAndroidId Exception: ", exception);
            return "";
        }
    }

    public static String getModDevice() {
        return h.a("ro.product.mod_device", "");
    }

    public static String getStackTrace(Throwable object) {
        StringWriter stringWriter;
        if (object == null) {
            return "";
        }
        Throwable throwable = object;
        object = stringWriter;
        stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)object));
        return ((StringWriter)object).toString();
    }

    public static boolean checkSkipAdWebViewUrl(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        Uri uri = Uri.parse((String)string2);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)uri.getQueryParameter(SKIP_AD_REMOTE_WEBVIEW)) && uri.getQueryParameter(SKIP_AD_REMOTE_WEBVIEW).equals("true");
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string2;
        objectArray[1] = bl2;
        MLog.i(TAG, String.format("checkSkipAdWebViewUrl:%s, result is %s", objectArray2));
        return bl2;
    }

    public static boolean openUrlWithBrowser(Context context, String string2) {
        block5: {
            if (context != null) {
                if (TextUtils.isEmpty((CharSequence)string2)) break block5;
                Context context2 = context;
                Intent intent = Intent.parseUri((String)string2, (int)0);
                Intent intent2 = intent;
                intent.setFlags(0x10000000);
                try {
                    context2.startActivity(intent2);
                    return true;
                }
                catch (Exception exception) {
                    MLog.e(TAG, "openUrlWithBrowser exception:", exception);
                }
            }
        }
        return false;
    }

    public static void enterFullScreenMode(View view) {
        if (view != null) {
            view.getRootView().setSystemUiVisibility(5382);
        }
    }

    public static void exitFullScreenMode(View view) {
        if (view != null) {
            view.getRootView().setSystemUiVisibility(0);
        }
    }

    public static void runOnMainThread(Handler handler, Runnable runnable) {
        if (handler != null && runnable != null) {
            if (AndroidUtils.isMainThread()) {
                runnable.run();
            } else {
                handler.post(runnable);
            }
            return;
        }
    }

    public static boolean getRestrictImei() {
        return "1".equals(h.a("ro.miui.restrict_imei_p"));
    }
}

