/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.ad.mediation.internal.loader.load;

import android.content.Context;
import b.c.a.a.a.a;
import b.c.a.a.a.a.b;
import b.c.a.a.c;
import com.xiaomi.ad.common.util.MLog;
import com.xiaomi.ad.common.util.e;
import com.xiaomi.ad.mediation.MMAdError;
import com.xiaomi.ad.mediation.internal.DspWeight;
import com.xiaomi.ad.mediation.internal.loader.AdBaseTask;
import com.xiaomi.ad.mediation.internal.loader.AdInternalConfig;
import com.xiaomi.ad.mediation.internal.loader.load.AdLoadBaseTask;
import com.xiaomi.ad.mediation.internal.loader.load.AdLoadListener;
import com.xiaomi.ad.mediation.internal.loader.load.AdLoadable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AdLoadTask<T extends a>
extends AdLoadBaseTask
implements AdLoadListener<T> {
    public static final String TAG = "AdLoadTask";
    public long TASK_LOAD_TIME_OUT = 10000L;
    public AdLoadable<T> mAdLoadable;
    public AdBaseTask.AdTaskListener mAdTaskListener;
    public b<T> mAdCacheItem;
    public AdInternalConfig mAdConfig;
    public Future mTaskLoadTimeOutFuture;
    public Runnable TaskTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            AdLoadTask adLoadTask = AdLoadTask.this;
            if (adLoadTask.isCancelled) {
                return;
            }
            adLoadTask.isCancelled = true;
            if (adLoadTask.mAdTaskListener != null) {
                MLog.e(AdLoadTask.TAG, "Failed to load ads from : " + AdLoadTask.this.mADInfoFlag + "  current task load time out");
                AdLoadTask.this.mAdTaskListener.onExecuteFail(AdLoadTask.this, new MMAdError(-200));
            }
        }
    };

    public AdLoadTask(String string2, b<T> b2, int n2, AdInternalConfig adInternalConfig) {
        super(n2);
        this.mADInfoFlag = string2;
        this.mAdCacheItem = b2;
        this.mAdConfig = adInternalConfig;
    }

    public b<T> getAdCacheItem() {
        return this.mAdCacheItem;
    }

    public AdInternalConfig getAdConfig() {
        return this.mAdConfig;
    }

    public boolean initLoader(Context context, String string2, String string3) {
        this.mAdLoadable = c.a().a(context, string2, string3);
        return this.mAdLoadable != null;
    }

    public boolean hasCacheAds() {
        int n2 = this.mAdCacheItem.a(this.mADInfoFlag);
        if (n2 != 0 && n2 >= this.mAdConfig.adCount) {
            MLog.d(TAG, this.mADInfoFlag + "->load ads count =" + this.mAdConfig.adCount + " \n current has ad size = " + n2 + "  use cache ad ");
            return true;
        }
        MLog.d(TAG, this.mADInfoFlag + "->load ads count =" + this.mAdConfig.adCount + " \n current has ad size = " + n2 + "  don't use cache ad ");
        return false;
    }

    @Override
    public void onLoaded(List<T> list) {
        List<DspWeight> list2;
        MLog.d(TAG, "Success to load ads from : " + this.mADInfoFlag);
        if (this.isCancelled) {
            MLog.d(TAG, "for mimo-mediation only: ad timeout, don't save to cache");
            return;
        }
        if (this.isBid) {
            list2 = list.iterator();
            while (list2.hasNext()) {
                ((a)list2.next()).setAdId(e.a());
            }
        }
        AdLoadTask adLoadTask = this;
        adLoadTask.mAdCacheItem.a(this.mADInfoFlag, list);
        if (adLoadTask.isBid && this.mADInfoFlag.contains("mimo")) {
            ArrayList arrayList;
            list2 = arrayList;
            arrayList = new ArrayList();
            if (!list.isEmpty()) {
                list2 = ((a)list.get(0)).getDspWeightList();
            }
            if (!list2.isEmpty()) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    DspWeight dspWeight;
                    DspWeight dspWeight2 = dspWeight;
                    dspWeight = new DspWeight("mimo", ((a)list.get(i2)).getWeight());
                    this.mDspWeightList.add(dspWeight2);
                }
                AdLoadTask adLoadTask2 = this;
                adLoadTask2.mDspWeightList.addAll(list2);
                Collections.sort(adLoadTask2.mDspWeightList, new Comparator<DspWeight>(){

                    @Override
                    public int compare(DspWeight dspWeight, DspWeight dspWeight2) {
                        return Integer.compare(dspWeight2.getWeight(), dspWeight.getWeight());
                    }
                });
                adLoadTask2.mAdCacheItem.a(list2);
            } else {
                MLog.d(TAG, "dspWeights is empty, mAdCacheItem setBid false");
                this.mAdCacheItem.a(false);
            }
        }
        this.notifyExecuteSucess();
    }

    @Override
    public void onError(MMAdError mMAdError) {
        MLog.e(TAG, "Failed to load ads from : " + this.mADInfoFlag + " Error : " + mMAdError.toString());
        this.notifyExectueFail(mMAdError);
    }

    @Override
    public void execute(AdBaseTask.AdTaskListener adTaskListener) {
        if (this.mAdLoadable == null) {
            this.notifyExectueFail(new MMAdError(-700));
            MLog.d(TAG, this.mADInfoFlag + " no ad adapter ");
            return;
        }
        MLog.d(TAG, "Start to load ad from : " + this.mADInfoFlag + " priority ->" + this.mPriority);
        this.mAdTaskListener = adTaskListener;
        this.mTaskLoadTimeOutFuture = com.xiaomi.ad.common.util.c.h.schedule(this.TaskTimeOutRunnable, this.TASK_LOAD_TIME_OUT, TimeUnit.MILLISECONDS);
        this.mAdLoadable.load(this.mAdConfig, this);
    }

    public void notifyExecuteSucess() {
        Object object = this.mTaskLoadTimeOutFuture;
        if (object != null) {
            object.cancel(true);
        }
        if (this.isCancelled) {
            return;
        }
        object = this.mAdTaskListener;
        if (object != null) {
            object.onExecuteSuccess(this);
        }
    }

    public void notifyExectueFail(MMAdError mMAdError) {
        Object object = this.mTaskLoadTimeOutFuture;
        if (object != null) {
            object.cancel(true);
        }
        if (this.isCancelled) {
            return;
        }
        object = this.mAdTaskListener;
        if (object != null) {
            object.onExecuteFail(this, mMAdError);
        }
    }
}

