/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.ad.mediation.internal.loader.load;

import b.c.a.a.e;
import com.xiaomi.ad.common.util.MLog;
import com.xiaomi.ad.common.util.c;
import com.xiaomi.ad.mediation.MMAdError;
import com.xiaomi.ad.mediation.internal.DspWeight;
import com.xiaomi.ad.mediation.internal.loader.AdBaseTask;
import com.xiaomi.ad.mediation.internal.loader.load.AdLoadBaseTask;
import com.xiaomi.ad.mediation.internal.loader.load.AdLoadTaskGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AdParallelLoadTaskGroup
extends AdLoadTaskGroup {
    public static final String TAG = "ParallelLoadTask";
    public static final int BID_RESULT_UNKNOWN = 0;
    public static final int BID_RESULT_SUCCESS = 1;
    public static final int BID_RESULT_FAIL = -1;
    public AdBaseTask.AdTaskListener mAdTaskListener;
    public e mError;
    public List<AdLoadBaseTask> mRuningTask = new ArrayList<AdLoadBaseTask>();
    public List<AdBaseTask> mRunedTask = new ArrayList<AdBaseTask>();
    public Lock mLock = new ReentrantLock();
    public Future mTimeOut;
    public boolean mTaskTimeOut = true;
    public int mBidResult = 0;
    public String mXiaomiAdInfoFlag = "";
    public AdBaseTask.AdTaskListener runAdTaskListener = new AdBaseTask.AdTaskListener(){

        @Override
        public void onExecuteSuccess(AdBaseTask adBaseTask) {
            MLog.d(AdParallelLoadTaskGroup.TAG, "parallel loadTask  run  success " + adBaseTask.mADInfoFlag + " priority = " + adBaseTask.mPriority);
            AdParallelLoadTaskGroup.this.currentTaskSucess(adBaseTask);
        }

        @Override
        public void onExecuteFail(AdBaseTask adBaseTask, MMAdError mMAdError) {
            MLog.d(AdParallelLoadTaskGroup.TAG, "parallel load Task run fail " + adBaseTask.mADInfoFlag + " priority = " + adBaseTask.mPriority + mMAdError.errorMessage);
            AdParallelLoadTaskGroup.this.currentTaskFail(adBaseTask, mMAdError);
        }
    };
    public int mParallelLoadAdNum = 1;

    public AdParallelLoadTaskGroup(int n2) {
        super(n2);
    }

    public AdParallelLoadTaskGroup(int n2, int n3) {
        super(n2);
        this.mParallelLoadAdNum = n3;
    }

    private void handleSuccess(AdBaseTask adBaseTask) {
        if (this.hasHigherPriorityRuningTask(adBaseTask)) {
            this.taskSuccess(adBaseTask);
        } else if (this.mRuningTask.isEmpty()) {
            MLog.d(TAG, " current task success " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + " task is empty and runing task is empty so success ");
            this.taskSuccess(adBaseTask);
        } else {
            MLog.d(TAG, " current task success " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + " but isn't higher priority  and task is empty so wait other load task result ");
        }
    }

    private void handleRequestFailed(AdBaseTask adBaseTask, MMAdError mMAdError) {
        List<AdBaseTask> list;
        if (!this.mRunedTask.isEmpty()) {
            AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
            Collections.sort(adParallelLoadTaskGroup.mRunedTask);
            if (adParallelLoadTaskGroup.hasHigherPriorityRuningTask(adParallelLoadTaskGroup.mRunedTask.get(0))) {
                AdParallelLoadTaskGroup adParallelLoadTaskGroup2 = this;
                adParallelLoadTaskGroup2.taskSuccess(adParallelLoadTaskGroup2.mRunedTask.get(0));
                return;
            }
        }
        if ((list = this.mRunedTask) != null && list.size() > 0) {
            return;
        }
        if (!this.mTasks.isEmpty()) {
            MLog.d(TAG, " current task fail " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + "  task isn't empty so run next task ");
            this.executeNextTask();
        } else if (this.mRuningTask.isEmpty()) {
            MLog.d(TAG, " current task fail " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + "  task is empty and runing task is empty so all fail ");
            this.taskFail(mMAdError);
        } else {
            MLog.d(TAG, " current task fail " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + " wait other load task result ");
        }
    }

    private void taskSuccess(AdBaseTask object) {
        if (!this.isBid) {
            MLog.d(TAG, "parallel load Task  this highest priority success : " + ((AdBaseTask)object).mADInfoFlag + " priority =" + ((AdBaseTask)object).mPriority);
        }
        AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
        adParallelLoadTaskGroup.cancelAllRunTask();
        object = adParallelLoadTaskGroup.mAdTaskListener;
        if (object != null) {
            object.onExecuteSuccess(this);
        }
        AdParallelLoadTaskGroup adParallelLoadTaskGroup2 = this;
        adParallelLoadTaskGroup2.cancleTimeOutRunable();
        adParallelLoadTaskGroup2.mDspWeightList.clear();
    }

    private void taskFail(MMAdError mMAdError) {
        if (this.mAdTaskListener != null) {
            e e2 = this.mError;
            if (e2 != null) {
                e2.a(mMAdError);
            }
            AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
            this.mAdTaskListener.onExecuteFail(adParallelLoadTaskGroup, adParallelLoadTaskGroup.mError);
        }
        AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
        adParallelLoadTaskGroup.cancleTimeOutRunable();
        adParallelLoadTaskGroup.mDspWeightList.clear();
    }

    private void executeNextTask() {
        AdParallelLoadTaskGroup adParallelLoadTaskGroup;
        AdLoadBaseTask adLoadBaseTask;
        AdParallelLoadTaskGroup adParallelLoadTaskGroup2 = this;
        adParallelLoadTaskGroup2.mLock.lock();
        try {
            adLoadBaseTask = adParallelLoadTaskGroup2.mTasks.get(0);
            adParallelLoadTaskGroup = this;
        }
        catch (Throwable throwable) {
            this.mLock.unlock();
            throw throwable;
        }
        MLog.d(TAG, "run next load Task : " + adLoadBaseTask.mADInfoFlag + " priority =" + adLoadBaseTask.mPriority);
        adParallelLoadTaskGroup.mTasks.remove(adLoadBaseTask);
        adParallelLoadTaskGroup.mRuningTask.add(adLoadBaseTask);
        adLoadBaseTask.execute(adParallelLoadTaskGroup.runAdTaskListener);
        adParallelLoadTaskGroup2.mLock.unlock();
    }

    private void parallelLoadTaskTimeOut() {
        AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
        adParallelLoadTaskGroup.cancelAllRunTask();
        if (adParallelLoadTaskGroup.mRunedTask.isEmpty()) {
            if (this.mAdTaskListener != null) {
                MLog.d(TAG, "parallel task load time out ,no dsp load success, notify load fail");
                this.mAdTaskListener.onExecuteFail(this, new MMAdError(-200));
            }
        } else {
            MLog.d(TAG, "parallel task load time out ,has dsp load success, notify load success");
            AdBaseTask.AdTaskListener adTaskListener = this.mAdTaskListener;
            if (adTaskListener != null) {
                adTaskListener.onExecuteSuccess(this);
            }
        }
    }

    private void cancelAllRunTask() {
        List<AdLoadBaseTask> list2 = ((AdParallelLoadTaskGroup)this).mRuningTask;
        if (list2 != null && !list2.isEmpty()) {
            for (AdBaseTask adBaseTask : ((AdParallelLoadTaskGroup)this).mRuningTask) {
                MLog.d(TAG, "cancel other parallel load Task   : " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority);
                adBaseTask.cancel();
            }
        }
    }

    private void cancleTimeOutRunable() {
        Future future = this.mTimeOut;
        if (future != null) {
            future.cancel(true);
        }
        this.mTaskTimeOut = false;
    }

    @Override
    public void execute(AdBaseTask.AdTaskListener adTaskListener) {
        MLog.d(TAG, "start parallel Load task group");
        if (this.mTasks.isEmpty()) {
            adTaskListener = this.mAdTaskListener;
            if (adTaskListener != null) {
                adTaskListener.onExecuteFail(this, new MMAdError(-800));
            }
            return;
        }
        this.mTimeOut = c.h.schedule(new Runnable(){

            @Override
            public void run() {
                if (AdParallelLoadTaskGroup.this.mTaskTimeOut) {
                    AdParallelLoadTaskGroup.this.parallelLoadTaskTimeOut();
                }
            }
        }, this.TASKTIMEOUT, TimeUnit.MILLISECONDS);
        Collections.sort(this.mTasks);
        this.mError = new e(-300);
        this.mAdTaskListener = adTaskListener;
        this.startAllRequest();
    }

    public void startAllRequest() {
        int n2 = this.mParallelLoadAdNum;
        if (this.mTasks.size() >= n2) {
            List<AdLoadBaseTask> list = this.mTasks.subList(0, n2);
            this.mRuningTask.addAll(list);
            list.clear();
        } else {
            AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
            adParallelLoadTaskGroup.mRuningTask.addAll(this.mTasks);
            adParallelLoadTaskGroup.mTasks.clear();
        }
        for (AdLoadBaseTask adLoadBaseTask : new ArrayList<AdLoadBaseTask>(this.mRuningTask)) {
            if (adLoadBaseTask == null) continue;
            MLog.d(TAG, "start parallel Load task " + adLoadBaseTask.mADInfoFlag + " priority =" + adLoadBaseTask.mPriority);
            adLoadBaseTask.execute(this.runAdTaskListener);
        }
    }

    public void currentTaskSucess(AdBaseTask adBaseTask) {
        List<AdLoadBaseTask> list = this.mRuningTask;
        if (list != null) {
            list.remove(adBaseTask);
        }
        AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
        adParallelLoadTaskGroup.mRunedTask.add(adBaseTask);
        if (adParallelLoadTaskGroup.isBid) {
            if (adBaseTask.mADInfoFlag.contains("mimo")) {
                if (adBaseTask.getDspWeightList().isEmpty()) {
                    this.isBid = false;
                    this.handleSuccess(adBaseTask);
                    return;
                }
                this.mBidResult = 1;
                this.mXiaomiAdInfoFlag = adBaseTask.mADInfoFlag;
                if (adBaseTask.getDspWeightList().size() >= this.getAdCount()) {
                    List<DspWeight> list2 = adBaseTask.getDspWeightList().subList(0, this.getAdCount());
                    this.mDspWeightList.addAll(list2);
                    boolean bl2 = true;
                    Iterator<DspWeight> iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().getDsp().contains("mimo")) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2 || this.mRuningTask.size() == 0) {
                        this.taskSuccess(adBaseTask);
                    }
                } else if (this.mRuningTask.size() == 0) {
                    this.taskSuccess(adBaseTask);
                }
            } else {
                int n2 = this.mBidResult;
                if (n2 == 1) {
                    if (this.mRunedTask.size() >= this.mParallelLoadAdNum || this.mRuningTask.size() == 0) {
                        this.taskSuccess(adBaseTask);
                    }
                } else if (n2 == -1 && this.mAdCacheItem.a(this.mXiaomiAdInfoFlag) == 0) {
                    this.handleSuccess(adBaseTask);
                } else if (this.mRuningTask.size() == 0) {
                    this.taskSuccess(adBaseTask);
                }
            }
        } else {
            this.handleSuccess(adBaseTask);
        }
    }

    public void currentTaskFail(AdBaseTask adBaseTask, MMAdError mMAdError) {
        List<AdLoadBaseTask> list = this.mRuningTask;
        if (list != null) {
            list.remove(adBaseTask);
        }
        if (this.isBid) {
            if (adBaseTask.mADInfoFlag.contains("mimo")) {
                AdParallelLoadTaskGroup adParallelLoadTaskGroup = this;
                adParallelLoadTaskGroup.mXiaomiAdInfoFlag = adBaseTask.mADInfoFlag;
                adParallelLoadTaskGroup.mBidResult = -1;
                this.handleRequestFailed(adBaseTask, mMAdError);
            } else {
                int n2 = this.mBidResult;
                if (n2 == 0) {
                    if (!this.isTaskEmpty()) {
                        MLog.d(TAG, " current task fail " + adBaseTask.mADInfoFlag + " priority =" + adBaseTask.mPriority + "  task isn't empty so run next task ");
                        this.executeNextTask();
                    }
                } else if (n2 == 1) {
                    if (!this.isTaskEmpty()) {
                        this.executeNextTask();
                    } else if (this.mRuningTask.size() == 0) {
                        this.taskSuccess(adBaseTask);
                    }
                } else {
                    this.handleRequestFailed(adBaseTask, mMAdError);
                }
            }
        } else {
            this.handleRequestFailed(adBaseTask, mMAdError);
        }
    }

    public boolean hasHigherPriorityRuningTask(AdBaseTask adBaseTask) {
        List<AdLoadBaseTask> list = ((AdParallelLoadTaskGroup)((Object)iterator)).mRuningTask;
        if (list != null && !list.isEmpty()) {
            Iterator<AdLoadBaseTask> iterator = ((AdParallelLoadTaskGroup)((Object)iterator)).mRuningTask.iterator();
            while (iterator.hasNext()) {
                if (((AdBaseTask)iterator.next()).mPriority <= adBaseTask.mPriority) continue;
                return false;
            }
        }
        return true;
    }
}

