/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.ad.mediation.mimo;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import com.miui.zeus.mimo.sdk.BannerAd;
import com.xiaomi.ad.common.util.AndroidUtils;
import com.xiaomi.ad.common.util.MLog;
import com.xiaomi.ad.mediation.MMAdConfig;
import com.xiaomi.ad.mediation.MMAdError;
import com.xiaomi.ad.mediation.banner.MMAdBannerAdapter;
import com.xiaomi.ad.mediation.internal.loader.AdInternalConfig;
import com.xiaomi.ad.mediation.internal.loader.loadandshow.AdLoadAndShowInteractionListener;
import com.xiaomi.ad.mediation.internal.loader.loadandshow.AdLoadAndShowListener;

public class MiMoAdBannerAdapter
extends MMAdBannerAdapter {
    public static final String TAG = "MiMoAdBannerAdapter";
    public BannerAd mBannerAd;
    public ViewGroup mContainerView;
    public Handler mMainHandler;
    public BannerAd.BannerInteractionListener mBannerInteractionListener = new BannerAd.BannerInteractionListener(){

        @Override
        public void onAdClick() {
            MLog.d(MiMoAdBannerAdapter.TAG, "mimo ad onAdClicked");
            MiMoAdBannerAdapter.this.notifyAdClicked();
        }

        @Override
        public void onAdShow() {
            MLog.d(MiMoAdBannerAdapter.TAG, " mimo ad onAdShow");
            MiMoAdBannerAdapter.this.notifyAdShow();
        }

        @Override
        public void onAdDismiss() {
            MLog.d(MiMoAdBannerAdapter.TAG, " mimo ad onAdDismiss");
            MiMoAdBannerAdapter.this.notifyAdDismissed();
        }

        @Override
        public void onRenderSuccess() {
            MLog.d(MiMoAdBannerAdapter.TAG, " mimo ad onRenderSuccess");
            MiMoAdBannerAdapter.this.notifyLoadSuccess();
        }

        @Override
        public void onRenderFail(int n2, String string2) {
            b b2 = this;
            int n3 = n2;
            b2.MiMoAdBannerAdapter.this.notifyLoadError(new MMAdError(n3, String.valueOf(n3), string2));
            b2.MiMoAdBannerAdapter.this.trackDspLoad(String.valueOf(n2), string2);
        }
    };

    public MiMoAdBannerAdapter(Context context, String string2) {
        super(context, string2);
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    private void loadBannerAd(AdInternalConfig object) {
        Activity activity = ((MMAdConfig)object).getBannerActivity();
        this.mContainerView = ((MMAdConfig)object).getBannerContainer();
        object = ((AdInternalConfig)object).adPositionId;
        this.mBannerAd = new BannerAd();
        if (activity == null) {
            MLog.e(TAG, "can not load banner ad, bannerActivity is null");
            return;
        }
        if (this.mContainerView == null) {
            MLog.e(TAG, "can not load banner ad, bannerContainer is null");
            return;
        }
        BannerAd bannerAd = this.mBannerAd;
        if (bannerAd == null) {
            MLog.e(TAG, "can not load banner ad, bannerAd init failed");
            this.notifyLoadError(new MMAdError(-800));
            return;
        }
        bannerAd.loadAd((String)object, new BannerAd.BannerLoadListener(){

            @Override
            public void onBannerAdLoadSuccess() {
                MLog.w(MiMoAdBannerAdapter.TAG, "load banner ad success ,start render");
                if (MiMoAdBannerAdapter.this.mBannerAd != null) {
                    MLog.w(MiMoAdBannerAdapter.TAG, "start show banner ad");
                    MiMoAdBannerAdapter.this.mBannerAd.showAd(MiMoAdBannerAdapter.this.mConfig.getBannerActivity(), MiMoAdBannerAdapter.this.mContainerView, MiMoAdBannerAdapter.this.mBannerInteractionListener);
                } else {
                    c c2 = this;
                    MLog.w(MiMoAdBannerAdapter.TAG, "load banner ad success,but banner ad is null");
                    c2.MiMoAdBannerAdapter.this.notifyLoadError(new MMAdError(-2000));
                    c2.MiMoAdBannerAdapter.this.trackDspLoad(String.valueOf(-2000), null);
                }
            }

            @Override
            public void onAdLoadFailed(int n2, String string2) {
                c c2 = this;
                MLog.w(MiMoAdBannerAdapter.TAG, "onError [" + n2 + "] " + string2);
                c2.MiMoAdBannerAdapter.this.notifyLoadError(new MMAdError(-300, String.valueOf(n2), string2));
                c2.MiMoAdBannerAdapter.this.trackDspLoad(String.valueOf(n2), string2);
            }
        });
    }

    public <T extends AdLoadAndShowInteractionListener> void loadAndShow(final AdInternalConfig adInternalConfig, AdLoadAndShowListener adLoadAndShowListener, T t2) {
        MiMoAdBannerAdapter miMoAdBannerAdapter = this;
        super.loadAndShow(adInternalConfig, adLoadAndShowListener, t2);
        AndroidUtils.runOnMainThread(miMoAdBannerAdapter.mMainHandler, new Runnable(){

            @Override
            public void run() {
                MiMoAdBannerAdapter.this.loadBannerAd(adInternalConfig);
            }
        });
    }

    public void destroy() {
        MiMoAdBannerAdapter miMoAdBannerAdapter = this;
        super.destroy();
        ViewGroup viewGroup = miMoAdBannerAdapter.mContainerView;
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        if ((this = ((MiMoAdBannerAdapter)((Object)this)).mBannerAd) != null) {
            ((BannerAd)this).destroy();
        }
    }

    public String getDspName() {
        return "mimo";
    }
}

