/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.gamecenter.sdk.entry;

import android.content.Context;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import com.xiaomi.gamecenter.sdk.IServiceCallback;
import com.xiaomi.gamecenter.sdk.MiCommplatform;
import com.xiaomi.gamecenter.sdk.PluginVersionCode;
import com.xiaomi.gamecenter.sdk.entry.DebugMode;
import com.xiaomi.gamecenter.sdk.entry.MiAccountInfo;
import com.xiaomi.gamecenter.sdk.entry.MiAppInfo;
import com.xiaomi.gamecenter.sdk.entry.MiAppType;
import com.xiaomi.gamecenter.sdk.entry.MiGravity;
import com.xiaomi.gamecenter.sdk.entry.PayMode;
import com.xiaomi.gamecenter.sdk.entry.ScreenOrientation;
import com.xiaomi.gamecenter.sdk.entry.i;
import com.xiaomi.gamecenter.sdk.utils.HyUtils;

public class MiAppEntry
implements Parcelable {
    private int pid;
    private int uid;
    private Context ctx;
    private int appId;
    private String appKey;
    private MiAppType appType;
    private ScreenOrientation orientation;
    private boolean weakAccount;
    private String cpMark = "XXX";
    private PayMode payMode = PayMode.custom;
    private MiAccountInfo account;
    private String pkgName;
    private String pkgLabel;
    private IServiceCallback callback;
    private int SDK_INDEX = PluginVersionCode.b();
    private String newAppId;
    private DebugMode debugMode = DebugMode.ONLINE;
    private boolean isSocialGame = false;
    private MiGravity miGravity = MiGravity.MI_TOP_RIGHT;
    private String sdkVerName;
    private String gameVerName;
    private String gameVerCode;
    public static final Parcelable.Creator<MiAppEntry> CREATOR = new i();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeInt(this.appId);
        parcel.writeString(this.appKey);
        parcel.writeString(this.appType.toString());
        parcel.writeString(this.cpMark);
        parcel.writeString(this.orientation.toString());
        parcel.writeString(Boolean.toString(this.weakAccount));
        parcel.writeString(this.payMode.toString());
        parcel.writeParcelable((Parcelable)this.account, 0);
        parcel.writeString(this.pkgName);
        parcel.writeString(this.pkgLabel);
        parcel.writeInt(this.pid);
        parcel.writeInt(this.uid);
        parcel.writeStrongInterface((IInterface)this.callback);
        parcel.writeInt(this.SDK_INDEX);
        parcel.writeString(this.newAppId);
        parcel.writeString(this.debugMode.toString());
        parcel.writeString(Boolean.toString(this.isSocialGame));
        parcel.writeString(this.miGravity.toString());
        if (MiAppInfo.sServiceVerCode <= 0L) {
            MiAppInfo.sServiceVerCode = HyUtils.d(MiCommplatform.getApplicationContext());
        }
        if (MiAppInfo.sServiceVerCode >= 6010100L) {
            parcel.writeString(this.sdkVerName);
            parcel.writeString(this.gameVerName);
            parcel.writeString(this.gameVerCode);
        }
    }

    private MiAppEntry() {
        this.orientation = ScreenOrientation.vertical;
        this.weakAccount = false;
    }

    public MiAppEntry(MiAppInfo miAppInfo) {
        this.appKey = miAppInfo.getAppKey();
        this.appType = miAppInfo.getAppType();
        this.cpMark = miAppInfo.getCpMark();
        this.orientation = miAppInfo.getOrientation();
        this.account = miAppInfo.getAccount();
        this.newAppId = miAppInfo.getAppId();
        this.debugMode = miAppInfo.getDebugMode();
        this.isSocialGame = miAppInfo.isSocialGame();
        if (miAppInfo.getCtx() != null) {
            this.pkgName = miAppInfo.getCtx().getPackageName();
        }
        this.sdkVerName = miAppInfo.getSdkVerName();
        this.gameVerName = miAppInfo.getGameVerName();
        this.gameVerCode = miAppInfo.getGameVerCode();
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getPkgLabel() {
        return this.pkgLabel;
    }

    public String getNewAppId() {
        return this.newAppId;
    }

    public String getAppId() {
        if (this.appId == 0 && this.SDK_INDEX > 1) {
            return this.newAppId;
        }
        this.newAppId = String.valueOf(this.appId);
        return this.newAppId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public MiAppType getAppType() {
        return this.appType;
    }

    /* synthetic */ MiAppEntry(i i2) {
        this();
    }

    static /* synthetic */ int access$102(MiAppEntry miAppEntry, int n2) {
        miAppEntry.appId = n2;
        return miAppEntry.appId;
    }

    static /* synthetic */ String access$202(MiAppEntry miAppEntry, String string2) {
        miAppEntry.appKey = string2;
        return miAppEntry.appKey;
    }

    static /* synthetic */ MiAppType access$302(MiAppEntry miAppEntry, MiAppType miAppType) {
        miAppEntry.appType = miAppType;
        return miAppEntry.appType;
    }

    static /* synthetic */ String access$402(MiAppEntry miAppEntry, String string2) {
        miAppEntry.cpMark = string2;
        return miAppEntry.cpMark;
    }

    static /* synthetic */ ScreenOrientation access$502(MiAppEntry miAppEntry, ScreenOrientation screenOrientation) {
        miAppEntry.orientation = screenOrientation;
        return miAppEntry.orientation;
    }

    static /* synthetic */ boolean access$602(MiAppEntry miAppEntry, boolean bl2) {
        miAppEntry.weakAccount = bl2;
        return miAppEntry.weakAccount;
    }

    static /* synthetic */ PayMode access$702(MiAppEntry miAppEntry, PayMode payMode) {
        miAppEntry.payMode = payMode;
        return miAppEntry.payMode;
    }

    static /* synthetic */ MiAccountInfo access$802(MiAppEntry miAppEntry, MiAccountInfo miAccountInfo) {
        miAppEntry.account = miAccountInfo;
        return miAppEntry.account;
    }

    static /* synthetic */ String access$902(MiAppEntry miAppEntry, String string2) {
        miAppEntry.pkgName = string2;
        return miAppEntry.pkgName;
    }

    static /* synthetic */ String access$1002(MiAppEntry miAppEntry, String string2) {
        miAppEntry.pkgLabel = string2;
        return miAppEntry.pkgLabel;
    }

    static /* synthetic */ int access$1102(MiAppEntry miAppEntry, int n2) {
        miAppEntry.pid = n2;
        return miAppEntry.pid;
    }

    static /* synthetic */ int access$1202(MiAppEntry miAppEntry, int n2) {
        miAppEntry.uid = n2;
        return miAppEntry.uid;
    }

    static /* synthetic */ IServiceCallback access$1302(MiAppEntry miAppEntry, IServiceCallback iServiceCallback) {
        miAppEntry.callback = iServiceCallback;
        return miAppEntry.callback;
    }

    static /* synthetic */ int access$1402(MiAppEntry miAppEntry, int n2) {
        miAppEntry.SDK_INDEX = n2;
        return miAppEntry.SDK_INDEX;
    }

    static /* synthetic */ String access$1502(MiAppEntry miAppEntry, String string2) {
        miAppEntry.newAppId = string2;
        return miAppEntry.newAppId;
    }

    static /* synthetic */ DebugMode access$1602(MiAppEntry miAppEntry, DebugMode debugMode) {
        miAppEntry.debugMode = debugMode;
        return miAppEntry.debugMode;
    }

    static /* synthetic */ boolean access$1702(MiAppEntry miAppEntry, boolean bl2) {
        miAppEntry.isSocialGame = bl2;
        return miAppEntry.isSocialGame;
    }

    static /* synthetic */ MiGravity access$1802(MiAppEntry miAppEntry, MiGravity miGravity) {
        miAppEntry.miGravity = miGravity;
        return miAppEntry.miGravity;
    }

    static /* synthetic */ String access$1902(MiAppEntry miAppEntry, String string2) {
        miAppEntry.sdkVerName = string2;
        return miAppEntry.sdkVerName;
    }

    static /* synthetic */ String access$2002(MiAppEntry miAppEntry, String string2) {
        miAppEntry.gameVerName = string2;
        return miAppEntry.gameVerName;
    }

    static /* synthetic */ String access$2102(MiAppEntry miAppEntry, String string2) {
        miAppEntry.gameVerCode = string2;
        return miAppEntry.gameVerCode;
    }
}

