/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.gamecenter.sdk.utils;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Scroller;
import android.widget.TextView;
import com.xiaomi.gamecenter.sdk.utils.g;

public class MarqueeTextView
extends TextView {
    private static final int ROLLING_INTERVAL_DEFAULT = 20;
    private static final int FIRST_SCROLL_DELAY_DEFAULT = 1000;
    public static final int SCROLL_FOREVER = 0;
    public static final int SCROLL_ONCE = 1;
    private Scroller mScroller;
    private int mRollingInterval;
    private int mXPaused = 0;
    private boolean mPaused = true;
    private boolean mFirst = true;
    private int mScrollMode;
    private int mFirstScrollDelay;

    public MarqueeTextView(Context context) {
        this(context, null);
    }

    public MarqueeTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MarqueeTextView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.initView();
    }

    private void initView() {
        this.mRollingInterval = 20;
        this.mScrollMode = 0;
        this.mFirstScrollDelay = 1000;
        this.setSingleLine();
        this.setEllipsize(null);
    }

    public void startScroll() {
        this.mXPaused = 0;
        this.mPaused = true;
        this.mFirst = true;
        this.resumeScroll();
    }

    public void resumeScroll() {
        if (!this.mPaused) {
            return;
        }
        this.setGravity(16);
        this.setHorizontallyScrolling(true);
        if (this.mScroller == null) {
            this.mScroller = new Scroller(this.getContext(), (Interpolator)new LinearInterpolator());
            MarqueeTextView marqueeTextView = this;
            marqueeTextView.setScroller(marqueeTextView.mScroller);
        }
        int n2 = this.calculateScrollingLen();
        int n3 = n2 - this.mXPaused;
        n2 = Double.valueOf(this.mRollingInterval * n2).intValue();
        if (this.mFirst) {
            new Handler(Looper.getMainLooper()).postDelayed((Runnable)new g(this, n3, n2), (long)this.mFirstScrollDelay);
            return;
        }
        this.mScroller.startScroll(this.mXPaused, 0, n3, 0, n2);
        this.invalidate();
        this.mPaused = false;
    }

    public void pauseScroll() {
        if (this.mScroller == null) {
            return;
        }
        if (this.mPaused) {
            return;
        }
        this.mPaused = true;
        this.mXPaused = this.mScroller.getCurrX();
        this.mScroller.abortAnimation();
    }

    public void stopScroll() {
        if (this.mScroller == null) {
            return;
        }
        this.setGravity(17);
        this.mPaused = true;
        this.mScroller.startScroll(0, 0, 0, 0, 0);
    }

    private int calculateScrollingLen() {
        TextPaint textPaint = this.getPaint();
        Rect rect = new Rect();
        String string2 = this.getText().toString();
        textPaint.getTextBounds(string2, 0, string2.length(), rect);
        return rect.width();
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller == null) {
            return;
        }
        if (this.mScroller.isFinished() && !this.mPaused) {
            if (this.mScrollMode == 1) {
                this.stopScroll();
                return;
            }
            this.mPaused = true;
            this.mXPaused = -1 * this.getWidth();
            this.mFirst = false;
            this.resumeScroll();
        }
    }

    public int getRndDuration() {
        return this.mRollingInterval;
    }

    public void setRndDuration(int n2) {
        this.mRollingInterval = n2;
    }

    public void setScrollMode(int n2) {
        this.mScrollMode = n2;
    }

    public int getScrollMode() {
        return this.mScrollMode;
    }

    public void setScrollFirstDelay(int n2) {
        this.mFirstScrollDelay = n2;
    }

    public int getScrollFirstDelay() {
        return this.mFirstScrollDelay;
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    static /* synthetic */ int access$000(MarqueeTextView marqueeTextView) {
        return marqueeTextView.mXPaused;
    }

    static /* synthetic */ Scroller access$100(MarqueeTextView marqueeTextView) {
        return marqueeTextView.mScroller;
    }

    static /* synthetic */ boolean access$202(MarqueeTextView marqueeTextView, boolean bl2) {
        marqueeTextView.mPaused = bl2;
        return marqueeTextView.mPaused;
    }
}

