/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.greendao;

import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.xiaomi.greendao.AbstractDaoSession;
import com.xiaomi.greendao.DaoException;
import com.xiaomi.greendao.DaoLog;
import com.xiaomi.greendao.Property;
import com.xiaomi.greendao.identityscope.IdentityScopeLong;
import com.xiaomi.greendao.identityscope.a;
import com.xiaomi.greendao.internal.DaoConfig;
import com.xiaomi.greendao.internal.FastCursor;
import com.xiaomi.greendao.internal.TableStatements;
import com.xiaomi.greendao.query.Query;
import com.xiaomi.greendao.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class AbstractDao<T, K> {
    public final SQLiteDatabase db;
    public final DaoConfig config;
    public a<K, T> identityScope;
    public IdentityScopeLong<T> identityScopeLong;
    public TableStatements statements;
    public final AbstractDaoSession session;
    public final int pkOrdinal;

    public AbstractDao(DaoConfig daoConfig) {
        this(daoConfig, null);
    }

    public AbstractDao(DaoConfig object, AbstractDaoSession object2) {
        this.config = object;
        this.session = object2;
        this.db = ((DaoConfig)object).a;
        this.identityScope = ((DaoConfig)object).j;
        object2 = this.identityScope;
        if (object2 instanceof IdentityScopeLong) {
            this.identityScopeLong = (IdentityScopeLong)object2;
        }
        this.statements = ((DaoConfig)object).i;
        object = ((DaoConfig)object).g;
        int n2 = object != null ? ((Property)object).a : -1;
        this.pkOrdinal = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeInsertInTx(SQLiteStatement var1_1, Iterable<T> var2_2, boolean var3_4) {
        this.db.beginTransaction();
        ** synchronized (var1_1)
lbl-1000:
        // 1 sources

        {
            block19: {
                if (this.identityScope == null) break block19;
                this.identityScope.b();
            }
            var2_2 = var2_2.iterator();
            while (true) {
                if (!var2_2.hasNext()) break;
                v0 = var3_4;
                v1 = this;
                v2 = var1_1;
                var4_5 = var2_2.next();
                v1.bindValues(v2, var4_5);
                if (!v0) ** GOTO lbl25
                this.updateKeyAfterInsertAndAttach(var4_5, var1_1.executeInsert(), false);
                continue;
lbl25:
                // 1 sources

                var1_1.execute();
                continue;
                break;
            }
            if (this.identityScope == null) ** GOTO lbl31
            this.identityScope.c();
lbl31:
            // 2 sources

            v3 = this;
            v4 = v3;
            v5 = v3;
        }
        v4.db.setTransactionSuccessful();
        v5.db.endTransaction();
        return;
        {
            catch (Throwable var2_3) {
                try {
                    if (this.identityScope == null) ** GOTO lbl50
                }
                catch (Throwable v6) {
                    // MONITOREXIT @DISABLED, blocks:[16, 14, 15] lbl45 : MonitorExitStatement: MONITOREXIT : var1_1
                    try {
                        throw v6;
                    }
                    catch (Throwable v7) {
                        this.db.endTransaction();
                        throw v7;
                    }
                }
                this.identityScope.c();
lbl50:
                // 2 sources

                throw var2_3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long executeInsert(T t2, SQLiteStatement sQLiteStatement) {
        long l2;
        if (this.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement2 = sQLiteStatement;
            // MONITORENTER : sQLiteStatement
            this.bindValues(sQLiteStatement, t2);
            l2 = sQLiteStatement2.executeInsert();
            // MONITOREXIT : sQLiteStatement2
        } else {
            AbstractDao abstractDao = this;
            SQLiteStatement sQLiteStatement3 = sQLiteStatement;
            this.db.beginTransaction();
            this.bindValues(sQLiteStatement, t2);
            l2 = sQLiteStatement3.executeInsert();
            // MONITOREXIT : sQLiteStatement3
            abstractDao.db.setTransactionSuccessful();
            abstractDao.db.endTransaction();
        }
        this.updateKeyAfterInsertAndAttach(t2, l2, true);
        return l2;
        catch (Throwable throwable) {
            // MONITOREXIT : sQLiteStatement
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.db.endTransaction();
                throw throwable2;
            }
        }
    }

    private void loadAllUnlockOnWindowBounds(Cursor cursor, CursorWindow cursorWindow, List<T> list) {
        int n2 = cursorWindow.getStartPosition() + cursorWindow.getNumRows();
        int n3 = 0;
        while (true) {
            block5: {
                block4: {
                    block3: {
                        list.add(this.loadCurrent(cursor, 0, false));
                        if (++n3 < n2) break block3;
                        CursorWindow cursorWindow2 = this.moveToNextUnlocked(cursor);
                        if (cursorWindow2 == null) break block4;
                        n2 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
                        break block5;
                    }
                    if (cursor.moveToNext()) break block5;
                }
                return;
            }
            ++n3;
        }
    }

    private CursorWindow moveToNextUnlocked(Cursor cursor) {
        block3: {
            this.identityScope.c();
            try {
                if (!cursor.moveToNext()) break block3;
            }
            catch (Throwable throwable) {
                this.identityScope.b();
                throw throwable;
            }
            CursorWindow cursorWindow = ((CrossProcessCursor)cursor).getWindow();
            this.identityScope.b();
            return cursorWindow;
        }
        this.identityScope.b();
        return null;
    }

    private void deleteByKeyInsideSynchronized(K k2, SQLiteStatement sQLiteStatement) {
        block4: {
            block3: {
                block2: {
                    if (!(k2 instanceof Long)) break block2;
                    long l2 = (Long)k2;
                    sQLiteStatement.bindLong(1, l2);
                    break block3;
                }
                if (k2 == null) break block4;
                sQLiteStatement.bindString(1, k2.toString());
            }
            sQLiteStatement.execute();
            return;
        }
        throw new DaoException("Cannot delete entity, key is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteInTxInternal(Iterable<T> var1_1, Iterable<K> var2_3) {
        v0 = this;
        v0.assertSinglePk();
        var3_4 = v0.statements.c();
        var4_5 = null;
        this.db.beginTransaction();
        ** synchronized (var3_4)
lbl-1000:
        // 1 sources

        {
            block17: {
                if (v0.identityScope == null) break block17;
                this.identityScope.b();
                var4_5 = v1;
                v1 = new ArrayList<Object>();
            }
            if (var1_1 == null) ** GOTO lbl26
            try {
                var1_1 = var1_1.iterator();
                while (var1_1.hasNext()) {
                    v2 = this;
                    var5_6 = v2.getKeyVerified(var1_1.next());
                    v2.deleteByKeyInsideSynchronized(var5_6, var3_4);
                    if (var4_5 == null) continue;
                    var4_5.add(var5_6);
                }
lbl26:
                // 2 sources

                if (var2_3 == null) ** GOTO lbl45
                var1_1 = var2_3.iterator();
                ** GOTO lbl38
            }
            catch (Throwable var1_2) {}
            try {
                if (this.identityScope != null) {
                    this.identityScope.c();
                }
                throw var1_2;
            }
            catch (Throwable v3) {
                block18: {
                    // MONITOREXIT @DISABLED, blocks:[9, 11] lbl34 : MonitorExitStatement: MONITOREXIT : var3_4
                    throw v3;
lbl38:
                    // 3 sources

                    while (var1_1.hasNext()) {
                        var2_3 = var1_1.next();
                        {
                            this.deleteByKeyInsideSynchronized(var2_3, var3_4);
                            if (var4_5 == null) continue;
                            var4_5.add(var2_3);
                        }
                    }
lbl45:
                    // 2 sources

                    if (this.identityScope != null) {
                        this.identityScope.c();
                    }
                    // MONITOREXIT @DISABLED, blocks:[9, 11] lbl46 : MonitorExitStatement: MONITOREXIT : var3_4
                    try {
                        this.db.setTransactionSuccessful();
                        if (var4_5 == null || this.identityScope == null) break block18;
                        this.identityScope.a(var4_5);
                    }
                    catch (Throwable v4) {
                        this.db.endTransaction();
                        throw v4;
                    }
                }
                this.db.endTransaction();
                return;
            }
        }
    }

    public AbstractDaoSession getSession() {
        return this.session;
    }

    public TableStatements getStatements() {
        return this.config.i;
    }

    public String getTablename() {
        return this.config.b;
    }

    public Property[] getProperties() {
        return this.config.c;
    }

    public Property getPkProperty() {
        return this.config.g;
    }

    public String[] getAllColumns() {
        return this.config.d;
    }

    public String[] getPkColumns() {
        return this.config.e;
    }

    public String[] getNonPkColumns() {
        return this.config.f;
    }

    public T load(K k2) {
        ((AbstractDao)((Object)string2)).assertSinglePk();
        if (k2 == null) {
            return null;
        }
        Object object = ((AbstractDao)((Object)string2)).identityScope;
        if (object != null && (object = object.a(k2)) != null) {
            return (T)object;
        }
        AbstractDao abstractDao = string2;
        String string2 = abstractDao.statements.f();
        String[] stringArray = new String[1];
        object = stringArray;
        stringArray[0] = k2.toString();
        return abstractDao.loadUniqueAndCloseCursor(abstractDao.db.rawQuery(string2, object));
    }

    public T loadByRowId(long l2) {
        AbstractDao abstractDao = this;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = Long.toString(l2);
        SQLiteDatabase sQLiteDatabase = abstractDao.db;
        TableStatements tableStatements = this.statements;
        if (tableStatements.k == null) {
            tableStatements.k = tableStatements.e() + "WHERE ROWID=?";
        }
        return abstractDao.loadUniqueAndCloseCursor(sQLiteDatabase.rawQuery(tableStatements.k, stringArray2));
    }

    public T loadUniqueAndCloseCursor(Cursor cursor) {
        T t2;
        try {
            t2 = this.loadUnique(cursor);
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
        cursor.close();
        return t2;
    }

    public T loadUnique(Cursor cursor) {
        if (!cursor.moveToFirst()) {
            return null;
        }
        if (cursor.isLast()) {
            return this.loadCurrent(cursor, 0, true);
        }
        throw new DaoException("Expected unique result, but count was " + cursor.getCount());
    }

    public List<T> loadAll() {
        AbstractDao abstractDao = this;
        return abstractDao.loadAllAndCloseCursor(abstractDao.db.rawQuery(this.statements.e(), null));
    }

    public boolean detach(T t2) {
        if (abstractDao2.identityScope != null) {
            AbstractDao abstractDao = abstractDao2;
            AbstractDao<T, K> abstractDao2 = abstractDao.getKeyVerified(t2);
            return abstractDao.identityScope.c(abstractDao2, t2);
        }
        return false;
    }

    public void detachAll() {
        a<K, T> a2 = ((AbstractDao)((Object)a2)).identityScope;
        if (a2 != null) {
            a2.a();
        }
    }

    public List<T> loadAllAndCloseCursor(Cursor cursor) {
        List<T> list;
        try {
            list = this.loadAllFromCursor(cursor);
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
        cursor.close();
        return list;
    }

    public void insertInTx(Iterable<T> iterable) {
        this.insertInTx(iterable, this.isEntityUpdateable());
    }

    public void insertInTx(T ... TArray) {
        this.insertInTx((Iterable<T>)Arrays.asList(TArray), this.isEntityUpdateable());
    }

    public void insertInTx(Iterable<T> iterable, boolean bl2) {
        AbstractDao abstractDao = this;
        abstractDao.executeInsertInTx(abstractDao.statements.a(), iterable, bl2);
    }

    public void insertOrReplaceInTx(Iterable<T> iterable, boolean bl2) {
        AbstractDao abstractDao = this;
        abstractDao.executeInsertInTx(abstractDao.statements.b(), iterable, bl2);
    }

    public void insertOrReplaceInTx(Iterable<T> iterable) {
        this.insertOrReplaceInTx(iterable, this.isEntityUpdateable());
    }

    public void insertOrReplaceInTx(T ... TArray) {
        this.insertOrReplaceInTx((Iterable<T>)Arrays.asList(TArray), this.isEntityUpdateable());
    }

    public long insert(T t2) {
        return this.executeInsert(t2, this.statements.a());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertWithoutSettingPk(T t2) {
        AbstractDao abstractDao = this;
        SQLiteStatement sQLiteStatement = abstractDao.statements.a();
        if (abstractDao.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement2 = sQLiteStatement;
            synchronized (sQLiteStatement) {
                this.bindValues(sQLiteStatement, t2);
                long l2 = sQLiteStatement2.executeInsert();
                // ** MonitorExit[v1] (shouldn't be in output)
                return l2;
            }
        }
        AbstractDao abstractDao2 = this;
        SQLiteStatement sQLiteStatement3 = sQLiteStatement;
        this.db.beginTransaction();
        synchronized (sQLiteStatement) {
        }
        {
            catch (Throwable throwable) {
                this.db.endTransaction();
                throw throwable;
            }
            {
                long l3;
                try {
                    this.bindValues(sQLiteStatement, t2);
                    l3 = sQLiteStatement3.executeInsert();
                    // ** MonitorExit[v4] (shouldn't be in output)
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                {
                    abstractDao2.db.setTransactionSuccessful();
                }
                abstractDao2.db.endTransaction();
                return l3;
            }
        }
    }

    public long insertOrReplace(T t2) {
        return this.executeInsert(t2, this.statements.b());
    }

    public void updateKeyAfterInsertAndAttach(T t2, long l2, boolean bl2) {
        if (l2 != -1L) {
            AbstractDao abstractDao = this;
            abstractDao.attachEntity(abstractDao.updateKeyAfterInsert(t2, l2), t2, bl2);
            return;
        }
        DaoLog.c("Could not insert row (executeInsert returned -1)");
    }

    /*
     * Unable to fully structure code
     */
    public List<T> loadAllFromCursor(Cursor var1_1) {
        block13: {
            var2_3 = var1_1.getCount();
            if (var2_3 == 0) {
                return new ArrayList<E>();
            }
            var3_4 = v0;
            v0 = new ArrayList<T>(var2_3);
            var4_5 = null;
            var5_6 = false;
            if (var1_1 instanceof CrossProcessCursor && (var4_5 = ((CrossProcessCursor)var1_1).getWindow()) != null) {
                if (var4_5.getNumRows() == var2_3) {
                    var1_1 = v1;
                    v1 = new FastCursor(var4_5);
                    var5_6 = true;
                } else {
                    DaoLog.a("Window vs. result size: " + var4_5.getNumRows() + "/" + var2_3);
                }
            }
            if (!var1_1.moveToFirst()) break block13;
            var6_7 = this.identityScope;
            if (var6_7 != null) {
                var6_7.b();
                this.identityScope.a(var2_3);
            }
            if (var5_6 || var4_5 == null) ** GOTO lbl-1000
            try {
                if (this.identityScope != null) {
                    this.loadAllUnlockOnWindowBounds(var1_1, var4_5, var3_4);
                } else lbl-1000:
                // 2 sources

                {
                    do {
                        var3_4.add(this.loadCurrent(var1_1, 0, false));
                    } while (var1_1.moveToNext());
                }
            }
            finally {
                this = this.identityScope;
                if (this != null) {
                    this.c();
                }
            }
        }
        return var3_4;
    }

    public final T loadCurrent(Cursor object, int n2, boolean bl2) {
        if (this.identityScopeLong != null) {
            if (n2 != 0 && object.isNull(this.pkOrdinal + n2)) {
                return null;
            }
            long l2 = object.getLong(this.pkOrdinal + n2);
            T t2 = bl2 ? this.identityScopeLong.a(l2) : this.identityScopeLong.b(l2);
            if (t2 != null) {
                return t2;
            }
            AbstractDao abstractDao = this;
            object = abstractDao.readEntity((Cursor)object, n2);
            abstractDao.attachEntity(object);
            if (bl2) {
                this.identityScopeLong.a(l2, (Cursor)object);
            } else {
                this.identityScopeLong.b(l2, (Cursor)object);
            }
            return (T)object;
        }
        if (this.identityScope != null) {
            K k2 = this.readKey((Cursor)object, n2);
            if (n2 != 0 && k2 == null) {
                return null;
            }
            T t3 = bl2 ? this.identityScope.a(k2) : this.identityScope.b(k2);
            if (t3 != null) {
                return t3;
            }
            object = this.readEntity((Cursor)object, n2);
            this.attachEntity(k2, object, bl2);
            return (T)object;
        }
        if (n2 != 0 && this.readKey((Cursor)object, n2) == null) {
            return null;
        }
        T t4 = this.readEntity((Cursor)object, n2);
        this.attachEntity(t4);
        return t4;
    }

    public final <O> O loadCurrentOther(AbstractDao<O, ?> abstractDao, Cursor cursor, int n2) {
        return abstractDao.loadCurrent(cursor, n2, true);
    }

    public List<T> queryRaw(String string2, String ... stringArray) {
        AbstractDao abstractDao = this;
        return abstractDao.loadAllAndCloseCursor(abstractDao.db.rawQuery(this.statements.e() + string2, stringArray));
    }

    public Query<T> queryRawCreate(String string2, Object ... objectArray) {
        return this.queryRawCreateListArgs(string2, Arrays.asList(objectArray));
    }

    public Query<T> queryRawCreateListArgs(String string2, Collection<Object> collection) {
        return Query.a(this, this.statements.e() + string2, collection.toArray());
    }

    public void deleteAll() {
        AbstractDao abstractDao = a2;
        abstractDao.db.execSQL("DELETE FROM '" + ((AbstractDao)((Object)a2)).config.b + "'");
        a<K, T> a2 = abstractDao.identityScope;
        if (a2 != null) {
            a2.a();
        }
    }

    public void delete(T t2) {
        AbstractDao abstractDao = this;
        this.assertSinglePk();
        abstractDao.deleteByKey(abstractDao.getKeyVerified(t2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void deleteByKey(K k2) {
        AbstractDao abstractDao = a2;
        abstractDao.assertSinglePk();
        SQLiteStatement sQLiteStatement = abstractDao.statements.c();
        if (abstractDao.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement2 = sQLiteStatement;
            // MONITORENTER : sQLiteStatement2
            ((AbstractDao)((Object)a2)).deleteByKeyInsideSynchronized(k2, sQLiteStatement2);
            // MONITOREXIT : sQLiteStatement
        } else {
            AbstractDao abstractDao2 = a2;
            ((AbstractDao)((Object)a2)).db.beginTransaction();
            ((AbstractDao)((Object)a2)).deleteByKeyInsideSynchronized(k2, sQLiteStatement);
            // MONITOREXIT : sQLiteStatement
            abstractDao2.db.setTransactionSuccessful();
            abstractDao2.db.endTransaction();
        }
        a<K, T> a2 = ((AbstractDao)((Object)a2)).identityScope;
        if (a2 == null) return;
        a2.c(k2);
        return;
        catch (Throwable throwable) {
            // MONITOREXIT : sQLiteStatement
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                ((AbstractDao)((Object)a2)).db.endTransaction();
                throw throwable2;
            }
        }
    }

    public void deleteInTx(Iterable<T> iterable) {
        this.deleteInTxInternal(iterable, null);
    }

    public void deleteInTx(T ... TArray) {
        this.deleteInTxInternal(Arrays.asList(TArray), null);
    }

    public void deleteByKeyInTx(Iterable<K> iterable) {
        this.deleteInTxInternal(null, iterable);
    }

    public void deleteByKeyInTx(K ... KArray) {
        this.deleteInTxInternal(null, Arrays.asList(KArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refresh(T t2) {
        String string2;
        block5: {
            AbstractDao abstractDao = this;
            this.assertSinglePk();
            K k2 = abstractDao.getKeyVerified(t2);
            string2 = abstractDao.statements.f();
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = k2.toString();
            string2 = abstractDao.db.rawQuery(string2, stringArray2);
            try {
                if (!string2.moveToFirst()) throw new DaoException("Entity does not exist in the database anymore: " + t2.getClass() + " with key " + k2);
            }
            catch (Throwable throwable) {
                string2.close();
                throw throwable;
            }
            if (!string2.isLast()) break block5;
            this.readEntity((Cursor)string2, t2, 0);
            this.attachEntity(k2, t2, true);
            string2.close();
            return;
        }
        throw new DaoException("Expected unique result, but count was " + string2.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(T t2) {
        AbstractDao abstractDao = this;
        abstractDao.assertSinglePk();
        SQLiteStatement sQLiteStatement = abstractDao.statements.d();
        if (abstractDao.db.isDbLockedByCurrentThread()) {
            SQLiteStatement sQLiteStatement2 = sQLiteStatement;
            synchronized (sQLiteStatement2) {
                this.updateInsideSynchronized(t2, sQLiteStatement2, true);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
        AbstractDao abstractDao2 = this;
        SQLiteStatement sQLiteStatement3 = sQLiteStatement;
        this.db.beginTransaction();
        synchronized (sQLiteStatement3) {
        }
        {
            catch (Throwable throwable) {
                this.db.endTransaction();
                throw throwable;
            }
            {
                try {
                    this.updateInsideSynchronized(t2, sQLiteStatement3, true);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
                {
                    abstractDao2.db.setTransactionSuccessful();
                }
                abstractDao2.db.endTransaction();
                return;
            }
        }
    }

    public QueryBuilder<T> queryBuilder() {
        return QueryBuilder.a(this);
    }

    public void updateInsideSynchronized(T t2, SQLiteStatement sQLiteStatement, boolean bl2) {
        block4: {
            K k2;
            block3: {
                int n2;
                block2: {
                    AbstractDao abstractDao = this;
                    abstractDao.bindValues(sQLiteStatement, t2);
                    n2 = abstractDao.config.d.length + 1;
                    k2 = this.getKey(t2);
                    if (!(k2 instanceof Long)) break block2;
                    sQLiteStatement.bindLong(n2, ((Long)k2).longValue());
                    break block3;
                }
                if (k2 == null) break block4;
                sQLiteStatement.bindString(n2, k2.toString());
            }
            sQLiteStatement.execute();
            this.attachEntity(k2, t2, bl2);
            return;
        }
        throw new DaoException("Cannot update entity without key - was it inserted before?");
    }

    public final void attachEntity(K k2, T t2, boolean bl2) {
        AbstractDao abstractDao = a2;
        abstractDao.attachEntity(t2);
        a<K, T> a2 = abstractDao.identityScope;
        if (a2 != null && k2 != null) {
            if (bl2) {
                a2.a(k2, t2);
                return;
            }
            a2.b(k2, t2);
        }
    }

    public void attachEntity(T t2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updateInTx(Iterable<T> iterator) {
        SQLiteStatement sQLiteStatement;
        block19: {
            AbstractDao abstractDao = this;
            sQLiteStatement = abstractDao.statements.d();
            this.db.beginTransaction();
            if (abstractDao.identityScope == null) break block19;
            this.identityScope.b();
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            this.updateInsideSynchronized(iterator.next(), sQLiteStatement, false);
        }
        if (this.identityScope != null) {
            this.identityScope.c();
        }
        AbstractDao abstractDao = this;
        AbstractDao abstractDao2 = abstractDao;
        AbstractDao abstractDao3 = abstractDao;
        // MONITOREXIT : sQLiteStatement
        abstractDao2.db.setTransactionSuccessful();
        abstractDao3.db.endTransaction();
        return;
        catch (Throwable throwable) {
            try {
                if (this.identityScope == null) throw throwable;
                this.identityScope.c();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // MONITOREXIT : sQLiteStatement
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                catch (RuntimeException runtimeException) {
                    try {
                        return;
                    }
                    catch (RuntimeException runtimeException2) {
                        DaoLog.b("Could not end transaction (rethrowing initial exception)", runtimeException2);
                        throw runtimeException;
                    }
                }
                finally {
                    this.db.endTransaction();
                }
            }
        }
    }

    public void updateInTx(T ... TArray) {
        this.updateInTx((Iterable<T>)Arrays.asList(TArray));
    }

    public void assertSinglePk() {
        if (this.config.e.length == 1) {
            return;
        }
        throw new DaoException(this + " (" + this.config.b + ") does not have a single-column primary key");
    }

    public long count() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)("'" + this.config.b + '\''));
    }

    /*
     * WARNING - void declaration
     */
    public K getKeyVerified(T t2) {
        void var1_2;
        K k2 = this.getKey(var1_2);
        if (k2 == null) {
            if (var1_2 == null) {
                throw new NullPointerException("Entity may not be null");
            }
            throw new DaoException("Entity has no key");
        }
        return k2;
    }

    public SQLiteDatabase getDatabase() {
        return this.db;
    }

    public abstract T readEntity(Cursor var1, int var2);

    public abstract K readKey(Cursor var1, int var2);

    public abstract void readEntity(Cursor var1, T var2, int var3);

    public abstract void bindValues(SQLiteStatement var1, T var2);

    public abstract K updateKeyAfterInsert(T var1, long var2);

    public abstract K getKey(T var1);

    public abstract boolean isEntityUpdateable();
}

