/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.hy.dj.fragment;

import android.app.Fragment;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.os.CountDownTimer;
import com.xiaomi.gamecenter.sdk.utils.ReporterUtils;
import com.xiaomi.hy.dj.PayResultCallback;
import com.xiaomi.hy.dj.config.ResultCode;
import com.xiaomi.hy.dj.log.Logger;
import com.xiaomi.hy.dj.model.AppInfo;
import com.xiaomi.hy.dj.model.CallModel;
import com.xiaomi.hy.dj.model.TokenManager;
import com.xiaomi.hy.dj.protocol.PayListener;
import com.xiaomi.hy.dj.protocol.PayProtocol;
import com.xiaomi.hy.dj.purchase.OrderPurchase;
import com.xiaomi.hy.dj.purchase.Purchase;

public class BaseFragment
extends Fragment
implements PayListener {
    private String[] paymentList;
    protected PayProtocol protocol;
    private Purchase purchase;
    private long callbackId;
    public ProgressDialog dialog;
    public CountDownTimer timer;
    private Bundle bundle;

    public void onCreate(Bundle object) {
        super.onCreate((Bundle)object);
        this.bundle = this.getActivity().getIntent().getBundleExtra("_bundle");
        if (object != null) {
            this.bundle = object.getBundle("_bundle");
        }
        object = (AppInfo)this.bundle.getSerializable("_appinfo");
        this.paymentList = ((AppInfo)object).getPaymentList();
        this.purchase = (Purchase)this.bundle.getSerializable("_purchase");
        this.callbackId = ((AppInfo)object).getCallId();
        this.dialog = new ProgressDialog((Context)this.getActivity());
        this.dialog.setMessage((CharSequence)"\u6b63\u5728\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f...");
        this.dialog.setCancelable(false);
        this.dialog.show();
        this.protocol = new PayProtocol((Context)this.getActivity(), (AppInfo)object, this.purchase);
        this.protocol.setListener(this);
        if (TokenManager.getInstance().isExist((Context)this.getActivity())) {
            this.goPay();
        }
    }

    @Override
    public void onNetError() {
        this.callbackErrorcode(3060);
    }

    @Override
    public void onError(int n2) {
        this.callbackErrorcode(n2);
    }

    @Override
    public void onPay(String string2, String string3, String string4) {
    }

    @Override
    public void onQuery(String string2) {
    }

    @Override
    public void onPayAntiAddiction(int n2, String string2, String string3) {
        if (n2 == 4012) {
            this.callbackAntiError(195, string2 + "&" + string3);
            return;
        }
        if (n2 == 4013) {
            this.callbackAntiError(196, string2);
        }
    }

    protected void queryResult(final String string2, long l2, long l3) {
        this.dialog.setMessage((CharSequence)"\u6b63\u5728\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f...");
        if (this.timer == null) {
            this.timer = new CountDownTimer(l2, l3){

                public void onTick(long l2) {
                    BaseFragment.this.protocol.queryOrder();
                }

                public void onFinish() {
                    if (string2.equals("WXMWEB")) {
                        ReporterUtils.getInstance().report(174);
                    } else if (string2.equals("WXNATIVE")) {
                        ReporterUtils.getInstance().report(178);
                    } else if (string2.equals("ALIPAY")) {
                        ReporterUtils.getInstance().report(170);
                    } else if (string2.equals("PAYECO")) {
                        ReporterUtils.getInstance().report(188);
                    } else if (string2.equals("SZFPAY")) {
                        ReporterUtils.getInstance().report(192);
                    } else {
                        ReporterUtils.getInstance().report(182);
                    }
                    BaseFragment.this.callbackErrorcode(185);
                }
            };
            this.timer.start();
        }
    }

    public void callbackErrorcode(int n2) {
        try {
            this.protocol.cancelAllRequest();
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.dismiss();
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            PayResultCallback payResultCallback = CallModel.pop(this.callbackId);
            if (n2 == 169 || n2 == 181 || n2 == 177 || n2 == 173 || n2 == 187 || n2 == 191) {
                payResultCallback.onSuccess(this.purchase.getCpOrderId());
            } else {
                payResultCallback.onError(n2, ResultCode.errorMap.get(n2));
            }
            this.getActivity().finish();
            this.getActivity().overridePendingTransition(0, 0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void callbackAntiError(int n2, String string2) {
        try {
            this.protocol.cancelAllRequest();
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.dismiss();
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            CallModel.pop(this.callbackId).onError(n2, string2);
            this.getActivity().finish();
            this.getActivity().overridePendingTransition(0, 0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBundle("_bundle", this.bundle);
    }

    private void goPay() {
        if (this.purchase instanceof OrderPurchase) {
            this.protocol.getPayInfo(this.paymentList[0]);
            return;
        }
        Logger.d("hydj", "purchase should be instance of OrderPurchase");
    }
}

