/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.hy.dj.http.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

public final class SystemConfig {
    private static Boolean is_cmcc;
    private static Boolean is_unicom;
    private static Boolean is_telcom;
    private static ConnectivityManager cmgr;
    private static TelephonyManager telMgr;

    public static void getTelephonyManager(Context context) {
        if (telMgr == null) {
            telMgr = (TelephonyManager)context.getSystemService("phone");
        }
    }

    public static boolean isAirplaneModeOn(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    public static boolean isCmwap(Context context) {
        String[] stringArray = new String[]{"cmwap", "uniwap", "3gwap"};
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) == null || context.getType() == 1) {
            return false;
        }
        String string2 = null;
        try {
            string2 = context.getExtraInfo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!stringArray[i2].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isctwap(Context context) {
        if ((context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) == null || context.getType() == 1) {
            return false;
        }
        String string2 = null;
        try {
            string2 = context.getExtraInfo();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2 == null) {
            return false;
        }
        return string2.indexOf("ctwap") >= 0;
    }

    public static String getSimOperaterNumeric(Context object) {
        SystemConfig.getTelephonyManager(object);
        if (telMgr == null) {
            return "";
        }
        object = telMgr.getSimOperator();
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = telMgr.getNetworkOperator();
        }
        return object;
    }

    public static String getSimOperaterNumeric_(Context object) {
        SystemConfig.getTelephonyManager(object);
        if (telMgr == null) {
            return "";
        }
        object = telMgr.getSimOperator();
        if (TextUtils.isEmpty((CharSequence)object)) {
            object = "";
        }
        return object;
    }

    private static int get_mnc(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -1;
        }
        if (string2.length() < 5) {
            return -1;
        }
        int n2 = -1;
        try {
            String string3 = string2;
            n2 = Integer.parseInt(string3.substring(string3.length() - (string2.length() > 5 ? 3 : 2)));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static boolean isCmcc(Context context) {
        if (is_cmcc == null) {
            int n2 = SystemConfig.get_mnc(SystemConfig.getSimOperaterNumeric(context));
            is_cmcc = new Boolean(n2 == 0 || 2 == n2 || 7 == n2);
        }
        return is_cmcc;
    }

    public static boolean isUnicom_(Context object) {
        if (is_unicom == null) {
            is_unicom = new Boolean(((String)(object = SystemConfig.getSimOperaterNumeric_((Context)object))).equals("46001") || ((String)object).equals("46006"));
        }
        return is_unicom;
    }

    public static boolean isTelecom(Context context) {
        if (is_telcom == null) {
            int n2 = SystemConfig.get_mnc(SystemConfig.getSimOperaterNumeric(context));
            is_telcom = new Boolean(3 == n2);
        }
        return is_telcom;
    }

    public static int getPlatFormSDK(Context object) {
        object = SystemConfig.getSystemProperties("ro.build.version.sdk");
        int n2 = 3;
        if (object != null) {
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    public static boolean isOPhone(Context object) {
        object = SystemConfig.getSystemProperties("apps.setting.platformversion");
        if (object == null) {
            return false;
        }
        return ((String)object).toLowerCase().indexOf("ophone") >= 0;
    }

    public static String getSystemProperties(String string2) {
        String string3 = "";
        try {
            string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    public static int getSystemIntProperties(String string2) {
        int n2 = 0;
        try {
            n2 = (Integer)Class.forName("android.os.SystemProperties").getMethod("getInt", String.class, Integer.TYPE).invoke(null, string2, 0);
        }
        catch (Exception exception) {
            Log.w((String)"", (Throwable)exception);
        }
        return n2;
    }

    private static void get_connectivitymanager(Context context) {
        if (cmgr == null) {
            cmgr = (ConnectivityManager)context.getSystemService("connectivity");
        }
    }

    public static NetworkInfo getActiveNetworkInfo(Context context) {
        SystemConfig.get_connectivitymanager(context);
        return cmgr.getActiveNetworkInfo();
    }

    public static boolean isNetworkAvailable(Context context) {
        SystemConfig.get_connectivitymanager(context);
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = cmgr;
            context = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (context == null) {
                return false;
            }
            return !(!context.hasCapability(12) && !context.hasCapability(14) && !context.hasCapability(13) || !context.hasTransport(1) && !context.hasTransport(0) && !context.hasTransport(4));
        }
        return cmgr.getActiveNetworkInfo() != null && cmgr.getActiveNetworkInfo().isConnected();
    }

    public static boolean isWifiNetwork(Context context) {
        SystemConfig.get_connectivitymanager(context);
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = cmgr;
            context = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (context == null) {
                return false;
            }
            return context.hasCapability(12) && context.hasTransport(1);
        }
        context = cmgr.getActiveNetworkInfo();
        if (context == null) {
            return false;
        }
        return context.getType() == 1 || context.getType() == 6;
    }

    public static boolean isMobileNetwork(Context context) {
        SystemConfig.get_connectivitymanager(context);
        if (Build.VERSION.SDK_INT >= 23) {
            ConnectivityManager connectivityManager = cmgr;
            context = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (context == null) {
                return false;
            }
            return context.hasCapability(12) && (context.hasTransport(0) || context.hasTransport(4));
        }
        context = cmgr.getActiveNetworkInfo();
        if (context == null) {
            return false;
        }
        return context.getType() != 1 && context.getType() != 6;
    }

    public static String get_CARRIER(Context context) {
        if (context == null) {
            return null;
        }
        if (SystemConfig.isCmcc(context)) {
            return "cmcc";
        }
        if (SystemConfig.isUnicom_(context)) {
            return "unicom";
        }
        if (SystemConfig.isTelecom(context)) {
            return "telecom";
        }
        return "unknown";
    }
}

