/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.hy.dj.protocol;

import android.content.Context;
import android.text.TextUtils;
import com.xiaomi.gamecenter.sdk.utils.ReporterUtils;
import com.xiaomi.hy.dj.http.RequestListener;
import com.xiaomi.hy.dj.http.RestClient;
import com.xiaomi.hy.dj.log.Logger;
import com.xiaomi.hy.dj.model.AppInfo;
import com.xiaomi.hy.dj.model.TokenManager;
import com.xiaomi.hy.dj.protocol.PayListener;
import com.xiaomi.hy.dj.purchase.FeePurchase;
import com.xiaomi.hy.dj.purchase.OrderPurchase;
import com.xiaomi.hy.dj.purchase.Purchase;
import com.xiaomi.hy.dj.purchase.RepeatPurchase;
import com.xiaomi.hy.dj.purchase.UnrepeatPurchase;
import com.xiaomi.hy.dj.utils.AESEncryption;
import com.xiaomi.hy.dj.utils.HmacSHA1Encryption;
import com.xiaomi.hy.dj.utils.HyUtils;
import com.xiaomi.hy.dj.utils.URLBase64;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PayProtocol {
    private Purchase purchase;
    private Context context;
    private String appid;
    private String appkey;
    private String chargeCode;
    private String amount;
    private String feeValue;
    private String orderId;
    private String displayName;
    private PayListener listener;
    private String payments;
    private boolean cancled = false;

    public PayProtocol(Context object, AppInfo appInfo, Purchase purchase) {
        this.context = object;
        this.purchase = purchase;
        this.appid = appInfo.getAppid();
        this.appkey = appInfo.getAppkey();
        this.payments = Arrays.toString(appInfo.getPaymentList());
        if (purchase instanceof UnrepeatPurchase) {
            this.chargeCode = ((UnrepeatPurchase)purchase).getChargeCode();
            if (TextUtils.isEmpty((CharSequence)this.chargeCode)) {
                throw new IllegalArgumentException("\u8ba1\u8d39\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.amount = "1";
        }
        if (purchase instanceof RepeatPurchase) {
            this.chargeCode = ((RepeatPurchase)purchase).getChargeCode();
            this.amount = ((RepeatPurchase)purchase).getAmout();
            if (TextUtils.isEmpty((CharSequence)this.chargeCode)) {
                throw new IllegalArgumentException("\u8ba1\u8d39\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (TextUtils.isEmpty((CharSequence)this.amount)) {
                this.amount = "1";
            }
        }
        if (purchase instanceof FeePurchase) {
            this.feeValue = ((FeePurchase)purchase).getFeeValue();
            this.displayName = ((FeePurchase)purchase).getDisplayName();
            if (TextUtils.isEmpty((CharSequence)this.feeValue)) {
                throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.chargeCode = "-1";
        } else {
            this.feeValue = "-1";
        }
        if (purchase instanceof OrderPurchase) {
            object = (OrderPurchase)purchase;
            this.feeValue = ((OrderPurchase)object).getFeeValue();
            this.displayName = ((OrderPurchase)object).getDisplayName();
            this.orderId = ((OrderPurchase)object).getMiOrderId();
        }
    }

    public void setListener(PayListener payListener) {
        this.listener = payListener;
    }

    public void getPayInfo(final String string2) {
        Object object;
        String string3 = "";
        String string4 = "";
        Object object2 = RestClient.getRequestmap(this.context);
        object2.put((String)"devAppId", (Object)this.appid);
        object2.put((String)"openId", (Object)TokenManager.getInstance().getToken(this.context).getOpenId());
        object2.put((String)"payment", (Object)string2);
        object2.put((String)"orderId", (Object)this.orderId);
        object2.put((String)"amount", (Object)this.feeValue);
        object2.put((String)"displayName", (Object)this.displayName);
        object2.put((String)"tradeType", (Object)"WXMWEB");
        try {
            object = AESEncryption.hex2byte("38464B6C45486561724D415964687A61");
            string3 = URLBase64.encode(AESEncryption.Encrypt_CBC(new JSONObject(object2).toString(), (byte[])object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = hashMap;
        hashMap.put("session", TokenManager.getInstance().getToken(this.context).getSession());
        if (!TextUtils.isEmpty((CharSequence)TokenManager.getInstance().getToken(this.context).getUid())) {
            object.put("uid", TokenManager.getInstance().getToken(this.context).getUid());
        } else {
            object.put("uid", TokenManager.getInstance().getToken(this.context).getOpenId());
        }
        object.put("p", string3);
        try {
            object2 = HyUtils.createLinkString((Map<String, String>)object) + "&uri=/order-manager/order/v3/getTransactionData";
            Logger.e("signString", (String)object2);
            Logger.e("appkey", this.appkey);
            string4 = HmacSHA1Encryption.HmacSHA1Encrypt((String)object2, this.appkey + "&key");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object.put("sign", string4);
        RestClient.post("https://mis.g.mi.com/order-manager/order/v3/getTransactionData", (Map<String, String>)object, new RequestListener(){

            @Override
            public void onSuccess(String object) {
                if (PayProtocol.this.cancled) {
                    return;
                }
                try {
                    object = URLBase64.decode((String)object);
                    object = new String((byte[])object, "UTF-8");
                    Logger.e("getPayInfo", (String)object);
                    object = new JSONObject((String)object);
                    Object object2 = object.optString("sign");
                    String string22 = object.optString("data");
                    String string3 = object.optString("errorMsg");
                    object = object.optString("errcode");
                    Object object3 = new HashMap<String, String>();
                    object3.put("errcode", object);
                    object3.put("errorMsg", string3);
                    object3.put("data", string22);
                    Logger.e("data", string22);
                    if (HmacSHA1Encryption.HmacSHA1Encrypt(HyUtils.createLinkString(object3) + "&uri=/order-manager/order/v3/getTransactionData", PayProtocol.this.appkey + "&key").equals(object2) && (((String)object).equals("200") || ((String)object).equals("4012"))) {
                        object2 = AESEncryption.Decrypt_CBC(URLBase64.decode(string22), AESEncryption.hex2byte("38464B6C45486561724D415964687A61"));
                        object2 = new String((byte[])object2, "UTF-8");
                        if (((String)object).equals("4012")) {
                            ReporterUtils.getInstance().report(195);
                            if (PayProtocol.this.listener != null) {
                                PayProtocol.this.listener.onPayAntiAddiction(4012, string3, (String)object2);
                            }
                            return;
                        }
                        Logger.e("getPayInfo onSuccess", (String)object2);
                        object = new JSONObject((String)object2);
                        object2 = object.optString("schemeUrl");
                        string22 = object.optString("codeUrl");
                        string3 = object.optString("mwebUrl");
                        object3 = object.optString("referer");
                        if ("PAYECO".equals(string2)) {
                            JSONObject jSONObject = new JSONObject();
                            try {
                                jSONObject.put("Amount", (Object)object.optString("Amount"));
                                jSONObject.put("MerchOrderId", (Object)object.optString("MerchOrderId"));
                                jSONObject.put("MerchantId", (Object)object.optString("MerchantId"));
                                jSONObject.put("Sign", (Object)object.optString("Sign"));
                                jSONObject.put("OrderId", (Object)object.optString("OrderId"));
                                jSONObject.put("TradeTime", (Object)object.optString("TradeTime"));
                                jSONObject.put("Version", (Object)object.optString("Version"));
                                PayProtocol.this.listener.onPay(string2, jSONObject.toString(), null);
                                return;
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                            }
                        }
                        Logger.e("mwebUrl", string3);
                        Logger.e("referer", (String)object3);
                        if (!TextUtils.isEmpty((CharSequence)object2)) {
                            PayProtocol.this.listener.onPay(string2, (String)object2, null);
                            return;
                        }
                        if (!TextUtils.isEmpty((CharSequence)string3)) {
                            PayProtocol.this.listener.onPay(string2, string3, (String)object3);
                            return;
                        }
                        PayProtocol.this.listener.onPay(string2, string22, null);
                        return;
                    }
                    if (((String)object).equals("4013")) {
                        ReporterUtils.getInstance().report(196);
                        if (PayProtocol.this.listener != null) {
                            PayProtocol.this.listener.onPayAntiAddiction(4013, string3, "");
                            return;
                        }
                    } else {
                        ReporterUtils.getInstance().report(3063);
                        PayProtocol.this.listener.onError(3063);
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ReporterUtils.getInstance().report(3063);
                    PayProtocol.this.listener.onError(3063);
                    return;
                }
            }

            @Override
            public void onError(String string22) {
                if (PayProtocol.this.cancled) {
                    return;
                }
                ReporterUtils.getInstance().report(3060);
                PayProtocol.this.listener.onNetError();
            }
        });
    }

    public void queryOrder() {
        Object object;
        String string2 = "";
        String string3 = "";
        Object object2 = RestClient.getRequestmap(this.context);
        object2.put((String)"devAppId", (Object)this.appid);
        object2.put((String)"openId", (Object)TokenManager.getInstance().getToken(this.context).getOpenId());
        object2.put((String)"orderId", (Object)this.orderId);
        try {
            object = AESEncryption.hex2byte("38464B6C45486561724D415964687A61");
            string2 = URLBase64.encode(AESEncryption.Encrypt_CBC(new JSONObject(object2).toString(), (byte[])object));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = hashMap;
        hashMap.put("session", TokenManager.getInstance().getToken(this.context).getSession());
        if (!TextUtils.isEmpty((CharSequence)TokenManager.getInstance().getToken(this.context).getUid())) {
            object.put("uid", TokenManager.getInstance().getToken(this.context).getUid());
        } else {
            object.put("uid", TokenManager.getInstance().getToken(this.context).getOpenId());
        }
        object.put("p", string2);
        try {
            object2 = HyUtils.createLinkString((Map<String, String>)object) + "&uri=/order-manager/order/v3/queryReceiptStatus";
            Logger.e("signString", (String)object2);
            Logger.e("appkey", this.appkey);
            string3 = HmacSHA1Encryption.HmacSHA1Encrypt((String)object2, this.appkey + "&key");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object.put("sign", string3);
        RestClient.post("https://mis.g.mi.com/order-manager/order/v3/queryReceiptStatus", (Map<String, String>)object, new RequestListener(){

            @Override
            public void onSuccess(String object) {
                if (PayProtocol.this.cancled) {
                    return;
                }
                try {
                    object = URLBase64.decode((String)object);
                    object = new String((byte[])object, "UTF-8");
                    Logger.e("queryOrder", (String)object);
                    object = new JSONObject((String)object);
                    String string2 = object.optString("sign");
                    String string3 = object.optString("data");
                    String string4 = object.optString("errorMsg");
                    object = object.optString("errcode");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("errcode", (String)object);
                    hashMap.put("errorMsg", string4);
                    hashMap.put("data", string3);
                    Logger.e("data", string3);
                    if (HmacSHA1Encryption.HmacSHA1Encrypt(HyUtils.createLinkString(hashMap) + "&uri=/order-manager/order/v3/queryReceiptStatus", PayProtocol.this.appkey + "&key").equals(string2) && ((String)object).equals("200")) {
                        object = AESEncryption.Decrypt_CBC(URLBase64.decode(string3), AESEncryption.hex2byte("38464B6C45486561724D415964687A61"));
                        object = new String((byte[])object, "UTF-8");
                        Logger.e("queryOrder onSuccess", (String)object);
                        object = new JSONObject((String)object).optString("status");
                        PayProtocol.this.listener.onQuery((String)object);
                        return;
                    }
                    PayProtocol.this.listener.onError(3064);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    PayProtocol.this.listener.onError(3064);
                    return;
                }
            }

            @Override
            public void onError(String string2) {
                if (PayProtocol.this.cancled) {
                    return;
                }
                ReporterUtils.getInstance().report(3060);
                PayProtocol.this.listener.onNetError();
            }
        });
    }

    public void cancelAllRequest() {
        this.cancled = true;
    }
}

