/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.hy.dj.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class HyUtils {
    public static final int WX_SUPPORT_VERSION = 0x22020000;

    public static String createLinkString(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        String string2 = "";
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string3 = (String)arrayList.get(i2);
            String string4 = map.get(string3);
            if (TextUtils.isEmpty((CharSequence)string4)) continue;
            string2 = i2 == arrayList.size() - 1 ? string2 + string3 + "=" + string4 : string2 + string3 + "=" + string4 + "&";
        }
        return string2;
    }

    public static boolean isWeixinAvilible(Context context) {
        try {
            if (context.getPackageManager().getPackageInfo("com.tencent.mm", 0) != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean isAlipayAvilible(Context context) {
        try {
            if (context.getPackageManager().getPackageInfo("com.eg.android.AlipayGphone", 0) != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean isQQpayAvilible(Context context) {
        try {
            context = context.getPackageManager().getPackageInfo("com.tencent.mobileqq", 0);
            if (context != null) {
                return HyUtils.compareQQVersion(context.versionName, "4.7.2") >= 0;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean isQQHDpayAvilible(Context context) {
        try {
            context = context.getPackageManager().getPackageInfo("com.tencent.minihd.qq", 0);
            if (context != null) {
                return HyUtils.compareQQVersion(context.versionName, "5.8.0") >= 0;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
        return false;
    }

    private static int compareQQVersion(String string2, String string3) {
        int n2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return -1;
        }
        String[] stringArray = string2.split("\\.");
        String[] stringArray2 = string3.split("\\.");
        for (n2 = 0; n2 < stringArray.length && n2 < stringArray2.length; ++n2) {
            int n3;
            int n4 = Integer.parseInt(stringArray[n2]);
            if (n4 < (n3 = Integer.parseInt(stringArray2[n2]))) {
                return -1;
            }
            if (n4 <= n3) continue;
            return 1;
        }
        if (stringArray.length > n2) {
            return 1;
        }
        if (stringArray2.length > n2) {
            return -1;
        }
        return string2.compareTo(string3);
    }

    public static boolean isRemoteServiceAvailable(Context context) {
        context = context.getPackageManager();
        try {
            if (context.getPackageInfo((String)"com.xiaomi.gamecenter.sdk.service", (int)64).versionCode >= 480900) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return false;
        }
        return false;
    }

    public static JSONArray getPaymentlist(String[] stringArray) {
        JSONArray jSONArray = new JSONArray();
        if (stringArray == null || stringArray.length <= 0) {
            jSONArray.put((Object)"ALIPAY");
            return jSONArray;
        }
        for (String string2 : stringArray) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }

    public static int getWXAppSupportAPI(Context context) {
        context = context.getContentResolver();
        String[] stringArray = new String[]{"_id", "key", "type", "value"};
        String string2 = "_build_info_sdk_int_";
        if ((context = context.query(Uri.parse((String)"content://com.tencent.mm.sdk.plugin.provider/sharedpref"), stringArray, "key = ?", new String[]{string2}, null)) == null) {
            return 0;
        }
        int n2 = context.getColumnIndex("type");
        int n3 = context.getColumnIndex("value");
        int n4 = 0;
        if (context.moveToFirst()) {
            try {
                n4 = (Integer)Value.a(context.getInt(n2), context.getString(n3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        context.close();
        return n4;
    }

    public static int version2Int(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return 1;
        }
        string2 = Pattern.compile("[^0-9]").matcher(string2).replaceAll("").trim();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return 1;
        }
    }

    private static final class Value {
        private Value() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Object a(int n2, String string2) {
            try {
                switch (n2) {
                    case 1: {
                        return Integer.valueOf(string2);
                    }
                    case 2: {
                        return Long.valueOf(string2);
                    }
                    case 3: {
                        return string2;
                    }
                    case 4: {
                        return Boolean.valueOf(string2);
                    }
                    case 5: {
                        return Float.valueOf(string2);
                    }
                    case 6: {
                        return Double.valueOf(string2);
                    }
                }
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

