/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.onetrack;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.xiaomi.onetrack.api.f;
import com.xiaomi.onetrack.c.d;
import com.xiaomi.onetrack.e.a;
import com.xiaomi.onetrack.util.aa;
import com.xiaomi.onetrack.util.ac;
import com.xiaomi.onetrack.util.b;
import com.xiaomi.onetrack.util.i;
import com.xiaomi.onetrack.util.k;
import com.xiaomi.onetrack.util.p;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CrashAnalysis {
    private static final String a = "CrashAnalysis";
    private static final String b = "com.xiaomi.digest.DigestUtil";
    private static final String c = "calcuateJavaDigest";
    private static final String d = "/sdcard/tombstone";
    private static final String e = "backtrace feature id:\n\t";
    private static final String f = "error reason:\n\t";
    private static final String g = "Crash time: '";
    public static final String JAVA_CRASH = "java";
    public static final String ANR_CRASH = "anr";
    public static final String NATIVE_CRASH = "native";
    private static final String h = ".xcrash";
    private static final int i = 604800000;
    private static final int j = 102400;
    private static final int k = 10;
    private static final int l = 20;
    private static final String m = "@[0-9a-fA-F]{1,10}";
    private static final String n = "\\$[0-9a-fA-F]{1,10}@[0-9a-fA-F]{1,10}";
    private static final String o = "0x[0-9a-fA-F]{1,10}";
    private static final String p = "\\d+[B,KB,MB]*";
    private static final String q = "((java:)|(length=)|(index=)|(Index:)|(Size:))\\d+";
    private static final int r = 20;
    private static final boolean s = false;
    private static final AtomicBoolean t = new AtomicBoolean(false);
    private final FileProcessor[] u;
    private final f v;

    private CrashAnalysis(Context context, f f2) {
        try {
            Class<?> clazz = Class.forName("xcrash.XCrash$InitParameters");
            Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.a(obj, "setNativeDumpAllThreads", false);
            this.a(obj, "setLogDir", CrashAnalysis.a());
            this.a(obj, "setNativeDumpMap", false);
            this.a(obj, "setNativeDumpFds", false);
            this.a(obj, "setJavaDumpAllThreads", false);
            this.a(obj, "setAnrRethrow", false);
            Class<?> clazz2 = Class.forName("xcrash.XCrash");
            Method method = clazz2.getDeclaredMethod("init", Context.class, obj.getClass());
            method.invoke(null, context.getApplicationContext(), obj);
            com.xiaomi.onetrack.util.p.a(a, "XCrash init success");
        }
        catch (Throwable throwable) {
            com.xiaomi.onetrack.util.p.a(a, "XCrash init failed: " + throwable.toString());
        }
        this.v = f2;
        this.u = new FileProcessor[]{new FileProcessor(JAVA_CRASH), new FileProcessor(ANR_CRASH), new FileProcessor(NATIVE_CRASH)};
    }

    public static boolean isSupport() {
        try {
            Class.forName("xcrash.XCrash");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static void a(Context context) {
        try {
            com.xiaomi.onetrack.e.a.a(context);
            Class<?> clazz = Class.forName("xcrash.XCrash");
            Method method = clazz.getDeclaredMethod("initHooker", Context.class, String.class);
            method.invoke(null, context.getApplicationContext(), CrashAnalysis.a());
            Log.d((String)a, (String)"registerHook succeeded");
        }
        catch (Throwable throwable) {
            Log.d((String)a, (String)("registerHook failed: " + throwable.toString()));
        }
    }

    public static void start(final Context context, final f f2) {
        if (t.compareAndSet(false, true)) {
            com.xiaomi.onetrack.util.i.a(new Runnable(){

                @Override
                public void run() {
                    try {
                        CrashAnalysis crashAnalysis = new CrashAnalysis(context, f2);
                        if (crashAnalysis.d()) {
                            crashAnalysis.e();
                        } else {
                            com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "no crash file found");
                        }
                    }
                    catch (Throwable throwable) {
                        com.xiaomi.onetrack.util.p.b(CrashAnalysis.a, "processCrash error: " + throwable.toString());
                    }
                }
            });
        } else {
            com.xiaomi.onetrack.util.p.b(a, "run method has been invoked more than once");
        }
    }

    private static String c(String string2, String string3) {
        String string4 = "uncategoried";
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                if (string3.equals(ANR_CRASH)) {
                    int n2;
                    int n3 = string2.indexOf(" tid=1 ");
                    if (n3 != -1 && (n3 = string2.indexOf("\n  at ", n3)) != -1 && (n2 = string2.indexOf(10, n3 + 6)) != -1) {
                        string4 = string2.substring(n3 + 2, n2);
                    }
                } else {
                    int n4;
                    int n5 = string2.indexOf(f);
                    if (n5 != -1 && (n4 = string2.indexOf("\n\n", n5 += f.length())) != -1) {
                        string4 = string2.substring(n5, n4);
                    }
                }
            }
            catch (Exception exception) {
                com.xiaomi.onetrack.util.p.b(a, "getErrorReasonString error: " + exception.toString());
            }
        }
        return string4;
    }

    private static String d(String string2, String string3) {
        String string4 = "";
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                if (string3.equals(ANR_CRASH)) {
                    int n2;
                    int n3 = string2.indexOf(" tid=1 ");
                    if (n3 != -1 && (n2 = string2.indexOf("\n\n", n3)) != -1) {
                        String string5 = string2.substring(n3, n2);
                        string4 = CrashAnalysis.calculateJavaDigest(string5);
                    }
                } else {
                    int n4;
                    int n5 = string2.indexOf(e);
                    if (n5 != -1 && (n4 = string2.indexOf("\n\n", n5 += e.length())) != -1) {
                        string4 = string2.substring(n5, n4);
                    }
                }
            }
            catch (Exception exception) {
                com.xiaomi.onetrack.util.p.b(a, "calculateFeatureId error: " + exception.toString());
            }
        }
        return string4;
    }

    private static long b(String string2) {
        long l2 = 0L;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                int n2;
                int n3 = string2.indexOf(g);
                if (n3 != -1 && (n2 = string2.indexOf("'\n", n3 += g.length())) != -1) {
                    l2 = com.xiaomi.onetrack.util.b.a(string2.substring(n3, n2));
                }
            }
            catch (Exception exception) {
                com.xiaomi.onetrack.util.p.b(a, "getCrashTimeStamp error: " + exception.toString());
            }
        }
        return l2;
    }

    private void a(Object object, String string2, Object object2) throws Exception {
        Class<Boolean> clazz = object2.getClass() == Boolean.class ? Boolean.TYPE : object2.getClass();
        Method method = object.getClass().getDeclaredMethod(string2, clazz);
        method.invoke(object, object2);
    }

    private static String a() {
        return com.xiaomi.onetrack.util.k.a();
    }

    private long b() {
        long l2 = aa.c();
        if (l2 == 0L) {
            com.xiaomi.onetrack.util.p.a(a, "no ticket data found, return max count");
            return 10L;
        }
        long l3 = ac.b();
        if (l2 / 100L != l3) {
            com.xiaomi.onetrack.util.p.a(a, "no today's ticket, return max count");
            return 10L;
        }
        long l4 = l2 - l3 * 100L;
        com.xiaomi.onetrack.util.p.a(a, "today's remain ticket is " + l4);
        return l4;
    }

    private void a(long l2) {
        long l3 = ac.b();
        long l4 = l3 * 100L + l2;
        aa.d(l4);
    }

    private List<File> c() {
        File[] fileArray = new File(CrashAnalysis.a()).listFiles();
        if (fileArray == null) {
            com.xiaomi.onetrack.util.p.a(a, "this path does not denote a directory, or if an I/O error occurs.");
            return null;
        }
        List<File> list = Arrays.asList(fileArray);
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return (int)(file.lastModified() - file2.lastModified());
            }
        });
        int n2 = list.size();
        if (n2 > 20) {
            int n3 = n2 - 20;
            for (int i2 = 0; i2 < n3; ++i2) {
                com.xiaomi.onetrack.util.k.a(list.get(i2));
            }
            list = list.subList(n3, n2);
        }
        return list;
    }

    private boolean d() {
        boolean bl2 = false;
        List<File> list = this.c();
        long l2 = this.b();
        if (list != null && list.size() > 0) {
            long l3 = System.currentTimeMillis();
            long l4 = aa.b();
            if (l4 > l3) {
                l4 = l3 - 604800000L;
            }
            long l5 = 0L;
            for (File file : list) {
                long l6 = file.lastModified();
                if (l6 < l3 - 604800000L || l6 > l3) {
                    com.xiaomi.onetrack.util.p.a(a, "remove obsolete crash files: " + file.getName());
                    com.xiaomi.onetrack.util.k.a(file);
                    continue;
                }
                if (l6 <= l4) {
                    com.xiaomi.onetrack.util.p.a(a, "found already reported crash file, ignore");
                    continue;
                }
                if (l2 <= 0L) continue;
                for (FileProcessor fileProcessor : this.u) {
                    if (!fileProcessor.a(file)) continue;
                    com.xiaomi.onetrack.util.p.a(a, "find crash file:" + file.getName());
                    bl2 = true;
                    --l2;
                    if (l5 >= l6) continue;
                    l5 = l6;
                }
            }
            if (l5 > 0L) {
                aa.c(l5);
            }
        }
        if (bl2) {
            this.a(l2);
        }
        return bl2;
    }

    private void e() {
        for (FileProcessor fileProcessor : this.u) {
            fileProcessor.a();
        }
    }

    public static String calculateJavaDigest(String string2) {
        int n2;
        String string3 = string2.replaceAll("\\t", "");
        String[] stringArray = string3.split("\\n");
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = Math.min(stringArray.length, 20);
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = stringArray[n2].replaceAll(q, "$1XX").replaceAll("\\$[0-9a-fA-F]{1,10}@[0-9a-fA-F]{1,10}|@[0-9a-fA-F]{1,10}|0x[0-9a-fA-F]{1,10}", "XX").replaceAll(p, "");
        }
        for (n2 = 0; !(n2 >= n3 || stringArray[n2].contains("...") && stringArray[n2].contains("more")); ++n2) {
            stringBuilder.append(stringArray[n2]);
            stringBuilder.append('\n');
        }
        return com.xiaomi.onetrack.c.d.h(stringBuilder.toString());
    }

    private class FileProcessor {
        final List<File> a = new ArrayList<File>();
        final String b;
        final String c;

        FileProcessor(String string2) {
            this.c = string2;
            this.b = string2 + CrashAnalysis.h;
        }

        boolean a(File file) {
            if (file.getName().contains(this.b)) {
                this.a.add(file);
                return true;
            }
            return false;
        }

        private String a(String string2) {
            String[] stringArray;
            if (!TextUtils.isEmpty((CharSequence)string2) && (stringArray = string2.split("__")).length == 2 && (stringArray = stringArray[0].split("_")).length == 3) {
                return stringArray[2];
            }
            return null;
        }

        void a() {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                File file = this.a.get(i2);
                String string2 = file.getAbsoluteFile().getAbsolutePath();
                String string3 = this.a(string2);
                String string4 = com.xiaomi.onetrack.util.k.a(string2, 102400);
                if (TextUtils.isEmpty((CharSequence)string4) || CrashAnalysis.this.v == null) continue;
                String string5 = CrashAnalysis.d(string4, this.c);
                String string6 = CrashAnalysis.c(string4, this.c);
                long l2 = CrashAnalysis.b(string4);
                com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "fileName: " + string2);
                com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "feature id: " + string5);
                com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "error: " + string6);
                com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "crashTimeStamp: " + l2);
                CrashAnalysis.this.v.a(string4, string6, this.c, string3, string5, l2);
                com.xiaomi.onetrack.util.k.a(new File(string2));
                com.xiaomi.onetrack.util.p.a(CrashAnalysis.a, "remove reported crash file");
            }
        }
    }
}

